/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.xmlmeta;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.util.xmlmeta.XMConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClassToXML
implements XMConstants {
    private Class designClass;
    private Class dpClass;
    private Class midoClass;
    private Class doClass = null;
    private Class soClass = null;
    private List<Class> classList;
    private List ignoreList;
    private List otherClasses = new ArrayList();
    private FileFilter classFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".class");
        }
    };

    public ClassToXML() {
        this.classList = new ArrayList<Class>();
        this.ignoreList = new ArrayList();
        this.ignoreList.add("MDConfiguration");
        this.ignoreList.add("MDPreferences");
        this.ignoreList.add("oracle.dbtools.crest.model.persistence");
        this.ignoreList.add("oracle.dbtools.crest.model.datatype");
        this.ignoreList.add("oracle.dbtools.crest.model.designrules");
        this.ignoreList.add("oracle.dbtools.crest.model.placeholder");
        this.ignoreList.add("oracle.dbtools.crest.model.propertyholder");
        this.ignoreList.add("oracle.dbtools.crest.model.reference");
        this.ignoreList.add("oracle.dbtools.crest.model.xtdmapping");
        this.ignoreList.add("oracle.dbtools.crest.model.design.compare");
        this.ignoreList.add("oracle.dbtools.crest.model.design.constraint");
        this.ignoreList.add("oracle.dbtools.crest.model.design.engineering");
        this.ignoreList.add("oracle.dbtools.crest.model.design.glossary");
        this.ignoreList.add("oracle.dbtools.crest.model.design.impact");
        this.ignoreList.add("oracle.dbtools.crest.model.design.undo");
        try {
            this.designClass = Class.forName("oracle.dbtools.crest.model.design.Design");
            this.dpClass = Class.forName("oracle.dbtools.crest.model.design.DesignPart");
            this.midoClass = Class.forName("oracle.dbtools.crest.model.ModelIDObject");
            this.doClass = Class.forName("oracle.dbtools.crest.model.design.DesignObject");
            this.soClass = Class.forName("oracle.dbtools.crest.model.design.storage.StorageObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void execute() {
        try {
            try {
                this.otherClasses.add(Class.forName("oracle.dbtools.crest.model.xtdmapping.RelMapping"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (Class clazz : this.otherClasses) {
                this.generateXMLOther(clazz);
            }
            System.out.println("DONE!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void listClasses(ClassLoader classLoader, String string) {
        if (this.ignoreList.contains(string)) {
            return;
        }
        try {
            String string2 = string.replace('.', '/');
            URL uRL = classLoader.getResource(string2);
            File file = new File(uRL.getFile());
            if (file.exists()) {
                File[] fileArray = file.listFiles(this.classFilter);
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        this.listClasses(classLoader, string + "." + fileArray[i].getName());
                        continue;
                    }
                    String string3 = fileArray[i].getName();
                    if (this.ignoreList.contains(string3 = string3.substring(0, string3.length() - 6)) || string3.indexOf(36) > -1) continue;
                    this.classList.add(Class.forName(string + '.' + string3));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isDesign(Class clazz) {
        return this.designClass != null && this.designClass.isAssignableFrom(clazz);
    }

    private boolean isDesignPart(Class clazz) {
        return this.dpClass != null && this.dpClass.isAssignableFrom(clazz);
    }

    private boolean isModelIDObject(Class clazz) {
        return this.midoClass != null && this.midoClass.equals(clazz);
    }

    private boolean isDesignObject(Class clazz) {
        return this.doClass != null && this.doClass.isAssignableFrom(clazz);
    }

    private boolean isStorageObject(Class clazz) {
        return this.soClass != null && this.soClass.isAssignableFrom(clazz);
    }

    private void generateXMLFor(Class clazz) {
        try {
            if (this.isDesign(clazz) || this.isDesignPart(clazz) || this.isModelIDObject(clazz) || this.isDesignObject(clazz) || this.isStorageObject(clazz)) {
                Method[] methodArray = clazz.getDeclaredMethods();
                Method[] methodArray2 = clazz.getSuperclass().getMethods();
                TreeMap treeMap = new TreeMap();
                TreeMap treeMap2 = new TreeMap();
                TreeMap treeMap3 = new TreeMap();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (!this.isAccepted(methodArray[i], methodArray2)) continue;
                    if (methodArray[i].getName().startsWith("set")) {
                        this.addToMap(methodArray[i], treeMap, 3);
                        continue;
                    }
                    if (methodArray[i].getName().startsWith("get")) {
                        this.addToMap(methodArray[i], treeMap2, 3);
                        continue;
                    }
                    if (!methodArray[i].getName().startsWith("is")) continue;
                    this.addToMap(methodArray[i], treeMap3, 2);
                }
                this.buildXML(clazz, treeMap2, treeMap3, treeMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateXMLOther(Class clazz) {
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            Method[] methodArray2 = clazz.getSuperclass().getMethods();
            TreeMap treeMap = new TreeMap();
            TreeMap treeMap2 = new TreeMap();
            TreeMap treeMap3 = new TreeMap();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!this.isAccepted(methodArray[i], methodArray2)) continue;
                if (methodArray[i].getName().startsWith("set")) {
                    this.addToMap(methodArray[i], treeMap, 3);
                    continue;
                }
                if (methodArray[i].getName().startsWith("get")) {
                    this.addToMap(methodArray[i], treeMap2, 3);
                    continue;
                }
                if (!methodArray[i].getName().startsWith("is")) continue;
                this.addToMap(methodArray[i], treeMap3, 2);
            }
            this.buildXML(clazz, treeMap2, treeMap3, treeMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToMap(Method method, Map map, int n) {
        String string = method.getName().substring(n);
        map.put(string, method);
    }

    private String getDataType(String string) {
        String string2 = string.trim();
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.startsWith("class ")) {
            return string2.substring(6).trim();
        }
        return string2;
    }

    private String isReffered(String string) {
        if (string.startsWith("oracle.dbtools.crest") || string.startsWith("[Loracle.dbtools.crest")) {
            return "true";
        }
        return "false";
    }

    private String lowerFirstChar(String string) {
        String string2 = string.replace(string.charAt(0), string.toLowerCase().charAt(0));
        return string2.replace(string2.charAt(1), string2.toLowerCase().charAt(1));
    }

    private void buildXML(Class clazz, Map map, Map map2, Map map3) {
        try {
            Object object;
            Object object2;
            Method method;
            String string;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            String string2 = clazz.getName();
            boolean bl = false;
            if (string2.indexOf(36) > -1) {
                string2 = string2.replace('$', '.');
                bl = true;
            }
            Element element = document.createElement(string2);
            document.appendChild(element);
            element.setAttribute("parentClass", clazz.getSuperclass().getName());
            if (bl) {
                element.setAttribute("innerClass", "true");
            }
            for (String string3 : map3.keySet()) {
                string = this.lowerFirstChar(string3);
                method = (Method)map3.get(string3);
                object2 = null;
                if (map.containsKey(string3)) {
                    object2 = (Method)map.get(string3);
                } else if (map2.containsKey(string3)) {
                    object2 = (Method)map2.get(string3);
                }
                if (object2 == null || method == null) continue;
                object = ((Method)object2).getReturnType();
                String string4 = this.getDataType(((Class)object).toString());
                Element element2 = document.createElement("property");
                element.appendChild(element2);
                element2.setAttribute("name", string);
                element2.setAttribute("dataType", string4);
                element2.setAttribute("defaultValue", "");
                element2.setAttribute("xmlName", string);
                element2.setAttribute("xmlType", "element");
                element2.setAttribute("getter", ((Method)object2).getName());
                element2.setAttribute("setter", method.getName());
                element2.setAttribute("reffered", this.isReffered(string4));
                map2.remove(string3);
                map.remove(string3);
            }
            for (String string3 : map2.keySet()) {
                string = this.lowerFirstChar(string3);
                method = (Method)map2.get(string3);
                object2 = this.getDataType(method.getReturnType().toString().toString());
                object = document.createElement("roproperty");
                element.appendChild((Node)object);
                object.setAttribute("name", string);
                object.setAttribute("dataType", (String)object2);
                object.setAttribute("getter", method.getName());
            }
            for (String string3 : map.keySet()) {
                string = this.lowerFirstChar(string3);
                method = (Method)map.get(string3);
                object2 = this.getDataType(method.getReturnType().toString().toString());
                object = document.createElement("roproperty");
                element.appendChild((Node)object);
                object.setAttribute("name", string);
                object.setAttribute("dataType", (String)object2);
                object.setAttribute("getter", method.getName());
            }
            this.saveXML(document, clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveXML(Document document, Class clazz) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            String string = clazz.getName();
            string = string.replace('.', '/');
            String string2 = string.substring(0, string.lastIndexOf(47));
            String string3 = System.getProperty("user.dir");
            File file = new File(string3, "xmlmeta/" + string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(string3, "xmlmeta/" + string + ".xml");
            StreamResult streamResult = new StreamResult(file2);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isAccepted(Method method, Method[] methodArray) {
        boolean bl = this.isPublicNonStaticMethod(method) && (this.hasSingleArgument(method) || this.hasNoArgument(method) && !this.hasVoidReturn(method)) && this.isNewMethod(method, methodArray);
        return bl;
    }

    private boolean isNewMethod(Method method, Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase(method.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isPublicNonStaticMethod(Method method) {
        int n = method.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isStatic(n);
    }

    private boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    public static void main(String[] stringArray) {
        ClassToXML classToXML = new ClassToXML();
        classToXML.execute();
    }
}

