/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.runtime;

public class RuntimeMonitor {
    private static final int DEFAULT_POLLING_INTERVAL = 50;
    private static RuntimeMonitor instance;
    private int threadCount;
    private Object threadCountLock = new Object();
    private int pollingInterval = 50;
    private Object pollingLock = new Object();

    private RuntimeMonitor() {
    }

    public static RuntimeMonitor getInstance() {
        if (instance == null) {
            instance = new RuntimeMonitor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementThreadCount() {
        Object object = this.threadCountLock;
        synchronized (object) {
            ++this.threadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementThreadCount() {
        Object object = this.threadCountLock;
        synchronized (object) {
            --this.threadCount;
        }
    }

    public boolean isFinished() {
        return this.threadCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingInterval(int n) {
        Object object = this.pollingLock;
        synchronized (object) {
            this.pollingInterval = n;
        }
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registeredThreadsFinished() {
        Object object = this.threadCountLock;
        synchronized (object) {
            if (this.threadCount < 0) {
                throw new IllegalStateException("Thread count < 0; some threads do not register or decrement count more than once or locking fails");
            }
            return this.threadCount == 0;
        }
    }

    public void systemExitAfterThreadsNonBlocking() {
        Thread thread = new Thread(new ThreadCountZeroMonitorSystemExit());
        thread.start();
    }

    public void systemExitAfterThreadsBlocking() {
        new ThreadCountZeroMonitorSystemExit().run();
    }

    private class ThreadCountZeroMonitorSystemExit
    implements Runnable {
        private ThreadCountZeroMonitorSystemExit() {
        }

        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                if (RuntimeMonitor.this.registeredThreadsFinished()) {
                    bl = false;
                    this.exit();
                    continue;
                }
                try {
                    Thread.sleep(RuntimeMonitor.this.getPollingInterval());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void exit() {
            System.exit(0);
        }
    }
}

