/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap.wrapperpool;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;

public class PMWPool {
    private Class baseClass = Object.class;
    private Class wrappeeClass = Object.class;
    private Stack free = new Stack();
    private Set used = new HashSet();
    private int keepInstances = 10;
    private PropertyTranslator[] translators = new PropertyTranslator[0];
    private PropertyMapWrapper prototype = null;

    public PMWPool(Class clazz, Class clazz2) {
        this.baseClass = clazz;
        this.wrappeeClass = clazz2;
    }

    private PropertyMapWrapper createInstance() {
        PropertyMapWrapper propertyMapWrapper = null;
        if (this.prototype == null) {
            this.prototype = new PMWPooled(this);
            this.prototype.setTranslators(this.translators);
            this.prototype.setBaseClass(this.baseClass);
            this.prototype.setWrappeeClass(this.wrappeeClass);
        }
        propertyMapWrapper = this.prototype.makeClone();
        return propertyMapWrapper;
    }

    public PropertyMapWrapper getInstance(Object object) {
        PropertyMapWrapper propertyMapWrapper = null;
        propertyMapWrapper = this.free.isEmpty() ? this.createInstance() : (PropertyMapWrapper)this.free.pop();
        this.used.add(propertyMapWrapper);
        propertyMapWrapper.setWrappee(object);
        return propertyMapWrapper;
    }

    public void releaseInstance(PropertyMapWrapper propertyMapWrapper) {
        propertyMapWrapper.setWrappee(null);
        this.used.remove(propertyMapWrapper);
        if (this.free.size() < this.keepInstances) {
            this.free.push(propertyMapWrapper);
        } else if (propertyMapWrapper instanceof PMWPooled) {
            ((PMWPooled)propertyMapWrapper).setPool(null);
        }
    }

    public int getKeepInstances() {
        return this.keepInstances;
    }

    public void setKeepInstances(int n) {
        this.keepInstances = n;
    }

    public int getUsedInstanceCount() {
        return this.used.size();
    }

    public int getFreeInstanceCount() {
        return this.free.size();
    }

    public void setTranslators(PropertyTranslator[] propertyTranslatorArray) {
        this.translators = propertyTranslatorArray;
    }
}

