/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options.namingstandards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;

public class NamingStandardRule
implements NamingConstants {
    private List entitiesList = new ArrayList();
    private List attributesList = new ArrayList();
    private List tablesList = new ArrayList();
    private List columnsList = new ArrayList();
    private List domainsList = new ArrayList();
    private List glossariesList = new ArrayList();
    private String logicalSep = "Space";
    private String logicalChar = " ";
    private String relSep = "_";
    private boolean caseProperty = false;
    private boolean abbreviatedOnly = false;
    private String domainsSep = " ";
    private String pkConsr = "{table}_PK";
    private String fkConsr = "{child}_{parent}_FK";
    private String ckConsr = "{table}_CK";
    private String unConstr = "{table}_{column}_UN";
    private String idxConstr = "{table}_{column}_IDX";
    private String colckConstr = "CK_{table}_{column}";
    private String fkColumn = "{ref table}_{ref column}";
    private String uiConsr = "{entity} PK";
    private String relationAttribute = "{ref entity}_{ref attribute}";
    private List glossaries;

    public List getEntitiesList() {
        return this.entitiesList;
    }

    public List getAttributesList() {
        return this.attributesList;
    }

    public List getTablesList() {
        return this.tablesList;
    }

    public List getColumnsList() {
        return this.columnsList;
    }

    public List getDomainsList() {
        return this.domainsList;
    }

    public List getGlossariesList() {
        return this.glossariesList;
    }

    public String getLogicalSep() {
        return this.logicalSep;
    }

    public void setLogicalSep(String string) {
        this.logicalSep = string;
    }

    public String getLogicalChar() {
        return this.logicalChar;
    }

    public void setLogicalChar(String string) {
        this.logicalChar = string;
    }

    public char getLogicalSeparatorChar() {
        if ("Space".equalsIgnoreCase(this.logicalSep) || "Title Case".equalsIgnoreCase(this.logicalSep)) {
            return ' ';
        }
        if ("".equalsIgnoreCase(this.logicalChar)) {
            return '\u0000';
        }
        return this.logicalChar.charAt(0);
    }

    public char getRelationalSeparatorChar() {
        if ("".equalsIgnoreCase(this.relSep)) {
            return '\u0000';
        }
        return this.relSep.charAt(0);
    }

    public char getDomainsSeparatorChar() {
        if ("".equalsIgnoreCase(this.domainsSep)) {
            return '\u0000';
        }
        return this.domainsSep.charAt(0);
    }

    public String getRelSep() {
        return this.relSep;
    }

    public void setRelSep(String string) {
        this.relSep = string;
    }

    public boolean isCaseProperty() {
        return this.caseProperty;
    }

    public void setCaseProperty(boolean bl) {
        this.caseProperty = bl;
    }

    public String getDomainsSep() {
        return this.domainsSep;
    }

    public void setDomainsSep(String string) {
        this.domainsSep = string;
    }

    public String getPkConstr() {
        return this.pkConsr;
    }

    public void setPkConstr(String string) {
        this.pkConsr = string;
    }

    public String getUIConstr() {
        return this.uiConsr;
    }

    public void setUIConstr(String string) {
        this.uiConsr = string;
    }

    public String getFkConstr() {
        return this.fkConsr;
    }

    public void setFkConstr(String string) {
        this.fkConsr = string;
    }

    public String getCkConstr() {
        return this.ckConsr;
    }

    public void setCkConstr(String string) {
        this.ckConsr = string;
    }

    public String getUnConstr() {
        return this.unConstr;
    }

    public void setUnConstr(String string) {
        this.unConstr = string;
    }

    public String getIdxConstr() {
        return this.idxConstr;
    }

    public void setIdxConstr(String string) {
        this.idxConstr = string;
    }

    public String getColckConstr() {
        return this.colckConstr;
    }

    public void setColckConstr(String string) {
        this.colckConstr = string;
    }

    public String getFkColumn() {
        return this.fkColumn;
    }

    public void setFkColumn(String string) {
        this.fkColumn = string;
    }

    public String getRelationAttribute() {
        return this.relationAttribute;
    }

    public void setRelationAttribute(String string) {
        this.relationAttribute = string;
    }

    public List getGlossaries() {
        if (this.glossaries == null) {
            this.glossaries = new ArrayList();
            for (GlossaryFile glossaryFile : this.getGlossariesList()) {
                Glossary glossary = new Glossary(new File(glossaryFile.getFilePath()));
                glossary.prepareUtilityMaps();
                this.glossaries.add(glossary);
            }
        }
        return this.glossaries;
    }

    public void clearGlossaries() {
        if (this.glossaries != null) {
            for (Glossary glossary : this.glossaries) {
                glossary.clearGlossary();
            }
            this.glossaries = null;
        }
    }

    public boolean isAbbreviatedOnly() {
        return this.abbreviatedOnly;
    }

    public void setAbbreviatedOnly(boolean bl) {
        this.abbreviatedOnly = bl;
    }
}

