/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.util.ArrayList;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Messages;

public class ImportLogger {
    private ArrayList warnings = new ArrayList();
    private ArrayList errors = new ArrayList();
    private ArrayList notRecognized = new ArrayList();
    private int importedStatemnets;
    private ArrayList failed = new ArrayList();
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";

    public ArrayList getErrors() {
        return this.errors;
    }

    public void addFailedStatement(String string) {
        if (!"".equalsIgnoreCase(string)) {
            this.failed.add(string.trim());
        }
    }

    public void addError(String string) {
        if (!"".equalsIgnoreCase(string)) {
            this.errors.add(string.trim());
        }
    }

    public void addWarning(String string) {
        this.addWarning(string, false);
    }

    public void addWarning(String string, boolean bl) {
        if (!"".equalsIgnoreCase(string)) {
            if (bl) {
                if (!this.warningExists(string.trim())) {
                    this.warnings.add(string.trim());
                }
            } else {
                this.warnings.add(string);
            }
        }
    }

    public boolean warningExists(String string) {
        for (String string2 : this.warnings) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void setErrors(ArrayList arrayList) {
        this.errors = arrayList;
    }

    public int getFailedStatements() {
        return this.failed.size();
    }

    public ArrayList getNotRecognized() {
        return this.notRecognized;
    }

    public void addNotRecognized(String string) {
        this.notRecognized.add(string);
    }

    public void setNotRecognized(ArrayList arrayList) {
        this.notRecognized = arrayList;
    }

    public int getImportedStatemnets() {
        return this.importedStatemnets;
    }

    public void setImportedStatemnets(int n) {
        this.importedStatemnets = n;
    }

    public void incrementImportedStatements() {
        ++this.importedStatemnets;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList arrayList) {
        this.warnings = arrayList;
    }

    public String generateDDLReport(ApplicationView applicationView, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DesignName")).append(applicationView.getDesignName()).append(NEWLINE);
        stringBuffer.append("RDBMS : ").append(applicationView.getCurrentDesign().getSelectedRDBMSSite()).append(NEWLINE).append(NEWLINE);
        stringBuffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.AllStatements")).append('\t').append('\t').append(n).append(NEWLINE);
        stringBuffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.ImportedStatements")).append('\t').append(this.getImportedStatemnets()).append(NEWLINE);
        stringBuffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.FailedStatements")).append('\t').append('\t').append(this.getFailedStatements()).append(NEWLINE);
        for (int i = 0; i < this.failed.size(); ++i) {
            stringBuffer.append(NEWLINE).append(TAB).append(TAB).append(TAB).append(this.failed.get(i)).append(NEWLINE).append(NEWLINE);
        }
        stringBuffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.NotRecognizedStatements")).append('\t').append(n - this.getImportedStatemnets() - this.getFailedStatements()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String string : this.getErrors()) {
                stringBuffer.append(string).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String string : this.getWarnings()) {
                stringBuffer.append(string).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getNotRecognized().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< " + Messages.getString("ExportLogger.NOTRECOGNIZEDL") + " >>>>>").append(NEWLINE);
            for (String string : this.getNotRecognized()) {
                stringBuffer.append(string).append(NEWLINE).append(NEWLINE);
            }
        }
        return stringBuffer.toString();
    }

    public String generateVARReport(ApplicationView applicationView) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DesignName")).append(applicationView.getDesignName()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String string : this.getErrors()) {
                stringBuffer.append(string).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String string : this.getWarnings()) {
                stringBuffer.append(string).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getErrors().size() == 0 && this.getWarnings().size() == 0) {
            stringBuffer.append(NEWLINE).append(Messages.getString("ImportLogger.ImportFinishedSuccess"));
        }
        return stringBuffer.toString();
    }

    public String generateReport(ApplicationView applicationView) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.DesignName")).append(applicationView.getDesignName()).append(NEWLINE);
        stringBuffer.append(NEWLINE).append(Messages.getString("ImportLogger.ImportFinished")).append(NEWLINE).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.Errors")).append(this.getErrors().size()).append(NEWLINE);
        stringBuffer.append(Messages.getString("ImportLogger.Warnings")).append(this.getWarnings().size()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String string : this.getErrors()) {
                stringBuffer.append(string).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String string : this.getWarnings()) {
                stringBuffer.append(string).append(NEWLINE);
            }
        }
        return stringBuffer.toString();
    }
}

