/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;

public class URLChooserShortcuts
implements URLChooserShortcutProvider {
    private static List<URLChooserShortcut> s_shortcuts = null;

    private static boolean isValidURL(URL uRL) {
        return URLFileSystem.exists((URL)uRL) && URLFileSystem.isDirectory((URL)uRL) && !URLFileSystem.isHidden((URL)uRL);
    }

    private static void addIfExists(URL uRL, String string, Collection<URLChooserShortcut> collection, Icon icon) {
        if (URLChooserShortcuts.isValidURL(uRL)) {
            if (icon == null) {
                collection.add(new URLChooserShortcut(OracleIcons.getIcon((String)"folder.png"), string, uRL));
            } else {
                collection.add(new URLChooserShortcut(icon, string, uRL));
            }
        }
    }

    public Collection<URLChooserShortcut> createShortcuts(Context context) {
        if (s_shortcuts == null) {
            s_shortcuts = new ArrayList<URLChooserShortcut>();
            URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)uRL, (String)"Desktop"), UtilsResources.get((String)"DESKTOP"), s_shortcuts, RaptorImagesArb.getIcon((String)"DESKTOP"));
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)uRL, (String)"Documents"), UtilsResources.get((String)"DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon((String)"MY_DOCUMENTS"));
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)uRL, (String)"My Documents"), UtilsResources.get((String)"MY_DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon((String)"MY_DOCUMENTS"));
        }
        return s_shortcuts;
    }
}

