/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.dbtools.crest.util.gui.swing.DefaultLabelColorScheme;
import oracle.dbtools.crest.util.gui.swing.LabelColorScheme;

public class JSelectableLabel
extends JLabel {
    protected boolean _hasFocus;
    protected boolean _isSelected;
    protected LabelColorScheme _colorScheme;
    private int _heightAdj;

    public JSelectableLabel() {
        this("");
    }

    public JSelectableLabel(String string) {
        this(string, new DefaultLabelColorScheme());
    }

    public JSelectableLabel(String string, LabelColorScheme labelColorScheme) {
        super(string);
        this._colorScheme = labelColorScheme;
        this.setHasFocus(false);
        this.setSelected(false);
        this.setBorder(new EmptyBorder(0, 3, 0, 3));
    }

    public boolean getHasFocus() {
        return this._hasFocus;
    }

    public void setHasFocus(boolean bl) {
        this._hasFocus = bl;
    }

    public void setHeightAdjustment(int n) {
        this._heightAdj = n;
        this.setVerticalAlignment(n == 0 ? 0 : 3);
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
        this._updateColors();
    }

    protected void _updateColors() {
        if (this.isSelected()) {
            this.setForeground(this._colorScheme.getTextSelectionColor());
            this.setBackground(this._colorScheme.getBackgroundSelectionColor());
        } else if (!this.isEnabled()) {
            this.setForeground(Color.gray);
            this.setBackground(this._colorScheme.getBackgroundNonSelectionColor());
        } else {
            this.setForeground(this._colorScheme.getTextNonSelectionColor());
            this.setBackground(this._colorScheme.getBackgroundNonSelectionColor());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height += this._heightAdj;
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getLabelStart();
        boolean bl = this.isEnabled();
        if (this._isSelected) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, this._heightAdj, this.getWidth() - 1 - n, this.getHeight() - this._heightAdj);
        }
        if (this._hasFocus) {
            Border border = UIManager.getBorder("Tree.focusBorder");
            if (border != null) {
                graphics.setColor(this.getForeground());
                border.paintBorder(this, graphics, n, this._heightAdj, this.getWidth() - n, this.getHeight() - this._heightAdj);
            } else {
                if (!bl) {
                    graphics.setColor(this._colorScheme.getBackgroundSelectionColor());
                } else {
                    graphics.setColor(this._colorScheme.getBorderSelectionColor());
                }
                graphics.drawRect(n, this._heightAdj, this.getWidth() - 1 - n, this.getHeight() - 1 - this._heightAdj);
            }
        }
        super.paint(graphics);
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(8, this.getIconTextGap() - 1) - 1;
        }
        return 0;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._updateColors();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._colorScheme != null) {
            this._colorScheme.updateUI();
        }
    }
}

