/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JDecimalField
extends JFormattedTextField {
    private DecimalFormat df;

    public JDecimalField() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.df = numberFormat instanceof DecimalFormat ? (DecimalFormat)numberFormat : new DecimalFormat("###.##");
        this.setDocument(new DecimalDocument());
    }

    public JDecimalField(double d, int n) {
        this.df = new DecimalFormat("###.##");
        this.setDocument(new DecimalDocument());
        this.setColumns(n);
        this.setValue(d);
    }

    public void setValue(double d) {
        try {
            this.setText(this.df.format(d));
        }
        catch (Exception exception) {
            this.setText(Double.toString(d));
        }
    }

    public void setValue(float f) {
        try {
            String string = Float.toString(f);
            if (string.equalsIgnoreCase("0.0")) {
                this.setText("0");
            } else {
                this.setText(string);
            }
        }
        catch (Exception exception) {
            this.setText("0");
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (ClassCastException classCastException) {
            return Long.parseLong(this.getText());
        }
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.getText());
        }
        catch (ClassCastException classCastException) {
            return Long.parseLong(this.getText());
        }
    }

    static class DecimalDocument
    extends PlainDocument {
        DecimalDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            if (n2 == 0) {
                string2 = string;
            } else {
                String string3 = this.getText(0, n2);
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.insert(n, string);
                string2 = stringBuffer.toString();
            }
            try {
                Double.parseDouble(string2);
                super.insertString(n, string, attributeSet);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

