/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.exceptions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DDLExceptionList {
    private static final String EXCEPTIONS_FILE_NAME = "ddlexceptions.xml";
    private static final String DDLEXCEPTION_ELEMENT = "ddlexception";
    private static final String DDLEXCEPTIONS_NUMBER = "ddlexception";
    private static final String DDLEXCEPTIONS_DESCRIPTION = "number";
    private static final String DDLEXCEPTIONS_SELECTED = "selected";
    private List<DDLException> ddlExceptions = new ArrayList<DDLException>();
    private static final Logger LOGGER = new Logger(DDLExceptionList.class);

    public List<DDLException> getDDLExceptions() {
        return this.ddlExceptions;
    }

    public boolean addDDLException(DDLException dDLException) {
        if (!this.containsDDLException(dDLException)) {
            return this.ddlExceptions.add(dDLException);
        }
        return false;
    }

    public void removeDDLException(DDLException dDLException) {
        this.ddlExceptions.remove(dDLException);
    }

    public boolean containsDDLException(DDLException dDLException) {
        for (DDLException dDLException2 : this.ddlExceptions) {
            if (dDLException.getNumber() != dDLException2.getNumber()) continue;
            return true;
        }
        return false;
    }

    public void clearDDLExceptionsList() {
        this.ddlExceptions.clear();
    }

    public void init() {
        block5: {
            try {
                File file = new File(EXCEPTIONS_FILE_NAME);
                if (!file.exists()) break block5;
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = document.getElementsByTagName("ddlexception");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element = (Element)nodeList.item(i);
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(element.getAttribute("ddlexception"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String string = StringUtilities.decodeAttributeValue(element.getAttribute(DDLEXCEPTIONS_DESCRIPTION));
                    boolean bl = Boolean.valueOf(element.getAttribute(DDLEXCEPTIONS_SELECTED));
                    DDLException dDLException = new DDLException(n2, string);
                    dDLException.setSelected(bl);
                    this.addDDLException(dDLException);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to initialize DDL Exceptions: ", exception);
            }
        }
    }
}

