/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CompareMappingDialog
extends CustomDialog {
    private JDialog dialog;
    private List mappingList;
    private JTable mappingTable;
    private JPanel general;
    private JButton bnOK;
    private JButton bnCancel;
    private Map selectedValuesMap = new TreeMap();
    private JButton bnRemoveColumn;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private static final String BTN_REMOVE = Messages.getString("CompareMappingDialog.Remove");

    public CompareMappingDialog(ApplicationView applicationView) {
        super(applicationView);
        this.general = new JPanel(new BorderLayout());
        this.general.setPreferredSize(new Dimension(500, 300));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        jPanel.add(this.bnOK);
        jPanel.add(this.bnCancel);
        jPanel.add(jButton);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.add((Component)this.general, "Center");
        this.add((Component)jPanel, "South");
        this.createTable();
        this.add((Component)this.general, "Center");
        this.initTable();
    }

    public JPanel getGeneralPane() {
        return this.general;
    }

    private void createTable() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mappingList = new ArrayList();
        CompareMappingModel compareMappingModel = new CompareMappingModel();
        this.mappingTable = new JTable(compareMappingModel);
        this.mappingTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mappingTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.bnRemoveColumn = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveCompareMappingObject());
        this.bnSelectAll = new JButton(gUIConfiguration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAll.setToolTipText(Messages.getString("CompareMappingDialog.SelectAll"));
        this.bnSelectAll.addActionListener(new SelectAllCompareMappingObject());
        this.bnDeselectAll = new JButton(gUIConfiguration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAll.setToolTipText(Messages.getString("CompareMappingDialog.DeselectAll"));
        this.bnDeselectAll.addActionListener(new DeselectAllCompareMappingObject());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.addSeparator();
        jToolBar.add(this.bnRemoveColumn);
        jToolBar.addSeparator();
        jToolBar.add(this.bnSelectAll);
        jToolBar.add(this.bnDeselectAll);
        jPanel2.add(jToolBar);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.general.add(jPanel);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.getCaption(), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public String getCaption() {
        return Messages.getString("CompareMappingDialog.CompareMapping");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "COMPARE_MAPPING_DIALOG";
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void initTable() {
        for (CompareMappingObject compareMappingObject : this.getApplicationView().getCurrentDesign().getDLSettings().getCompareMapping().asList()) {
            CompareMappingObject compareMappingObject2 = new CompareMappingObject(compareMappingObject.getSourceParentName(), compareMappingObject.getSourceObjectName(), compareMappingObject.getTargetParentName(), compareMappingObject.getTargetObjectName());
            compareMappingObject2.setSelected(compareMappingObject.isSelected());
            this.mappingList.add(compareMappingObject2);
            this.addToSelectedValueMap(this.mappingList.size() - 1, compareMappingObject2);
        }
        this.mappingTable.updateUI();
    }

    private void addToSelectedValueMap(int n, CompareMappingObject compareMappingObject) {
        String string = compareMappingObject.getTargetParentName() + '.' + compareMappingObject.getTargetObjectName();
        if (this.selectedValuesMap.containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.selectedValuesMap.get(string);
            arrayList.add(new Integer(n));
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(n));
            this.selectedValuesMap.put(string, arrayList);
        }
    }

    public void setMapping() {
        int n = this.mappingTable.getEditingColumn();
        int n2 = this.mappingTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            this.mappingTable.getCellEditor(n2, n).stopCellEditing();
        }
        Iterator iterator = this.mappingList.iterator();
        CompareMapping compareMapping = this.getApplicationView().getCurrentDesign().getDLSettings().getCompareMapping();
        compareMapping.getCompareMap().clear();
        while (iterator.hasNext()) {
            CompareMappingObject compareMappingObject = (CompareMappingObject)iterator.next();
            compareMapping.addCompareMappingObject(compareMappingObject);
        }
    }

    public Action createOKButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CompareMappingDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareMappingDialog.this.setMapping();
                CompareMappingDialog.this.close();
            }
        };
        return abstractAction;
    }

    public Action createCancelButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CompareMappingDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CompareMappingDialog.this.mappingTable.getEditingColumn();
                int n2 = CompareMappingDialog.this.mappingTable.getEditingRow();
                if (n > -1 && n2 > -1) {
                    CompareMappingDialog.this.mappingTable.getCellEditor(n2, n).cancelCellEditing();
                }
                CompareMappingDialog.this.close();
            }
        };
        return abstractAction;
    }

    private int getPreferredIconSize() {
        return 16;
    }

    private class RemoveCompareMappingObject
    implements ActionListener {
        private RemoveCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CompareMappingDialog.this.mappingTable.getSelectedRow();
            if (n != -1 && CompareMappingDialog.this.mappingList.size() > 0 && n < CompareMappingDialog.this.mappingList.size()) {
                CompareMappingObject compareMappingObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(n);
                String string = (String)CompareMappingDialog.this.mappingTable.getValueAt(n, 2);
                CompareMappingDialog.this.selectedValuesMap.remove(string);
                CompareMappingDialog.this.mappingList.remove(compareMappingObject);
                CompareMappingDialog.this.mappingTable.updateUI();
            }
        }
    }

    private class DeselectAllCompareMappingObject
    implements ActionListener {
        private DeselectAllCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (CompareMappingObject compareMappingObject : CompareMappingDialog.this.mappingList) {
                compareMappingObject.setSelected(false);
            }
            CompareMappingDialog.this.mappingTable.updateUI();
        }
    }

    private class SelectAllCompareMappingObject
    implements ActionListener {
        private SelectAllCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = CompareMappingDialog.this.selectedValuesMap.keySet().iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList = (ArrayList)CompareMappingDialog.this.selectedValuesMap.get(iterator.next());
                if (arrayList.size() <= 0) continue;
                Integer n = (Integer)arrayList.get(0);
                CompareMappingDialog.this.mappingTable.setValueAt(Boolean.TRUE, n, 0);
            }
        }
    }

    public class CompareMappingModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CompareMappingDialog.this.mappingList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareMappingDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("CompareMappingDialog.SourceObject");
            }
            if (n == 2) {
                return Messages.getString("CompareMappingDialog.TargetObject");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CompareMappingObject compareMappingObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(n);
            if (n2 == 0) {
                return compareMappingObject.isSelected();
            }
            if (n2 == 1) {
                return compareMappingObject.getSourceParentName() + '.' + compareMappingObject.getSourceObjectName();
            }
            if (n2 == 2) {
                return compareMappingObject.getTargetParentName() + '.' + compareMappingObject.getTargetObjectName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CompareMappingObject compareMappingObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(n);
            if (n2 == 0) {
                compareMappingObject.setSelected((Boolean)object);
                if (compareMappingObject.isSelected()) {
                    String string = (String)this.getValueAt(n, 2);
                    if (CompareMappingDialog.this.selectedValuesMap.containsKey(string)) {
                        for (Integer n3 : (List)CompareMappingDialog.this.selectedValuesMap.get(string)) {
                            if (n == n3) continue;
                            CompareMappingObject compareMappingObject2 = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(n3);
                            compareMappingObject2.setSelected(false);
                        }
                    }
                    this.fireTableDataChanged();
                }
            }
        }
    }
}

