/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class WinRegistry {
    public static final int _HKEY_LOCAL_MACHINE = -2147483646;
    public static final int KEY_READ = 131097;
    private Method openKey = null;
    private Method closeKey = null;
    private Method queryInfoKey = null;
    private Method enumKey = null;
    private Method queryValue = null;

    public WinRegistry() throws Exception {
        this.initMethods();
    }

    public int openKey(int n, String string, int n2) throws Exception {
        int[] nArray = (int[])this.openKey.invoke(null, new Integer(n), this.getString(string), new Integer(n2));
        if (nArray == null || nArray[1] != 0) {
            return -1;
        }
        return nArray[0];
    }

    private int[] getChildInformation(int n) throws Exception {
        return (int[])this.queryInfoKey.invoke(null, new Integer(n));
    }

    private byte[] enumKeys(int n, int n2, int n3) throws Exception {
        return (byte[])this.enumKey.invoke(null, new Integer(n), new Integer(n2), new Integer(n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys(int n, String string) throws Exception {
        int n2 = -1;
        try {
            int[] nArray;
            n2 = this.openKey(n, string, 131097);
            if (n2 != -1 && (nArray = this.getChildInformation(n2)) != null && nArray[0] != -1) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != nArray[0]; ++i) {
                    String string2 = WinRegistry.parseValue(this.enumKeys(n2, i, nArray[3] + 1));
                    if (string2 == null) continue;
                    arrayList.add(string2);
                }
                ArrayList<String> arrayList2 = arrayList.isEmpty() ? null : arrayList;
                return arrayList2;
            }
        }
        finally {
            this.closeKey(n2);
        }
        return null;
    }

    public int closeKey(int n) throws Exception {
        Integer n2 = (Integer)this.closeKey.invoke(null, new Integer(n));
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public static String parseValue(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray);
        if (string.charAt(string.length() - 1) == '\u0000') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private byte[] getString(String string) {
        if (string == null) {
            string = "";
        }
        string = string + "\u0000";
        return string.getBytes();
    }

    private void initMethods() throws Exception {
        Class<?> clazz = null;
        clazz = Class.forName("java.util.prefs.WindowsPreferences");
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray == null) {
            throw new Exception("Cannot access java.util.prefs.WindowsPreferences class!");
        }
        for (int i = 0; i != methodArray.length; ++i) {
            if (methodArray[i] == null) continue;
            if (methodArray[i].getName().equals("WindowsRegOpenKey")) {
                this.openKey = methodArray[i];
                this.openKey.setAccessible(true);
                continue;
            }
            if (methodArray[i].getName().equals("WindowsRegCloseKey")) {
                this.closeKey = methodArray[i];
                this.closeKey.setAccessible(true);
                continue;
            }
            if (methodArray[i].getName().equals("WindowsRegQueryInfoKey")) {
                this.queryInfoKey = methodArray[i];
                this.queryInfoKey.setAccessible(true);
                continue;
            }
            if (methodArray[i].getName().equals("WindowsRegEnumKeyEx")) {
                this.enumKey = methodArray[i];
                this.enumKey.setAccessible(true);
                continue;
            }
            if (!methodArray[i].getName().equals("WindowsRegQueryValueEx")) continue;
            this.queryValue = methodArray[i];
            this.queryValue.setAccessible(true);
        }
    }

    public byte[] readValue(int n, String string) throws Exception {
        byte[] byArray = (byte[])this.queryValue.invoke(null, new Integer(n), this.getString(string));
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "Software\\Oracle";
        try {
            WinRegistry winRegistry = new WinRegistry();
            List list = winRegistry.getKeys(-2147483646, string);
            if (list != null) {
                for (Object e : list) {
                    int n = winRegistry.openKey(-2147483646, string + "\\" + (String)e, 131097);
                    if (n <= -1) continue;
                    try {
                        byte[] byArray = winRegistry.readValue(n, "ORACLE_HOME");
                        if (byArray == null) continue;
                        System.out.println(WinRegistry.parseValue(byArray));
                    }
                    finally {
                        winRegistry.closeKey(n);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

