/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.undo.FormatTV_Edit;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TopViewColorDialog
extends JDialog
implements ItemListener,
AbstractEditorConstants {
    private Object[] topViews;
    private JCheckBox chbUseCustomFormat = new JCheckBox("<html><body><b>" + Messages.getString("TopViewColorDialog.UseCustomFormat") + "</b>" + "</body>" + "</html>");
    private JCheckBox chbUseDefault = new JCheckBox("<html><body><b>" + Messages.getString("TopViewColorDialog.UseDefaultColor") + "</b>" + "</body>" + "</html>");
    private JButton bnBackground;
    private JButton bnBorder;
    private JButton bnFontColor;
    private Color backgroundColor = null;
    private Color borderColor = null;
    private JComboBox fontList;
    private JComboBox sizeList;
    private JComboBox styleList;
    private JLabel lbPreview;
    private boolean enableFonts = false;
    private JList efList;
    private FontObject currentFO = null;
    private boolean selected = true;
    private List tempFonts;
    private DefaultFontAndColor dfc = null;
    private JButton bnCancel;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopViewColorDialog.this.bnCancel.doClick();
        }
    };

    public TopViewColorDialog(Object[] objectArray) {
        super(((TopView)objectArray[0]).getApplicationView().getFrame());
        this.topViews = objectArray;
        this.setTitle(Messages.getString("TopViewColorDialog.FormatObject"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TopViewColorDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new OKAction(Messages.getString("TopViewColorDialog.OK")));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(new ApplyAction(Messages.getString("TopViewColorDialog.Apply")));
        jButton2.setMnemonic(65);
        this.bnCancel = new JButton(new CancelAction(Messages.getString("TopViewColorDialog.Cancel")));
        this.bnCancel.setMnemonic(67);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.bnCancel);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Messages.getString("TopViewColorDialog.Colors"), this.initColorPanel());
        if (((TopView)objectArray[0]).getModel() instanceof EditableFonts) {
            jTabbedPane.addTab(Messages.getString("TopViewColorDialog.Font"), this.initFontPanel());
            this.enableFonts = true;
        }
        this.getContentPane().add((Component)jTabbedPane, "North");
        this.getContentPane().add((Component)jPanel, "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    public TopViewColorDialog(DefaultFontAndColor defaultFontAndColor) {
        this.dfc = defaultFontAndColor;
        this.setTitle(MessageFormat.format(Messages.getString("TopViewColorDialog.Format"), defaultFontAndColor.getClassName()));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TopViewColorDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new OKAction(Messages.getString("TopViewColorDialog.OK")));
        jButton.setMnemonic(79);
        this.bnCancel = new JButton(new CancelAction(Messages.getString("TopViewColorDialog.Cancel")));
        this.bnCancel.setMnemonic(67);
        jPanel.add(jButton);
        jPanel.add(this.bnCancel);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Messages.getString("TopViewColorDialog.Colors"), this.initColorPanel());
        jTabbedPane.addTab(Messages.getString("TopViewColorDialog.Font"), this.initFontPanel());
        this.enableFonts = true;
        this.getContentPane().add((Component)jTabbedPane, "North");
        this.getContentPane().add((Component)jPanel, "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel initColorPanel() {
        Object object;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
        JPanel jPanel4 = new JPanel(new FlowLayout(3));
        JPanel jPanel5 = new JPanel(new FlowLayout(3));
        if (this.dfc == null) {
            jPanel4.add(this.chbUseCustomFormat);
            jPanel5.add(this.chbUseDefault);
        }
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel2.add(jPanel3);
        this.chbUseDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TopViewColorDialog.this.bnBackground.setEnabled(false);
                    TopViewColorDialog.this.bnBorder.setEnabled(false);
                } else {
                    TopViewColorDialog.this.bnBackground.setEnabled(true);
                    TopViewColorDialog.this.bnBorder.setEnabled(true);
                }
            }
        });
        this.bnBackground = new JButton();
        this.backgroundColor = this.dfc != null ? this.dfc.getBackgroundColor() : ((TopView)this.topViews[0]).getBackgroundColor();
        if (this.backgroundColor == null && (serializable2 = ((TopView)this.topViews[0]).getCellView()) != null && (object2 = ((AbstractCellView)serializable2).getRenderer()) != null) {
            this.backgroundColor = object2.getBGColor();
        }
        if (this.backgroundColor != null) {
            this.bnBackground.setBackground(this.backgroundColor);
        }
        this.bnBackground.setPreferredSize(new Dimension(140, 20));
        this.bnBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectBackgroundColor"), TopViewColorDialog.this.bnBackground.getBackground());
                Color color = colorChooserDialog.showDialog();
                if (color != null) {
                    TopViewColorDialog.this.backgroundColor = color;
                    TopViewColorDialog.this.bnBackground.setBackground(TopViewColorDialog.this.backgroundColor);
                }
            }
        });
        serializable2 = new JLabel(Messages.getString("TopViewColorDialog.BackgroundColor"));
        ((JComponent)serializable2).setPreferredSize(new Dimension(140, 20));
        object2 = new JPanel(new FlowLayout(3));
        ((Container)object2).add((Component)serializable2);
        ((Container)object2).add(this.bnBackground);
        jPanel2.add((Component)object2);
        this.bnBorder = new JButton();
        this.borderColor = this.dfc != null ? this.dfc.getForegroundColor() : ((TopView)this.topViews[0]).getForegroundColor();
        if (this.borderColor == null && (serializable = ((TopView)this.topViews[0]).getCellView()) != null && (object = ((AbstractCellView)serializable).getRenderer()) != null) {
            this.borderColor = object.getFGColor();
        }
        if (this.borderColor != null) {
            this.bnBorder.setBackground(this.borderColor);
        }
        this.bnBorder.setPreferredSize(this.bnBackground.getPreferredSize());
        this.bnBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectBorderColor"), TopViewColorDialog.this.bnBorder.getBackground());
                Color color = colorChooserDialog.showDialog();
                if (color != null) {
                    TopViewColorDialog.this.borderColor = color;
                    TopViewColorDialog.this.bnBorder.setBackground(TopViewColorDialog.this.borderColor);
                }
            }
        });
        serializable = new JLabel(Messages.getString("TopViewColorDialog.BorderColor"));
        ((JComponent)serializable).setPreferredSize(new Dimension(140, 20));
        object = new JPanel(new FlowLayout(3));
        ((Container)object).add((Component)serializable);
        ((Container)object).add(this.bnBorder);
        jPanel2.add((Component)object);
        if (this.dfc == null) {
            this.chbUseCustomFormat.setSelected(((TopView)this.topViews[0]).useCustomFormat());
            this.chbUseDefault.setSelected(((TopView)this.topViews[0]).useDefaultColor());
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel initFontPanel() {
        int n;
        Object object2;
        JPanel jPanel = new JPanel(new BorderLayout());
        EditableFonts editableFonts = this.dfc != null ? this.dfc : (EditableFonts)((Object)((TopView)this.topViews[0]).getModel());
        this.tempFonts = new ArrayList();
        for (Object object2 : editableFonts.getEditableFonts()) {
            this.tempFonts.add(((FontObject)object2).copy());
        }
        this.efList = new JList<Object>(this.tempFonts.toArray());
        this.efList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TopViewColorDialog.this.efList.getSelectedIndex() > -1) {
                    TopViewColorDialog.this.selected = false;
                    TopViewColorDialog.this.currentFO = (FontObject)TopViewColorDialog.this.efList.getSelectedValue();
                    TopViewColorDialog.this.fontList.setSelectedItem(TopViewColorDialog.this.currentFO.getFont().getName());
                    TopViewColorDialog.this.sizeList.setSelectedItem(new Integer(TopViewColorDialog.this.currentFO.getFont().getSize()));
                    TopViewColorDialog.this.styleList.setSelectedIndex(TopViewColorDialog.this.currentFO.getFont().getStyle());
                    TopViewColorDialog.this.bnFontColor.setBackground(TopViewColorDialog.this.currentFO.getColor());
                    TopViewColorDialog.this.lbPreview.setForeground(TopViewColorDialog.this.currentFO.getColor());
                    TopViewColorDialog.this.lbPreview.setFont(TopViewColorDialog.this.currentFO.getFont());
                    TopViewColorDialog.this.lbPreview.setText(TopViewColorDialog.this.currentFO.getFont().getName());
                    TopViewColorDialog.this.selected = true;
                }
            }
        });
        object2 = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)new JLabel(Messages.getString("TopViewColorDialog.Symbol")), "North");
        JScrollPane jScrollPane = new JScrollPane(this.efList);
        jScrollPane.setPreferredSize(new Dimension(140, 140));
        jPanel2.add((Component)jScrollPane, "Center");
        ((Container)object2).add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.fontList = new JComboBox();
        this.sizeList = new JComboBox();
        this.styleList = new JComboBox<Object>(new Object[]{Messages.getString("TopViewColorDialog.Regular"), Messages.getString("TopViewColorDialog.Bold"), Messages.getString("TopViewColorDialog.Italic"), Messages.getString("TopViewColorDialog.BoldItalic")});
        this.fontList.setPreferredSize(new Dimension(200, 20));
        this.fontList.setMaximumRowCount(20);
        this.sizeList.setPreferredSize(new Dimension(60, 20));
        this.styleList.setPreferredSize(new Dimension(70, 20));
        this.sizeList.setMaximumRowCount(20);
        JPanel jPanel4 = new JPanel(new FlowLayout(3));
        JLabel jLabel = new JLabel(Messages.getString("TopViewColorDialog.Name"));
        jLabel.setPreferredSize(new Dimension(60, 20));
        jPanel4.add(jLabel);
        jPanel4.add(this.fontList);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(3));
        JLabel jLabel2 = new JLabel(Messages.getString("TopViewColorDialog.Size"));
        jLabel2.setPreferredSize(jLabel.getPreferredSize());
        jPanel5.add(jLabel2);
        jPanel5.add(this.sizeList);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(3));
        JLabel jLabel3 = new JLabel(Messages.getString("TopViewColorDialog.Style"));
        jLabel3.setPreferredSize(jLabel.getPreferredSize());
        jPanel6.add(jLabel3);
        jPanel6.add(this.styleList);
        jPanel3.add(jPanel6);
        this.bnFontColor = new JButton();
        this.bnFontColor.setPreferredSize(new Dimension(140, 20));
        this.bnFontColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserDialog colorChooserDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectFontColor"), TopViewColorDialog.this.bnFontColor.getBackground());
                Color color = colorChooserDialog.showDialog();
                if (color != null) {
                    TopViewColorDialog.this.bnFontColor.setBackground(color);
                    TopViewColorDialog.this.lbPreview.setForeground(color);
                    if (TopViewColorDialog.this.currentFO != null) {
                        TopViewColorDialog.this.currentFO.setColor(color);
                    }
                }
            }
        });
        JLabel jLabel4 = new JLabel(Messages.getString("TopViewColorDialog.Color"));
        jLabel4.setPreferredSize(jLabel.getPreferredSize());
        JPanel jPanel7 = new JPanel(new FlowLayout(3));
        jPanel7.add(jLabel4);
        jPanel7.add(this.bnFontColor);
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.setPreferredSize(new Dimension(200, 80));
        this.lbPreview = new JLabel();
        this.lbPreview.setHorizontalAlignment(0);
        jPanel8.add(this.lbPreview);
        jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getString("TopViewColorDialog.Preview")));
        jPanel8.setBackground(Color.WHITE);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        for (n = 0; n < stringArray.length; ++n) {
            this.fontList.addItem(stringArray[n]);
        }
        for (n = 6; n < 73; ++n) {
            this.sizeList.addItem(new Integer(n));
        }
        this.fontList.addItemListener(this);
        this.sizeList.addItemListener(this);
        this.styleList.addItemListener(this);
        this.efList.setSelectedIndex(0);
        ((Container)object2).add((Component)jPanel3, "Center");
        jPanel.add((Component)object2, "North");
        jPanel.add(jPanel8);
        return jPanel;
    }

    private void setTopView() {
        if (this.dfc != null) {
            if (!this.dfc.getBackgroundColor().equals(this.backgroundColor) || !this.dfc.getForegroundColor().equals(this.borderColor)) {
                DefaultFontAndColor.setModified(this.dfc.getClassName());
            }
            this.dfc.setBackgroundColor(this.backgroundColor);
            this.dfc.setForegroundColor(this.borderColor);
            for (FontObject fontObject : this.tempFonts) {
                FontObject fontObject2 = this.dfc.getFontObject(fontObject.getType());
                if (fontObject2 == null) continue;
                this.dfc.getEditableFonts().remove(fontObject2);
                this.dfc.getEditableFonts().add(fontObject.copy());
            }
        } else {
            TopView topView;
            int n;
            FormatTV_Edit formatTV_Edit = null;
            formatTV_Edit = this.enableFonts ? new FormatTV_Edit(this.topViews, this.chbUseCustomFormat.isSelected(), this.chbUseDefault.isSelected(), this.backgroundColor, this.borderColor, this.tempFonts) : new FormatTV_Edit(this.topViews, this.chbUseCustomFormat.isSelected(), this.chbUseDefault.isSelected(), this.backgroundColor, this.borderColor, new ArrayList());
            formatTV_Edit.applyUpdates();
            formatTV_Edit.end();
            ((TopView)this.topViews[0]).getModel().getDesignPart().postUndoableEdit(formatTV_Edit);
            for (n = 0; n < this.topViews.length; ++n) {
                topView = (TopView)this.topViews[n];
                topView.getModel().setDirty(true);
            }
            for (n = 0; n < formatTV_Edit.getTopViews().length; ++n) {
                topView = (TopView)formatTV_Edit.getTopViews()[n];
                topView.getDesignPartView().setDirty(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.selected && this.currentFO != null) {
            String string = (String)this.fontList.getSelectedItem();
            int n = (Integer)this.sizeList.getSelectedItem();
            int n2 = this.styleList.getSelectedIndex();
            Font font = new Font(string.trim(), n2, n);
            this.currentFO.setFont(font);
            this.lbPreview.setText(string.trim());
            this.lbPreview.setFont(font);
            this.lbPreview.repaint();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopViewColorDialog.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopViewColorDialog.this.setTopView();
            if (TopViewColorDialog.this.dfc == null) {
                ((TopView)TopViewColorDialog.this.topViews[0]).getCellView().getDiagram().repaint();
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopViewColorDialog.this.setTopView();
            TopViewColorDialog.this.dispose();
        }
    }
}

