/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectVersionDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable desTable;
    private AbstractRepositoryManager.DesignDescriptor result = null;
    private List elmList;
    private List desList;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectVersionDialog.this.dispose();
        }
    };

    public SelectVersionDialog(Frame frame) {
        super(frame, Messages.getString("SelectVersionDialog.SelectDesignAndRepositoryVersion"), true);
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(700, 350));
        CommonUtil.centerOnScreen(this);
    }

    private void loadVersions(AbstractRepositoryManager.DesignDescriptor designDescriptor) {
        this.elmList.clear();
        try {
            this.elmList.add(0, new Version(designDescriptor.v_sequence, designDescriptor.date_created, designDescriptor.checkout_by));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
        if (this.elmList.size() > 0) {
            this.jtable.setRowSelectionInterval(0, 0);
        }
    }

    private void loadDesigns(List list) {
        try {
            for (AbstractRepositoryManager.DesignDescriptor designDescriptor : list) {
                this.desList.add(designDescriptor);
            }
            this.desTable.updateUI();
            if (this.desList.size() > 0) {
                this.desTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.desList = new ArrayList();
        this.desTable = new JTable(new DesignTableModel());
        this.desTable.setSelectionMode(0);
        this.desTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SelectVersionDialog.this.desTable.getSelectedRow();
                if (n != -1 && SelectVersionDialog.this.desList.size() > 0 && n < SelectVersionDialog.this.desList.size()) {
                    AbstractRepositoryManager.DesignDescriptor designDescriptor = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(n);
                    SelectVersionDialog.this.loadVersions(designDescriptor);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.desTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.setSelectionMode(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.jtable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.jtable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        this.jtable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.jtable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(1).setMaxWidth(120);
        JScrollPane jScrollPane2 = new JScrollPane(this.jtable);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(342);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton(Messages.getString("SelectVersionDialog.OK"));
        jButton.setMnemonic(79);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRepositoryManager.DesignDescriptor designDescriptor = null;
                int n = SelectVersionDialog.this.desTable.getSelectedRow();
                if (n != -1 && SelectVersionDialog.this.desList.size() > 0 && n < SelectVersionDialog.this.desList.size()) {
                    designDescriptor = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(n);
                }
                SelectVersionDialog.this.result = designDescriptor;
                SelectVersionDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("SelectVersionDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectVersionDialog.this.dispose();
            }
        });
        jPanel.add(jButton2);
        return jPanel;
    }

    public AbstractRepositoryManager.DesignDescriptor getResult() {
        return this.result;
    }

    public static AbstractRepositoryManager.DesignDescriptor showDialog(Frame frame, List list) {
        SelectVersionDialog selectVersionDialog = new SelectVersionDialog(frame);
        selectVersionDialog.loadDesigns(list);
        selectVersionDialog.setVisible(true);
        return selectVersionDialog.getResult();
    }

    private class Version {
        int version;
        String date;
        String checkout_by;

        public Version(int n, String string, String string2) {
            this.version = n;
            this.date = string;
            this.checkout_by = string2 == null ? "" : string2;
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectVersionDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectVersionDialog.Version");
            }
            if (n == 1) {
                return Messages.getString("SelectVersionDialog.Date");
            }
            if (n == 2) {
                return Messages.getString("SelectVersionDialog.SelectVersionDialog.CheckoutBy");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Version version = (Version)SelectVersionDialog.this.elmList.get(n);
            if (n2 == 0) {
                return version.version;
            }
            if (n2 == 1) {
                return version.date;
            }
            if (n2 == 2) {
                return version.checkout_by;
            }
            return new Integer(n * n2);
        }
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectVersionDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectVersionDialog.DesignName");
            }
            if (n == 1) {
                return Messages.getString("SelectVersionDialog.Comment");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractRepositoryManager.DesignDescriptor designDescriptor = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(n);
            if (n2 == 0) {
                return designDescriptor.name;
            }
            if (n2 == 1) {
                return designDescriptor.short_description;
            }
            return new Integer(n * n2);
        }
    }
}

