/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.util.Messages;

public class JDBCDriverLoader
extends URLClassLoader {
    private static JDBCDriverLoader instance = null;

    private JDBCDriverLoader() {
        super(new URL[0]);
    }

    public static JDBCDriverLoader getInstance() {
        if (instance == null) {
            instance = new JDBCDriverLoader();
        }
        return instance;
    }

    private void addFile(String string) throws MalformedURLException {
        String string2 = "jar:file:" + string.replace('\\', '/') + "!/";
        this.addURL(new URL(string2));
    }

    private boolean urlExists(String string) {
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            if (!uRL.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void loadDrivers(List list) {
        try {
            for (String string : list) {
                if (this.urlExists(string)) continue;
                this.addFile(string);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public Connection getConnection(String string, String string2, String string3, String string4) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("user", string3);
        properties.setProperty("password", string4);
        return this.getConnection(string, string2, properties);
    }

    public Connection getConnection(String string, String string2, Properties properties) throws Exception {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            Driver driver = (Driver)this.loadClass(string).newInstance();
            Connection connection = driver.connect(string2, properties);
            if (connection == null) {
                throw new Exception(Messages.getString("JDBCDriverLoader.getConnection_invalid_url_for_driver"));
            }
            return connection;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.getClass().getSimpleName() + ": " + throwable.getMessage(), throwable);
        }
    }
}

