/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.File;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.ExtensionRegistry;
import oracle.ideri.util.Product;

public class Extension {
    public static final String EXTENSION_ID = "oracle.datamodeler";
    public static final String VIEWER_EXTENSION_ID = "oracle.datamodeler.viewer";
    public static final String SVN_EXTENSION_ID = "oracle.jdeveloper.subversion";
    public static boolean isExtension = true;
    private static String extVersion = null;

    public static String getExtensionVersion() {
        if (extVersion == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension extension = extensionRegistry.findExtension(Extension.getExtensionID());
            extVersion = extension != null ? extension.getName() + " " + extension.getVersion().toString() : Messages.getString("Extension.Version");
        }
        return extVersion;
    }

    public static boolean isViewer() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        javax.ide.extension.Extension extension = extensionRegistry.findExtension(VIEWER_EXTENSION_ID);
        return extension != null;
    }

    public static boolean isSVNExtensionLoaded() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        javax.ide.extension.Extension extension = extensionRegistry.findExtension(SVN_EXTENSION_ID);
        return extension != null;
    }

    public static String getExtensionID() {
        if (Extension.isViewer()) {
            return VIEWER_EXTENSION_ID;
        }
        return EXTENSION_ID;
    }

    public static boolean isDataModeler() {
        return EXTENSION_ID.equals(Product.getProductID());
    }

    public static String getBaseDir() {
        if (!Extension.isDataModeler()) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension extension = extensionRegistry.findExtension(Extension.getExtensionID());
            if (extension != null) {
                return extensionRegistry.getInstallDirectory(extension).getAbsolutePath();
            }
        } else {
            File file;
            File file2;
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension extension = extensionRegistry.findExtension(Extension.getExtensionID());
            if (extension != null && (file2 = extensionRegistry.getExtensionJAR(extension)) != null && (file = file2.getParentFile()) != null) {
                return file.getParent();
            }
        }
        return null;
    }
}

