/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DBLoginDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTextField tfUserName;
    private JPasswordField pfPassword;
    private String userName = null;
    private String password = null;
    private boolean result = false;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DBLoginDialog.this.dispose();
        }
    };

    public DBLoginDialog(Frame frame) {
        super(frame, Messages.getString("DBLoginDialog.DBLoginDialog.ConnectionInformation"), true);
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    public DBLoginDialog() {
        this(ApplicationView.frame);
    }

    protected JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    private JPanel init() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = new JLabel(Messages.getString("DBLoginDialog.DBLoginDialog.Username"));
        this.tfUserName = new JTextField();
        this.tfUserName.setPreferredSize(new Dimension(200, 20));
        jPanel.add(this.newRow(jLabel, this.tfUserName));
        JLabel jLabel2 = new JLabel(Messages.getString("PasswordDialog.Password"));
        this.pfPassword = new JPasswordField();
        this.pfPassword.setPreferredSize(new Dimension(200, 20));
        jPanel.add(this.newRow(jLabel2, this.pfPassword));
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton(Messages.getString("PasswordDialog.OK"));
        jButton.setMnemonic(79);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                DBLoginDialog.this.userName = DBLoginDialog.this.tfUserName.getText();
                if ("".equalsIgnoreCase(DBLoginDialog.this.userName)) {
                    bl = false;
                    MessageDialogs.showErrorMessage(Messages.getString("DBLoginDialog.DBLoginDialog.ValidationFailed"), Messages.getString("DBLoginDialog.DBLoginDialog.UsernameRequired"));
                    DBLoginDialog.this.tfUserName.requestFocus();
                    return;
                }
                DBLoginDialog.this.password = String.valueOf(DBLoginDialog.this.pfPassword.getPassword());
                if ("".equalsIgnoreCase(DBLoginDialog.this.password)) {
                    bl = false;
                    MessageDialogs.showErrorMessage(Messages.getString("DBLoginDialog.DBLoginDialog.ValidationFailed"), Messages.getString("DBLoginDialog.DBLoginDialog.PasswordRequired"));
                    DBLoginDialog.this.pfPassword.requestFocus();
                    return;
                }
                if (bl) {
                    DBLoginDialog.this.result = true;
                    DBLoginDialog.this.dispose();
                }
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("PasswordDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBLoginDialog.this.userName = null;
                DBLoginDialog.this.password = null;
                DBLoginDialog.this.result = false;
                DBLoginDialog.this.dispose();
            }
        });
        jPanel.add(jButton2);
        return jPanel;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean showDialog(String string) {
        return this.showDialog(string, true);
    }

    public boolean showDialog(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.tfUserName.setText(string);
        this.tfUserName.setEnabled(bl);
        if (!"".equalsIgnoreCase(string)) {
            this.pfPassword.requestFocus();
        }
        this.setVisible(true);
        return this.result;
    }
}

