/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.Messages;

public abstract class CustomDialog
extends JPanel {
    public static final String KEY_ESCAPE = "ESCAPE";
    public static final String KEY_F1 = "KEY_F1";
    private Action actionHelp;
    private Action actionEscape;
    private ApplicationView applicationView;

    public CustomDialog(ApplicationView applicationView) {
        this.applicationView = applicationView;
        this.setLayout(new BorderLayout());
    }

    protected void showHelp() {
        HelpManager.showTopic(this.getDialog(), this.getHelpIndex());
    }

    protected abstract Window getDialog();

    protected abstract void close();

    protected abstract String getHelpIndex();

    protected boolean canClose() {
        return true;
    }

    protected Action getHelpAction() {
        if (this.actionHelp == null) {
            this.actionHelp = new HelpAction(Messages.getString("CustomDialog.Help"));
        }
        return this.actionHelp;
    }

    protected Action getEscapeAction() {
        if (this.actionEscape == null) {
            this.actionEscape = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CustomDialog.this.canClose()) {
                        CustomDialog.this.close();
                    }
                }
            };
        }
        return this.actionEscape;
    }

    public void setDefaultActions(JDialog jDialog) {
        this.setDefaultActions(jDialog, true);
    }

    public void setDefaultActions(JComponent jComponent, boolean bl) {
        int n = 1;
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.getEscapeAction());
        if (bl) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, false);
            jComponent.getInputMap(n).put(keyStroke, KEY_F1);
            jComponent.getActionMap().put(KEY_F1, this.getHelpAction());
        }
    }

    public void setDefaultActions(JDialog jDialog, boolean bl) {
        this.setDefaultActions((JComponent)jDialog.getContentPane(), bl);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (CustomDialog.this.canClose()) {
                    CustomDialog.this.close();
                }
            }
        });
    }

    public ApplicationView getApplicationView() {
        return this.applicationView;
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public Design getDesign() {
        return this.applicationView.getCurrentDesign();
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER;
    }

    private class HelpAction
    extends AbstractAction {
        public HelpAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomDialog.this.showHelp();
        }
    }
}

