/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectReportObjectDialog
extends CustomDialog {
    private static final long serialVersionUID = 3472056109744549424L;
    private boolean result = false;
    private ReportsGenerationDialog parent;
    private JDialog dialog;
    private JPanel mainPanel;
    public JButton bnClose;
    public JButton bnOK;
    private JScrollPane availableObjectsSP;
    private JList availableObjectsList;
    private DefaultListModel availableObjectsModel;
    private ApplicationView appView;
    private boolean subViews;

    public SelectReportObjectDialog(ApplicationView applicationView, ReportsGenerationDialog reportsGenerationDialog, boolean bl) {
        super(applicationView);
        this.parent = reportsGenerationDialog;
        this.appView = applicationView;
        this.subViews = bl;
        this.init();
        this.initObjectsPanel();
        this.initButtonsPanel();
        this.initData();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(350, 500));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initObjectsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.availableObjectsModel = new DefaultListModel();
        this.availableObjectsList = new JList(this.availableObjectsModel);
        this.availableObjectsList.setSelectionMode(0);
        this.availableObjectsSP = new JScrollPane(this.availableObjectsList);
        this.availableObjectsSP.setPreferredSize(new Dimension(340, 460));
        jPanel.add(this.availableObjectsSP);
        this.availableObjectsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectReportObjectDialog.this.availableObjectsList.getSelectedIndex() == -1) {
                    SelectReportObjectDialog.this.bnOK.setEnabled(false);
                } else {
                    SelectReportObjectDialog.this.bnOK.setEnabled(true);
                }
            }
        });
        this.mainPanel.add((Component)jPanel, "North");
    }

    private void initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("ReportsGenerationDialog.OK"));
        this.bnOK.setEnabled(false);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new OKAction());
        jPanel.add(this.bnOK);
        this.bnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        jPanel.add(this.bnClose);
        this.mainPanel.add((Component)jPanel, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private void initData() {
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                this.availableObjectsModel.clear();
                                if (this.parent.getCmbModels().getSelectedItem() == null) break block6;
                                if (!this.subViews) break block7;
                                DesignPart designPart = (DesignPart)this.parent.getCmbModels().getSelectedItem();
                                Iterator iterator = designPart.getDesignSubviews().iterator();
                                while (iterator.hasNext()) {
                                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                                    this.availableObjectsModel.addElement(designPartViewPlaceHolder);
                                }
                                break block6;
                            }
                            if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Tables")) break block8;
                            RelationalDesign relationalDesign = (RelationalDesign)this.parent.getCmbModels().getSelectedItem();
                            Iterator iterator = relationalDesign.getTableSet().iterator();
                            while (iterator.hasNext()) {
                                Table table = (Table)iterator.next();
                                this.availableObjectsModel.addElement(table);
                            }
                            break block6;
                        }
                        if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Entities")) break block9;
                        LogicalDesign logicalDesign = (LogicalDesign)this.parent.getCmbModels().getSelectedItem();
                        Iterator iterator = logicalDesign.getEntitySet().iterator();
                        while (iterator.hasNext()) {
                            Entity entity = (Entity)iterator.next();
                            this.availableObjectsModel.addElement(entity);
                        }
                        break block6;
                    }
                    if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Structured Types")) break block10;
                    DataTypesDesign dataTypesDesign = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
                    Iterator iterator = dataTypesDesign.getStructuredTypeSet().iterator();
                    while (iterator.hasNext()) {
                        StructuredType structuredType = (StructuredType)iterator.next();
                        this.availableObjectsModel.addElement(structuredType);
                    }
                    break block6;
                }
                if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Collection Types")) break block11;
                DataTypesDesign dataTypesDesign = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
                Iterator iterator = dataTypesDesign.getCollectionTypeSet().iterator();
                while (iterator.hasNext()) {
                    CollectionType collectionType = (CollectionType)iterator.next();
                    this.availableObjectsModel.addElement(collectionType);
                }
                break block6;
            }
            if (!((String)this.parent.getCmbReports().getSelectedItem()).equalsIgnoreCase("Distinct Types")) break block6;
            DataTypesDesign dataTypesDesign = (DataTypesDesign)this.parent.getCmbModels().getSelectedItem();
            Iterator iterator = dataTypesDesign.getDistinctTypeSet().iterator();
            while (iterator.hasNext()) {
                DistinctType distinctType = (DistinctType)iterator.next();
                this.availableObjectsModel.addElement(distinctType);
            }
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectObjectDialog.SelectObject"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectReportObjectDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DesignObject designObject = (DesignObject)SelectReportObjectDialog.this.availableObjectsList.getSelectedValue();
            if (SelectReportObjectDialog.this.subViews) {
                SelectReportObjectDialog.this.parent.setSelectedObject(null);
                SelectReportObjectDialog.this.parent.fillTxtSelectedObject("");
                SelectReportObjectDialog.this.parent.setSelectedSubView(designObject);
                SelectReportObjectDialog.this.parent.fillTxtSelectedSubView(designObject.getName());
            } else {
                SelectReportObjectDialog.this.parent.setSelectedSubView(null);
                SelectReportObjectDialog.this.parent.fillTxtSelectedSubView("");
                SelectReportObjectDialog.this.parent.setSelectedObject(designObject);
                SelectReportObjectDialog.this.parent.fillTxtSelectedObject(designObject.getName());
            }
            SelectReportObjectDialog.this.close();
        }
    }
}

