/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SelectModelDialog
extends JDialog {
    private static final long serialVersionUID = -7349566331978231952L;
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable designsTable;
    private JTable versionsTable;
    private JTable modelsTable;
    private JTable objectsTable;
    private List versionsList;
    private List desList;
    private List modelsList;
    private List allDesigns;
    private List objectsList;
    private Connection connection;
    private JButton bnOK;
    private ReportsGenerationDialog parent;
    private String report;
    private static final Logger LOGGER = new Logger(SelectModelDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectModelDialog.this.dispose();
        }
    };

    public SelectModelDialog(Frame frame, Connection connection, ReportsGenerationDialog reportsGenerationDialog) {
        super(frame, Messages.getString("SelectDesignsDialog.SelectModels"));
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(900, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
        this.parent = reportsGenerationDialog;
        this.report = (String)reportsGenerationDialog.getCmbReports().getSelectedItem();
    }

    private JPanel init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(10, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Designs")));
        this.desList = new ArrayList();
        this.designsTable = new JTable(new DesignTableModel());
        this.designsTable.setSelectionMode(0);
        this.designsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SelectModelDialog.this.designsTable.getSelectedRow();
                if (n != -1) {
                    if (SelectModelDialog.this.desList.size() > 0 && n < SelectModelDialog.this.desList.size()) {
                        DesignModel designModel = (DesignModel)SelectModelDialog.this.desList.get(n);
                        SelectModelDialog.this.loadVersions(designModel);
                    }
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.versionsTable.clearSelection();
                    SelectModelDialog.this.versionsTable.setEnabled(false);
                    SelectModelDialog.this.modelsTable.clearSelection();
                    SelectModelDialog.this.modelsTable.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.designsTable);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(10, 10));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Versions")));
        this.versionsList = new ArrayList();
        this.versionsTable = new JTable(new VersionsTableModel());
        this.versionsTable.setSelectionMode(0);
        this.versionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SelectModelDialog.this.versionsTable.getSelectedRow();
                if (n != -1) {
                    if (SelectModelDialog.this.versionsList.size() > 0 && n < SelectModelDialog.this.versionsList.size()) {
                        DesignModel designModel = (DesignModel)SelectModelDialog.this.versionsList.get(n);
                        SelectModelDialog.this.loadModels(designModel);
                    }
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.modelsTable.clearSelection();
                    SelectModelDialog.this.modelsTable.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        this.versionsTable.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.versionsTable.getColumnModel().getColumn(0).setMaxWidth(300);
        this.versionsTable.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.versionsTable.getColumnModel().getColumn(1).setMaxWidth(300);
        JScrollPane jScrollPane2 = new JScrollPane(this.versionsTable);
        jPanel3.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setPreferredSize(new Dimension(10, 10));
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Models")));
        this.modelsList = new ArrayList();
        this.modelsTable = new JTable(new ModelsTableModel());
        this.modelsTable.setSelectionMode(0);
        this.modelsTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.modelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SelectModelDialog.this.modelsTable.getSelectedRow();
                if (n != -1) {
                    DesignModel designModel = (DesignModel)SelectModelDialog.this.modelsList.get(n);
                    SelectModelDialog.this.loadObjects(designModel);
                    SelectModelDialog.this.bnOK.setEnabled(true);
                } else {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                    SelectModelDialog.this.objectsTable.clearSelection();
                    SelectModelDialog.this.objectsTable.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane3 = new JScrollPane(this.modelsTable);
        jPanel4.add((Component)jScrollPane3, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel3, jPanel4);
        jSplitPane.setDividerLocation(140);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDesignsDialog.Objects")));
        this.objectsList = new ArrayList();
        this.objectsTable = new JTable(new ObjectsTableModel());
        this.objectsTable.setSelectionMode(0);
        this.objectsTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.objectsTable.getColumnModel().removeColumn(this.objectsTable.getColumnModel().getColumn(1));
        this.objectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SelectModelDialog.this.objectsTable.getSelectedRow();
                if (n != -1) {
                    SelectModelDialog.this.bnOK.setEnabled(true);
                } else if (!SelectModelDialog.this.parent.getcbIncludeAll().isSelected()) {
                    SelectModelDialog.this.bnOK.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane4 = new JScrollPane(this.objectsTable);
        jPanel5.add((Component)jScrollPane4, "Center");
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel2, jSplitPane);
        jSplitPane2.setDividerLocation(300);
        JSplitPane jSplitPane3 = new JSplitPane(1, jSplitPane2, jPanel5);
        jSplitPane3.setDividerLocation(600);
        jPanel.add(jSplitPane3);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("SelectDesignsDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.setEnabled(false);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignModel designModel;
                SelectModelDialog.this.parent.fillTxtSelectedDesign((String)SelectModelDialog.this.designsTable.getModel().getValueAt(SelectModelDialog.this.designsTable.getSelectedRow(), 0));
                SelectModelDialog.this.parent.fillTxtSelectedVersionDate((String)SelectModelDialog.this.versionsTable.getModel().getValueAt(SelectModelDialog.this.versionsTable.getSelectedRow(), 0));
                if (SelectModelDialog.this.modelsTable.getSelectedRow() != -1) {
                    SelectModelDialog.this.parent.fillTxtSelectedModel((String)SelectModelDialog.this.modelsTable.getModel().getValueAt(SelectModelDialog.this.modelsTable.getSelectedRow(), 0));
                }
                if (!SelectModelDialog.this.parent.getcbIncludeAll().isSelected()) {
                    if (SelectModelDialog.this.objectsTable.getSelectedRow() > -1) {
                        SelectModelDialog.this.parent.fillTtxtSelectedDesignObject((String)SelectModelDialog.this.objectsTable.getModel().getValueAt(SelectModelDialog.this.objectsTable.getSelectedRow(), 0));
                    }
                    SelectModelDialog.this.parent.setSelectedObjectOvid((String)SelectModelDialog.this.objectsTable.getModel().getValueAt(SelectModelDialog.this.objectsTable.getSelectedRow(), 1));
                } else if (SelectModelDialog.this.modelsList.size() > 0) {
                    designModel = (DesignModel)SelectModelDialog.this.modelsList.get(SelectModelDialog.this.modelsTable.getSelectedRow());
                    SelectModelDialog.this.parent.setSelectedObjectOvid(designModel.getModelOVID());
                } else {
                    designModel = (DesignModel)SelectModelDialog.this.desList.get(SelectModelDialog.this.designsTable.getSelectedRow());
                    SelectModelDialog.this.parent.setSelectedObjectOvid(designModel.getDesignOVID());
                }
                if (SelectModelDialog.this.report.equals("Domains") || SelectModelDialog.this.report.equals("Glossaries")) {
                    designModel = (DesignModel)SelectModelDialog.this.versionsList.get(SelectModelDialog.this.versionsTable.getSelectedRow());
                    SelectModelDialog.this.parent.setSelectedObjectOvid(designModel.getDesignOVID());
                }
                SelectModelDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnOK);
        jPanel.add(this.bnOK);
        JButton jButton = new JButton(Messages.getString("Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectModelDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void loadDesignNames() {
        this.desList.clear();
        Iterator iterator = this.allDesigns.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            DesignModel designModel = (DesignModel)iterator.next();
            if (this.desList.size() == 0) {
                this.desList.add(designModel);
                continue;
            }
            for (DesignModel designModel2 : this.desList) {
                if (designModel.getDesignName().equals(designModel2.getDesignName())) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            this.desList.add(designModel);
        }
        this.sort(this.desList);
        this.sort(this.desList);
        this.sort(this.desList);
        this.designsTable.updateUI();
        if (this.desList.size() > 0) {
            this.designsTable.setRowSelectionInterval(0, 0);
        }
        this.versionsTable.updateUI();
        this.modelsTable.updateUI();
    }

    private boolean loadDesigns() {
        boolean bl;
        block10: {
            bl = false;
            try {
                this.allDesigns = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float f = SchemaFactory.schemaVersion(this.connection);
                    if (f != 0.0f) {
                        String string = "SELECT  TO_CHAR(d.date_published,'dd.mm.yyyy hh24:mi:ss'), d.version_comments, d.design_ovid, d.Design_ID, d.design_name, m.model_type, m.model_name, m.model_ovid FROM  \tdmrs_designs d, dmrs_models m WHERE d.design_ovid = m.design_ovid AND   m.model_type IN ('Relational','Logical','Data Types') GROUP BY d.date_published, d.version_comments, d.design_ovid, d.Design_ID, d.design_name, m.model_type, m.model_name, m.model_ovid ORDER BY d.design_name";
                        try {
                            Statement statement = this.connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string);
                            Statement statement2 = this.connection.createStatement();
                            while (resultSet.next()) {
                                DesignModel designModel = new DesignModel();
                                designModel.setDatePublished(resultSet.getString(1));
                                designModel.setComments(resultSet.getString(2));
                                designModel.setDesignOVID(resultSet.getString(3));
                                designModel.setDesignID(resultSet.getString(4));
                                designModel.setDesignName(resultSet.getString(5));
                                designModel.setModelType(resultSet.getString(6));
                                designModel.setModelName(resultSet.getString(7));
                                designModel.setModelOVID(resultSet.getString(8));
                                String string2 = " SELECT ovid, table_name, 'Tables' FROM   dmrs_tables  WHERE  model_ovid = '" + resultSet.getString(8) + "' " + " UNION ALL " + " SELECT ovid, " + "entity_name, " + "'" + "Entities" + "'" + " FROM   dmrs_entities " + " WHERE  model_ovid = '" + resultSet.getString(8) + "' " + " UNION ALL " + " SELECT structured_type_ovid, " + " structured_type_name, " + "'" + "Structured Types" + "'" + " FROM   dmrs_structured_types " + " WHERE  model_ovid = '" + resultSet.getString(8) + "' " + " UNION ALL " + " SELECT collection_type_ovid, " + " collection_type_name, " + "'" + "Collection Types" + "'" + " FROM   dmrs_collection_types " + " WHERE  model_ovid = '" + resultSet.getString(8) + "' " + " UNION ALL " + " SELECT distinct_type_ovid, " + " distinct_type_name, " + "'" + "Distinct Types" + "'" + " FROM   dmrs_distinct_types " + " WHERE  model_ovid = '" + resultSet.getString(8) + "' ";
                                ResultSet resultSet2 = statement2.executeQuery(string2);
                                while (resultSet2.next()) {
                                    DesignObjectsModel designObjectsModel = new DesignObjectsModel();
                                    designObjectsModel.setObjectOVID(resultSet2.getString(1));
                                    designObjectsModel.setObjectName(resultSet2.getString(2));
                                    designObjectsModel.setObjectType(resultSet2.getString(3));
                                    designModel.addDesignObjectsModel(designObjectsModel);
                                }
                                this.allDesigns.add(designModel);
                            }
                            statement.close();
                            statement2.close();
                            this.loadDesignNames();
                            bl = true;
                        }
                        catch (SQLException sQLException) {
                            LOGGER.error("SelectModelDialog.loadDesigns()", sQLException);
                        }
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("SelectDesignsDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException differentVersionException) {
                    MessageDialogs.showWarningMessage(Messages.getString("SelectDesignsDialog.DBSchemaOutOfDate"));
                }
                catch (Exception exception) {
                    LOGGER.error("SelectDesignsDialog.loadDesigns()", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"));
                }
            }
            catch (Exception exception) {
                LOGGER.error("SelectDesignsDialog.loadDesigns()", exception);
                MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"));
            }
        }
        return bl;
    }

    private void loadVersions(DesignModel designModel) {
        this.versionsList.clear();
        for (DesignModel designModel2 : this.allDesigns) {
            if (!designModel2.getDesignName().equals(designModel.getDesignName()) || this.versionListed(designModel2)) continue;
            this.versionsList.add(designModel2);
        }
        Collections.sort(this.versionsList);
        this.versionsTable.updateUI();
        if (this.versionsList.size() > 0) {
            this.versionsTable.setEnabled(true);
            this.versionsTable.setRowSelectionInterval(0, 0);
            int n = this.versionsTable.getSelectedRow();
            DesignModel designModel3 = (DesignModel)this.versionsList.get(n);
            this.loadModels(designModel3);
        }
        this.sort(this.versionsList);
    }

    private boolean versionListed(DesignModel designModel) {
        for (DesignModel designModel2 : this.versionsList) {
            if (!designModel2.getDesignOVID().equals(designModel.getDesignOVID())) continue;
            return true;
        }
        return false;
    }

    private void loadModels(DesignModel designModel) {
        this.modelsList.clear();
        Iterator iterator = this.allDesigns.iterator();
        if (this.report.equals("Tables")) {
            while (iterator.hasNext()) {
                DesignModel designModel2 = (DesignModel)iterator.next();
                if (!designModel2.getDesignOVID().equals(designModel.getDesignOVID()) || !designModel2.getModelType().equals("Relational")) continue;
                this.modelsList.add(designModel2);
            }
            this.modelsTable.setBackground(Color.WHITE);
        } else if (this.report.equals("Entities")) {
            while (iterator.hasNext()) {
                DesignModel designModel3 = (DesignModel)iterator.next();
                if (!designModel3.getDesignOVID().equals(designModel.getDesignOVID()) || !designModel3.getModelType().equals("Logical")) continue;
                this.modelsList.add(designModel3);
            }
            this.modelsTable.setBackground(Color.WHITE);
        } else if (this.report.equals("Domains") || this.report.equals("Glossaries")) {
            while (iterator.hasNext()) {
                DesignModel designModel4 = (DesignModel)iterator.next();
                if (!designModel4.getDesignOVID().equals(designModel.getDesignOVID())) continue;
                this.modelsList.add(designModel4);
            }
            this.modelsTable.setBackground(Color.LIGHT_GRAY);
            this.modelsTable.clearSelection();
        } else if (this.report.equals("Structured Types") || this.report.equals("Collection Types") || this.report.equals("Distinct Types")) {
            while (iterator.hasNext()) {
                DesignModel designModel5 = (DesignModel)iterator.next();
                if (!designModel5.getDesignOVID().equals(designModel.getDesignOVID()) || !designModel5.getModelType().equals("Data Types")) continue;
                this.modelsList.add(designModel5);
            }
            this.modelsTable.setBackground(Color.WHITE);
        }
        if (this.modelsList.size() == 0 && (this.report.equals("Change Requests") || this.report.equals("Measurements"))) {
            this.bnOK.setEnabled(true);
        }
        this.modelsTable.updateUI();
        if (this.modelsList.size() > 0) {
            this.modelsTable.setEnabled(true);
            this.modelsTable.clearSelection();
            this.modelsTable.setRowSelectionInterval(0, 0);
            this.bnOK.setEnabled(true);
        }
        this.sort(this.modelsList);
    }

    private void loadObjects(DesignModel designModel) {
        this.objectsList.clear();
        ArrayList<DesignObjectsModel> arrayList = designModel.getDesignObjectsModelList();
        for (DesignObjectsModel designObjectsModel : arrayList) {
            if (!this.report.equals(designObjectsModel.getObjectType())) continue;
            this.objectsList.add(designObjectsModel);
        }
        this.objectsTable.updateUI();
        if (this.objectsList.size() > 0) {
            if (this.parent.getcbIncludeAll().isSelected()) {
                this.objectsTable.setEnabled(false);
                this.objectsTable.setBackground(Color.LIGHT_GRAY);
            } else {
                this.objectsTable.setEnabled(true);
                this.objectsTable.setRowSelectionInterval(0, 0);
            }
            this.bnOK.setEnabled(true);
        }
        this.sortDo(this.objectsList);
    }

    public static void showDialog(Frame frame, Connection connection, ReportsGenerationDialog reportsGenerationDialog) {
        SelectModelDialog selectModelDialog = new SelectModelDialog(frame, connection, reportsGenerationDialog);
        if (selectModelDialog.loadDesigns()) {
            selectModelDialog.setVisible(true);
        } else {
            selectModelDialog.dispose();
        }
    }

    public void sort(List list) {
        Collections.sort(list, new DesignModelComparator());
    }

    public void sortDo(List list) {
        Collections.sort(list, new DesignObjectComparator());
    }

    class DesignObjectComparator
    implements Comparator {
        DesignObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            DesignObjectsModel designObjectsModel = (DesignObjectsModel)object;
            DesignObjectsModel designObjectsModel2 = (DesignObjectsModel)object2;
            String string = designObjectsModel.getObjectName();
            String string2 = designObjectsModel2.getObjectName();
            return string.compareTo(string2);
        }
    }

    class DesignModelComparator
    implements Comparator {
        DesignModelComparator() {
        }

        public int compare(Object object, Object object2) {
            DesignModel designModel = (DesignModel)object;
            DesignModel designModel2 = (DesignModel)object2;
            String string = designModel.getDesignName() + designModel.getDatePublished() + designModel.getComments();
            String string2 = designModel2.getDesignName() + designModel2.getDatePublished() + designModel2.getComments();
            return string.compareTo(string2);
        }
    }

    private class ObjectsTableModel
    extends AbstractTableModel {
        private ObjectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.objectsList.size();
        }

        @Override
        public String getColumnName(int n) {
            return Messages.getString("SelectDesignsDialog.ObjectName");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObjectsModel designObjectsModel = (DesignObjectsModel)SelectModelDialog.this.objectsList.get(n);
            if (n2 == 0) {
                return designObjectsModel.getObjectName();
            }
            if (n2 == 1) {
                return designObjectsModel.getObjectOVID();
            }
            return new Integer(n * n2);
        }
    }

    private class ModelsTableModel
    extends AbstractTableModel {
        private ModelsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.modelsList.size();
        }

        @Override
        public String getColumnName(int n) {
            return Messages.getString("SelectDesignsDialog.ModelName");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignModel designModel = (DesignModel)SelectModelDialog.this.modelsList.get(n);
            if (n2 == 0) {
                return designModel.getModelName();
            }
            return new Integer(n * n2);
        }
    }

    private class VersionsTableModel
    extends AbstractTableModel {
        private VersionsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.versionsList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectDesignsDialog.Date");
            }
            if (n == 1) {
                return Messages.getString("SelectDesignsDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignModel designModel = (DesignModel)SelectModelDialog.this.versionsList.get(n);
            if (n2 == 0) {
                return designModel.getDatePublished();
            }
            if (n2 == 1) {
                return designModel.getComments() == null ? "" : designModel.getComments();
            }
            return new Integer(n * n2);
        }
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectModelDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectDesignsDialog.DesignName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignModel designModel = (DesignModel)SelectModelDialog.this.desList.get(n);
            if (n2 == 0) {
                return designModel.getDesignName();
            }
            return new Integer(n * n2);
        }
    }

    public class DesignObjectsModel
    implements Comparable {
        private String objectOVID;
        private String objectType;
        private String objectName;

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public void setObjectOVID(String string) {
            this.objectOVID = string;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String string) {
            this.objectType = string;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String string) {
            this.objectName = string;
        }

        public int compareTo(Object object) {
            return this.getObjectName().compareToIgnoreCase(((DesignObjectsModel)object).getObjectName());
        }
    }

    public class DesignModel
    implements Comparable {
        private String datePublished;
        private String comments = "";
        private String designOVID;
        private String designID;
        private String designName;
        private String modelType;
        private String modelName;
        private String modelOVID;
        private boolean selected = false;
        private ArrayList<DesignObjectsModel> designObjectsModelList;

        public String getDatePublished() {
            return this.datePublished;
        }

        public void setDatePublished(String string) {
            this.datePublished = string;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public void setDesignOVID(String string) {
            this.designOVID = string;
        }

        public String getDesignID() {
            return this.designID;
        }

        public void setDesignID(String string) {
            this.designID = string;
        }

        public String getDesignName() {
            return this.designName;
        }

        public void setDesignName(String string) {
            this.designName = string;
        }

        public String getModelType() {
            return this.modelType;
        }

        public void setModelType(String string) {
            this.modelType = string;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String string) {
            this.modelName = string;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public void setModelOVID(String string) {
            this.modelOVID = string;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public ArrayList<DesignObjectsModel> getDesignObjectsModelList() {
            if (this.designObjectsModelList == null) {
                this.designObjectsModelList = new ArrayList();
            }
            return this.designObjectsModelList;
        }

        public void addDesignObjectsModel(DesignObjectsModel designObjectsModel) {
            this.getDesignObjectsModelList().add(designObjectsModel);
        }

        public int compareTo(Object object) {
            return SelectModelDialog.this.getName().compareToIgnoreCase(((DesignModel)object).getDesignName());
        }
    }
}

