/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SelectGlossaryDialog
extends CustomDialog {
    private static final long serialVersionUID = -2774925804241895401L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private int result = 0;
    private JDialog dialog;
    private JPanel mainPanel;
    private ReportsGenerationDialog parent;
    public JButton bnClose;
    public JButton bnOK;
    private JScrollPane availableObjectsSP;
    private List availableGlossariesList;
    private Connection connection;
    private JTable glossariesTable;
    private static final Logger LOGGER = new Logger(SelectGlossaryDialog.class);

    public SelectGlossaryDialog(ApplicationView applicationView, ReportsGenerationDialog reportsGenerationDialog, Connection connection) {
        super(applicationView);
        this.parent = reportsGenerationDialog;
        this.connection = connection;
        this.init();
        this.initGlossariesPanel();
        this.initButtonsPanel();
        this.loadGlossaries();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(350, 500));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initGlossariesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.availableGlossariesList = new ArrayList();
        this.glossariesTable = new JTable(new GlossariesTableModel());
        this.glossariesTable.setSelectionMode(0);
        this.glossariesTable.getColumnModel().removeColumn(this.glossariesTable.getColumnModel().getColumn(2));
        this.availableObjectsSP = new JScrollPane(this.glossariesTable);
        this.availableObjectsSP.setPreferredSize(new Dimension(340, 460));
        jPanel.add(this.availableObjectsSP);
        this.glossariesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SelectGlossaryDialog.this.glossariesTable.getSelectedRow() == -1) {
                    SelectGlossaryDialog.this.bnOK.setEnabled(false);
                } else {
                    SelectGlossaryDialog.this.bnOK.setEnabled(true);
                }
            }
        });
        this.mainPanel.add((Component)jPanel, "North");
    }

    private void initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("ReportsGenerationDialog.OK"));
        this.bnOK.setEnabled(false);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new OKAction());
        jPanel.add(this.bnOK);
        this.bnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        jPanel.add(this.bnClose);
        this.mainPanel.add((Component)jPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectGlossaryDialog.SelectGlossary"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private boolean loadGlossaries() {
        boolean bl;
        block9: {
            bl = false;
            try {
                if (this.connection == null) break block9;
                try {
                    float f = SchemaFactory.schemaVersion(this.connection);
                    if (f != 0.0f) {
                        String string = "SELECT  TO_CHAR(date_published,'dd.mm.yyyy hh24:mi:ss'), glossary_name, glossary_ovid FROM  dmrs_glossaries ORDER BY glossary_name, date_published";
                        try {
                            Statement statement = this.connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string);
                            while (resultSet.next()) {
                                GlossaryObject glossaryObject = new GlossaryObject();
                                glossaryObject.setDatePublished(resultSet.getString(1));
                                glossaryObject.setGlossaryObjName(resultSet.getString(2));
                                glossaryObject.setGlossaryObjOVID(resultSet.getString(3));
                                this.availableGlossariesList.add(glossaryObject);
                            }
                            statement.close();
                            bl = true;
                        }
                        catch (SQLException sQLException) {
                            LOGGER.error("SelectGlossaryDialog.loadDesigns()", sQLException);
                        }
                        break block9;
                    }
                    MessageDialogs.showMessage(Messages.getString("SelectGlossaryDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException differentVersionException) {
                    MessageDialogs.showWarningMessage(Messages.getString("SelectGlossaryDialog.DBSchemaOutOfDate"));
                }
                catch (Exception exception) {
                    LOGGER.error("SelectGlossaryDialog.loadDesigns()", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectGlossaryDialog.UnableToLoadDesigns"));
                }
            }
            catch (Exception exception) {
                LOGGER.error("SelectGlossaryDialog.loadDesigns()", exception);
                MessageDialogs.showErrorMessage(Messages.getString("SelectGlossaryDialog.UnableToLoadDesigns"));
            }
        }
        return bl;
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private class GlossariesTableModel
    extends AbstractTableModel {
        private GlossariesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectGlossaryDialog.this.availableGlossariesList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SelectGlossaryDialog.GlossaryName");
            }
            if (n == 1) {
                return Messages.getString("SelectGlossaryDialog.GlossaryDP");
            }
            if (n == 2) {
                return "OVID";
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GlossaryObject glossaryObject = (GlossaryObject)SelectGlossaryDialog.this.availableGlossariesList.get(n);
            if (n2 == 0) {
                return glossaryObject.getGlossaryObjName();
            }
            if (n2 == 1) {
                return glossaryObject.getDatePublished();
            }
            if (n2 == 2) {
                return glossaryObject.getGlossaryObjOVID();
            }
            return new Integer(n * n2);
        }
    }

    private class GlossaryObject {
        private String glossaryObjName;
        private String datePublished;
        private String glossaryObjOVID;

        private GlossaryObject() {
        }

        public String getGlossaryObjName() {
            return this.glossaryObjName;
        }

        public void setGlossaryObjName(String string) {
            this.glossaryObjName = string;
        }

        public String getDatePublished() {
            return this.datePublished;
        }

        public void setDatePublished(String string) {
            this.datePublished = string;
        }

        public String getGlossaryObjOVID() {
            return this.glossaryObjOVID;
        }

        public void setGlossaryObjOVID(String string) {
            this.glossaryObjOVID = string;
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectGlossaryDialog.this.parent.setSelectedObjectOvid((String)SelectGlossaryDialog.this.glossariesTable.getModel().getValueAt(SelectGlossaryDialog.this.glossariesTable.getSelectedRow(), 2));
            SelectGlossaryDialog.this.close();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectGlossaryDialog.this.close();
        }
    }
}

