/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.RenderPDFReport;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsHTMLTOC;
import oracle.dbtools.crest.swingui.wizards.reports.SaxonLoader;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportsGenerator {
    private String reportsPath;
    private String reportFileName = "";
    private File xsltFile = null;
    private ApplicationView appView;
    private ProgressDialog monitor;
    private String vmOptions;
    private String saxonPath;
    private static final Logger LOGGER = new Logger(ReportsGenerator.class);

    public ReportsGenerator(ApplicationView applicationView) {
        this.appView = applicationView;
        this.saxonPath = applicationView.getSettings().getDefaultSaxonPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(String string, String string2, String string3, ReportTemplate reportTemplate, Design design, DesignPart designPart, Object object, Object object2, Glossary glossary, String string4) {
        Document document = null;
        File file = null;
        String string5 = "";
        this.reportsPath = string4;
        this.vmOptions = string3;
        String string6 = string2.toLowerCase();
        String string7 = "";
        string7 = this.saxonPath != null && !this.saxonPath.equals("") ? "20" : "10";
        if (object != null) {
            if (string.equalsIgnoreCase("Tables")) {
                document = this.gatherSingleTableData(design, designPart, object, reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/SingleTableDetails_" + string6 + ".xslt");
                this.reportFileName = "SingleTableDetails_" + this.getLastUsedFileIdx("SingleTableDetails") + "." + string6;
            } else if (string.equalsIgnoreCase("Entities")) {
                document = this.gatherSingleEntityData(design, designPart, object, reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/SingleEntityDetails_" + string6 + ".xslt");
                this.reportFileName = "SingleEntityDetails_" + this.getLastUsedFileIdx("SingleEntityDetails") + "." + string6;
            } else if (string.equalsIgnoreCase("Collection Types")) {
                document = this.gatherSingleCollectionTypeData(design, designPart, object, reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/SingleCollectionTypeDetails_" + string6 + ".xslt");
                this.reportFileName = "SingleCollectionTypeDetails_" + this.getLastUsedFileIdx("SingleCollectionTypeDetails") + "." + string6;
            } else if (string.equalsIgnoreCase("Structured Types")) {
                document = this.gatherSingleStructuredTypeData(design, designPart, object, reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/SingleStructuredTypeDetails_" + string6 + ".xslt");
                this.reportFileName = "SingleStructuredTypeDetails_" + this.getLastUsedFileIdx("SingleStructuredTypeDetails") + "." + string6;
            } else if (string.equalsIgnoreCase("Distinct Types")) {
                document = this.gatherSingleDistinctTypeData(design, designPart, object, reportTemplate);
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/SingleDistinctTypeDetails_" + string6 + ".xslt");
                this.reportFileName = "SingleDistinctTypeDetails_" + this.getLastUsedFileIdx("SingleDistinctTypeDetails") + "." + string6;
            }
        } else if (string.equalsIgnoreCase("Tables")) {
            document = this.gatherAllTablesData(design, designPart, reportTemplate, object2);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllTablesDetails_" + string6 + ".xslt");
            this.reportFileName = "AllTablesDetails_" + this.getLastUsedFileIdx("AllTablesDetails") + "." + string6;
            string5 = "TableName";
        } else if (string.equalsIgnoreCase("Entities")) {
            document = this.gatherAllEntitiesData(design, designPart, reportTemplate, object2);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllEntitiesDetails_" + string6 + ".xslt");
            this.reportFileName = "AllEntitiesDetails_" + this.getLastUsedFileIdx("AllEntitiesDetails") + "." + string6;
            string5 = "EntityName";
        } else if (string.equalsIgnoreCase("Domains")) {
            document = this.gatherAllDomainsData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllDomainsDetails_" + string6 + ".xslt");
            this.reportFileName = "AllDomainsDetails_" + this.getLastUsedFileIdx("AllDomainsDetails") + "." + string6;
            string5 = "DomainName";
        } else if (string.equalsIgnoreCase("Glossaries")) {
            if (glossary != null) {
                document = this.gatherGlossaryData(glossary);
            }
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/GlossaryDetails_" + string6 + ".xslt");
            this.reportFileName = "GlossaryDetails_" + this.getLastUsedFileIdx("GlossaryDetails") + "." + string6;
        } else if (string.equalsIgnoreCase("Structured Types")) {
            document = this.gatherAllStructuredTypesData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllStructuredTypesDetails_" + string6 + ".xslt");
            this.reportFileName = "AllStructuredTypesDetails_" + this.getLastUsedFileIdx("AllStructuredTypesDetails") + "." + string6;
            string5 = "STName";
        } else if (string.equalsIgnoreCase("Distinct Types")) {
            document = this.gatherAllDistinctTypesData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllDistinctTypesDetails_" + string6 + ".xslt");
            this.reportFileName = "AllDistinctTypesDetails_" + this.getLastUsedFileIdx("AllDistinctTypesDetails") + "." + string6;
            string5 = "DTName";
        } else if (string.equalsIgnoreCase("Collection Types")) {
            document = this.gatherAllCollectionTypesData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/AllCollectionTypesDetails_" + string6 + ".xslt");
            this.reportFileName = "AllCollectionTypesDetails_" + this.getLastUsedFileIdx("AllCollectionTypesDetails") + "." + string6;
            string5 = "CTName";
        } else if (string.equalsIgnoreCase("Change Requests")) {
            document = this.gatherChangeRequestsData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/ChangeRequestsDetails_" + string6 + ".xslt");
            this.reportFileName = "ChangeRequestsDetails_" + this.getLastUsedFileIdx("ChangeRequestsDetails") + "." + string6;
        } else if (string.equalsIgnoreCase("Measurements")) {
            document = this.gatherMeasurementsData(design, designPart, reportTemplate);
            this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + string7 + "/MeasurementsDetails_" + string6 + ".xslt");
            this.reportFileName = "MeasurementsDetails_" + this.getLastUsedFileIdx("MeasurementsDetails") + "." + string6;
        }
        file = new File(string4, this.reportFileName);
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        OutputStreamWriter outputStreamWriter = null;
        OutputStreamWriter outputStreamWriter2 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            this.monitor = new ProgressDialog(this.appView, "", 0, 100);
            this.monitor.setNote(Messages.getString("ReportsGenerationDialog.GatherData"));
            this.monitor.setProgress(1);
            if (document != null) {
                DOMSource dOMSource = new DOMSource(document);
                File file2 = new File(string4, "report_data.xml");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
                transformer.transform(dOMSource, new StreamResult(outputStreamWriter));
                if (this.xsltFile != null) {
                    this.monitor.setProgress(50);
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
                    StreamSource streamSource = new StreamSource(bufferedReader);
                    bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.xsltFile), "UTF-8"));
                    StreamSource streamSource2 = new StreamSource(bufferedReader2);
                    if (string2.equals("PDF")) {
                        this.createPDFReport();
                        this.monitor.setProgress(100);
                        this.monitor.close();
                        ApplicationView.log(Messages.getString("ReportsGenerationDialog.RenderingPDFReport"));
                        JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.PDFRenderingStarted"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                    } else {
                        Object object3;
                        Object object4;
                        if (this.saxonPath != null && !this.saxonPath.equals("")) {
                            object4 = SaxonLoader.getInstance(this.saxonPath);
                            object3 = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", (ClassLoader)object4);
                            Transformer transformer2 = ((TransformerFactory)object3).newTransformer(streamSource2);
                            transformer2.setOutputProperty("encoding", "UTF-8");
                            transformer2.transform(streamSource, new StreamResult(file));
                        } else {
                            object4 = TransformerFactory.newInstance();
                            object3 = ((TransformerFactory)object4).newTransformer(streamSource2);
                            ((Transformer)object3).setOutputProperty("encoding", "UTF-8");
                            outputStreamWriter2 = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                            ((Transformer)object3).transform(streamSource, new StreamResult(outputStreamWriter2));
                        }
                        if (string2.equals("HTML") && !string5.equals("")) {
                            object4 = this.reportFileName.substring(0, this.reportFileName.indexOf(".")) + "_index" + this.reportFileName.substring(this.reportFileName.indexOf("."), this.reportFileName.length());
                            object3 = this.reportFileName.substring(0, this.reportFileName.indexOf(".")) + "_toc" + this.reportFileName.substring(this.reportFileName.indexOf("."), this.reportFileName.length());
                            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string4, (String)object4)), "UTF-8"));
                            printWriter.print(ReportsHTMLTOC.createHTMLIndexPage((String)object3, this.reportFileName));
                            printWriter.flush();
                            printWriter.close();
                            printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string4, (String)object3)), "UTF-8"));
                            printWriter2.print(ReportsHTMLTOC.createHTMLTOCPage(this.reportFileName, file2, string5));
                            printWriter2.flush();
                            printWriter2.close();
                            this.reportFileName = object4;
                        }
                        this.monitor.setProgress(100);
                        this.monitor.close();
                        JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsg"), this.reportFileName, string4), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                    }
                } else {
                    LOGGER.error("Required XSLT file " + string + " for report generation not found. Process is terminated.");
                    JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.error("Exception during report generation " + transformerConfigurationException);
            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        catch (TransformerException transformerException) {
            LOGGER.error("Exception during report generation " + transformerException);
            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage().contains("Access is denied")) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), fileNotFoundException.getMessage()), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + fileNotFoundException);
            } else {
                JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                LOGGER.error("Exception during report generation " + fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Exception during report generation " + iOException);
            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during report generation " + exception);
            JOptionPane.showMessageDialog(null, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + iOException);
                }
            }
            if (outputStreamWriter2 != null) {
                try {
                    outputStreamWriter2.flush();
                    outputStreamWriter2.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + this.reportFileName + ": " + iOException);
                }
            }
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.flush();
                printWriter2.close();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + iOException);
                }
            }
            if (bufferedReader2 != null) {
                try {
                    bufferedReader2.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + iOException);
                }
            }
            this.monitor.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleTableData(Design design, DesignPart designPart, Object object, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object22;
            Object object32;
            Object object4;
            Object object5;
            Object object62;
            Object object72;
            Object object13;
            Object object14;
            Object object15;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElementNS("osdm_t", "osdm_t:root");
            document.appendChild(element);
            Element element2 = document.createElement("osdm_t:DesignName");
            element2.appendChild(document.createTextNode(design.getName()));
            element.appendChild(element2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element2 = document.createElement("osdm_t:VersionDate");
            element2.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element.appendChild(element2);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                object15 = document.createElement("osdm_t:VersionComment");
                object14 = document.createElement("osdm_t:VersionCommentDetails");
                object13 = null;
                for (String object122 : Arrays.asList(string.split("\\n"))) {
                    object13 = document.createElement("osdm_t:VersionCommentRow");
                    object13.appendChild(document.createTextNode(object122));
                    object14.appendChild((Node)object13);
                }
                if (object13 == null) {
                    object13 = document.createElement("osdm_t:VersionCommentRow");
                    object13.appendChild(document.createTextNode(""));
                    object14.appendChild((Node)object13);
                }
                object15.appendChild((Node)object14);
                element.appendChild((Node)object15);
            }
            element2 = document.createElement("osdm_t:ModelName");
            element2.appendChild(document.createTextNode(designPart.getName()));
            element.appendChild(element2);
            object15 = (Table)object;
            element2 = document.createElement("osdm_t:TableName");
            element2.appendChild(document.createTextNode(((Table)object15).getLongName()));
            element.appendChild(element2);
            element2 = document.createElement("osdm_t:FunctionalName");
            element2.appendChild(document.createTextNode(((Table)object15).getEngEntity() != null ? ((Table)object15).getEngEntity().getName() : ""));
            element.appendChild(element2);
            element2 = document.createElement("osdm_t:Abbreviation");
            element2.appendChild(document.createTextNode(((Table)object15).getAbbreviation()));
            element.appendChild(element2);
            element2 = document.createElement("osdm_t:ClassificationTypeName");
            element2.appendChild(document.createTextNode(""));
            element.appendChild(element2);
            element2 = document.createElement("osdm_t:ObjectTypeName");
            element2.appendChild(document.createTextNode(((ContainerObject)object15).getBasedOnStructuredType() != null ? ((ContainerObject)object15).getBasedOnStructuredType().getName() : ""));
            element.appendChild(element2);
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                object14 = "";
                object14 = ((ModelIDObject)object15).getComment() == null || ((ModelIDObject)object15).getComment().equals("") ? ((ModelIDObject)object15).getCommentInRDBMS() : ((ModelIDObject)object15).getComment();
                object13 = ((ModelIDObject)object15).getNotes();
                if (object14 != "" && object14 != null || object13 != "" && object13 != null) {
                    Element element3 = document.createElement("osdm_t:DescriptionNotes");
                    if (object14 != "" && object14 != null) {
                        Element element4 = document.createElement("osdm_t:Description");
                        object72 = document.createElement("osdm_t:DescriptionDetails");
                        object62 = null;
                        for (String string2 : Arrays.asList(((String)object14).split("\\n"))) {
                            object62 = document.createElement("osdm_t:DescriptionRow");
                            object62.appendChild(document.createTextNode(string2));
                            object72.appendChild((Node)object62);
                        }
                        if (object62 == null) {
                            object62 = document.createElement("osdm_t:DescriptionRow");
                            object62.appendChild(document.createTextNode(""));
                            object72.appendChild((Node)object62);
                        }
                        element4.appendChild((Node)object72);
                        element3.appendChild(element4);
                    }
                    if (object13 != "" && object13 != null) {
                        Element element5 = document.createElement("osdm_t:Notes");
                        object72 = document.createElement("osdm_t:NotesDetails");
                        object62 = null;
                        for (String string3 : Arrays.asList(((String)object13).split("\\n"))) {
                            object62 = document.createElement("osdm_t:NoteRow");
                            object62.appendChild(document.createTextNode(string3));
                            object72.appendChild((Node)object62);
                        }
                        if (object62 == null) {
                            object62 = document.createElement("osdm_t:NoteRow");
                            object62.appendChild(document.createTextNode(""));
                            object72.appendChild((Node)object62);
                        }
                        element5.appendChild((Node)object72);
                        element3.appendChild(element5);
                    }
                    element.appendChild(element3);
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseQuantitativeInfo()) {
                object14 = document.createElement("osdm_t:QuantitativeInfoCollection");
                element2 = document.createElement("osdm_t:NumberOfColumns");
                element2.appendChild(document.createTextNode(Integer.valueOf(((ContainerObject)object15).getElements().length).toString()));
                object14.appendChild(element2);
                element2 = document.createElement("osdm_t:NumberOfRowsMin");
                element2.appendChild(document.createTextNode(((Table)object15).getMinVolumes()));
                object14.appendChild(element2);
                element2 = document.createElement("osdm_t:NumberOfRowsMax");
                element2.appendChild(document.createTextNode(((Table)object15).getMaxVolumes()));
                object14.appendChild(element2);
                element2 = document.createElement("osdm_t:ExpectedNumberOfRows");
                element2.appendChild(document.createTextNode(((Table)object15).getExpectedVolumes()));
                object14.appendChild(element2);
                element2 = document.createElement("osdm_t:ExpectedGrowth");
                element2.appendChild(document.createTextNode(((Table)object15).getGrowthPercent()));
                object14.appendChild(element2);
                element2 = document.createElement("osdm_t:GrowthInterval");
                element2.appendChild(document.createTextNode(((Table)object15).getGrowthType()));
                object14.appendChild(element2);
                element.appendChild((Node)object14);
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableColumns()) {
                int n = 0;
                object13 = null;
                for (Column column : Arrays.asList(((ContainerObject)object15).getElements())) {
                    void var24_86;
                    void var23_73;
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:ColumnsCollection");
                        element.appendChild((Node)object13);
                    }
                    object72 = document.createElement("osdm_t:ColumnDetails");
                    object13.appendChild((Node)object72);
                    element2 = document.createElement("osdm_t:Sequence");
                    element2.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:ColumnName");
                    element2.appendChild(document.createTextNode(column.getName()));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:PK");
                    element2.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:FK");
                    element2.appendChild(document.createTextNode(column.isFKElement() ? "F" : ""));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:M");
                    element2.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                    object72.appendChild(element2);
                    object62 = "";
                    String string4 = "";
                    String string5 = "";
                    switch (column.getUse()) {
                        case 0: {
                            String string6 = "DOM";
                            object5 = column.getDomain();
                            String string7 = ((DesignObject)object5).getName();
                            object62 = this.getSizePrecisionScale(object5, ((Domain)object5).getLogicalDatatype().getName());
                            String string10 = string7.replace("Unknown", "");
                            string10 = string10.replace("unknown", "");
                            string10 = string10.replace("UNKNOWN", "");
                            break;
                        }
                        case 1: {
                            String string11 = "LT";
                            object62 = this.getSizePrecisionScale(column, column.getLogicalDatatype().getName());
                            break;
                        }
                        case 2: {
                            String string12 = "DT";
                            break;
                        }
                        case 3: {
                            if (column.isReference()) {
                                String string13 = "RST";
                                break;
                            }
                            String string14 = "ST";
                            break;
                        }
                        case 4: {
                            String string15 = "CT";
                        }
                    }
                    element2 = document.createElement("osdm_t:DataType");
                    object5 = column.isAutoIncrementColumn() ? " - AI" : "";
                    object4 = column.isIdentityColumn() ? " - ID" : "";
                    element2.appendChild(document.createTextNode((String)object62 + (String)object5 + (String)object4));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:DataTypeKind");
                    element2.appendChild(document.createTextNode((String)var23_73));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:DomainName");
                    element2.appendChild(document.createTextNode((String)var24_86));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:Formula");
                    element2.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                    object72.appendChild(element2);
                    String string16 = "";
                    Object object8 = column.isContainsPII() == null ? "" : (object32 = column.isContainsPII() != false ? "Y" : "");
                    Object object9 = column.isContainsSensitiveInformation() == null ? "" : (object22 = column.isContainsSensitiveInformation() != false ? "Y" : "");
                    String string17 = column.isMaskData() == null ? "" : (column.isMaskData() != false ? "Y" : "");
                    String string19 = (String)object32 + "/" + (String)object22 + "/" + string17;
                    string19 = string19.replace("//", "");
                    element2 = document.createElement("osdm_t:Security");
                    element2.appendChild(document.createTextNode(string19));
                    object72.appendChild(element2);
                    element2 = document.createElement("osdm_t:PreferredAbbreviation");
                    element2.appendChild(document.createTextNode(column.getAbbreviation()));
                    object72.appendChild(element2);
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableColumnsComments()) {
                int n = 0;
                object13 = null;
                for (Column column : Arrays.asList(((ContainerObject)object15).getElements())) {
                    object72 = "";
                    object72 = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                    object62 = column.getNotes();
                    if ((object72 == null || ((String)object72).equals("")) && (object62 == null || ((String)object62).equals(""))) continue;
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:ColumnsCommentsCollection");
                        element.appendChild((Node)object13);
                    }
                    Element element6 = document.createElement("osdm_t:ColumnCommentsDetails");
                    object13.appendChild(element6);
                    element2 = document.createElement("osdm_t:ColumnCommentsSequence");
                    element2.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                    element6.appendChild(element2);
                    element2 = document.createElement("osdm_t:ColumnCommentsName");
                    element2.appendChild(document.createTextNode(column.getName()));
                    element6.appendChild(element2);
                    if (object72 != "" && object72 != null) {
                        Element element7 = document.createElement("osdm_t:ColumnDescription");
                        object5 = document.createElement("osdm_t:ColumnDescriptionDetails");
                        object4 = null;
                        for (String string20 : Arrays.asList(((String)object72).split("\\n"))) {
                            object4 = document.createElement("osdm_t:ColumnDescriptionRow");
                            object4.appendChild(document.createTextNode(string20));
                            object5.appendChild((Node)object4);
                        }
                        if (object4 == null) {
                            object4 = document.createElement("osdm_t:ColumnDescriptionRow");
                            object4.appendChild(document.createTextNode(""));
                            object5.appendChild((Node)object4);
                        }
                        element7.appendChild((Node)object5);
                        element6.appendChild(element7);
                    }
                    if (object62 != "" && object62 != null) {
                        Element element8 = document.createElement("osdm_t:ColumnNotes");
                        object5 = document.createElement("osdm_t:ColumnNotesDetails");
                        object4 = null;
                        for (String string21 : Arrays.asList(((String)object62).split("\\n"))) {
                            object4 = document.createElement("osdm_t:ColumnNoteRow");
                            object4.appendChild(document.createTextNode(string21));
                            object5.appendChild((Node)object4);
                        }
                        if (object4 == null) {
                            object4 = document.createElement("osdm_t:ColumnNoteRow");
                            object4.appendChild(document.createTextNode(""));
                            object5.appendChild((Node)object4);
                        }
                        element8.appendChild((Node)object5);
                        element6.appendChild(element8);
                    }
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableIndexes()) {
                int n = 0;
                object13 = new ArrayList();
                Object var19_32 = null;
                Iterator iterator2 = ((ContainerWithKeyObject)object15).getKeySet().iterator();
                while (iterator2.hasNext()) {
                    object72 = (Index)iterator2.next();
                    if (((KeyObject)object72).isFK()) continue;
                    if (n == 0) {
                        Element element9 = document.createElement("osdm_t:IndexesCollection");
                        element.appendChild(element9);
                    }
                    for (Column column : Arrays.asList(((ContainerObject)object72).getElements())) {
                        void var19_33;
                        Element element10 = document.createElement("osdm_t:IndexDetails");
                        var19_33.appendChild(element10);
                        boolean bl = false;
                        object4 = ((DesignObject)object72).getName();
                        Iterator iterator3 = ((ArrayList)object13).iterator();
                        while (iterator3.hasNext()) {
                            object32 = (String)iterator3.next();
                            if (!((String)object32).equals(object4)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            ((ArrayList)object13).add(object4);
                        }
                        element2 = document.createElement("osdm_t:IndexName");
                        element2.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object72).getName()));
                        element10.appendChild(element2);
                        object32 = ((Index)object72).getIndexState();
                        object32 = ((String)object32).equals("Unique Plain Index") ? "UN" : (((String)object32).equals("Unique Constraint") ? "UK" : (((String)object32).equals("Primary Constraint") ? "PK" : ""));
                        element2 = document.createElement("osdm_t:IndexState");
                        element2.appendChild(document.createTextNode((String)(bl ? "" : object32)));
                        element10.appendChild(element2);
                        element2 = document.createElement("osdm_t:IndexFunctional");
                        element2.appendChild(document.createTextNode(!"".equalsIgnoreCase(((Index)object72).getIndexExpression()) ? "Y" : ""));
                        element10.appendChild(element2);
                        element2 = document.createElement("osdm_t:IndexSpatial");
                        element2.appendChild(document.createTextNode(((Index)object72).isSpatialIndex() ? "Y" : ""));
                        element10.appendChild(element2);
                        element2 = document.createElement("osdm_t:IndexExpression");
                        element2.appendChild(document.createTextNode(((Index)object72).getIndexExpression()));
                        element10.appendChild(element2);
                        element2 = document.createElement("osdm_t:IndexColumnName");
                        element2.appendChild(document.createTextNode(column.getName()));
                        element10.appendChild(element2);
                        element2 = document.createElement("osdm_t:IndexSortOrder");
                        element2.appendChild(document.createTextNode(((Index)object72).getColumnSortOrder(column)));
                        element10.appendChild(element2);
                    }
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableConstraints()) {
                int n = 0;
                object13 = null;
                Object var19_36 = null;
                for (Object object72 : ((Table)object15).getCheckConstraints()) {
                    void var19_37;
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:ConstraintsCollection");
                        element.appendChild((Node)object13);
                        Element element11 = document.createElement("osdm_t:TableLevelConstraintsCollection");
                        object13.appendChild(element11);
                    }
                    object62 = document.createElement("osdm_t:TableLevelConstraintDetails");
                    var19_37.appendChild((Node)object62);
                    element2 = document.createElement("osdm_t:TLConstraintType");
                    element2.appendChild(document.createTextNode(n == 0 ? "Table Level" : ""));
                    object62.appendChild(element2);
                    element2 = document.createElement("osdm_t:TLConstraintName");
                    element2.appendChild(document.createTextNode(((DesignObject)object72).getName()));
                    object62.appendChild(element2);
                    Element element12 = document.createElement("osdm_t:TLConstraintRule");
                    Element element13 = document.createElement("osdm_t:TLConstraintRuleDetails");
                    Element element14 = null;
                    object4 = ((TableLevelConstraint)object72).getRule();
                    for (String string22 : Arrays.asList(((String)object4).split("\\n"))) {
                        element14 = document.createElement("osdm_t:TLConstraintRuleRow");
                        element14.appendChild(document.createTextNode(string22));
                        element13.appendChild(element14);
                    }
                    if (element14 == null) {
                        element14 = document.createElement("osdm_t:TLConstraintRuleRow");
                        element14.appendChild(document.createTextNode(""));
                        element13.appendChild(element14);
                    }
                    element12.appendChild(element13);
                    object62.appendChild(element12);
                    ++n;
                }
                int n2 = 0;
                object62 = null;
                for (Column column : Arrays.asList(((ContainerObject)object15).getElements())) {
                    Object object10;
                    Object object11;
                    Object object12;
                    Object object16;
                    if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:ConstraintsCollection");
                        element.appendChild((Node)object13);
                    }
                    if (n2 == 0) {
                        object62 = document.createElement("osdm_t:ColumnLevelConstraintsCollection");
                        object13.appendChild((Node)object62);
                    }
                    String string23 = "";
                    object4 = column.getCheck();
                    if (object4 != null && !(string23 = ((ModelObject)object4).getName()).equals("")) {
                        string23 = " / " + string23;
                    }
                    Element element15 = document.createElement("osdm_t:ConstraintDetails");
                    object62.appendChild(element15);
                    element2 = document.createElement("osdm_t:ContstraintType");
                    element2.appendChild(document.createTextNode(n2 == 0 ? "Column Level" : ""));
                    element15.appendChild(element2);
                    element2 = document.createElement("osdm_t:ALCConstraintName");
                    element2.appendChild(document.createTextNode(column.getName() + string23));
                    element15.appendChild(element2);
                    object32 = null;
                    object22 = column.getAVTs().iterator();
                    int n3 = 0;
                    while (object22.hasNext()) {
                        object16 = (AVT)object22.next();
                        if (n3 == 0) {
                            object32 = document.createElement("osdm_t:RangesCollection");
                            element15.appendChild((Node)object32);
                        }
                        Element element16 = document.createElement("osdm_t:RangeDetails");
                        object32.appendChild(element16);
                        element2 = document.createElement("osdm_t:RangeBeginValue");
                        element2.appendChild(document.createTextNode(((AVT)object16).getBeginValue()));
                        element16.appendChild(element2);
                        element2 = document.createElement("osdm_t:RangeEndValue");
                        element2.appendChild(document.createTextNode(((AVT)object16).getEndValue()));
                        element16.appendChild(element2);
                        element2 = document.createElement("osdm_t:RangeShortDescription");
                        element2.appendChild(document.createTextNode(((AVT)object16).getDescription()));
                        element16.appendChild(element2);
                        ++n3;
                    }
                    object16 = null;
                    int n4 = 0;
                    if (column.getValueList() != null) {
                        object12 = column.getValueIterator();
                        while (object12.hasNext()) {
                            object11 = object12.next();
                            String string24 = (String)column.getValueList().getValuesDescriptionMap().get(object11);
                            if (n4 == 0) {
                                object16 = document.createElement("osdm_t:ValueListsCollection");
                                element15.appendChild((Node)object16);
                            }
                            object10 = document.createElement("osdm_t:ValueListDetails");
                            object16.appendChild((Node)object10);
                            element2 = document.createElement("osdm_t:VLValue");
                            element2.appendChild(document.createTextNode(object11.toString()));
                            object10.appendChild(element2);
                            element2 = document.createElement("osdm_t:VLShortDescription");
                            element2.appendChild(document.createTextNode(string24));
                            object10.appendChild(element2);
                            ++n4;
                        }
                    }
                    if (object4 != null && !"".equalsIgnoreCase(((CheckConstraint)object4).getGenericConstraint())) {
                        object12 = document.createElement("osdm_t:CheckConstraintsCollection");
                        element15.appendChild((Node)object12);
                        object11 = ((CheckConstraint)object4).getTypes();
                        for (int i = 0; i < ((E)object11).length; ++i) {
                            object10 = (RDBMSType)object11[i];
                            String string25 = ((CheckConstraint)object4).getImplementationFor(object10);
                            if (string25 == null) continue;
                            Element element17 = document.createElement("osdm_t:CheckConstraintDetails");
                            object12.appendChild(element17);
                            Element element18 = document.createElement("osdm_t:CheckConstraintText");
                            Element element19 = document.createElement("osdm_t:CheckConstraintTextDetails");
                            Element element20 = null;
                            for (String string26 : Arrays.asList(string25.split("\\n"))) {
                                element20 = document.createElement("osdm_t:CheckConstraintTextRow");
                                element20.appendChild(document.createTextNode(string26));
                                element19.appendChild(element20);
                            }
                            if (element20 == null) {
                                element20 = document.createElement("osdm_t:CheckConstraintTextRow");
                                element20.appendChild(document.createTextNode(""));
                                element19.appendChild(element20);
                            }
                            element18.appendChild(element19);
                            element17.appendChild(element18);
                            element2 = document.createElement("osdm_t:DatabaseType");
                            element2.appendChild(document.createTextNode(object10 != null ? ((RDBMSType)object10).getName() : ""));
                            element17.appendChild(element2);
                        }
                    }
                    ++n2;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableFKReferringTo()) {
                int n = 0;
                object13 = null;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (FKIndexAssociation fKIndexAssociation : ((Table)object15).getFKAssociationsList()) {
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:FKRTCollection");
                        element.appendChild((Node)object13);
                    }
                    for (Column column : Arrays.asList(fKIndexAssociation.getRemoteIndex().getElements())) {
                        Element element21 = document.createElement("osdm_t:FKRTDetails");
                        object13.appendChild(element21);
                        boolean bl = false;
                        object4 = fKIndexAssociation.getRemoteTable().getName();
                        for (Object object32 : arrayList) {
                            if (!((String)object32).equals(object4)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList.add(object4);
                        }
                        element2 = document.createElement("osdm_t:FKName");
                        element2.appendChild(document.createTextNode(bl ? "" : fKIndexAssociation.getName()));
                        element21.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKReferringTo");
                        element2.appendChild(document.createTextNode(bl ? "" : fKIndexAssociation.getRemoteTable().getName()));
                        element21.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKMandatory");
                        element2.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.isMandatory() ? "Y" : "")));
                        element21.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKTransferable");
                        element2.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.isTransferable() ? "Y" : "")));
                        element21.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKInArc");
                        element2.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.getArc() != null ? "Y" : "")));
                        element21.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKColumnName");
                        element2.appendChild(document.createTextNode(column.getName()));
                        element21.appendChild(element2);
                    }
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseTableFKReferredFrom()) {
                int n = 0;
                object13 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)((DesignObject)object15).getDesignPart()).getFKIndexAssociationSet();
                for (Object object62 : fKIndexAssociationSet.getAssociationsWith((Table)object15)) {
                    if (n == 0) {
                        object13 = document.createElement("osdm_t:FKRFCollection");
                        element.appendChild((Node)object13);
                    }
                    for (Column column : Arrays.asList(((FKIndexAssociation)object62).getRemoteIndex().getElements())) {
                        Element element22 = document.createElement("osdm_t:FKRFDetails");
                        object13.appendChild(element22);
                        boolean bl = false;
                        String string27 = ((FKIndexAssociation)object62).getContainerWithKeyObject().getName();
                        for (Object object22 : arrayList) {
                            if (!((String)object22).equals(string27)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList.add(string27);
                        }
                        element2 = document.createElement("osdm_t:FKName");
                        element2.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object62).getName()));
                        element22.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKReferredFrom");
                        element2.appendChild(document.createTextNode(bl ? "" : ((FKIndexAssociation)object62).getContainerWithKeyObject().getName()));
                        element22.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKMandatory");
                        element2.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object62).isMandatory() ? "Y" : "")));
                        element22.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKTransferable");
                        element2.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object62).isTransferable() ? "Y" : "")));
                        element22.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKInArc");
                        element2.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object62).getArc() != null ? "Y" : "")));
                        element22.appendChild(element2);
                        element2 = document.createElement("osdm_t:FKColumnName");
                        element2.appendChild(document.createTextNode(column.getName()));
                        element22.appendChild(element2);
                    }
                    ++n;
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during single table report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during single table report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleEntityData(Design design, DesignPart designPart, Object object, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object[] objectArray;
            Object object22;
            Object object3;
            Object object4;
            Object object7;
            Object object8;
            Object object9;
            Iterator iterator;
            Object object10;
            Object object11;
            Object object12;
            Element element;
            Object object13;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_e", "osdm_e:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_e:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_e:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                object13 = document.createElement("osdm_e:VersionComment");
                element = document.createElement("osdm_e:VersionCommentDetails");
                object12 = null;
                for (String string2 : Arrays.asList(string.split("\\n"))) {
                    object12 = document.createElement("osdm_e:VersionCommentRow");
                    object12.appendChild(document.createTextNode(string2));
                    element.appendChild((Node)object12);
                }
                if (object12 == null) {
                    object12 = document.createElement("osdm_e:VersionCommentRow");
                    object12.appendChild(document.createTextNode(""));
                    element.appendChild((Node)object12);
                }
                object13.appendChild(element);
                element2.appendChild((Node)object13);
            }
            element3 = document.createElement("osdm_e:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            object13 = (Entity)object;
            element3 = document.createElement("osdm_e:EntityName");
            element3.appendChild(document.createTextNode(((DesignObject)object13).getName()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_e:Abbreviation");
            element3.appendChild(document.createTextNode(((Entity)object13).getPreferredAbbreviation()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_e:ClassificationTypeName");
            element3.appendChild(document.createTextNode(""));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_e:ObjectTypeName");
            element3.appendChild(document.createTextNode(((ContainerObject)object13).getBasedOnStructuredType() != null ? ((ContainerObject)object13).getBasedOnStructuredType().getName() : ""));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_e:SuperType");
            element3.appendChild(document.createTextNode(((Entity)object13).getHierarchicalParent() != null ? ((Entity)object13).getHierarchicalParent().getName() : ""));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_e:Synonyms");
            element3.appendChild(document.createTextNode(((Entity)object13).getSynonym()));
            element2.appendChild(element3);
            element = null;
            object12 = ((Entity)object13).getAllMappedtables().iterator();
            int n = 0;
            while (object12.hasNext()) {
                object11 = (Table)object12.next();
                if (n == 0) {
                    element = document.createElement("osdm_e:MappedTablesCollection");
                    element2.appendChild(element);
                }
                object10 = document.createElement("osdm_e:MappedTablesDetails");
                element.appendChild((Node)object10);
                iterator = ((ModelObject)object11).getDesign().getRelationalDesign().getName() != null ? ((ModelObject)object11).getDesign().getRelationalDesign().getName() + "." : "";
                element3 = document.createElement("osdm_e:TableName");
                element3.appendChild(document.createTextNode(iterator + ((Table)object11).getLongName()));
                object10.appendChild(element3);
                ++n;
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                object11 = "";
                object11 = ((ModelIDObject)object13).getComment() == null || ((ModelIDObject)object13).getComment().equals("") ? ((ModelIDObject)object13).getCommentInRDBMS() : ((ModelIDObject)object13).getComment();
                object10 = ((ModelIDObject)object13).getNotes();
                if (object11 != "" && object11 != null || object10 != "" && object10 != null) {
                    iterator = document.createElement("osdm_e:DescriptionNotes");
                    if (object11 != "" && object11 != null) {
                        object9 = document.createElement("osdm_e:Description");
                        object8 = document.createElement("osdm_e:DescriptionDetails");
                        object7 = null;
                        for (String object62 : Arrays.asList(((String)object11).split("\\n"))) {
                            object7 = document.createElement("osdm_e:DescriptionRow");
                            object7.appendChild(document.createTextNode(object62));
                            object8.appendChild((Node)object7);
                        }
                        if (object7 == null) {
                            object7 = document.createElement("osdm_e:DescriptionRow");
                            object7.appendChild(document.createTextNode(""));
                            object8.appendChild((Node)object7);
                        }
                        object9.appendChild((Node)object8);
                        iterator.appendChild((Node)object9);
                    }
                    if (object10 != "" && object10 != null) {
                        object9 = document.createElement("osdm_e:Notes");
                        object8 = document.createElement("osdm_e:NotesDetails");
                        object7 = null;
                        for (String string6 : Arrays.asList(((String)object10).split("\\n"))) {
                            object7 = document.createElement("osdm_e:NoteRow");
                            object7.appendChild(document.createTextNode(string6));
                            object8.appendChild((Node)object7);
                        }
                        if (object7 == null) {
                            object7 = document.createElement("osdm_e:NoteRow");
                            object7.appendChild(document.createTextNode(""));
                            object8.appendChild((Node)object7);
                        }
                        object9.appendChild((Node)object8);
                        iterator.appendChild((Node)object9);
                    }
                    element2.appendChild((Node)((Object)iterator));
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseQuantitativeInfo()) {
                object11 = document.createElement("osdm_e:QuantitativeInfoCollection");
                element3 = document.createElement("osdm_e:NumberOfColumns");
                element3.appendChild(document.createTextNode(Integer.valueOf(((ContainerObject)object13).getElements().length).toString()));
                object11.appendChild(element3);
                element3 = document.createElement("osdm_e:NumberOfRowsMin");
                element3.appendChild(document.createTextNode(((Entity)object13).getMinVolumes()));
                object11.appendChild(element3);
                element3 = document.createElement("osdm_e:NumberOfRowsMax");
                element3.appendChild(document.createTextNode(((Entity)object13).getMaxVolumes()));
                object11.appendChild(element3);
                element3 = document.createElement("osdm_e:ExpectedNumberOfRows");
                element3.appendChild(document.createTextNode(((Entity)object13).getExpectedVolumes()));
                object11.appendChild(element3);
                element3 = document.createElement("osdm_e:ExpectedGrowth");
                element3.appendChild(document.createTextNode(((Entity)object13).getGrowthPercent()));
                object11.appendChild(element3);
                element3 = document.createElement("osdm_e:GrowthInterval");
                element3.appendChild(document.createTextNode(((Entity)object13).getGrowthType()));
                object11.appendChild(element3);
                element2.appendChild((Node)object11);
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityAttributes()) {
                int n2 = 0;
                object10 = null;
                iterator = ((Entity)object13).getAttributes().iterator();
                ((ContainerObject)object13).getElements();
                while (iterator.hasNext()) {
                    void var26_51;
                    object9 = (Attribute)iterator.next();
                    if (n2 == 0) {
                        object10 = document.createElement("osdm_e:AttributesCollection");
                        element2.appendChild((Node)object10);
                    }
                    object8 = document.createElement("osdm_e:AttributeDetails");
                    object10.appendChild((Node)object8);
                    element3 = document.createElement("osdm_e:Sequence");
                    element3.appendChild(document.createTextNode(Integer.valueOf(((ContainedObject)object9).getContainer().getIndexOf((ContainedObject)object9) + 1).toString()));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:AttributeName");
                    element3.appendChild(document.createTextNode(((ContainedObject)object9).getName()));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:PK");
                    element3.appendChild(document.createTextNode(((ContainedObjectWithDomain)object9).isPKElement() ? "P" : ""));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:FK");
                    element3.appendChild(document.createTextNode(((Attribute)object9).isFKElement() ? "F" : ""));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:M");
                    element3.appendChild(document.createTextNode(((Attribute)object9).getNullsAllowed() ? "" : "Y"));
                    object8.appendChild(element3);
                    object7 = "";
                    String string2 = "";
                    object4 = "";
                    switch (((Attribute)object9).getUse()) {
                        case 0: {
                            String string3 = "DOM";
                            object3 = ((Attribute)object9).getDomain();
                            object4 = ((DesignObject)object3).getName();
                            object7 = this.getSizePrecisionScale(object3, ((Domain)object3).getLogicalDatatype().getName());
                            object4 = ((String)object4).replace("Unknown", "");
                            object4 = ((String)object4).replace("unknown", "");
                            object4 = ((String)object4).replace("UNKNOWN", "");
                            break;
                        }
                        case 1: {
                            String string4 = "LT";
                            object7 = this.getSizePrecisionScale(object9, ((Attribute)object9).getLogicalDatatype().getName());
                            break;
                        }
                        case 2: {
                            String string5 = "DT";
                            break;
                        }
                        case 3: {
                            if (((ContainedObjectWithDomain)object9).isReference()) {
                                String string6 = "RST";
                                break;
                            }
                            String string7 = "ST";
                            break;
                        }
                        case 4: {
                            String string8 = "CT";
                        }
                    }
                    element3 = document.createElement("osdm_e:DataType");
                    element3.appendChild(document.createTextNode((String)object7));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:DataTypeKind");
                    element3.appendChild(document.createTextNode((String)var26_51));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:DomainName");
                    element3.appendChild(document.createTextNode((String)object4));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:Formula");
                    element3.appendChild(document.createTextNode((((ContainedObject)object9).getFormulaDesc() + " " + ((ContainedObjectWithDomain)object9).getDefaultValue()).trim()));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:PreferredAbbreviation");
                    element3.appendChild(document.createTextNode(((Attribute)object9).getPreferredAbbreviation()));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:AttributeSynonyms");
                    element3.appendChild(document.createTextNode(((ContainedObject)object9).getSynonym()));
                    object8.appendChild(element3);
                    ++n2;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityAttributesComments()) {
                int n3 = 0;
                object10 = null;
                iterator = ((Entity)object13).getAttributes().iterator();
                ((ContainerObject)object13).getElements();
                while (iterator.hasNext()) {
                    Element element4;
                    object9 = (Attribute)iterator.next();
                    object8 = "";
                    object8 = ((Attribute)object9).getComment() == null || ((Attribute)object9).getComment().equals("") ? ((Attribute)object9).getCommentInRDBMS() : ((Attribute)object9).getComment();
                    object7 = ((Attribute)object9).getNotes();
                    if ((object8 == null || ((String)object8).equals("")) && (object7 == null || ((String)object7).equals(""))) continue;
                    if (n3 == 0) {
                        object10 = document.createElement("osdm_e:AttributesCommentsCollection");
                        element2.appendChild((Node)object10);
                    }
                    Element element5 = document.createElement("osdm_e:AttributeCommentsDetails");
                    object10.appendChild(element5);
                    element3 = document.createElement("osdm_e:AttributeCommentsSequence");
                    element3.appendChild(document.createTextNode(Integer.valueOf(((ContainedObject)object9).getContainer().getIndexOf((ContainedObject)object9) + 1).toString()));
                    element5.appendChild(element3);
                    element3 = document.createElement("osdm_e:AttributeCommentsName");
                    element3.appendChild(document.createTextNode(((ContainedObject)object9).getName()));
                    element5.appendChild(element3);
                    if (object8 != "" && object8 != null) {
                        object4 = document.createElement("osdm_e:AttributeDescription");
                        object3 = document.createElement("osdm_e:AttributeDescriptionDetails");
                        element4 = null;
                        for (String string9 : Arrays.asList(((String)object8).split("\\n"))) {
                            element4 = document.createElement("osdm_e:AttributeDescriptionRow");
                            element4.appendChild(document.createTextNode(string9));
                            object3.appendChild(element4);
                        }
                        if (element4 == null) {
                            element4 = document.createElement("osdm_e:AttributeDescriptionRow");
                            element4.appendChild(document.createTextNode(""));
                            object3.appendChild(element4);
                        }
                        object4.appendChild((Node)object3);
                        element5.appendChild((Node)object4);
                    }
                    if (object7 != "" && object7 != null) {
                        object4 = document.createElement("osdm_e:AttributeNotes");
                        object3 = document.createElement("osdm_e:AttributeNotesDetails");
                        element4 = null;
                        for (String string10 : Arrays.asList(((String)object7).split("\\n"))) {
                            element4 = document.createElement("osdm_e:AttributeNoteRow");
                            element4.appendChild(document.createTextNode(string10));
                            object3.appendChild(element4);
                        }
                        if (element4 == null) {
                            element4 = document.createElement("osdm_e:AttributeNoteRow");
                            element4.appendChild(document.createTextNode(""));
                            object3.appendChild(element4);
                        }
                        object4.appendChild((Node)object3);
                        element5.appendChild((Node)object4);
                    }
                    ++n3;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityConstraints()) {
                Element element5 = null;
                object10 = ((Entity)object13).getAttributes().iterator();
                int n4 = 0;
                while (object10.hasNext()) {
                    Object object5;
                    object9 = (Attribute)object10.next();
                    if (((Attribute)object9).getAVTs().size() <= 0 && ((Attribute)object9).getValueList() == null && ((Attribute)object9).getCheck() == null) continue;
                    if (n4 == 0) {
                        element5 = document.createElement("osdm_e:ConstraintsCollection");
                        element2.appendChild(element5);
                    }
                    object8 = "";
                    object7 = ((Attribute)object9).getCheck();
                    if (object7 != null && !((String)(object8 = ((ModelObject)object7).getName())).equals("")) {
                        object8 = " / " + (String)object8;
                    }
                    Element element6 = document.createElement("osdm_e:ConstraintDetails");
                    element5.appendChild(element6);
                    element3 = document.createElement("osdm_e:ContstraintType");
                    element3.appendChild(document.createTextNode(n4 == 0 ? "Attribute Level" : ""));
                    element6.appendChild(element3);
                    element3 = document.createElement("osdm_e:ALCConstraintName");
                    element3.appendChild(document.createTextNode(((ContainedObject)object9).getName() + (String)object8));
                    element6.appendChild(element3);
                    object4 = null;
                    object3 = ((Attribute)object9).getAVTs().iterator();
                    int n2 = 0;
                    while (object3.hasNext()) {
                        AVT aVT = (AVT)object3.next();
                        if (n2 == 0) {
                            object4 = document.createElement("osdm_e:RangesCollection");
                            element6.appendChild((Node)object4);
                        }
                        Element element7 = document.createElement("osdm_e:RangeDetails");
                        object4.appendChild(element7);
                        element3 = document.createElement("osdm_e:RangeBeginValue");
                        element3.appendChild(document.createTextNode(aVT.getBeginValue()));
                        element7.appendChild(element3);
                        element3 = document.createElement("osdm_e:RangeEndValue");
                        element3.appendChild(document.createTextNode(aVT.getEndValue()));
                        element7.appendChild(element3);
                        element3 = document.createElement("osdm_e:RangeShortDescription");
                        element3.appendChild(document.createTextNode(aVT.getDescription()));
                        element7.appendChild(element3);
                        ++n2;
                    }
                    Object var30_74 = null;
                    int n3 = 0;
                    if (((Attribute)object9).getValueList() != null) {
                        object22 = ((ContainedObjectWithDomain)object9).getValueIterator();
                        while (object22.hasNext()) {
                            void var30_75;
                            objectArray = object22.next();
                            String string11 = (String)((Attribute)object9).getValueList().getValuesDescriptionMap().get(objectArray);
                            if (n3 == 0) {
                                Element element8 = document.createElement("osdm_e:ValueListsCollection");
                                element6.appendChild(element8);
                            }
                            object5 = document.createElement("osdm_e:ValueListDetails");
                            var30_75.appendChild((Node)object5);
                            element3 = document.createElement("osdm_e:VLValue");
                            element3.appendChild(document.createTextNode(objectArray.toString()));
                            object5.appendChild(element3);
                            element3 = document.createElement("osdm_e:VLShortDescription");
                            element3.appendChild(document.createTextNode(string11));
                            object5.appendChild(element3);
                            ++n3;
                        }
                    }
                    if (object7 != null && !"".equalsIgnoreCase(((CheckConstraint)object7).getGenericConstraint())) {
                        object22 = document.createElement("osdm_e:CheckConstraintsCollection");
                        element6.appendChild((Node)object22);
                        objectArray = ((CheckConstraint)object7).getTypes();
                        for (int i = 0; i < objectArray.length; ++i) {
                            object5 = (RDBMSType)objectArray[i];
                            String string12 = ((CheckConstraint)object7).getImplementationFor(object5);
                            if (string12 == null) continue;
                            Element element9 = document.createElement("osdm_e:CheckConstraintDetails");
                            object22.appendChild(element9);
                            Element element10 = document.createElement("osdm_e:CheckConstraintText");
                            Element element11 = document.createElement("osdm_e:CheckConstraintTextDetails");
                            Element element12 = null;
                            for (String string13 : Arrays.asList(string12.split("\\n"))) {
                                element12 = document.createElement("osdm_e:CheckConstraintTextRow");
                                element12.appendChild(document.createTextNode(string13));
                                element11.appendChild(element12);
                            }
                            if (element12 == null) {
                                element12 = document.createElement("osdm_e:CheckConstraintTextRow");
                                element12.appendChild(document.createTextNode(""));
                                element11.appendChild(element12);
                            }
                            element10.appendChild(element11);
                            element9.appendChild(element10);
                            element3 = document.createElement("osdm_e:DatabaseType");
                            element3.appendChild(document.createTextNode(object5 != null ? ((RDBMSType)object5).getName() : ""));
                            element9.appendChild(element3);
                        }
                    }
                    ++n4;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityIdentifiers()) {
                Element element11 = null;
                object10 = ((ContainerWithKeyObject)object13).getKeySet().iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n7 = 0;
                while (object10.hasNext()) {
                    if (n7 == 0) {
                        element11 = document.createElement("osdm_e:IdentifiersCollection");
                        element2.appendChild(element11);
                    }
                    object8 = (CandidateKey)object10.next();
                    object7 = ((CandidateKey)object8).getElements();
                    for (int i = 0; i < ((ContainedObject[])object7).length; ++i) {
                        object4 = object7[i];
                        object3 = document.createElement("osdm_e:IdentifierDetails");
                        element11.appendChild((Node)object3);
                        boolean bl = false;
                        String string14 = ((DesignObject)object8).getName();
                        for (Object object22 : arrayList) {
                            if (!((String)object22).equals(string14)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList.add(string14);
                        }
                        element3 = document.createElement("osdm_e:IdentifierName");
                        element3.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object8).getName()));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_e:PrimaryIdentifier");
                        element3.appendChild(document.createTextNode(bl ? "" : (((CandidateKey)object8).getKeyState().equals("Primary Key") ? "Y" : "")));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_e:ElementName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object4).getName()));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_e:ElementType");
                        element3.appendChild(document.createTextNode("A"));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_e:SourceLabel");
                        element3.appendChild(document.createTextNode(""));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_e:TargetLabel");
                        element3.appendChild(document.createTextNode(""));
                        object3.appendChild(element3);
                    }
                    ++n7;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityRelationships()) {
                Element element12 = null;
                object10 = design.getLogicalDesign().getRelationSet().getRelationsTo((Entity)object13).iterator();
                int n8 = 0;
                while (object10.hasNext()) {
                    if (n8 == 0) {
                        element12 = document.createElement("osdm_e:RelationshipsCollection");
                        element2.appendChild(element12);
                    }
                    Relation relation = (Relation)object10.next();
                    object8 = document.createElement("osdm_e:RelationshipDetails");
                    element12.appendChild((Node)object8);
                    if (object13 == relation.getSourceEntity()) {
                        element3 = document.createElement("osdm_e:SourceName");
                        element3.appendChild(document.createTextNode(relation.getTargetEntity().getName()));
                        object8.appendChild(element3);
                    } else if (object13 == relation.getTargetEntity()) {
                        element3 = document.createElement("osdm_e:SourceName");
                        element3.appendChild(document.createTextNode(relation.getSourceEntity().getName()));
                        object8.appendChild(element3);
                    }
                    element3 = document.createElement("osdm_e:SourceRole");
                    element3.appendChild(document.createTextNode(relation.getNameOnSource() != null ? relation.getNameOnSource() : ""));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:TargetRole");
                    element3.appendChild(document.createTextNode(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : ""));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:InArc");
                    element3.appendChild(document.createTextNode(relation.inArc() ? "Y" : ""));
                    object8.appendChild(element3);
                    String string15 = "";
                    object7 = relation.isOptionalSource() ? "0" : "1";
                    object4 = relation.getTargetCardinality().toString();
                    object7 = (String)object7 + ".." + (String)object4;
                    object3 = relation.isOptionalTarget() ? "0" : "1";
                    object4 = relation.getSourceCardinality().toString();
                    object3 = (String)object3 + ".." + (String)object4;
                    String string16 = (String)object7 + ":" + (String)object3;
                    element3 = document.createElement("osdm_e:Cardinality");
                    element3.appendChild(document.createTextNode(string16));
                    object8.appendChild(element3);
                    String string17 = "";
                    String string18 = relation.getDominantRole().getName();
                    if (string18 != null) {
                        string17 = string18.equals("None") ? "" : string18;
                    }
                    element3 = document.createElement("osdm_e:DominantRole");
                    element3.appendChild(document.createTextNode(string17));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:Identifying");
                    element3.appendChild(document.createTextNode(relation.isIdentifying() ? "Y" : ""));
                    object8.appendChild(element3);
                    element3 = document.createElement("osdm_e:Transferable");
                    element3.appendChild(document.createTextNode(relation.isTransferable() ? "Y" : ""));
                    object8.appendChild(element3);
                    ++n8;
                }
            }
            Element element13 = null;
            object10 = null;
            boolean bl = true;
            boolean bl2 = true;
            object8 = ((ModelObject)object13).getDesign().getProcessModel();
            object7 = ((ProcessModel)object8).getDataFlowDesigns().iterator();
            while (object7.hasNext()) {
                DataFlowDesign dataFlowDesign = (DataFlowDesign)object7.next();
                object4 = dataFlowDesign.getTopLevelDataFlowDesign() != null ? dataFlowDesign.getTopLevelDataFlowDesign().getName() : "";
                object3 = dataFlowDesign.getProcessSet().iterator();
                while (object3.hasNext()) {
                    Process process = (Process)object3.next();
                    if (process.getType() != 0) continue;
                    for (Process.ProcessedObject processedObject : process.getProcessedEntitiesAndFlows(false, (Entity)object13)) {
                        if (processedObject.getObject() != object13) continue;
                        object22 = "";
                        if (processedObject.isOpRead()) {
                            object22 = "R";
                        } else {
                            if (processedObject.isOpCreate()) {
                                object22 = "C";
                            }
                            if (processedObject.isOpUpdate()) {
                                object22 = (String)object22 + "U";
                            }
                            if (processedObject.isOpDelete()) {
                                object22 = (String)object22 + "D";
                            }
                        }
                        if (processedObject.isInbound()) {
                            if (reportTemplate.getType() != 0 && !reportTemplate.isUseEntityIncomingProcesses()) continue;
                            if (bl) {
                                element13 = document.createElement("osdm_e:IncomingProcessesCollection");
                                element2.appendChild(element13);
                                bl = false;
                            }
                            objectArray = document.createElement("osdm_e:IncomingProcessDetails");
                            element13.appendChild((Node)objectArray);
                            element3 = document.createElement("osdm_e:IncomingProcessName");
                            element3.appendChild(document.createTextNode(process.getName()));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_e:IncomingFlowName");
                            element3.appendChild(document.createTextNode(processedObject.getFlow().getName()));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_e:IncomingCRUDCode");
                            element3.appendChild(document.createTextNode((String)object22));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_e:IncomingDFDName");
                            element3.appendChild(document.createTextNode((String)object4));
                            objectArray.appendChild(element3);
                            continue;
                        }
                        if (reportTemplate.getType() != 0 && !reportTemplate.isUseEntityOutgoingProcesses()) continue;
                        if (bl2) {
                            object10 = document.createElement("osdm_e:OutgoingProcessesCollection");
                            element2.appendChild((Node)object10);
                            bl2 = false;
                        }
                        objectArray = document.createElement("osdm_e:OugoingProcessDetails");
                        object10.appendChild((Node)objectArray);
                        element3 = document.createElement("osdm_e:OutgoingProcessName");
                        element3.appendChild(document.createTextNode(process.getName()));
                        objectArray.appendChild(element3);
                        element3 = document.createElement("osdm_e:OutgoingFlowName");
                        element3.appendChild(document.createTextNode(processedObject.getFlow().getName()));
                        objectArray.appendChild(element3);
                        element3 = document.createElement("osdm_e:OutgoingCRUDCode");
                        element3.appendChild(document.createTextNode((String)object22));
                        objectArray.appendChild(element3);
                        element3 = document.createElement("osdm_e:OutgoingDFDName");
                        element3.appendChild(document.createTextNode((String)object4));
                        objectArray.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during single entity report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during single entity report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherAllEntitiesData(Design design, DesignPart designPart, ReportTemplate reportTemplate, Object object) {
        Document document = null;
        try {
            Object object2;
            Object object3;
            Iterator iterator;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_ae", "osdm_ae:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_ae:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_ae:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_ae:VersionComment");
                iterator = document.createElement("osdm_ae:VersionCommentDetails");
                object3 = null;
                for (String object4 : Arrays.asList(string.split("\\n"))) {
                    object3 = document.createElement("osdm_ae:VersionCommentRow");
                    object3.appendChild(document.createTextNode(object4));
                    iterator.appendChild((Node)object3);
                }
                if (object3 == null) {
                    object3 = document.createElement("osdm_ae:VersionCommentRow");
                    object3.appendChild(document.createTextNode(""));
                    iterator.appendChild((Node)object3);
                }
                element.appendChild((Node)((Object)iterator));
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_ae:ModelName");
            element3.appendChild(document.createTextNode(object == null ? designPart.getName() : designPart.getName() + " / " + ((DesignPartViewPlaceHolder)object).getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_ae:EntitiesCollection");
            element2.appendChild(element);
            iterator = null;
            if (object != null) {
                object3 = new ArrayList();
                for (Object object4 : ((DesignPartViewPlaceHolder)object).getDesignPartView().getTVShapes()) {
                    if (!(object4 instanceof TVEntity) || object3.contains(object2 = (Entity)((TVEntity)object4).getModel())) continue;
                    object3.add(object2);
                }
                Collections.sort(object3, ModelObjectSet.NAME_COMPARATOR);
                iterator = object3.iterator();
            } else {
                iterator = design.getLogicalDesign().getEntitySet().iterator();
            }
            while (iterator.hasNext()) {
                Object[] objectArray;
                Object object52;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object102;
                Iterator n8;
                Object object11;
                Object n3;
                Object object4;
                object3 = (Entity)iterator.next();
                Element element4 = document.createElement("osdm_ae:EntityDetails");
                element.appendChild(element4);
                element3 = document.createElement("osdm_ae:EntityName");
                element3.appendChild(document.createTextNode(((DesignObject)object3).getName()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_ae:Abbreviation");
                element3.appendChild(document.createTextNode(((Entity)object3).getPreferredAbbreviation()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_ae:ClassificationTypeName");
                element3.appendChild(document.createTextNode(""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_ae:ObjectTypeName");
                element3.appendChild(document.createTextNode(((ContainerObject)object3).getBasedOnStructuredType() != null ? ((ContainerObject)object3).getBasedOnStructuredType().getName() : ""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_ae:SuperType");
                element3.appendChild(document.createTextNode(((Entity)object3).getHierarchicalParent() != null ? ((Entity)object3).getHierarchicalParent().getName() : ""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_ae:Synonyms");
                element3.appendChild(document.createTextNode(((Entity)object3).getSynonym()));
                element4.appendChild(element3);
                object4 = null;
                object2 = ((Entity)object3).getAllMappedtables().iterator();
                int n = 0;
                while (object2.hasNext()) {
                    n3 = (Table)object2.next();
                    if (n == 0) {
                        object4 = document.createElement("osdm_ae:MappedTablesCollection");
                        element4.appendChild((Node)object4);
                    }
                    object11 = document.createElement("osdm_ae:MappedTablesDetails");
                    object4.appendChild((Node)object11);
                    n8 = ((ModelObject)n3).getDesign().getRelationalDesign().getName() != null ? ((ModelObject)n3).getDesign().getRelationalDesign().getName() + "." : "";
                    element3 = document.createElement("osdm_ae:TableName");
                    element3.appendChild(document.createTextNode(n8 + ((Table)n3).getLongName()));
                    object11.appendChild(element3);
                    ++n;
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                    n3 = "";
                    n3 = ((ModelIDObject)object3).getComment() == null || ((ModelIDObject)object3).getComment().equals("") ? ((ModelIDObject)object3).getCommentInRDBMS() : ((ModelIDObject)object3).getComment();
                    object11 = ((ModelIDObject)object3).getNotes();
                    if (n3 != "" && n3 != null || object11 != "" && object11 != null) {
                        n8 = document.createElement("osdm_ae:DescriptionNotes");
                        if (n3 != "" && n3 != null) {
                            object102 = document.createElement("osdm_ae:Description");
                            object9 = document.createElement("osdm_ae:DescriptionDetails");
                            object8 = null;
                            for (String dataFlowDesign : Arrays.asList(((String)n3).split("\\n"))) {
                                object8 = document.createElement("osdm_ae:DescriptionRow");
                                object8.appendChild(document.createTextNode(dataFlowDesign));
                                object9.appendChild((Node)object8);
                            }
                            if (object8 == null) {
                                object8 = document.createElement("osdm_ae:DescriptionRow");
                                object8.appendChild(document.createTextNode(""));
                                object9.appendChild((Node)object8);
                            }
                            object102.appendChild((Node)object9);
                            n8.appendChild((Node)object102);
                        }
                        if (object11 != "" && object11 != null) {
                            object102 = document.createElement("osdm_ae:Notes");
                            object9 = document.createElement("osdm_ae:NotesDetails");
                            object8 = null;
                            for (String string2 : Arrays.asList(((String)object11).split("\\n"))) {
                                object8 = document.createElement("osdm_ae:NoteRow");
                                object8.appendChild(document.createTextNode(string2));
                                object9.appendChild((Node)object8);
                            }
                            if (object8 == null) {
                                object8 = document.createElement("osdm_ae:NoteRow");
                                object8.appendChild(document.createTextNode(""));
                                object9.appendChild((Node)object8);
                            }
                            object102.appendChild((Node)object9);
                            n8.appendChild((Node)object102);
                        }
                        element4.appendChild((Node)((Object)n8));
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseQuantitativeInfo()) {
                    n3 = document.createElement("osdm_ae:QuantitativeInfoCollection");
                    element3 = document.createElement("osdm_ae:NumberOfColumns");
                    element3.appendChild(document.createTextNode(Integer.valueOf(((ContainerObject)object3).getElements().length).toString()));
                    n3.appendChild(element3);
                    element3 = document.createElement("osdm_ae:NumberOfRowsMin");
                    element3.appendChild(document.createTextNode(((Entity)object3).getMinVolumes()));
                    n3.appendChild(element3);
                    element3 = document.createElement("osdm_ae:NumberOfRowsMax");
                    element3.appendChild(document.createTextNode(((Entity)object3).getMaxVolumes()));
                    n3.appendChild(element3);
                    element3 = document.createElement("osdm_ae:ExpectedNumberOfRows");
                    element3.appendChild(document.createTextNode(((Entity)object3).getExpectedVolumes()));
                    n3.appendChild(element3);
                    element3 = document.createElement("osdm_ae:ExpectedGrowth");
                    element3.appendChild(document.createTextNode(((Entity)object3).getGrowthPercent()));
                    n3.appendChild(element3);
                    element3 = document.createElement("osdm_ae:GrowthInterval");
                    element3.appendChild(document.createTextNode(((Entity)object3).getGrowthType()));
                    n3.appendChild(element3);
                    element4.appendChild((Node)n3);
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityAttributes()) {
                    int element5 = 0;
                    object11 = null;
                    for (Object object102 : ((Entity)object3).getAttributes()) {
                        void var29_54;
                        if (element5 == 0) {
                            object11 = document.createElement("osdm_ae:AttributesCollection");
                            element4.appendChild((Node)object11);
                        }
                        object9 = document.createElement("osdm_ae:AttributeDetails");
                        object11.appendChild((Node)object9);
                        element3 = document.createElement("osdm_ae:Sequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(((ContainedObject)object102).getContainer().getIndexOf((ContainedObject)object102) + 1).toString()));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:AttributeName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object102).getName()));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:PK");
                        element3.appendChild(document.createTextNode(((ContainedObjectWithDomain)object102).isPKElement() ? "P" : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:FK");
                        element3.appendChild(document.createTextNode(((Attribute)object102).isFKElement() ? "F" : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:M");
                        element3.appendChild(document.createTextNode(((Attribute)object102).getNullsAllowed() ? "" : "Y"));
                        object9.appendChild(element3);
                        object8 = "";
                        String string3 = "";
                        object7 = "";
                        switch (((Attribute)object102).getUse()) {
                            case 0: {
                                String string4 = "DOM";
                                object6 = ((Attribute)object102).getDomain();
                                object7 = ((DesignObject)object6).getName();
                                object8 = this.getSizePrecisionScale(object6, ((Domain)object6).getLogicalDatatype().getName());
                                object7 = ((String)object7).replace("Unknown", "");
                                object7 = ((String)object7).replace("unknown", "");
                                object7 = ((String)object7).replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                String string5 = "LT";
                                object8 = this.getSizePrecisionScale(object102, ((Attribute)object102).getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                String string6 = "DT";
                                break;
                            }
                            case 3: {
                                if (((ContainedObjectWithDomain)object102).isReference()) {
                                    String string7 = "RST";
                                    break;
                                }
                                String string8 = "ST";
                                break;
                            }
                            case 4: {
                                String string9 = "CT";
                            }
                        }
                        element3 = document.createElement("osdm_ae:DataType");
                        element3.appendChild(document.createTextNode((String)object8));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:DataTypeKind");
                        element3.appendChild(document.createTextNode((String)var29_54));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:DomainName");
                        element3.appendChild(document.createTextNode((String)object7));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:Formula");
                        element3.appendChild(document.createTextNode((((ContainedObject)object102).getFormulaDesc() + " " + ((ContainedObjectWithDomain)object102).getDefaultValue()).trim()));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:PreferredAbbreviation");
                        element3.appendChild(document.createTextNode(((Attribute)object102).getPreferredAbbreviation()));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:AttributeSynonyms");
                        element3.appendChild(document.createTextNode(((ContainedObject)object102).getSynonym()));
                        object9.appendChild(element3);
                        ++element5;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityAttributesComments()) {
                    int element12 = 0;
                    object11 = null;
                    for (Object object102 : ((Entity)object3).getAttributes()) {
                        Element element5;
                        object9 = "";
                        object9 = ((Attribute)object102).getComment() == null || ((Attribute)object102).getComment().equals("") ? ((Attribute)object102).getCommentInRDBMS() : ((Attribute)object102).getComment();
                        object8 = ((Attribute)object102).getNotes();
                        if ((object9 == null || ((String)object9).equals("")) && (object8 == null || ((String)object8).equals(""))) continue;
                        if (element12 == 0) {
                            object11 = document.createElement("osdm_ae:AttributesCommentsCollection");
                            element4.appendChild((Node)object11);
                        }
                        Element element6 = document.createElement("osdm_ae:AttributeCommentsDetails");
                        object11.appendChild(element6);
                        element3 = document.createElement("osdm_ae:AttributeCommentsSequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(((ContainedObject)object102).getContainer().getIndexOf((ContainedObject)object102) + 1).toString()));
                        element6.appendChild(element3);
                        element3 = document.createElement("osdm_ae:AttributeCommentsName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object102).getName()));
                        element6.appendChild(element3);
                        if (object9 != "" && object9 != null) {
                            object7 = document.createElement("osdm_ae:AttributeDescription");
                            object6 = document.createElement("osdm_ae:AttributeDescriptionDetails");
                            element5 = null;
                            for (String string10 : Arrays.asList(((String)object9).split("\\n"))) {
                                element5 = document.createElement("osdm_ae:AttributeDescriptionRow");
                                element5.appendChild(document.createTextNode(string10));
                                object6.appendChild(element5);
                            }
                            if (element5 == null) {
                                element5 = document.createElement("osdm_ae:AttributeDescriptionRow");
                                element5.appendChild(document.createTextNode(""));
                                object6.appendChild(element5);
                            }
                            object7.appendChild((Node)object6);
                            element6.appendChild((Node)object7);
                        }
                        if (object8 != "" && object8 != null) {
                            object7 = document.createElement("osdm_ae:AttributeNotes");
                            object6 = document.createElement("osdm_ae:AttributeNotesDetails");
                            element5 = null;
                            for (String string11 : Arrays.asList(((String)object8).split("\\n"))) {
                                element5 = document.createElement("osdm_ae:AttributeNoteRow");
                                element5.appendChild(document.createTextNode(string11));
                                object6.appendChild(element5);
                            }
                            if (element5 == null) {
                                element5 = document.createElement("osdm_ae:AttributeNoteRow");
                                element5.appendChild(document.createTextNode(""));
                                object6.appendChild(element5);
                            }
                            object7.appendChild((Node)object6);
                            element6.appendChild((Node)object7);
                        }
                        ++element12;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityConstraints()) {
                    Element element7 = null;
                    object11 = ((Entity)object3).getAttributes().iterator();
                    int n2 = 0;
                    while (object11.hasNext()) {
                        Object object12;
                        object102 = (Attribute)object11.next();
                        if (((Attribute)object102).getAVTs().size() <= 0 && ((Attribute)object102).getValueList() == null && ((Attribute)object102).getCheck() == null) continue;
                        if (n2 == 0) {
                            element7 = document.createElement("osdm_ae:ConstraintsCollection");
                            element4.appendChild(element7);
                        }
                        object9 = "";
                        object8 = ((Attribute)object102).getCheck();
                        if (object8 != null && !((String)(object9 = ((ModelObject)object8).getName())).equals("")) {
                            object9 = " / " + (String)object9;
                        }
                        Element element8 = document.createElement("osdm_ae:ConstraintDetails");
                        element7.appendChild(element8);
                        element3 = document.createElement("osdm_ae:ContstraintType");
                        element3.appendChild(document.createTextNode(n2 == 0 ? "Attribute Level" : ""));
                        element8.appendChild(element3);
                        element3 = document.createElement("osdm_ae:ALCConstraintName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object102).getName() + (String)object9));
                        element8.appendChild(element3);
                        object7 = null;
                        object6 = ((Attribute)object102).getAVTs().iterator();
                        int n4 = 0;
                        while (object6.hasNext()) {
                            AVT aVT = (AVT)object6.next();
                            if (n4 == 0) {
                                object7 = document.createElement("osdm_ae:RangesCollection");
                                element8.appendChild((Node)object7);
                            }
                            Element element9 = document.createElement("osdm_ae:RangeDetails");
                            object7.appendChild(element9);
                            element3 = document.createElement("osdm_ae:RangeBeginValue");
                            element3.appendChild(document.createTextNode(aVT.getBeginValue()));
                            element9.appendChild(element3);
                            element3 = document.createElement("osdm_ae:RangeEndValue");
                            element3.appendChild(document.createTextNode(aVT.getEndValue()));
                            element9.appendChild(element3);
                            element3 = document.createElement("osdm_ae:RangeShortDescription");
                            element3.appendChild(document.createTextNode(aVT.getDescription()));
                            element9.appendChild(element3);
                            ++n4;
                        }
                        Object var33_73 = null;
                        int n5 = 0;
                        if (((Attribute)object102).getValueList() != null) {
                            object52 = ((ContainedObjectWithDomain)object102).getValueIterator();
                            while (object52.hasNext()) {
                                void var33_74;
                                objectArray = object52.next();
                                String string12 = (String)((Attribute)object102).getValueList().getValuesDescriptionMap().get(objectArray);
                                if (n5 == 0) {
                                    Element element10 = document.createElement("osdm_ae:ValueListsCollection");
                                    element8.appendChild(element10);
                                }
                                object12 = document.createElement("osdm_ae:ValueListDetails");
                                var33_74.appendChild((Node)object12);
                                element3 = document.createElement("osdm_ae:VLValue");
                                element3.appendChild(document.createTextNode(objectArray.toString()));
                                object12.appendChild(element3);
                                element3 = document.createElement("osdm_ae:VLShortDescription");
                                element3.appendChild(document.createTextNode(string12));
                                object12.appendChild(element3);
                                ++n5;
                            }
                        }
                        if (object8 != null && !"".equalsIgnoreCase(((CheckConstraint)object8).getGenericConstraint())) {
                            object52 = document.createElement("osdm_ae:CheckConstraintsCollection");
                            element8.appendChild((Node)object52);
                            objectArray = ((CheckConstraint)object8).getTypes();
                            for (int i = 0; i < objectArray.length; ++i) {
                                object12 = (RDBMSType)objectArray[i];
                                String string13 = ((CheckConstraint)object8).getImplementationFor(object12);
                                if (string13 == null) continue;
                                Element element11 = document.createElement("osdm_ae:CheckConstraintDetails");
                                object52.appendChild(element11);
                                Element element12 = document.createElement("osdm_ae:CheckConstraintText");
                                Element element13 = document.createElement("osdm_ae:CheckConstraintTextDetails");
                                Element element14 = null;
                                for (String string14 : Arrays.asList(string13.split("\\n"))) {
                                    element14 = document.createElement("osdm_ae:CheckConstraintTextRow");
                                    element14.appendChild(document.createTextNode(string14));
                                    element13.appendChild(element14);
                                }
                                if (element14 == null) {
                                    element14 = document.createElement("osdm_ae:CheckConstraintTextRow");
                                    element14.appendChild(document.createTextNode(""));
                                    element13.appendChild(element14);
                                }
                                element12.appendChild(element13);
                                element11.appendChild(element12);
                                element3 = document.createElement("osdm_ae:DatabaseType");
                                element3.appendChild(document.createTextNode(object12 != null ? ((RDBMSType)object12).getName() : ""));
                                element11.appendChild(element3);
                            }
                        }
                        ++n2;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityIdentifiers()) {
                    Element element15 = null;
                    object11 = ((ContainerWithKeyObject)object3).getKeySet().iterator();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n6 = 0;
                    while (object11.hasNext()) {
                        if (n6 == 0) {
                            element15 = document.createElement("osdm_ae:IdentifiersCollection");
                            element4.appendChild(element15);
                        }
                        object9 = (CandidateKey)object11.next();
                        object8 = ((CandidateKey)object9).getElements();
                        for (int i = 0; i < ((ContainedObject[])object8).length; ++i) {
                            object7 = object8[i];
                            object6 = document.createElement("osdm_ae:IdentifierDetails");
                            element15.appendChild((Node)object6);
                            boolean bl = false;
                            String string15 = ((DesignObject)object9).getName();
                            for (Object object52 : arrayList) {
                                if (!((String)object52).equals(string15)) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                arrayList.add(string15);
                            }
                            element3 = document.createElement("osdm_ae:IdentifierName");
                            element3.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object9).getName()));
                            object6.appendChild(element3);
                            element3 = document.createElement("osdm_ae:PrimaryIdentifier");
                            element3.appendChild(document.createTextNode(bl ? "" : (((CandidateKey)object9).getKeyState().equals("Primary Key") ? "Y" : "")));
                            object6.appendChild(element3);
                            element3 = document.createElement("osdm_ae:ElementName");
                            element3.appendChild(document.createTextNode(((ContainedObject)object7).getName()));
                            object6.appendChild(element3);
                            element3 = document.createElement("osdm_ae:ElementType");
                            element3.appendChild(document.createTextNode("A"));
                            object6.appendChild(element3);
                            element3 = document.createElement("osdm_ae:SourceLabel");
                            element3.appendChild(document.createTextNode(""));
                            object6.appendChild(element3);
                            element3 = document.createElement("osdm_ae:TargetLabel");
                            element3.appendChild(document.createTextNode(""));
                            object6.appendChild(element3);
                        }
                        ++n6;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseEntityRelationships()) {
                    Element element16 = null;
                    object11 = design.getLogicalDesign().getRelationSet().getRelationsTo((Entity)object3).iterator();
                    int n7 = 0;
                    while (object11.hasNext()) {
                        if (n7 == 0) {
                            element16 = document.createElement("osdm_ae:RelationshipsCollection");
                            element4.appendChild(element16);
                        }
                        Relation relation = (Relation)object11.next();
                        object9 = document.createElement("osdm_ae:RelationshipDetails");
                        element16.appendChild((Node)object9);
                        if (object3 == relation.getSourceEntity()) {
                            element3 = document.createElement("osdm_ae:SourceName");
                            element3.appendChild(document.createTextNode(relation.getTargetEntity().getName()));
                            object9.appendChild(element3);
                        } else if (object3 == relation.getTargetEntity()) {
                            element3 = document.createElement("osdm_ae:SourceName");
                            element3.appendChild(document.createTextNode(relation.getSourceEntity().getName()));
                            object9.appendChild(element3);
                        }
                        element3 = document.createElement("osdm_ae:SourceRole");
                        element3.appendChild(document.createTextNode(relation.getNameOnSource() != null ? relation.getNameOnSource() : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:TargetRole");
                        element3.appendChild(document.createTextNode(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:InArc");
                        element3.appendChild(document.createTextNode(relation.inArc() ? "Y" : ""));
                        object9.appendChild(element3);
                        String string16 = "";
                        object8 = relation.isOptionalSource() ? "0" : "1";
                        object7 = relation.getTargetCardinality().toString();
                        object8 = (String)object8 + ".." + (String)object7;
                        object6 = relation.isOptionalTarget() ? "0" : "1";
                        object7 = relation.getSourceCardinality().toString();
                        object6 = (String)object6 + ".." + (String)object7;
                        String string17 = (String)object8 + ":" + (String)object6;
                        element3 = document.createElement("osdm_ae:Cardinality");
                        element3.appendChild(document.createTextNode(string17));
                        object9.appendChild(element3);
                        String string18 = "";
                        String string19 = relation.getDominantRole().getName();
                        if (string19 != null) {
                            string18 = string19.equals("None") ? "" : string19;
                        }
                        element3 = document.createElement("osdm_ae:DominantRole");
                        element3.appendChild(document.createTextNode(string18));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:Identifying");
                        element3.appendChild(document.createTextNode(relation.isIdentifying() ? "Y" : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_ae:Transferable");
                        element3.appendChild(document.createTextNode(relation.isTransferable() ? "Y" : ""));
                        object9.appendChild(element3);
                        ++n7;
                    }
                }
                n3 = null;
                object11 = null;
                boolean arrayList = true;
                boolean relation = true;
                object9 = ((ModelObject)object3).getDesign().getProcessModel();
                object8 = ((ProcessModel)object9).getDataFlowDesigns().iterator();
                while (object8.hasNext()) {
                    DataFlowDesign dataFlowDesign = (DataFlowDesign)object8.next();
                    object7 = dataFlowDesign.getTopLevelDataFlowDesign() != null ? dataFlowDesign.getTopLevelDataFlowDesign().getName() : "";
                    object6 = dataFlowDesign.getProcessSet().iterator();
                    while (object6.hasNext()) {
                        Process process = (Process)object6.next();
                        if (process.getType() != 0) continue;
                        for (Process.ProcessedObject processedObject : process.getProcessedEntitiesAndFlows(false, (Entity)object3)) {
                            if (processedObject.getObject() != object3) continue;
                            object52 = "";
                            if (processedObject.isOpRead()) {
                                object52 = "R";
                            } else {
                                if (processedObject.isOpCreate()) {
                                    object52 = "C";
                                }
                                if (processedObject.isOpUpdate()) {
                                    object52 = (String)object52 + "U";
                                }
                                if (processedObject.isOpDelete()) {
                                    object52 = (String)object52 + "D";
                                }
                            }
                            if (processedObject.isInbound()) {
                                if (reportTemplate.getType() != 0 && !reportTemplate.isUseEntityIncomingProcesses()) continue;
                                if (arrayList) {
                                    n3 = document.createElement("osdm_ae:IncomingProcessesCollection");
                                    element4.appendChild((Node)n3);
                                    arrayList = false;
                                }
                                objectArray = document.createElement("osdm_ae:IncomingProcessDetails");
                                n3.appendChild((Node)objectArray);
                                element3 = document.createElement("osdm_ae:IncomingProcessName");
                                element3.appendChild(document.createTextNode(process.getName()));
                                objectArray.appendChild(element3);
                                element3 = document.createElement("osdm_ae:IncomingFlowName");
                                element3.appendChild(document.createTextNode(processedObject.getFlow().getName()));
                                objectArray.appendChild(element3);
                                element3 = document.createElement("osdm_ae:IncomingCRUDCode");
                                element3.appendChild(document.createTextNode((String)object52));
                                objectArray.appendChild(element3);
                                element3 = document.createElement("osdm_ae:IncomingDFDName");
                                element3.appendChild(document.createTextNode((String)object7));
                                objectArray.appendChild(element3);
                                continue;
                            }
                            if (reportTemplate.getType() != 0 && !reportTemplate.isUseEntityOutgoingProcesses()) continue;
                            if (relation) {
                                object11 = document.createElement("osdm_ae:OutgoingProcessesCollection");
                                element4.appendChild((Node)object11);
                                relation = false;
                            }
                            objectArray = document.createElement("osdm_ae:OugoingProcessDetails");
                            object11.appendChild((Node)objectArray);
                            element3 = document.createElement("osdm_ae:OutgoingProcessName");
                            element3.appendChild(document.createTextNode(process.getName()));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_ae:OutgoingFlowName");
                            element3.appendChild(document.createTextNode(processedObject.getFlow().getName()));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_ae:OutgoingCRUDCode");
                            element3.appendChild(document.createTextNode((String)object52));
                            objectArray.appendChild(element3);
                            element3 = document.createElement("osdm_ae:OutgoingDFDName");
                            element3.appendChild(document.createTextNode((String)object7));
                            objectArray.appendChild(element3);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during all entities report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all entities report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherAllTablesData(Design design, DesignPart designPart, ReportTemplate reportTemplate, Object object) {
        Document document = null;
        try {
            Object object2;
            Object object3;
            Iterator iterator;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_at", "osdm_at:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_at:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_at:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_at:VersionComment");
                iterator = document.createElement("osdm_at:VersionCommentDetails");
                object3 = null;
                for (String object4 : Arrays.asList(string.split("\\n"))) {
                    object3 = document.createElement("osdm_at:VersionCommentRow");
                    object3.appendChild(document.createTextNode(object4));
                    iterator.appendChild((Node)object3);
                }
                if (object3 == null) {
                    object3 = document.createElement("osdm_at:VersionCommentRow");
                    object3.appendChild(document.createTextNode(""));
                    iterator.appendChild((Node)object3);
                }
                element.appendChild((Node)((Object)iterator));
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_at:ModelName");
            element3.appendChild(document.createTextNode(object == null ? designPart.getName() : designPart.getName() + " / " + ((DesignPartViewPlaceHolder)object).getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_at:TablesCollection");
            element2.appendChild(element);
            iterator = null;
            if (object != null) {
                object3 = new ArrayList();
                for (Object n : ((DesignPartViewPlaceHolder)object).getDesignPartView().getTVShapes()) {
                    if (!(n instanceof TVTable) || object3.contains(object2 = (Table)((TVTable)n).getModel())) continue;
                    object3.add(object2);
                }
                Collections.sort(object3, ModelObjectSet.NAME_COMPARATOR);
                iterator = object3.iterator();
            } else {
                iterator = ((RelationalDesign)designPart).getTableSet().iterator();
            }
            while (iterator.hasNext()) {
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object82;
                Object object92;
                Object object102;
                Object object11;
                object3 = (Table)iterator.next();
                Element element4 = document.createElement("osdm_at:TableDetails");
                element.appendChild(element4);
                element3 = document.createElement("osdm_at:TableName");
                element3.appendChild(document.createTextNode(((Table)object3).getLongName()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_at:FunctionalName");
                element3.appendChild(document.createTextNode(((Table)object3).getEngEntity() != null ? ((Table)object3).getEngEntity().getName() : ""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_at:Abbreviation");
                element3.appendChild(document.createTextNode(((Table)object3).getAbbreviation()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_at:ClassificationTypeName");
                element3.appendChild(document.createTextNode(""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_at:ObjectTypeName");
                element3.appendChild(document.createTextNode(((ContainerObject)object3).getBasedOnStructuredType() != null ? ((ContainerObject)object3).getBasedOnStructuredType().getName() : ""));
                element4.appendChild(element3);
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                    String n = "";
                    n = ((ModelIDObject)object3).getComment() == null || ((ModelIDObject)object3).getComment().equals("") ? ((ModelIDObject)object3).getCommentInRDBMS() : ((ModelIDObject)object3).getComment();
                    object2 = ((ModelIDObject)object3).getNotes();
                    if (n != "" && n != null || object2 != "" && object2 != null) {
                        object11 = document.createElement("osdm_at:DescriptionNotes");
                        if (n != "" && n != null) {
                            Element element5 = document.createElement("osdm_at:Description");
                            object102 = document.createElement("osdm_at:DescriptionDetails");
                            object92 = null;
                            for (String string2 : Arrays.asList(n.split("\\n"))) {
                                object92 = document.createElement("osdm_at:DescriptionRow");
                                object92.appendChild(document.createTextNode(string2));
                                object102.appendChild((Node)object92);
                            }
                            if (object92 == null) {
                                object92 = document.createElement("osdm_at:DescriptionRow");
                                object92.appendChild(document.createTextNode(""));
                                object102.appendChild((Node)object92);
                            }
                            element5.appendChild((Node)object102);
                            object11.appendChild(element5);
                        }
                        if (object2 != "" && object2 != null) {
                            Element element6 = document.createElement("osdm_at:Notes");
                            object102 = document.createElement("osdm_at:NotesDetails");
                            object92 = null;
                            for (String string3 : Arrays.asList(((String)object2).split("\\n"))) {
                                object92 = document.createElement("osdm_at:NoteRow");
                                object92.appendChild(document.createTextNode(string3));
                                object102.appendChild((Node)object92);
                            }
                            if (object92 == null) {
                                object92 = document.createElement("osdm_at:NoteRow");
                                object92.appendChild(document.createTextNode(""));
                                object102.appendChild((Node)object92);
                            }
                            element6.appendChild((Node)object102);
                            object11.appendChild(element6);
                        }
                        element4.appendChild((Node)object11);
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseQuantitativeInfo()) {
                    Element n = document.createElement("osdm_at:QuantitativeInfoCollection");
                    element3 = document.createElement("osdm_at:NumberOfColumns");
                    element3.appendChild(document.createTextNode(Integer.valueOf(((ContainerObject)object3).getElements().length).toString()));
                    n.appendChild(element3);
                    element3 = document.createElement("osdm_at:NumberOfRowsMin");
                    element3.appendChild(document.createTextNode(((Table)object3).getMinVolumes()));
                    n.appendChild(element3);
                    element3 = document.createElement("osdm_at:NumberOfRowsMax");
                    element3.appendChild(document.createTextNode(((Table)object3).getMaxVolumes()));
                    n.appendChild(element3);
                    element3 = document.createElement("osdm_at:ExpectedNumberOfRows");
                    element3.appendChild(document.createTextNode(((Table)object3).getExpectedVolumes()));
                    n.appendChild(element3);
                    element3 = document.createElement("osdm_at:ExpectedGrowth");
                    element3.appendChild(document.createTextNode(((Table)object3).getGrowthPercent()));
                    n.appendChild(element3);
                    element3 = document.createElement("osdm_at:GrowthInterval");
                    element3.appendChild(document.createTextNode(((Table)object3).getGrowthType()));
                    n.appendChild(element3);
                    element4.appendChild(n);
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseTableColumns()) {
                    int n = 0;
                    object2 = null;
                    for (Column column : Arrays.asList(((ContainerObject)object3).getElements())) {
                        void var26_58;
                        if (n == 0) {
                            object2 = document.createElement("osdm_at:ColumnsCollection");
                            element4.appendChild((Node)object2);
                        }
                        object102 = document.createElement("osdm_at:ColumnDetails");
                        object2.appendChild((Node)object102);
                        element3 = document.createElement("osdm_at:Sequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:ColumnName");
                        element3.appendChild(document.createTextNode(column.getName()));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:PK");
                        element3.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:FK");
                        element3.appendChild(document.createTextNode(column.isFKElement() ? "F" : ""));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:M");
                        element3.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        object102.appendChild(element3);
                        object92 = "";
                        String string4 = "";
                        object82 = "";
                        switch (column.getUse()) {
                            case 0: {
                                String string5 = "DOM";
                                object7 = column.getDomain();
                                object82 = ((DesignObject)object7).getName();
                                object92 = this.getSizePrecisionScale(object7, ((Domain)object7).getLogicalDatatype().getName());
                                object82 = ((String)object82).replace("Unknown", "");
                                object82 = ((String)object82).replace("unknown", "");
                                object82 = ((String)object82).replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                String string6 = "LT";
                                object92 = this.getSizePrecisionScale(column, column.getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                String string7 = "DT";
                                break;
                            }
                            case 3: {
                                if (column.isReference()) {
                                    String string8 = "RST";
                                    break;
                                }
                                String string9 = "ST";
                                break;
                            }
                            case 4: {
                                String string10 = "CT";
                            }
                        }
                        element3 = document.createElement("osdm_at:DataType");
                        object7 = column.isAutoIncrementColumn() ? " - AI" : "";
                        object6 = column.isIdentityColumn() ? " - ID" : "";
                        element3.appendChild(document.createTextNode((String)object92 + (String)object7 + (String)object6));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:DataTypeKind");
                        element3.appendChild(document.createTextNode((String)var26_58));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:DomainName");
                        element3.appendChild(document.createTextNode((String)object82));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:Formula");
                        element3.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                        object102.appendChild(element3);
                        String string11 = "";
                        Object object12 = column.isContainsPII() == null ? "" : (object5 = column.isContainsPII() != false ? "Y" : "");
                        Object object13 = column.isContainsSensitiveInformation() == null ? "" : (object4 = column.isContainsSensitiveInformation() != false ? "Y" : "");
                        String string12 = column.isMaskData() == null ? "" : (column.isMaskData() != false ? "Y" : "");
                        String string14 = (String)object5 + "/" + (String)object4 + "/" + string12;
                        string14 = string14.replace("//", "");
                        element3 = document.createElement("osdm_at:Security");
                        element3.appendChild(document.createTextNode(string14));
                        object102.appendChild(element3);
                        element3 = document.createElement("osdm_at:PreferredAbbreviation");
                        element3.appendChild(document.createTextNode(column.getAbbreviation()));
                        object102.appendChild(element3);
                        ++n;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseTableColumnsComments()) {
                    int n = 0;
                    object2 = null;
                    for (Column column : Arrays.asList(((ContainerObject)object3).getElements())) {
                        object102 = "";
                        object102 = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                        object92 = column.getNotes();
                        if ((object102 == null || ((String)object102).equals("")) && (object92 == null || ((String)object92).equals(""))) continue;
                        if (n == 0) {
                            object2 = document.createElement("osdm_at:ColumnsCommentsCollection");
                            element4.appendChild((Node)object2);
                        }
                        Element element7 = document.createElement("osdm_at:ColumnCommentsDetails");
                        object2.appendChild(element7);
                        element3 = document.createElement("osdm_at:ColumnCommentsSequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        element7.appendChild(element3);
                        element3 = document.createElement("osdm_at:ColumnCommentsName");
                        element3.appendChild(document.createTextNode(column.getName()));
                        element7.appendChild(element3);
                        if (object102 != "" && object102 != null) {
                            object82 = document.createElement("osdm_at:ColumnDescription");
                            object7 = document.createElement("osdm_at:ColumnDescriptionDetails");
                            object6 = null;
                            for (String string15 : Arrays.asList(((String)object102).split("\\n"))) {
                                object6 = document.createElement("osdm_at:ColumnDescriptionRow");
                                object6.appendChild(document.createTextNode(string15));
                                object7.appendChild((Node)object6);
                            }
                            if (object6 == null) {
                                object6 = document.createElement("osdm_at:ColumnDescriptionRow");
                                object6.appendChild(document.createTextNode(""));
                                object7.appendChild((Node)object6);
                            }
                            object82.appendChild((Node)object7);
                            element7.appendChild((Node)object82);
                        }
                        if (object92 != "" && object92 != null) {
                            object82 = document.createElement("osdm_at:ColumnNotes");
                            object7 = document.createElement("osdm_at:ColumnNotesDetails");
                            object6 = null;
                            for (String string16 : Arrays.asList(((String)object92).split("\\n"))) {
                                object6 = document.createElement("osdm_at:ColumnNoteRow");
                                object6.appendChild(document.createTextNode(string16));
                                object7.appendChild((Node)object6);
                            }
                            if (object6 == null) {
                                object6 = document.createElement("osdm_at:ColumnNoteRow");
                                object6.appendChild(document.createTextNode(""));
                                object7.appendChild((Node)object6);
                            }
                            object82.appendChild((Node)object7);
                            element7.appendChild((Node)object82);
                        }
                        ++n;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseTableIndexes()) {
                    int n = 0;
                    object2 = new ArrayList();
                    object11 = null;
                    Iterator iterator3 = ((ContainerWithKeyObject)object3).getKeySet().iterator();
                    while (iterator3.hasNext()) {
                        object102 = (Index)iterator3.next();
                        if (((KeyObject)object102).isFK()) continue;
                        if (n == 0) {
                            object11 = document.createElement("osdm_at:IndexesCollection");
                            element4.appendChild((Node)object11);
                        }
                        for (Column column : Arrays.asList(((ContainerObject)object102).getElements())) {
                            object82 = document.createElement("osdm_at:IndexDetails");
                            object11.appendChild((Node)object82);
                            boolean bl = false;
                            object6 = ((DesignObject)object102).getName();
                            Iterator iterator4 = ((ArrayList)object2).iterator();
                            while (iterator4.hasNext()) {
                                object5 = (String)iterator4.next();
                                if (!((String)object5).equals(object6)) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                ((ArrayList)object2).add(object6);
                            }
                            element3 = document.createElement("osdm_at:IndexName");
                            element3.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object102).getName()));
                            object82.appendChild(element3);
                            object5 = ((Index)object102).getIndexState();
                            object5 = ((String)object5).equals("Unique Plain Index") ? "UN" : (((String)object5).equals("Unique Constraint") ? "UK" : (((String)object5).equals("Primary Constraint") ? "PK" : ""));
                            element3 = document.createElement("osdm_at:IndexState");
                            element3.appendChild(document.createTextNode((String)(bl ? "" : object5)));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:IndexFunctional");
                            element3.appendChild(document.createTextNode(!"".equalsIgnoreCase(((Index)object102).getIndexExpression()) ? "Y" : ""));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:IndexSpatial");
                            element3.appendChild(document.createTextNode(((Index)object102).isSpatialIndex() ? "Y" : ""));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:IndexExpression");
                            element3.appendChild(document.createTextNode(((Index)object102).getIndexExpression()));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:IndexColumnName");
                            element3.appendChild(document.createTextNode(column.getName()));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:IndexSortOrder");
                            element3.appendChild(document.createTextNode(((Index)object102).getColumnSortOrder(column)));
                            object82.appendChild(element3);
                        }
                        ++n;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseTableConstraints()) {
                    int n = 0;
                    object2 = null;
                    object11 = null;
                    for (Object object102 : ((Table)object3).getCheckConstraints()) {
                        if (n == 0) {
                            object2 = document.createElement("osdm_at:ConstraintsCollection");
                            element4.appendChild((Node)object2);
                            object11 = document.createElement("osdm_at:TableLevelConstraintsCollection");
                            object2.appendChild((Node)object11);
                        }
                        object92 = document.createElement("osdm_at:TableLevelConstraintDetails");
                        object11.appendChild((Node)object92);
                        element3 = document.createElement("osdm_at:TLConstraintType");
                        element3.appendChild(document.createTextNode(n == 0 ? "Table Level" : ""));
                        object92.appendChild(element3);
                        element3 = document.createElement("osdm_at:TLConstraintName");
                        element3.appendChild(document.createTextNode(((DesignObject)object102).getName()));
                        object92.appendChild(element3);
                        Element element8 = document.createElement("osdm_at:TLConstraintRule");
                        object82 = document.createElement("osdm_at:TLConstraintRuleDetails");
                        Element element9 = null;
                        object6 = ((TableLevelConstraint)object102).getRule();
                        for (String string17 : Arrays.asList(((String)object6).split("\\n"))) {
                            element9 = document.createElement("osdm_at:TLConstraintRuleRow");
                            element9.appendChild(document.createTextNode(string17));
                            object82.appendChild(element9);
                        }
                        if (element9 == null) {
                            element9 = document.createElement("osdm_at:TLConstraintRuleRow");
                            element9.appendChild(document.createTextNode(""));
                            object82.appendChild(element9);
                        }
                        element8.appendChild((Node)object82);
                        object92.appendChild(element8);
                        ++n;
                    }
                    int n2 = 0;
                    object92 = null;
                    for (Object object82 : Arrays.asList(((ContainerObject)object3).getElements())) {
                        Object object14;
                        Object object15;
                        Object object16;
                        Object object17;
                        if (((Column)object82).getAVTs().size() <= 0 && ((Column)object82).getValueList() == null && ((Column)object82).getCheck() == null) continue;
                        if (n == 0) {
                            object2 = document.createElement("osdm_at:ConstraintsCollection");
                            element4.appendChild((Node)object2);
                        }
                        if (n2 == 0) {
                            object92 = document.createElement("osdm_at:ColumnLevelConstraintsCollection");
                            object2.appendChild((Node)object92);
                        }
                        String string18 = "";
                        object6 = ((Column)object82).getCheck();
                        if (object6 != null && !(string18 = ((ModelObject)object6).getName()).equals("")) {
                            string18 = " / " + string18;
                        }
                        Element element10 = document.createElement("osdm_at:ConstraintDetails");
                        object92.appendChild(element10);
                        element3 = document.createElement("osdm_at:ContstraintType");
                        element3.appendChild(document.createTextNode(n2 == 0 ? "Column Level" : ""));
                        element10.appendChild(element3);
                        element3 = document.createElement("osdm_at:ALCConstraintName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object82).getName() + string18));
                        element10.appendChild(element3);
                        object5 = null;
                        object4 = ((Column)object82).getAVTs().iterator();
                        int n3 = 0;
                        while (object4.hasNext()) {
                            object17 = (AVT)object4.next();
                            if (n3 == 0) {
                                object5 = document.createElement("osdm_at:RangesCollection");
                                element10.appendChild((Node)object5);
                            }
                            Element element11 = document.createElement("osdm_at:RangeDetails");
                            object5.appendChild(element11);
                            element3 = document.createElement("osdm_at:RangeBeginValue");
                            element3.appendChild(document.createTextNode(((AVT)object17).getBeginValue()));
                            element11.appendChild(element3);
                            element3 = document.createElement("osdm_at:RangeEndValue");
                            element3.appendChild(document.createTextNode(((AVT)object17).getEndValue()));
                            element11.appendChild(element3);
                            element3 = document.createElement("osdm_at:RangeShortDescription");
                            element3.appendChild(document.createTextNode(((AVT)object17).getDescription()));
                            element11.appendChild(element3);
                            ++n3;
                        }
                        object17 = null;
                        int n4 = 0;
                        if (((Column)object82).getValueList() != null) {
                            object16 = ((ContainedObjectWithDomain)object82).getValueIterator();
                            while (object16.hasNext()) {
                                object15 = object16.next();
                                String string19 = (String)((Column)object82).getValueList().getValuesDescriptionMap().get(object15);
                                if (n4 == 0) {
                                    object17 = document.createElement("osdm_at:ValueListsCollection");
                                    element10.appendChild((Node)object17);
                                }
                                object14 = document.createElement("osdm_at:ValueListDetails");
                                object17.appendChild((Node)object14);
                                element3 = document.createElement("osdm_at:VLValue");
                                element3.appendChild(document.createTextNode(object15.toString()));
                                object14.appendChild(element3);
                                element3 = document.createElement("osdm_at:VLShortDescription");
                                element3.appendChild(document.createTextNode(string19));
                                object14.appendChild(element3);
                                ++n4;
                            }
                        }
                        if (object6 != null && !"".equalsIgnoreCase(((CheckConstraint)object6).getGenericConstraint())) {
                            object16 = document.createElement("osdm_at:CheckConstraintsCollection");
                            element10.appendChild((Node)object16);
                            object15 = ((CheckConstraint)object6).getTypes();
                            for (int i = 0; i < ((E)object15).length; ++i) {
                                object14 = (RDBMSType)object15[i];
                                String string20 = ((CheckConstraint)object6).getImplementationFor(object14);
                                if (string20 == null) continue;
                                Element element12 = document.createElement("osdm_at:CheckConstraintDetails");
                                object16.appendChild(element12);
                                Element element13 = document.createElement("osdm_at:CheckConstraintText");
                                Element element14 = document.createElement("osdm_at:CheckConstraintTextDetails");
                                Element element15 = null;
                                for (String string21 : Arrays.asList(string20.split("\\n"))) {
                                    element15 = document.createElement("osdm_at:CheckConstraintTextRow");
                                    element15.appendChild(document.createTextNode(string21));
                                    element14.appendChild(element15);
                                }
                                if (element15 == null) {
                                    element15 = document.createElement("osdm_at:CheckConstraintTextRow");
                                    element15.appendChild(document.createTextNode(""));
                                    element14.appendChild(element15);
                                }
                                element13.appendChild(element14);
                                element12.appendChild(element13);
                                element3 = document.createElement("osdm_at:DatabaseType");
                                element3.appendChild(document.createTextNode(object14 != null ? ((RDBMSType)object14).getName() : ""));
                                element12.appendChild(element3);
                            }
                        }
                        ++n2;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseTableFKReferringTo()) {
                    int n = 0;
                    object2 = null;
                    object11 = new ArrayList();
                    for (FKIndexAssociation fKIndexAssociation : ((Table)object3).getFKAssociationsList()) {
                        if (n == 0) {
                            object2 = document.createElement("osdm_at:FKRTCollection");
                            element4.appendChild((Node)object2);
                        }
                        for (Column column : Arrays.asList(fKIndexAssociation.getRemoteIndex().getElements())) {
                            object82 = document.createElement("osdm_at:FKRTDetails");
                            object2.appendChild((Node)object82);
                            boolean bl = false;
                            object6 = fKIndexAssociation.getRemoteTable().getName();
                            Iterator iterator5 = ((ArrayList)object11).iterator();
                            while (iterator5.hasNext()) {
                                object5 = (String)iterator5.next();
                                if (!((String)object5).equals(object6)) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                ((ArrayList)object11).add(object6);
                            }
                            element3 = document.createElement("osdm_at:FKName");
                            element3.appendChild(document.createTextNode(bl ? "" : fKIndexAssociation.getName()));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:FKReferringTo");
                            element3.appendChild(document.createTextNode(bl ? "" : fKIndexAssociation.getRemoteTable().getName()));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:FKMandatory");
                            element3.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.isMandatory() ? "Y" : "")));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:FKTransferable");
                            element3.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.isTransferable() ? "Y" : "")));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:FKInArc");
                            element3.appendChild(document.createTextNode(bl ? "" : (fKIndexAssociation.getArc() != null ? "Y" : "")));
                            object82.appendChild(element3);
                            element3 = document.createElement("osdm_at:FKColumnName");
                            element3.appendChild(document.createTextNode(column.getName()));
                            object82.appendChild(element3);
                        }
                        ++n;
                    }
                }
                if (reportTemplate.getType() != 0 && !reportTemplate.isUseTableFKReferredFrom()) continue;
                int n = 0;
                object2 = null;
                object11 = new ArrayList();
                FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)((DesignObject)object3).getDesignPart()).getFKIndexAssociationSet();
                for (Object object92 : fKIndexAssociationSet.getAssociationsWith((Table)object3)) {
                    if (n == 0) {
                        object2 = document.createElement("osdm_at:FKRFCollection");
                        element4.appendChild((Node)object2);
                    }
                    for (Object object82 : Arrays.asList(((FKIndexAssociation)object92).getRemoteIndex().getElements())) {
                        Element element16 = document.createElement("osdm_at:FKRFDetails");
                        object2.appendChild(element16);
                        boolean bl = false;
                        String string22 = ((FKIndexAssociation)object92).getContainerWithKeyObject().getName();
                        object5 = ((ArrayList)object11).iterator();
                        while (object5.hasNext()) {
                            object4 = (String)object5.next();
                            if (!((String)object4).equals(string22)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            ((ArrayList)object11).add(string22);
                        }
                        element3 = document.createElement("osdm_at:FKName");
                        element3.appendChild(document.createTextNode(bl ? "" : ((DesignObject)object92).getName()));
                        element16.appendChild(element3);
                        element3 = document.createElement("osdm_at:FKReferredFrom");
                        element3.appendChild(document.createTextNode(bl ? "" : ((FKIndexAssociation)object92).getContainerWithKeyObject().getName()));
                        element16.appendChild(element3);
                        element3 = document.createElement("osdm_at:FKMandatory");
                        element3.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object92).isMandatory() ? "Y" : "")));
                        element16.appendChild(element3);
                        element3 = document.createElement("osdm_at:FKTransferable");
                        element3.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object92).isTransferable() ? "Y" : "")));
                        element16.appendChild(element3);
                        element3 = document.createElement("osdm_at:FKInArc");
                        element3.appendChild(document.createTextNode(bl ? "" : (((FKIndexAssociation)object92).getArc() != null ? "Y" : "")));
                        element16.appendChild(element3);
                        element3 = document.createElement("osdm_at:FKColumnName");
                        element3.appendChild(document.createTextNode(((ContainedObject)object82).getName()));
                        element16.appendChild(element3);
                    }
                    ++n;
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during all tables report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all tables report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private Document gatherGlossaryData(Glossary glossary) {
        Document document = null;
        try {
            String string3;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElementNS("osdm_g", "osdm_g:root");
            document.appendChild(element);
            Element element2 = document.createElement("osdm_g:GlossaryName");
            element2.appendChild(document.createTextNode(glossary.getName()));
            element.appendChild(element2);
            String string2 = glossary.getDescription();
            Element element3 = document.createElement("osdm_g:Description");
            Element element4 = document.createElement("osdm_g:DescriptionDetails");
            Element element5 = null;
            for (String string3 : Arrays.asList(string2.split("\\n"))) {
                element5 = document.createElement("osdm_g:DescriptionRow");
                element5.appendChild(document.createTextNode(string3));
                element4.appendChild(element5);
            }
            if (element5 == null) {
                element5 = document.createElement("osdm_g:DescriptionRow");
                element5.appendChild(document.createTextNode(""));
                element4.appendChild(element5);
            }
            element3.appendChild(element4);
            element.appendChild(element3);
            element2 = document.createElement("osdm_g:FileName");
            element2.appendChild(document.createTextNode(glossary.getFileName()));
            element.appendChild(element2);
            element2 = document.createElement("osdm_g:IncompleteModifiers");
            element2.appendChild(document.createTextNode(glossary.isIncompleteModifiers() ? "Y" : ""));
            element.appendChild(element2);
            element2 = document.createElement("osdm_g:CaseSensitive");
            element2.appendChild(document.createTextNode(glossary.isCaseSensitive() ? "Y" : ""));
            element.appendChild(element2);
            element2 = document.createElement("osdm_g:UniqueAbbreviations");
            element2.appendChild(document.createTextNode(glossary.isUniqueAbbreviations() ? "Y" : ""));
            element.appendChild(element2);
            element2 = document.createElement("osdm_g:SeparatorType");
            element2.appendChild(document.createTextNode(glossary.getSeparatorType()));
            element.appendChild(element2);
            string3 = "";
            string3 = glossary.getSeparatorType().equalsIgnoreCase("SPACE") ? " " : String.valueOf(glossary.getMW_SeparatorChar());
            element2 = document.createElement("osdm_g:SeparatorChar");
            element2.appendChild(document.createTextNode(string3));
            element.appendChild(element2);
            int n = 0;
            Element element6 = null;
            for (GlossaryWord glossaryWord : glossary.getWords()) {
                if (n == 0) {
                    element6 = document.createElement("osdm_g:GlossaryCollection");
                    element.appendChild(element6);
                }
                Element element7 = document.createElement("osdm_g:GlossaryDetail");
                element6.appendChild(element7);
                element2 = document.createElement("osdm_g:TermName");
                element2.appendChild(document.createTextNode(glossaryWord.getName()));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:Plural");
                element2.appendChild(document.createTextNode(glossaryWord.getPlural()));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:Abbreviation");
                element2.appendChild(document.createTextNode(glossaryWord.getAbbreviation()));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:AltAbbreviation");
                element2.appendChild(document.createTextNode(glossaryWord.getAltAbbrevation()));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:P");
                element2.appendChild(document.createTextNode(glossaryWord.isPrimaryWord() ? "Y" : ""));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:C");
                element2.appendChild(document.createTextNode(glossaryWord.isClassWord() ? "Y" : ""));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:M");
                element2.appendChild(document.createTextNode(glossaryWord.isModifier() ? "Y" : ""));
                element7.appendChild(element2);
                element2 = document.createElement("osdm_g:Q");
                element2.appendChild(document.createTextNode(glossaryWord.isQualifier() ? "Y" : ""));
                element7.appendChild(element2);
                String string4 = glossaryWord.getShortDescription();
                if (string4 != "" && string4 != null) {
                    Element element8 = document.createElement("osdm_g:SDescription");
                    Element element9 = document.createElement("osdm_g:SDescriptionDetails");
                    Element element10 = null;
                    for (String string5 : Arrays.asList(string4.split("\\n"))) {
                        element10 = document.createElement("osdm_g:SDescriptionRow");
                        element10.appendChild(document.createTextNode(string5));
                        element9.appendChild(element10);
                    }
                    if (element10 == null) {
                        element10 = document.createElement("osdm_g:SDescriptionRow");
                        element10.appendChild(document.createTextNode(""));
                        element9.appendChild(element10);
                    }
                    element8.appendChild(element9);
                    element7.appendChild(element8);
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during glossary report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during glossary report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherAllDomainsData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_ad", "osdm_ad:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_ad:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_ad:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                Element element4 = document.createElement("osdm_ad:VersionComment");
                element = document.createElement("osdm_ad:VersionCommentDetails");
                object = null;
                for (String string2 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_ad:VersionCommentRow");
                    object.appendChild(document.createTextNode(string2));
                    element.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_ad:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    element.appendChild((Node)object);
                }
                element4.appendChild(element);
                element2.appendChild(element4);
            }
            int n = 0;
            element = null;
            object = (Domain[])design.getDomainSet().toArray();
            for (int i = 0; i < ((Domain[])object).length; ++i) {
                Object object2;
                Object object32;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Element element5;
                Element element6;
                Domain domain = object[i];
                if (n == 0) {
                    element = document.createElement("osdm_ad:DomainsCollection");
                    element2.appendChild(element);
                }
                Element element7 = document.createElement("osdm_ad:DomainDetails");
                element.appendChild(element7);
                element3 = document.createElement("osdm_ad:DomainName");
                element3.appendChild(document.createTextNode(domain.getName()));
                element7.appendChild(element3);
                element3 = document.createElement("osdm_ad:Synonyms");
                element3.appendChild(document.createTextNode(domain.getSynonym()));
                element7.appendChild(element3);
                String string3 = this.getSizePrecisionScale(domain, domain.getLogicalDatatype().getName());
                element3 = document.createElement("osdm_ad:DataType");
                element3.appendChild(document.createTextNode(string3));
                element7.appendChild(element3);
                element3 = document.createElement("osdm_ad:LogicalType");
                element3.appendChild(document.createTextNode(domain.getLogicalDatatype().getName()));
                element7.appendChild(element3);
                element3 = document.createElement("osdm_ad:UnitOfMeasure");
                element3.appendChild(document.createTextNode(domain.getUnitOfMeasure()));
                element7.appendChild(element3);
                element3 = document.createElement("osdm_ad:DefaultValue");
                element3.appendChild(document.createTextNode(domain.getDefaultValue()));
                element7.appendChild(element3);
                String string4 = "";
                string4 = domain.getComment() == null || domain.getComment().equals("") ? domain.getCommentInRDBMS() : domain.getComment();
                if (string4 != "" && string4 != null) {
                    element6 = document.createElement("osdm_ad:DomainComment");
                    element5 = document.createElement("osdm_ad:DomainCommentDetails");
                    object9 = null;
                    for (String string2 : Arrays.asList(string4.split("\\n"))) {
                        object9 = document.createElement("osdm_ad:DomainCommentRow");
                        object9.appendChild(document.createTextNode(string2));
                        element5.appendChild((Node)object9);
                    }
                    if (object9 == null) {
                        object9 = document.createElement("osdm_ad:DomainCommentRow");
                        object9.appendChild(document.createTextNode(""));
                        element5.appendChild((Node)object9);
                    }
                    element6.appendChild(element5);
                    element7.appendChild(element6);
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDomainConstraints()) {
                    element6 = null;
                    if (domain.getAVTs().size() > 0 || domain.getValueList() != null || domain.getCheck() != null) {
                        Object[] objectArray;
                        element5 = document.createElement("osdm_ad:ConstraintsCollection");
                        element7.appendChild(element5);
                        object9 = document.createElement("osdm_ad:ConstraintDetails");
                        element5.appendChild((Node)object9);
                        Iterator iterator2 = domain.getAVTs().iterator();
                        int n2 = 0;
                        while (iterator2.hasNext()) {
                            object8 = (AVT)iterator2.next();
                            if (n2 == 0) {
                                element6 = document.createElement("osdm_ad:RangesCollection");
                                object9.appendChild(element6);
                            }
                            Element element4 = document.createElement("osdm_ad:RangeDetails");
                            element6.appendChild(element4);
                            element3 = document.createElement("osdm_ad:RangeBeginValue");
                            element3.appendChild(document.createTextNode(((AVT)object8).getBeginValue()));
                            element4.appendChild(element3);
                            element3 = document.createElement("osdm_ad:RangeEndValue");
                            element3.appendChild(document.createTextNode(((AVT)object8).getEndValue()));
                            element4.appendChild(element3);
                            element3 = document.createElement("osdm_ad:RangeShortDescription");
                            element3.appendChild(document.createTextNode(((AVT)object8).getDescription()));
                            element4.appendChild(element3);
                            ++n2;
                        }
                        object8 = null;
                        int n3 = 0;
                        if (domain.getValueList() != null) {
                            object7 = domain.getValueIterator();
                            while (object7.hasNext()) {
                                object6 = object7.next();
                                objectArray = (String)domain.getValueList().getValuesDescriptionMap().get(object6);
                                if (n3 == 0) {
                                    object8 = document.createElement("osdm_ad:ValueListsCollection");
                                    object9.appendChild((Node)object8);
                                }
                                Element element8 = document.createElement("osdm_ad:ValueListDetails");
                                object8.appendChild(element8);
                                element3 = document.createElement("osdm_ad:VLValue");
                                element3.appendChild(document.createTextNode(object6.toString()));
                                element8.appendChild(element3);
                                element3 = document.createElement("osdm_ad:VLShortDescription");
                                element3.appendChild(document.createTextNode((String)objectArray));
                                element8.appendChild(element3);
                                ++n3;
                            }
                        }
                        if ((object7 = domain.getCheck()) != null && !"".equalsIgnoreCase(((CheckConstraint)object7).getGenericConstraint())) {
                            void var33_47;
                            object6 = document.createElement("osdm_ad:CheckConstraintsCollection");
                            object9.appendChild((Node)object6);
                            objectArray = ((CheckConstraint)object7).getTypes();
                            boolean bl = false;
                            while (var33_47 < objectArray.length) {
                                object5 = (RDBMSType)objectArray[var33_47];
                                String string5 = ((CheckConstraint)object7).getImplementationFor(object5);
                                if (string5 != null) {
                                    object4 = document.createElement("osdm_ad:CheckConstraintDetails");
                                    object6.appendChild((Node)object4);
                                    object32 = document.createElement("osdm_ad:CheckConstraintText");
                                    Element element9 = document.createElement("osdm_ad:CheckConstraintTextDetails");
                                    object2 = null;
                                    for (String string6 : Arrays.asList(string5.split("\\n"))) {
                                        object2 = document.createElement("osdm_ad:CheckConstraintTextRow");
                                        object2.appendChild(document.createTextNode(string6));
                                        element9.appendChild((Node)object2);
                                    }
                                    if (object2 == null) {
                                        object2 = document.createElement("osdm_ad:CheckConstraintTextRow");
                                        object2.appendChild(document.createTextNode(""));
                                        element9.appendChild((Node)object2);
                                    }
                                    object32.appendChild(element9);
                                    object4.appendChild((Node)object32);
                                    element3 = document.createElement("osdm_ad:DatabaseType");
                                    element3.appendChild(document.createTextNode(object5 != null ? ((RDBMSType)object5).getName() : ""));
                                    object4.appendChild(element3);
                                }
                                ++var33_47;
                            }
                        }
                    }
                }
                boolean bl = true;
                element5 = null;
                object9 = new ArrayList();
                ArrayList<String> iterator22 = new ArrayList<String>();
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDomainUsedInTables()) {
                    RelationalDesignSet relationalDesignSet = design.getRelationalDesigns();
                    object8 = relationalDesignSet.iterator();
                    while (object8.hasNext()) {
                        RelationalDesign relationalDesign = (RelationalDesign)object8.next();
                        object7 = relationalDesign.getTableSet().iterator();
                        while (object7.hasNext()) {
                            object6 = (Table)object7.next();
                            for (Column column : Arrays.asList(((ContainerObject)object6).getElements())) {
                                if (column.getUse() != 0 || column.getDomain() != domain) continue;
                                if (bl) {
                                    element5 = document.createElement("osdm_ad:TablesCollection");
                                    element7.appendChild(element5);
                                    bl = false;
                                }
                                object5 = document.createElement("osdm_ad:TableDetails");
                                element5.appendChild((Node)object5);
                                boolean bl2 = false;
                                object4 = relationalDesign.getName();
                                object32 = ((ArrayList)object9).iterator();
                                while (object32.hasNext()) {
                                    String string7 = (String)object32.next();
                                    if (!string7.equals(object4)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (!bl2) {
                                    ((ArrayList)object9).add(object4);
                                }
                                boolean bl3 = false;
                                object2 = ((Table)object6).getLongName();
                                for (String string8 : iterator22) {
                                    if (!string8.equals(object2)) continue;
                                    bl3 = true;
                                    break;
                                }
                                if (!bl3) {
                                    iterator22.add((String)object2);
                                }
                                element3 = document.createElement("osdm_ad:ModelName");
                                element3.appendChild(document.createTextNode(bl2 ? "" : relationalDesign.getName()));
                                object5.appendChild(element3);
                                element3 = document.createElement("osdm_ad:TableName");
                                element3.appendChild(document.createTextNode(!bl3 ? ((Table)object6).getLongName() : ""));
                                object5.appendChild(element3);
                                element3 = document.createElement("osdm_ad:ColumnName");
                                element3.appendChild(document.createTextNode(column.getName()));
                                object5.appendChild(element3);
                            }
                        }
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDomainUsedInEntities()) {
                    bl = true;
                    LogicalDesign logicalDesign = design.getLogicalDesign();
                    object8 = null;
                    ArrayList arrayList = new ArrayList();
                    object7 = logicalDesign.getEntitySet().iterator();
                    while (object7.hasNext()) {
                        object6 = (Entity)object7.next();
                        for (Attribute attribute : Arrays.asList(((ContainerObject)object6).getElements())) {
                            if (attribute.getUse() != 0 || attribute.getDomain() != domain) continue;
                            if (bl) {
                                object8 = document.createElement("osdm_ad:EntitiesCollection");
                                element7.appendChild((Node)object8);
                                bl = false;
                            }
                            boolean bl4 = false;
                            String string9 = ((DesignObject)object6).getName();
                            for (Object object32 : arrayList) {
                                if (!((String)object32).equals(string9)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                iterator22.add(string9);
                            }
                            object32 = document.createElement("osdm_ad:EntityDetails");
                            object8.appendChild((Node)object32);
                            element3 = document.createElement("osdm_ad:EntityName");
                            element3.appendChild(document.createTextNode(!bl4 ? ((DesignObject)object6).getName() : ""));
                            object32.appendChild(element3);
                            element3 = document.createElement("osdm_ad:AttributeName");
                            element3.appendChild(document.createTextNode(attribute.getName()));
                            object32.appendChild(element3);
                        }
                    }
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during domains report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during domains report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleCollectionTypeData(Design design, DesignPart designPart, Object object, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object2;
            ContainerWithKeyObject containerWithKeyObject;
            Iterator iterator;
            Object object3;
            Object object4;
            ModelObject modelObject;
            void var19_27;
            Element element;
            Object object5;
            Object object6;
            Object object10;
            Object object11;
            Object object12;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_s_ct", "osdm_s_ct:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_s_ct:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_s_ct:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                object12 = document.createElement("osdm_s_ct:VersionComment");
                object11 = document.createElement("osdm_s_ct:VersionCommentDetails");
                object10 = null;
                for (String object92 : Arrays.asList(string.split("\\n"))) {
                    object10 = document.createElement("osdm_s_ct:VersionCommentRow");
                    object10.appendChild(document.createTextNode(object92));
                    object11.appendChild((Node)object10);
                }
                if (object10 == null) {
                    object10 = document.createElement("osdm_s_ct:VersionCommentRow");
                    object10.appendChild(document.createTextNode(""));
                    object11.appendChild((Node)object10);
                }
                object12.appendChild((Node)object11);
                element2.appendChild((Node)object12);
            }
            element3 = document.createElement("osdm_s_ct:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            object12 = (CollectionType)object;
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                object11 = "";
                object11 = ((ModelIDObject)object12).getComment() == null || ((ModelIDObject)object12).getComment().equals("") ? ((ModelIDObject)object12).getCommentInRDBMS() : ((ModelIDObject)object12).getComment();
                object10 = ((ModelIDObject)object12).getNotes();
                if (object11 != "" && object11 != null || object10 != "" && object10 != null) {
                    Element element4 = document.createElement("osdm_s_ct:DescriptionNotes");
                    if (object11 != "" && object11 != null) {
                        object6 = document.createElement("osdm_s_ct:Description");
                        object5 = document.createElement("osdm_s_ct:DescriptionDetails");
                        element = null;
                        for (String string2 : Arrays.asList(((String)object11).split("\\n"))) {
                            element = document.createElement("osdm_s_ct:DescriptionRow");
                            element.appendChild(document.createTextNode(string2));
                            object5.appendChild(element);
                        }
                        if (element == null) {
                            element = document.createElement("osdm_s_ct:DescriptionRow");
                            element.appendChild(document.createTextNode(""));
                            object5.appendChild(element);
                        }
                        object6.appendChild((Node)object5);
                        element4.appendChild((Node)object6);
                    }
                    if (object10 != "" && object10 != null) {
                        object6 = document.createElement("osdm_s_ct:Notes");
                        object5 = document.createElement("osdm_s_ct:NotesDetails");
                        element = null;
                        for (String string3 : Arrays.asList(((String)object10).split("\\n"))) {
                            element = document.createElement("osdm_s_ct:NoteRow");
                            element.appendChild(document.createTextNode(string3));
                            object5.appendChild(element);
                        }
                        if (element == null) {
                            element = document.createElement("osdm_s_ct:NoteRow");
                            element.appendChild(document.createTextNode(""));
                            object5.appendChild(element);
                        }
                        object6.appendChild((Node)object5);
                        element4.appendChild((Node)object6);
                    }
                    element2.appendChild(element4);
                }
            }
            element3 = document.createElement("osdm_s_ct:CTName");
            element3.appendChild(document.createTextNode(((DesignObject)object12).getLongName()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_ct:CTType");
            element3.appendChild(document.createTextNode(((CollectionType)object12).getType()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_ct:CTMaxElements");
            element3.appendChild(document.createTextNode(Integer.valueOf(((CollectionType)object12).getMaxElement()).toString()));
            element2.appendChild(element3);
            object11 = "";
            object10 = "";
            String string4 = "";
            object6 = ((CollectionType)object12).getDataType();
            if (object6 instanceof Domain) {
                object10 = "DOM";
                object5 = (Domain)object6;
                String string5 = ((DesignObject)object5).getName();
                object11 = this.getSizePrecisionScale(object5, ((Domain)object5).getLogicalDatatype().getName());
                String string8 = string5.replace("Unknown", "");
                string8 = string8.replace("unknown", "");
                string8 = string8.replace("UNKNOWN", "");
            } else if (object6 instanceof LogicalDatatype) {
                object10 = "LT";
                object5 = (LogicalDatatype)object6;
                object11 = this.getSizePrecisionScale(((CollectionType)object12).getElementType(), ((DesignObject)object5).getName());
            } else if (object6 instanceof DistinctType) {
                object10 = "DT";
            } else if (object6 instanceof StructuredType) {
                object10 = "ST";
            } else if (object6 instanceof CollectionType) {
                object10 = "CT";
            }
            element3 = document.createElement("osdm_s_ct:CTDataType");
            element3.appendChild(document.createTextNode((String)object11));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_ct:CTDataTypeKind");
            element3.appendChild(document.createTextNode((String)object10));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_ct:CTDomainName");
            element3.appendChild(document.createTextNode((String)var19_27));
            element2.appendChild(element3);
            boolean bl = true;
            element = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (reportTemplate.getType() == 0 || reportTemplate.isUseCTUsedInTables()) {
                modelObject = design.getRelationalDesigns();
                object4 = ((ModelObjectSet)modelObject).iterator();
                while (object4.hasNext()) {
                    object3 = (RelationalDesign)object4.next();
                    iterator = ((RelationalDesign)object3).getTableSet().iterator();
                    while (iterator.hasNext()) {
                        containerWithKeyObject = (Table)iterator.next();
                        for (Column column : Arrays.asList(containerWithKeyObject.getElements())) {
                            if (column.getUse() != 4 || column.getCollectionType() != object12) continue;
                            if (bl) {
                                element = document.createElement("osdm_s_ct:TablesCollection");
                                element2.appendChild(element);
                                bl = false;
                            }
                            Element element5 = document.createElement("osdm_s_ct:TableDetails");
                            element.appendChild(element5);
                            boolean bl2 = false;
                            object2 = ((RelationalDesign)object3).getName();
                            for (String string9 : arrayList) {
                                if (!string9.equals(object2)) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                arrayList.add(object2);
                            }
                            boolean bl3 = false;
                            String string10 = ((Table)containerWithKeyObject).getLongName();
                            for (String string11 : arrayList2) {
                                if (!string11.equals(string10)) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                arrayList2.add(string10);
                            }
                            element3 = document.createElement("osdm_s_ct:ModelName");
                            element3.appendChild(document.createTextNode(bl2 ? "" : ((RelationalDesign)object3).getName()));
                            element5.appendChild(element3);
                            element3 = document.createElement("osdm_s_ct:TableName");
                            element3.appendChild(document.createTextNode(!bl3 ? ((Table)containerWithKeyObject).getLongName() : ""));
                            element5.appendChild(element3);
                            element3 = document.createElement("osdm_s_ct:ColumnName");
                            element3.appendChild(document.createTextNode(column.getName()));
                            element5.appendChild(element3);
                        }
                    }
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseCTUsedInEntities()) {
                bl = true;
                modelObject = design.getLogicalDesign();
                object4 = null;
                object3 = new ArrayList();
                iterator = ((LogicalDesign)modelObject).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    containerWithKeyObject = (Entity)iterator.next();
                    for (Attribute attribute : Arrays.asList(containerWithKeyObject.getElements())) {
                        Object object7;
                        if (attribute.getUse() != 4 || attribute.getCollectionType() != object12) continue;
                        if (bl) {
                            object4 = document.createElement("osdm_s_ct:EntitiesCollection");
                            element2.appendChild((Node)object4);
                            bl = false;
                        }
                        boolean bl4 = false;
                        String string12 = containerWithKeyObject.getName();
                        object2 = ((ArrayList)object3).iterator();
                        while (object2.hasNext()) {
                            object7 = (String)object2.next();
                            if (!((String)object7).equals(string12)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            arrayList2.add(string12);
                        }
                        object7 = document.createElement("osdm_s_ct:EntityDetails");
                        object4.appendChild((Node)object7);
                        element3 = document.createElement("osdm_s_ct:EntityName");
                        element3.appendChild(document.createTextNode(!bl4 ? containerWithKeyObject.getName() : ""));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_s_ct:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object7.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during single collection type report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during single collection type report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private Document gatherAllCollectionTypesData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object;
            Object object2;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_a_ct", "osdm_a_ct:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_a_ct:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_a_ct:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_a_ct:VersionComment");
                object2 = document.createElement("osdm_a_ct:VersionCommentDetails");
                object = null;
                for (String object3 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_a_ct:VersionCommentRow");
                    object.appendChild(document.createTextNode(object3));
                    object2.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_a_ct:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    object2.appendChild((Node)object);
                }
                element.appendChild((Node)object2);
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_a_ct:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_a_ct:CTCollection");
            element2.appendChild(element);
            object2 = design.getDataTypesDesign().getCollectionTypeSet().iterator();
            while (object2.hasNext()) {
                Object object3;
                ContainerWithKeyObject containerWithKeyObject;
                Iterator iterator2;
                Object object4;
                Object object5;
                ModelObject modelObject;
                Element element4;
                Object object6;
                Object object7;
                Object object8;
                String string2;
                String string3;
                object = (CollectionType)object2.next();
                Element element5 = document.createElement("osdm_a_ct:CTDetails");
                element.appendChild(element5);
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                    string3 = "";
                    string3 = ((ModelIDObject)object).getComment() == null || ((ModelIDObject)object).getComment().equals("") ? ((ModelIDObject)object).getCommentInRDBMS() : ((ModelIDObject)object).getComment();
                    string2 = ((ModelIDObject)object).getNotes();
                    if (string3 != "" && string3 != null || string2 != "" && string2 != null) {
                        object8 = document.createElement("osdm_a_ct:DescriptionNotes");
                        if (string3 != "" && string3 != null) {
                            object7 = document.createElement("osdm_a_ct:Description");
                            object6 = document.createElement("osdm_a_ct:DescriptionDetails");
                            element4 = null;
                            for (String string4 : Arrays.asList(string3.split("\\n"))) {
                                element4 = document.createElement("osdm_a_ct:DescriptionRow");
                                element4.appendChild(document.createTextNode(string4));
                                object6.appendChild(element4);
                            }
                            if (element4 == null) {
                                element4 = document.createElement("osdm_a_ct:DescriptionRow");
                                element4.appendChild(document.createTextNode(""));
                                object6.appendChild(element4);
                            }
                            object7.appendChild((Node)object6);
                            object8.appendChild((Node)object7);
                        }
                        if (string2 != "" && string2 != null) {
                            object7 = document.createElement("osdm_a_ct:Notes");
                            object6 = document.createElement("osdm_a_ct:NotesDetails");
                            element4 = null;
                            for (String string5 : Arrays.asList(string2.split("\\n"))) {
                                element4 = document.createElement("osdm_a_ct:NoteRow");
                                element4.appendChild(document.createTextNode(string5));
                                object6.appendChild(element4);
                            }
                            if (element4 == null) {
                                element4 = document.createElement("osdm_a_ct:NoteRow");
                                element4.appendChild(document.createTextNode(""));
                                object6.appendChild(element4);
                            }
                            object7.appendChild((Node)object6);
                            object8.appendChild((Node)object7);
                        }
                        element5.appendChild((Node)object8);
                    }
                }
                element3 = document.createElement("osdm_a_ct:CTName");
                element3.appendChild(document.createTextNode(((DesignObject)object).getLongName()));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_ct:CTType");
                element3.appendChild(document.createTextNode(((CollectionType)object).getType()));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_ct:CTMaxElements");
                element3.appendChild(document.createTextNode(Integer.valueOf(((CollectionType)object).getMaxElement()).toString()));
                element5.appendChild(element3);
                string3 = "";
                string2 = "";
                object8 = "";
                object7 = ((CollectionType)object).getDataType();
                if (object7 instanceof Domain) {
                    string2 = "DOM";
                    object6 = (Domain)object7;
                    object8 = ((DesignObject)object6).getName();
                    string3 = this.getSizePrecisionScale(object6, ((Domain)object6).getLogicalDatatype().getName());
                    object8 = ((String)object8).replace("Unknown", "");
                    object8 = ((String)object8).replace("unknown", "");
                    object8 = ((String)object8).replace("UNKNOWN", "");
                } else if (object7 instanceof LogicalDatatype) {
                    string2 = "LT";
                    object6 = (LogicalDatatype)object7;
                    string3 = this.getSizePrecisionScale(((CollectionType)object).getElementType(), ((DesignObject)object6).getName());
                } else if (object7 instanceof DistinctType) {
                    string2 = "DT";
                } else if (object7 instanceof StructuredType) {
                    string2 = "ST";
                } else if (object7 instanceof CollectionType) {
                    string2 = "CT";
                }
                element3 = document.createElement("osdm_a_ct:CTDataType");
                element3.appendChild(document.createTextNode(string3));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_ct:CTDataTypeKind");
                element3.appendChild(document.createTextNode(string2));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_ct:CTDomainName");
                element3.appendChild(document.createTextNode((String)object8));
                element5.appendChild(element3);
                boolean bl = true;
                element4 = null;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (reportTemplate.getType() == 0 || reportTemplate.isUseCTUsedInTables()) {
                    modelObject = design.getRelationalDesigns();
                    object5 = ((ModelObjectSet)modelObject).iterator();
                    while (object5.hasNext()) {
                        object4 = (RelationalDesign)object5.next();
                        iterator2 = ((RelationalDesign)object4).getTableSet().iterator();
                        while (iterator2.hasNext()) {
                            containerWithKeyObject = (Table)iterator2.next();
                            for (Column column : Arrays.asList(containerWithKeyObject.getElements())) {
                                if (column.getUse() != 4 || column.getCollectionType() != object) continue;
                                if (bl) {
                                    element4 = document.createElement("osdm_a_ct:TablesCollection");
                                    element5.appendChild(element4);
                                    bl = false;
                                }
                                Element element6 = document.createElement("osdm_a_ct:TableDetails");
                                element4.appendChild(element6);
                                boolean bl2 = false;
                                object3 = ((RelationalDesign)object4).getName();
                                for (String string6 : arrayList) {
                                    if (!string6.equals(object3)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (!bl2) {
                                    arrayList.add(object3);
                                }
                                boolean bl3 = false;
                                String string7 = ((Table)containerWithKeyObject).getLongName();
                                for (String string8 : arrayList2) {
                                    if (!string8.equals(string7)) continue;
                                    bl3 = true;
                                    break;
                                }
                                if (!bl3) {
                                    arrayList2.add(string7);
                                }
                                element3 = document.createElement("osdm_a_ct:ModelName");
                                element3.appendChild(document.createTextNode(bl2 ? "" : ((RelationalDesign)object4).getName()));
                                element6.appendChild(element3);
                                element3 = document.createElement("osdm_a_ct:TableName");
                                element3.appendChild(document.createTextNode(!bl3 ? ((Table)containerWithKeyObject).getLongName() : ""));
                                element6.appendChild(element3);
                                element3 = document.createElement("osdm_a_ct:ColumnName");
                                element3.appendChild(document.createTextNode(column.getName()));
                                element6.appendChild(element3);
                            }
                        }
                    }
                }
                if (reportTemplate.getType() != 0 && !reportTemplate.isUseCTUsedInEntities()) continue;
                bl = true;
                modelObject = design.getLogicalDesign();
                object5 = null;
                object4 = new ArrayList();
                iterator2 = ((LogicalDesign)modelObject).getEntitySet().iterator();
                while (iterator2.hasNext()) {
                    containerWithKeyObject = (Entity)iterator2.next();
                    for (Attribute attribute : Arrays.asList(containerWithKeyObject.getElements())) {
                        Object object9;
                        if (attribute.getUse() != 4 || attribute.getCollectionType() != object) continue;
                        if (bl) {
                            object5 = document.createElement("osdm_a_ct:EntitiesCollection");
                            element5.appendChild((Node)object5);
                            bl = false;
                        }
                        boolean bl4 = false;
                        String string9 = containerWithKeyObject.getName();
                        object3 = ((ArrayList)object4).iterator();
                        while (object3.hasNext()) {
                            object9 = (String)object3.next();
                            if (!((String)object9).equals(string9)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            arrayList2.add(string9);
                        }
                        object9 = document.createElement("osdm_a_ct:EntityDetails");
                        object5.appendChild((Node)object9);
                        element3 = document.createElement("osdm_a_ct:EntityName");
                        element3.appendChild(document.createTextNode(!bl4 ? containerWithKeyObject.getName() : ""));
                        object9.appendChild(element3);
                        element3 = document.createElement("osdm_a_ct:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object9.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during all collection type report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all collection type report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleStructuredTypeData(Design design, DesignPart designPart, Object object, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Element element;
            Object object2;
            Object object32;
            Iterator iterator;
            Object object4;
            Object object5;
            Object object11;
            Object object12;
            Object object13;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_s_st", "osdm_s_st:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_s_st:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_s_st:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                object13 = document.createElement("osdm_s_st:VersionComment");
                object12 = document.createElement("osdm_s_st:VersionCommentDetails");
                object11 = null;
                for (String object102 : Arrays.asList(string.split("\\n"))) {
                    object11 = document.createElement("osdm_s_st:VersionCommentRow");
                    object11.appendChild(document.createTextNode(object102));
                    object12.appendChild((Node)object11);
                }
                if (object11 == null) {
                    object11 = document.createElement("osdm_s_st:VersionCommentRow");
                    object11.appendChild(document.createTextNode(""));
                    object12.appendChild((Node)object11);
                }
                object13.appendChild((Node)object12);
                element2.appendChild((Node)object13);
            }
            element3 = document.createElement("osdm_s_st:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            object13 = (StructuredType)object;
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                object12 = "";
                object12 = ((ModelIDObject)object13).getComment() == null || ((ModelIDObject)object13).getComment().equals("") ? ((ModelIDObject)object13).getCommentInRDBMS() : ((ModelIDObject)object13).getComment();
                object11 = ((ModelIDObject)object13).getNotes();
                if (object12 != "" && object12 != null || object11 != "" && object11 != null) {
                    Element element4 = document.createElement("osdm_s_st:DescriptionNotes");
                    if (object12 != "" && object12 != null) {
                        Element element5 = document.createElement("osdm_s_st:Description");
                        object5 = document.createElement("osdm_s_st:DescriptionDetails");
                        object4 = null;
                        for (String string2 : Arrays.asList(((String)object12).split("\\n"))) {
                            object4 = document.createElement("osdm_s_st:DescriptionRow");
                            object4.appendChild(document.createTextNode(string2));
                            object5.appendChild((Node)object4);
                        }
                        if (object4 == null) {
                            object4 = document.createElement("osdm_s_st:DescriptionRow");
                            object4.appendChild(document.createTextNode(""));
                            object5.appendChild((Node)object4);
                        }
                        element5.appendChild((Node)object5);
                        element4.appendChild(element5);
                    }
                    if (object11 != "" && object11 != null) {
                        Element element6 = document.createElement("osdm_s_st:Notes");
                        object5 = document.createElement("osdm_s_st:NotesDetails");
                        object4 = null;
                        for (String string3 : Arrays.asList(((String)object11).split("\\n"))) {
                            object4 = document.createElement("osdm_s_st:NoteRow");
                            object4.appendChild(document.createTextNode(string3));
                            object5.appendChild((Node)object4);
                        }
                        if (object4 == null) {
                            object4 = document.createElement("osdm_s_st:NoteRow");
                            object4.appendChild(document.createTextNode(""));
                            object5.appendChild((Node)object4);
                        }
                        element6.appendChild((Node)object5);
                        element4.appendChild(element6);
                    }
                    element2.appendChild(element4);
                }
            }
            element3 = document.createElement("osdm_s_st:STName");
            element3.appendChild(document.createTextNode(((DesignObject)object13).getLongName()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_st:STSuperType");
            element3.appendChild(document.createTextNode(((StructuredType)object13).getParentType() != null ? ((StructuredType)object13).getParentType().getName() : ""));
            element2.appendChild(element3);
            if (reportTemplate.getType() == 0 || reportTemplate.isUseSTAttributes()) {
                int n = 0;
                object11 = null;
                for (TypeElement typeElement : Arrays.asList(((StructuredType)object13).getElements())) {
                    void var23_56;
                    if (n == 0) {
                        object11 = document.createElement("osdm_s_st:AttributesCollection");
                        element2.appendChild((Node)object11);
                    }
                    object5 = document.createElement("osdm_s_st:AttributeDetails");
                    object11.appendChild((Node)object5);
                    element3 = document.createElement("osdm_s_st:Sequence");
                    element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:AttributeName");
                    element3.appendChild(document.createTextNode(typeElement.getName()));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:M");
                    element3.appendChild(document.createTextNode(typeElement.isMandatory() ? "Y" : ""));
                    object5.appendChild(element3);
                    object4 = "";
                    String string4 = "";
                    iterator = "";
                    object32 = typeElement.getType();
                    if (object32 instanceof Domain) {
                        String string5 = "DOM";
                        object2 = typeElement.getDomain();
                        iterator = typeElement.getType().getName();
                        object4 = this.getSizePrecisionScale(object2, ((Domain)object2).getLogicalDatatype().getName());
                        iterator = ((String)((Object)iterator)).replace("Unknown", "");
                        iterator = ((String)((Object)iterator)).replace("unknown", "");
                        iterator = ((String)((Object)iterator)).replace("UNKNOWN", "");
                    } else if (object32 instanceof LogicalDatatype) {
                        String string6 = "LT";
                        object4 = this.getSizePrecisionScale(typeElement, typeElement.getType().getName());
                    } else if (object32 instanceof DistinctType) {
                        String string7 = "DT";
                    } else if (object32 instanceof StructuredType) {
                        String string8 = "ST";
                    } else if (object32 instanceof CollectionType) {
                        String string9 = "CT";
                    }
                    element3 = document.createElement("osdm_s_st:DataType");
                    element3.appendChild(document.createTextNode((String)object4));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:DataTypeKind");
                    element3.appendChild(document.createTextNode((String)var23_56));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:DomainName");
                    element3.appendChild(document.createTextNode((String)((Object)iterator)));
                    object5.appendChild(element3);
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseSTAttributesComments()) {
                int n = 0;
                object11 = null;
                for (TypeElement typeElement : ((StructuredType)object13).getAttributesList()) {
                    object5 = "";
                    object5 = typeElement.getComment() == null || typeElement.getComment().equals("") ? typeElement.getCommentInRDBMS() : typeElement.getComment();
                    object4 = typeElement.getNotes();
                    if ((object5 == null || ((String)object5).equals("")) && (object4 == null || ((String)object4).equals(""))) continue;
                    if (n == 0) {
                        object11 = document.createElement("osdm_s_st:AttributesCommentsCollection");
                        element2.appendChild((Node)object11);
                    }
                    Element element7 = document.createElement("osdm_s_st:AttributeCommentsDetails");
                    object11.appendChild(element7);
                    element3 = document.createElement("osdm_s_st:AttributeCommentsSequence");
                    element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                    element7.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:AttributeCommentsName");
                    element3.appendChild(document.createTextNode(typeElement.getName()));
                    element7.appendChild(element3);
                    iterator = document.createElement("osdm_s_st:AttributeDescription");
                    object32 = document.createElement("osdm_s_st:AttributeDescriptionDetails");
                    object2 = null;
                    for (String string10 : Arrays.asList(((String)object5).split("\\n"))) {
                        object2 = document.createElement("osdm_s_st:AttributeDescriptionRow");
                        object2.appendChild(document.createTextNode(string10));
                        object32.appendChild((Node)object2);
                    }
                    if (object2 == null) {
                        object2 = document.createElement("osdm_s_st:AttributeDescriptionRow");
                        object2.appendChild(document.createTextNode(""));
                        object32.appendChild((Node)object2);
                    }
                    iterator.appendChild((Node)object32);
                    element7.appendChild((Node)((Object)iterator));
                    Element element8 = document.createElement("osdm_s_st:AttributeNotes");
                    element = document.createElement("osdm_s_st:AttributeNotesDetails");
                    Element element9 = null;
                    for (String string11 : Arrays.asList(((String)object4).split("\\n"))) {
                        element9 = document.createElement("osdm_s_st:AttributeNoteRow");
                        element9.appendChild(document.createTextNode(string11));
                        element.appendChild(element9);
                    }
                    if (element9 == null) {
                        element9 = document.createElement("osdm_s_st:AttributeNoteRow");
                        element9.appendChild(document.createTextNode(""));
                        element.appendChild(element9);
                    }
                    element8.appendChild(element);
                    element7.appendChild(element8);
                    ++n;
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseSTMethods()) {
                int n = 0;
                object11 = null;
                for (Method method : ((StructuredType)object13).getMethodsList()) {
                    if (n == 0) {
                        object11 = document.createElement("osdm_s_st:MethodsCollection");
                        element2.appendChild((Node)object11);
                    }
                    object5 = document.createElement("osdm_s_st:MethodDetails");
                    object11.appendChild((Node)object5);
                    element3 = document.createElement("osdm_s_st:MethodSequence");
                    element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:MethodName");
                    element3.appendChild(document.createTextNode(method.getName()));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:MethodConstructor");
                    element3.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:MethodOverriding");
                    element3.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:MethodOverridenMethod");
                    element3.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                    object5.appendChild(element3);
                    element3 = document.createElement("osdm_s_st:MethodReturnValue");
                    element3.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                    object5.appendChild(element3);
                    int n2 = 0;
                    Object var23_60 = null;
                    for (Object object32 : method.getParameters()) {
                        void var23_61;
                        if (n2 == 0) {
                            Element element10 = document.createElement("osdm_s_st:MethodParametersCollection");
                            object5.appendChild(element10);
                        }
                        object2 = document.createElement("osdm_s_st:MethodParameterDetails");
                        var23_61.appendChild((Node)object2);
                        element3 = document.createElement("osdm_s_st:ParameterName");
                        element3.appendChild(document.createTextNode(((DesignObject)object32).getName()));
                        object2.appendChild(element3);
                        element3 = document.createElement("osdm_s_st:ParameterType");
                        element3.appendChild(document.createTextNode(((MethodParam)object32).getDataType()));
                        object2.appendChild(element3);
                        ++n2;
                    }
                    ++n;
                }
            }
            boolean bl = true;
            object11 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (reportTemplate.getType() == 0 || reportTemplate.isUseSTUsedInTables()) {
                object5 = design.getRelationalDesigns();
                object4 = ((ModelObjectSet)object5).iterator();
                while (object4.hasNext()) {
                    RelationalDesign relationalDesign = (RelationalDesign)object4.next();
                    iterator = relationalDesign.getTableSet().iterator();
                    while (iterator.hasNext()) {
                        object32 = (Table)iterator.next();
                        for (Column column : Arrays.asList(((ContainerObject)object32).getElements())) {
                            if (column.getUse() != 3 || column.getStructuredType() != object13) continue;
                            if (bl) {
                                object11 = document.createElement("osdm_s_st:TablesCollection");
                                element2.appendChild((Node)object11);
                                bl = false;
                            }
                            element = document.createElement("osdm_s_st:TableDetails");
                            object11.appendChild(element);
                            boolean bl2 = false;
                            String string12 = relationalDesign.getName();
                            for (String string13 : arrayList) {
                                if (!string13.equals(string12)) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                arrayList.add(string12);
                            }
                            boolean bl3 = false;
                            String string14 = ((Table)object32).getLongName();
                            for (String string15 : arrayList2) {
                                if (!string15.equals(string14)) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                arrayList2.add(string14);
                            }
                            element3 = document.createElement("osdm_s_st:ModelName");
                            element3.appendChild(document.createTextNode(bl2 ? "" : relationalDesign.getName()));
                            element.appendChild(element3);
                            element3 = document.createElement("osdm_s_st:TableName");
                            element3.appendChild(document.createTextNode(!bl3 ? ((Table)object32).getLongName() : ""));
                            element.appendChild(element3);
                            element3 = document.createElement("osdm_s_st:ColumnName");
                            element3.appendChild(document.createTextNode(column.getName()));
                            element.appendChild(element3);
                        }
                    }
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseSTUsedInEntities()) {
                bl = true;
                object5 = design.getLogicalDesign();
                object4 = null;
                ArrayList arrayList3 = new ArrayList();
                iterator = ((LogicalDesign)object5).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    object32 = (Entity)iterator.next();
                    for (Attribute attribute : Arrays.asList(((ContainerObject)object32).getElements())) {
                        Object object62;
                        if (attribute.getUse() != 3 || attribute.getStructuredType() != object13) continue;
                        if (bl) {
                            object4 = document.createElement("osdm_s_st:EntitiesCollection");
                            element2.appendChild((Node)object4);
                            bl = false;
                        }
                        boolean bl4 = false;
                        String string16 = ((DesignObject)object32).getName();
                        for (Object object62 : arrayList3) {
                            if (!((String)object62).equals(string16)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            arrayList2.add(string16);
                        }
                        object62 = document.createElement("osdm_s_st:EntityDetails");
                        object4.appendChild((Node)object62);
                        element3 = document.createElement("osdm_s_st:EntityName");
                        element3.appendChild(document.createTextNode(!bl4 ? ((DesignObject)object32).getName() : ""));
                        object62.appendChild(element3);
                        element3 = document.createElement("osdm_s_st:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object62.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during single structured type report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during single structured type report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherAllStructuredTypesData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object;
            Object object2;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_a_st", "osdm_a_st:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_a_st:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_a_st:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_a_st:VersionComment");
                object2 = document.createElement("osdm_a_st:VersionCommentDetails");
                object = null;
                for (String object3 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_a_st:VersionCommentRow");
                    object.appendChild(document.createTextNode(object3));
                    object2.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_a_st:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    object2.appendChild((Node)object);
                }
                element.appendChild((Node)object2);
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_a_st:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_a_st:STCollection");
            element2.appendChild(element);
            object2 = design.getDataTypesDesign().getStructuredTypeSet().iterator();
            while (object2.hasNext()) {
                Object object32;
                Element element4;
                Object object4;
                Object object52;
                Iterator iterator2;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                object = (StructuredType)object2.next();
                Element element5 = document.createElement("osdm_a_st:STDetails");
                element.appendChild(element5);
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                    String n = "";
                    n = ((ModelIDObject)object).getComment() == null || ((ModelIDObject)object).getComment().equals("") ? ((ModelIDObject)object).getCommentInRDBMS() : ((ModelIDObject)object).getComment();
                    object9 = ((ModelIDObject)object).getNotes();
                    if (n != "" && n != null || object9 != "" && object9 != null) {
                        object8 = document.createElement("osdm_a_st:DescriptionNotes");
                        if (n != "" && n != null) {
                            Element element6 = document.createElement("osdm_a_st:Description");
                            object7 = document.createElement("osdm_a_st:DescriptionDetails");
                            object6 = null;
                            for (String string2 : Arrays.asList(n.split("\\n"))) {
                                object6 = document.createElement("osdm_a_st:DescriptionRow");
                                object6.appendChild(document.createTextNode(string2));
                                object7.appendChild((Node)object6);
                            }
                            if (object6 == null) {
                                object6 = document.createElement("osdm_a_st:DescriptionRow");
                                object6.appendChild(document.createTextNode(""));
                                object7.appendChild((Node)object6);
                            }
                            element6.appendChild((Node)object7);
                            object8.appendChild(element6);
                        }
                        if (object9 != "" && object9 != null) {
                            Element element7 = document.createElement("osdm_a_st:Notes");
                            object7 = document.createElement("osdm_a_st:NotesDetails");
                            object6 = null;
                            for (String string3 : Arrays.asList(((String)object9).split("\\n"))) {
                                object6 = document.createElement("osdm_a_st:NoteRow");
                                object6.appendChild(document.createTextNode(string3));
                                object7.appendChild((Node)object6);
                            }
                            if (object6 == null) {
                                object6 = document.createElement("osdm_a_st:NoteRow");
                                object6.appendChild(document.createTextNode(""));
                                object7.appendChild((Node)object6);
                            }
                            element7.appendChild((Node)object7);
                            object8.appendChild(element7);
                        }
                        element5.appendChild((Node)object8);
                    }
                }
                element3 = document.createElement("osdm_a_st:STName");
                element3.appendChild(document.createTextNode(((DesignObject)object).getLongName()));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_st:STSuperType");
                element3.appendChild(document.createTextNode(((StructuredType)object).getParentType() != null ? ((StructuredType)object).getParentType().getName() : ""));
                element5.appendChild(element3);
                if (reportTemplate.getType() == 0 || reportTemplate.isUseSTAttributes()) {
                    int n = 0;
                    object9 = null;
                    for (TypeElement typeElement : Arrays.asList(((StructuredType)object).getElements())) {
                        void var25_51;
                        if (n == 0) {
                            object9 = document.createElement("osdm_a_st:AttributesCollection");
                            element5.appendChild((Node)object9);
                        }
                        object7 = document.createElement("osdm_a_st:AttributeDetails");
                        object9.appendChild((Node)object7);
                        element3 = document.createElement("osdm_a_st:Sequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:AttributeName");
                        element3.appendChild(document.createTextNode(typeElement.getName()));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:M");
                        element3.appendChild(document.createTextNode(typeElement.isMandatory() ? "Y" : ""));
                        object7.appendChild(element3);
                        object6 = "";
                        String string4 = "";
                        iterator2 = "";
                        object52 = typeElement.getType();
                        if (object52 instanceof Domain) {
                            String string5 = "DOM";
                            object4 = typeElement.getDomain();
                            iterator2 = typeElement.getType().getName();
                            object6 = this.getSizePrecisionScale(object4, ((Domain)object4).getLogicalDatatype().getName());
                            iterator2 = ((String)((Object)iterator2)).replace("Unknown", "");
                            iterator2 = ((String)((Object)iterator2)).replace("unknown", "");
                            iterator2 = ((String)((Object)iterator2)).replace("UNKNOWN", "");
                        } else if (object52 instanceof LogicalDatatype) {
                            String string6 = "LT";
                            object6 = this.getSizePrecisionScale(typeElement, typeElement.getType().getName());
                        } else if (object52 instanceof DistinctType) {
                            String string7 = "DT";
                        } else if (object52 instanceof StructuredType) {
                            String string8 = "ST";
                        } else if (object52 instanceof CollectionType) {
                            String string9 = "CT";
                        }
                        element3 = document.createElement("osdm_a_st:DataType");
                        element3.appendChild(document.createTextNode((String)object6));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:DataTypeKind");
                        element3.appendChild(document.createTextNode((String)var25_51));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:DomainName");
                        element3.appendChild(document.createTextNode((String)((Object)iterator2)));
                        object7.appendChild(element3);
                        ++n;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseSTAttributesComments()) {
                    int n = 0;
                    object9 = null;
                    for (TypeElement typeElement : ((StructuredType)object).getAttributesList()) {
                        object7 = "";
                        object7 = typeElement.getComment() == null || typeElement.getComment().equals("") ? typeElement.getCommentInRDBMS() : typeElement.getComment();
                        object6 = typeElement.getNotes();
                        if ((object7 == null || ((String)object7).equals("")) && (object6 == null || ((String)object6).equals(""))) continue;
                        if (n == 0) {
                            object9 = document.createElement("osdm_a_st:AttributesCommentsCollection");
                            element5.appendChild((Node)object9);
                        }
                        Element element8 = document.createElement("osdm_a_st:AttributeCommentsDetails");
                        object9.appendChild(element8);
                        element3 = document.createElement("osdm_a_st:AttributeCommentsSequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                        element8.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:AttributeCommentsName");
                        element3.appendChild(document.createTextNode(typeElement.getName()));
                        element8.appendChild(element3);
                        iterator2 = document.createElement("osdm_a_st:AttributeDescription");
                        object52 = document.createElement("osdm_a_st:AttributeDescriptionDetails");
                        object4 = null;
                        for (String string10 : Arrays.asList(((String)object7).split("\\n"))) {
                            object4 = document.createElement("osdm_a_st:AttributeDescriptionRow");
                            object4.appendChild(document.createTextNode(string10));
                            object52.appendChild((Node)object4);
                        }
                        if (object4 == null) {
                            object4 = document.createElement("osdm_a_st:AttributeDescriptionRow");
                            object4.appendChild(document.createTextNode(""));
                            object52.appendChild((Node)object4);
                        }
                        iterator2.appendChild((Node)object52);
                        element8.appendChild((Node)((Object)iterator2));
                        Element element9 = document.createElement("osdm_a_st:AttributeNotes");
                        element4 = document.createElement("osdm_a_st:AttributeNotesDetails");
                        Element element10 = null;
                        for (String string11 : Arrays.asList(((String)object6).split("\\n"))) {
                            element10 = document.createElement("osdm_a_st:AttributeNoteRow");
                            element10.appendChild(document.createTextNode(string11));
                            element4.appendChild(element10);
                        }
                        if (element10 == null) {
                            element10 = document.createElement("osdm_a_st:AttributeNoteRow");
                            element10.appendChild(document.createTextNode(""));
                            element4.appendChild(element10);
                        }
                        element9.appendChild(element4);
                        element8.appendChild(element9);
                        ++n;
                    }
                }
                if (reportTemplate.getType() == 0 || reportTemplate.isUseSTMethods()) {
                    int n = 0;
                    object9 = null;
                    for (Method method : ((StructuredType)object).getMethodsList()) {
                        if (n == 0) {
                            object9 = document.createElement("osdm_a_st:MethodsCollection");
                            element5.appendChild((Node)object9);
                        }
                        object7 = document.createElement("osdm_a_st:MethodDetails");
                        object9.appendChild((Node)object7);
                        element3 = document.createElement("osdm_a_st:MethodSequence");
                        element3.appendChild(document.createTextNode(Integer.valueOf(n + 1).toString()));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:MethodName");
                        element3.appendChild(document.createTextNode(method.getName()));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:MethodConstructor");
                        element3.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:MethodOverriding");
                        element3.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:MethodOverridenMethod");
                        element3.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                        object7.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:MethodReturnValue");
                        element3.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                        object7.appendChild(element3);
                        int n2 = 0;
                        Object var25_53 = null;
                        for (Object object52 : method.getParameters()) {
                            void var25_54;
                            if (n2 == 0) {
                                Element element11 = document.createElement("osdm_a_st:MethodParametersCollection");
                                object7.appendChild(element11);
                            }
                            object4 = document.createElement("osdm_a_st:MethodParameterDetails");
                            var25_54.appendChild((Node)object4);
                            element3 = document.createElement("osdm_a_st:ParameterName");
                            element3.appendChild(document.createTextNode(((DesignObject)object52).getName()));
                            object4.appendChild(element3);
                            element3 = document.createElement("osdm_a_st:ParameterType");
                            element3.appendChild(document.createTextNode(((MethodParam)object52).getDataType()));
                            object4.appendChild(element3);
                            ++n2;
                        }
                        ++n;
                    }
                }
                boolean n = true;
                object9 = null;
                object8 = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (reportTemplate.getType() == 0 || reportTemplate.isUseSTUsedInTables()) {
                    object7 = design.getRelationalDesigns();
                    object6 = ((ModelObjectSet)object7).iterator();
                    while (object6.hasNext()) {
                        RelationalDesign relationalDesign = (RelationalDesign)object6.next();
                        iterator2 = relationalDesign.getTableSet().iterator();
                        while (iterator2.hasNext()) {
                            object52 = (Table)iterator2.next();
                            for (Column column : Arrays.asList(((ContainerObject)object52).getElements())) {
                                if (column.getUse() != 3 || column.getStructuredType() != object) continue;
                                if (n) {
                                    object9 = document.createElement("osdm_a_st:TablesCollection");
                                    element5.appendChild((Node)object9);
                                    n = false;
                                }
                                element4 = document.createElement("osdm_a_st:TableDetails");
                                object9.appendChild(element4);
                                boolean bl = false;
                                String string12 = relationalDesign.getName();
                                object32 = ((ArrayList)object8).iterator();
                                while (object32.hasNext()) {
                                    String string13 = (String)object32.next();
                                    if (!string13.equals(string12)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!bl) {
                                    ((ArrayList)object8).add(string12);
                                }
                                boolean bl2 = false;
                                String string14 = ((Table)object52).getLongName();
                                for (String string15 : arrayList) {
                                    if (!string15.equals(string14)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (!bl2) {
                                    arrayList.add(string14);
                                }
                                element3 = document.createElement("osdm_a_st:ModelName");
                                element3.appendChild(document.createTextNode(bl ? "" : relationalDesign.getName()));
                                element4.appendChild(element3);
                                element3 = document.createElement("osdm_a_st:TableName");
                                element3.appendChild(document.createTextNode(!bl2 ? ((Table)object52).getLongName() : ""));
                                element4.appendChild(element3);
                                element3 = document.createElement("osdm_a_st:ColumnName");
                                element3.appendChild(document.createTextNode(column.getName()));
                                element4.appendChild(element3);
                            }
                        }
                    }
                }
                if (reportTemplate.getType() != 0 && !reportTemplate.isUseSTUsedInEntities()) continue;
                n = true;
                object7 = design.getLogicalDesign();
                object6 = null;
                ArrayList arrayList2 = new ArrayList();
                iterator2 = ((LogicalDesign)object7).getEntitySet().iterator();
                while (iterator2.hasNext()) {
                    object52 = (Entity)iterator2.next();
                    for (Attribute attribute : Arrays.asList(((ContainerObject)object52).getElements())) {
                        if (attribute.getUse() != 3 || attribute.getStructuredType() != object) continue;
                        if (n) {
                            object6 = document.createElement("osdm_a_st:EntitiesCollection");
                            element5.appendChild((Node)object6);
                            n = false;
                        }
                        boolean bl = false;
                        String string16 = ((DesignObject)object52).getName();
                        for (Object object32 : arrayList2) {
                            if (!((String)object32).equals(string16)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            arrayList.add(string16);
                        }
                        object32 = document.createElement("osdm_a_st:EntityDetails");
                        object6.appendChild((Node)object32);
                        element3 = document.createElement("osdm_a_st:EntityName");
                        element3.appendChild(document.createTextNode(!bl ? ((DesignObject)object52).getName() : ""));
                        object32.appendChild(element3);
                        element3 = document.createElement("osdm_a_st:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object32.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during all structured types report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all structured types report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private Document gatherSingleDistinctTypeData(Design design, DesignPart designPart, Object object, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object2;
            Object object3;
            ContainerWithKeyObject containerWithKeyObject;
            Iterator iterator;
            Object object4;
            Object object5;
            ModelObject modelObject;
            Object object6;
            Element element;
            Object object8;
            Object object9;
            Object object10;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_s_dt", "osdm_s_dt:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_s_dt:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_s_dt:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator2 = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                object10 = document.createElement("osdm_s_dt:VersionComment");
                object9 = document.createElement("osdm_s_dt:VersionCommentDetails");
                object8 = null;
                for (String object11 : Arrays.asList(string.split("\\n"))) {
                    object8 = document.createElement("osdm_s_dt:VersionCommentRow");
                    object8.appendChild(document.createTextNode(object11));
                    object9.appendChild((Node)object8);
                }
                if (object8 == null) {
                    object8 = document.createElement("osdm_s_dt:VersionCommentRow");
                    object8.appendChild(document.createTextNode(""));
                    object9.appendChild((Node)object8);
                }
                object10.appendChild((Node)object9);
                element2.appendChild((Node)object10);
            }
            element3 = document.createElement("osdm_s_dt:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            object10 = (DistinctType)object;
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                object9 = "";
                object9 = ((ModelIDObject)object10).getComment() == null || ((ModelIDObject)object10).getComment().equals("") ? ((ModelIDObject)object10).getCommentInRDBMS() : ((ModelIDObject)object10).getComment();
                object8 = ((ModelIDObject)object10).getNotes();
                if (object9 != "" && object9 != null || object8 != "" && object8 != null) {
                    Element element4;
                    Element n2 = document.createElement("osdm_s_dt:DescriptionNotes");
                    if (object9 != "" && object9 != null) {
                        element4 = document.createElement("osdm_s_dt:Description");
                        element = document.createElement("osdm_s_dt:DescriptionDetails");
                        object6 = null;
                        for (String string2 : Arrays.asList(((String)object9).split("\\n"))) {
                            object6 = document.createElement("osdm_s_dt:DescriptionRow");
                            object6.appendChild(document.createTextNode(string2));
                            element.appendChild((Node)object6);
                        }
                        if (object6 == null) {
                            object6 = document.createElement("osdm_s_dt:DescriptionRow");
                            object6.appendChild(document.createTextNode(""));
                            element.appendChild((Node)object6);
                        }
                        element4.appendChild(element);
                        n2.appendChild(element4);
                    }
                    if (object8 != "" && object8 != null) {
                        element4 = document.createElement("osdm_s_dt:Notes");
                        element = document.createElement("osdm_s_dt:NotesDetails");
                        object6 = null;
                        for (String string3 : Arrays.asList(((String)object8).split("\\n"))) {
                            object6 = document.createElement("osdm_s_dt:NoteRow");
                            object6.appendChild(document.createTextNode(string3));
                            element.appendChild((Node)object6);
                        }
                        if (object6 == null) {
                            object6 = document.createElement("osdm_s_dt:NoteRow");
                            object6.appendChild(document.createTextNode(""));
                            element.appendChild((Node)object6);
                        }
                        element4.appendChild(element);
                        n2.appendChild(element4);
                    }
                    element2.appendChild(n2);
                }
            }
            element3 = document.createElement("osdm_s_dt:DTName");
            element3.appendChild(document.createTextNode(((DesignObject)object10).getLongName()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_dt:DTLogicalType");
            element3.appendChild(document.createTextNode(((DistinctType)object10).getLogicalDataType().getName()));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_dt:DTSize");
            object9 = ((DistinctType)object10).getSize();
            if (object9 != null) {
                element3.appendChild(document.createTextNode(!((String)object9).equals("") && !((String)object9).equals("0") ? ((DistinctType)object10).getSize() : ""));
            } else {
                element3.appendChild(document.createTextNode(""));
            }
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_dt:DTPrecision");
            int n = ((DistinctType)object10).getPrecision();
            element3.appendChild(document.createTextNode(n > 0 ? Integer.valueOf(((DistinctType)object10).getPrecision()).toString() : ""));
            element2.appendChild(element3);
            element3 = document.createElement("osdm_s_dt:DTScale");
            int n2 = ((DistinctType)object10).getScale();
            element3.appendChild(document.createTextNode(n2 > 0 ? Integer.valueOf(((DistinctType)object10).getScale()).toString() : ""));
            element2.appendChild(element3);
            boolean bl = true;
            element = null;
            object6 = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDTUsedInTables()) {
                modelObject = design.getRelationalDesigns();
                object5 = ((ModelObjectSet)modelObject).iterator();
                while (object5.hasNext()) {
                    object4 = (RelationalDesign)object5.next();
                    iterator = ((RelationalDesign)object4).getTableSet().iterator();
                    while (iterator.hasNext()) {
                        containerWithKeyObject = (Table)iterator.next();
                        for (Column column : Arrays.asList(containerWithKeyObject.getElements())) {
                            if (column.getUse() != 2 || column.getDistinctType() != object10) continue;
                            if (bl) {
                                element = document.createElement("osdm_s_dt:TablesCollection");
                                element2.appendChild(element);
                                bl = false;
                            }
                            Element element5 = document.createElement("osdm_s_dt:TableDetails");
                            element.appendChild(element5);
                            boolean bl2 = false;
                            object3 = ((RelationalDesign)object4).getName();
                            object2 = ((ArrayList)object6).iterator();
                            while (object2.hasNext()) {
                                String string4 = (String)object2.next();
                                if (!string4.equals(object3)) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                ((ArrayList)object6).add(object3);
                            }
                            boolean bl3 = false;
                            String string5 = ((Table)containerWithKeyObject).getLongName();
                            for (String string6 : arrayList) {
                                if (!string6.equals(string5)) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                arrayList.add(string5);
                            }
                            element3 = document.createElement("osdm_s_dt:ModelName");
                            element3.appendChild(document.createTextNode(bl2 ? "" : ((RelationalDesign)object4).getName()));
                            element5.appendChild(element3);
                            element3 = document.createElement("osdm_s_dt:TableName");
                            element3.appendChild(document.createTextNode(!bl3 ? ((Table)containerWithKeyObject).getLongName() : ""));
                            element5.appendChild(element3);
                            element3 = document.createElement("osdm_s_dt:ColumnName");
                            element3.appendChild(document.createTextNode(column.getName()));
                            element5.appendChild(element3);
                        }
                    }
                }
            }
            if (reportTemplate.getType() == 0 || reportTemplate.isUseDTUsedInEntities()) {
                bl = true;
                modelObject = design.getLogicalDesign();
                object5 = null;
                object4 = new ArrayList();
                iterator = ((LogicalDesign)modelObject).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    containerWithKeyObject = (Entity)iterator.next();
                    for (Attribute attribute : Arrays.asList(containerWithKeyObject.getElements())) {
                        if (attribute.getUse() != 2 || attribute.getDistinctType() != object10) continue;
                        if (bl) {
                            object5 = document.createElement("osdm_s_dt:EntitiesCollection");
                            element2.appendChild((Node)object5);
                            bl = false;
                        }
                        boolean bl4 = false;
                        String string7 = containerWithKeyObject.getName();
                        object3 = ((ArrayList)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            if (!((String)object2).equals(string7)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            arrayList.add(string7);
                        }
                        object2 = document.createElement("osdm_s_dt:EntityDetails");
                        object5.appendChild((Node)object2);
                        element3 = document.createElement("osdm_s_dt:EntityName");
                        element3.appendChild(document.createTextNode(!bl4 ? containerWithKeyObject.getName() : ""));
                        object2.appendChild(element3);
                        element3 = document.createElement("osdm_s_dt:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object2.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during single distinct type report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during single distinct type report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private Document gatherAllDistinctTypesData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object;
            Object object2;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_a_dt", "osdm_a_dt:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_a_dt:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_a_dt:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_a_dt:VersionComment");
                object2 = document.createElement("osdm_a_dt:VersionCommentDetails");
                object = null;
                for (String object3 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_a_dt:VersionCommentRow");
                    object.appendChild(document.createTextNode(object3));
                    object2.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_a_dt:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    object2.appendChild((Node)object);
                }
                element.appendChild((Node)object2);
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_a_dt:ModelName");
            element3.appendChild(document.createTextNode("Data Types"));
            element2.appendChild(element3);
            element = document.createElement("osdm_a_dt:DTCollection");
            element2.appendChild(element);
            object2 = design.getDataTypesDesign().getDistinctTypeSet().iterator();
            while (object2.hasNext()) {
                Object object3;
                Object object4;
                ContainerWithKeyObject containerWithKeyObject;
                Iterator iterator2;
                Object object5;
                Object object6;
                ModelObject modelObject;
                Object object7;
                Element element4;
                String string2;
                object = (DistinctType)object2.next();
                Element element5 = document.createElement("osdm_a_dt:DTDetails");
                element.appendChild(element5);
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDescriptionInfo()) {
                    string2 = "";
                    string2 = ((ModelIDObject)object).getComment() == null || ((ModelIDObject)object).getComment().equals("") ? ((ModelIDObject)object).getCommentInRDBMS() : ((ModelIDObject)object).getComment();
                    String string3 = ((ModelIDObject)object).getNotes();
                    if (string2 != "" && string2 != null || string3 != "" && string3 != null) {
                        Element element6;
                        Element element7 = document.createElement("osdm_a_dt:DescriptionNotes");
                        if (string2 != "" && string2 != null) {
                            element6 = document.createElement("osdm_a_dt:Description");
                            element4 = document.createElement("osdm_a_dt:DescriptionDetails");
                            object7 = null;
                            for (String string4 : Arrays.asList(string2.split("\\n"))) {
                                object7 = document.createElement("osdm_a_dt:DescriptionRow");
                                object7.appendChild(document.createTextNode(string4));
                                element4.appendChild((Node)object7);
                            }
                            if (object7 == null) {
                                object7 = document.createElement("osdm_a_dt:DescriptionRow");
                                object7.appendChild(document.createTextNode(""));
                                element4.appendChild((Node)object7);
                            }
                            element6.appendChild(element4);
                            element7.appendChild(element6);
                        }
                        if (string3 != "" && string3 != null) {
                            element6 = document.createElement("osdm_a_dt:Notes");
                            element4 = document.createElement("osdm_a_dt:NotesDetails");
                            object7 = null;
                            for (String string5 : Arrays.asList(string3.split("\\n"))) {
                                object7 = document.createElement("osdm_a_dt:NoteRow");
                                object7.appendChild(document.createTextNode(string5));
                                element4.appendChild((Node)object7);
                            }
                            if (object7 == null) {
                                object7 = document.createElement("osdm_a_dt:NoteRow");
                                object7.appendChild(document.createTextNode(""));
                                element4.appendChild((Node)object7);
                            }
                            element6.appendChild(element4);
                            element7.appendChild(element6);
                        }
                        element5.appendChild(element7);
                    }
                }
                element3 = document.createElement("osdm_a_dt:DTName");
                element3.appendChild(document.createTextNode(((DesignObject)object).getLongName()));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_dt:DTLogicalType");
                element3.appendChild(document.createTextNode(((DistinctType)object).getLogicalDataType().getName()));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_dt:DTSize");
                string2 = ((DistinctType)object).getSize();
                if (string2 != null) {
                    element3.appendChild(document.createTextNode(!string2.equals("") && !string2.equals("0") ? ((DistinctType)object).getSize() : ""));
                } else {
                    element3.appendChild(document.createTextNode(""));
                }
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_dt:DTPrecision");
                int n = ((DistinctType)object).getPrecision();
                element3.appendChild(document.createTextNode(n > 0 ? Integer.valueOf(((DistinctType)object).getPrecision()).toString() : ""));
                element5.appendChild(element3);
                element3 = document.createElement("osdm_a_dt:DTScale");
                int n2 = ((DistinctType)object).getScale();
                element3.appendChild(document.createTextNode(n2 > 0 ? Integer.valueOf(((DistinctType)object).getScale()).toString() : ""));
                element5.appendChild(element3);
                boolean bl = true;
                element4 = null;
                object7 = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (reportTemplate.getType() == 0 || reportTemplate.isUseDTUsedInTables()) {
                    modelObject = design.getRelationalDesigns();
                    object6 = ((ModelObjectSet)modelObject).iterator();
                    while (object6.hasNext()) {
                        object5 = (RelationalDesign)object6.next();
                        iterator2 = ((RelationalDesign)object5).getTableSet().iterator();
                        while (iterator2.hasNext()) {
                            containerWithKeyObject = (Table)iterator2.next();
                            for (Column column : Arrays.asList(containerWithKeyObject.getElements())) {
                                if (column.getUse() != 2 || column.getDistinctType() != object) continue;
                                if (bl) {
                                    element4 = document.createElement("osdm_a_dt:TablesCollection");
                                    element5.appendChild(element4);
                                    bl = false;
                                }
                                Element element8 = document.createElement("osdm_a_dt:TableDetails");
                                element4.appendChild(element8);
                                boolean bl2 = false;
                                object4 = ((RelationalDesign)object5).getName();
                                object3 = ((ArrayList)object7).iterator();
                                while (object3.hasNext()) {
                                    String string6 = (String)object3.next();
                                    if (!string6.equals(object4)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (!bl2) {
                                    ((ArrayList)object7).add(object4);
                                }
                                boolean bl3 = false;
                                String string7 = ((Table)containerWithKeyObject).getLongName();
                                for (String string8 : arrayList) {
                                    if (!string8.equals(string7)) continue;
                                    bl3 = true;
                                    break;
                                }
                                if (!bl3) {
                                    arrayList.add(string7);
                                }
                                element3 = document.createElement("osdm_a_dt:ModelName");
                                element3.appendChild(document.createTextNode(bl2 ? "" : ((RelationalDesign)object5).getName()));
                                element8.appendChild(element3);
                                element3 = document.createElement("osdm_a_dt:TableName");
                                element3.appendChild(document.createTextNode(!bl3 ? ((Table)containerWithKeyObject).getLongName() : ""));
                                element8.appendChild(element3);
                                element3 = document.createElement("osdm_a_dt:ColumnName");
                                element3.appendChild(document.createTextNode(column.getName()));
                                element8.appendChild(element3);
                            }
                        }
                    }
                }
                if (reportTemplate.getType() != 0 && !reportTemplate.isUseDTUsedInEntities()) continue;
                bl = true;
                modelObject = design.getLogicalDesign();
                object6 = null;
                object5 = new ArrayList();
                iterator2 = ((LogicalDesign)modelObject).getEntitySet().iterator();
                while (iterator2.hasNext()) {
                    containerWithKeyObject = (Entity)iterator2.next();
                    for (Attribute attribute : Arrays.asList(containerWithKeyObject.getElements())) {
                        if (attribute.getUse() != 2 || attribute.getDistinctType() != object) continue;
                        if (bl) {
                            object6 = document.createElement("osdm_a_dt:EntitiesCollection");
                            element5.appendChild((Node)object6);
                            bl = false;
                        }
                        boolean bl4 = false;
                        String string9 = containerWithKeyObject.getName();
                        object4 = ((ArrayList)object5).iterator();
                        while (object4.hasNext()) {
                            object3 = (String)object4.next();
                            if (!((String)object3).equals(string9)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) {
                            arrayList.add(string9);
                        }
                        object3 = document.createElement("osdm_a_dt:EntityDetails");
                        object6.appendChild((Node)object3);
                        element3 = document.createElement("osdm_a_dt:EntityName");
                        element3.appendChild(document.createTextNode(!bl4 ? containerWithKeyObject.getName() : ""));
                        object3.appendChild(element3);
                        element3 = document.createElement("osdm_a_dt:AttributeName");
                        element3.appendChild(document.createTextNode(attribute.getName()));
                        object3.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during all distinct types report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all distinct types report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherChangeRequestsData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Object object;
            Object object2;
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_cr", "osdm_cr:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_cr:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_cr:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_cr:VersionComment");
                object2 = document.createElement("osdm_cr:VersionCommentDetails");
                object = null;
                for (String object3 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_cr:VersionCommentRow");
                    object.appendChild(document.createTextNode(object3));
                    object2.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_cr:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    object2.appendChild((Node)object);
                }
                element.appendChild((Node)object2);
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_cr:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_cr:CRCollection");
            element2.appendChild(element);
            object2 = design.getChangeRequestSet().iterator();
            while (object2.hasNext()) {
                Object object3;
                Object object4;
                Object object5;
                object = (ChangeRequest)object2.next();
                Element element4 = document.createElement("osdm_cr:CRDetails");
                element.appendChild(element4);
                element3 = document.createElement("osdm_cr:CRName");
                element3.appendChild(document.createTextNode(((DesignObject)object).getLongName()));
                element4.appendChild(element3);
                String string2 = ((ModelIDObject)object).getComment();
                if (string2 != "" && string2 != null) {
                    object5 = document.createElement("osdm_cr:CRComment");
                    object4 = document.createElement("osdm_cr:CRCommentDetails");
                    object3 = null;
                    for (String string3 : Arrays.asList(((ModelIDObject)object).getComment().split("\\n"))) {
                        object3 = document.createElement("osdm_cr:CRCommentRow");
                        object3.appendChild(document.createTextNode(string3));
                        object4.appendChild((Node)object3);
                    }
                    if (object3 == null) {
                        object3 = document.createElement("osdm_cr:CRCommentRow");
                        object3.appendChild(document.createTextNode(""));
                        object4.appendChild((Node)object3);
                    }
                    object5.appendChild((Node)object4);
                    element4.appendChild((Node)object5);
                }
                if ((object5 = ((ModelIDObject)object).getNotes()) != "" && object5 != null) {
                    void var23_28;
                    object4 = document.createElement("osdm_cr:CRNotes");
                    object3 = document.createElement("osdm_cr:CRNotesDetails");
                    Object var23_27 = null;
                    for (String string4 : Arrays.asList(((String)object5).split("\\n"))) {
                        Element element5 = document.createElement("osdm_cr:CRNoteRow");
                        element5.appendChild(document.createTextNode(string4));
                        object3.appendChild(element5);
                    }
                    if (var23_28 == null) {
                        Element element6 = document.createElement("osdm_cr:CRNoteRow");
                        element6.appendChild(document.createTextNode(""));
                        object3.appendChild(element6);
                    }
                    object4.appendChild((Node)object3);
                    element4.appendChild((Node)object4);
                }
                if ((object4 = ((ChangeRequest)object).getReason()) != "" && object4 != null) {
                    void var24_38;
                    object3 = document.createElement("osdm_cr:CRReason");
                    Element element7 = document.createElement("osdm_cr:CRReasonDetails");
                    Object var24_37 = null;
                    for (String string5 : Arrays.asList(((String)object4).split("\\n"))) {
                        Element element8 = document.createElement("osdm_cr:CRReasonRow");
                        element8.appendChild(document.createTextNode(string5));
                        element7.appendChild(element8);
                    }
                    if (var24_38 == null) {
                        Element element9 = document.createElement("osdm_cr:CRReasonRow");
                        element9.appendChild(document.createTextNode(""));
                        element7.appendChild(element9);
                    }
                    object3.appendChild(element7);
                    element4.appendChild((Node)object3);
                }
                element3 = document.createElement("osdm_cr:CRStatus");
                element3.appendChild(document.createTextNode(((ChangeRequest)object).getStatus()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_cr:CRCompleted");
                element3.appendChild(document.createTextNode(((ChangeRequest)object).isCompleted() ? "Y" : ""));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_cr:CRRequestDate");
                element3.appendChild(document.createTextNode(((ChangeRequest)object).getRequestDate()));
                element4.appendChild(element3);
                element3 = document.createElement("osdm_cr:CRCompletionDate");
                element3.appendChild(document.createTextNode(((ChangeRequest)object).getCompletionDate()));
                element4.appendChild(element3);
                object3 = ((ChangeRequest)object).getImplDescription();
                if (object3 != "" && object3 != null) {
                    void var25_47;
                    Element element10 = document.createElement("osdm_cr:CRImplementationNote");
                    Element element11 = document.createElement("osdm_cr:CRImplementationNoteDetails");
                    Object var25_46 = null;
                    for (String string6 : Arrays.asList(((String)object3).split("\\n"))) {
                        Element element12 = document.createElement("osdm_cr:CRImplementationNoteRow");
                        element12.appendChild(document.createTextNode(string6));
                        element11.appendChild(element12);
                    }
                    if (var25_47 == null) {
                        Element element13 = document.createElement("osdm_cr:CRReasonRow");
                        element13.appendChild(document.createTextNode(""));
                        element11.appendChild(element13);
                    }
                    element10.appendChild(element11);
                    element4.appendChild(element10);
                }
                if (reportTemplate.getType() != 0 && !reportTemplate.isUseCRImpactedObjects()) continue;
                Element element14 = document.createElement("osdm_cr:CRUsedInObjectCollection");
                element4.appendChild(element14);
                for (DesignObject designObject : ((ChangeRequest)object).getObjects()) {
                    Element element15 = document.createElement("osdm_cr:CRUsedInObjectDetails");
                    element14.appendChild(element15);
                    element3 = document.createElement("osdm_cr:ModelName");
                    element3.appendChild(document.createTextNode(designObject.getDesignPart().getName()));
                    element15.appendChild(element3);
                    element3 = document.createElement("osdm_cr:ObjectName");
                    element3.appendChild(document.createTextNode(designObject.getObjectTypeName()));
                    element15.appendChild(element3);
                    element3 = document.createElement("osdm_cr:TypeName");
                    element3.appendChild(document.createTextNode(designObject.getName()));
                    element15.appendChild(element3);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during change requests report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all change requests report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private Document gatherMeasurementsData(Design design, DesignPart designPart, ReportTemplate reportTemplate) {
        Document document = null;
        try {
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element2 = document.createElementNS("osdm_mr", "osdm_mr:root");
            document.appendChild(element2);
            Element element3 = document.createElement("osdm_mr:DesignName");
            element3.appendChild(document.createTextNode(design.getName()));
            element2.appendChild(element3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            Date date = new Date();
            element3 = document.createElement("osdm_mr:VersionDate");
            element3.appendChild(document.createTextNode(simpleDateFormat.format(date)));
            element2.appendChild(element3);
            Iterator<String> iterator = null;
            String string = design.getComment();
            if (string != "" && string != null) {
                element = document.createElement("osdm_mr:VersionComment");
                Element element4 = document.createElement("osdm_mr:VersionCommentDetails");
                Object object = null;
                for (String object2 : Arrays.asList(string.split("\\n"))) {
                    object = document.createElement("osdm_mr:VersionCommentRow");
                    object.appendChild(document.createTextNode(object2));
                    element4.appendChild((Node)object);
                }
                if (object == null) {
                    object = document.createElement("osdm_mr:VersionCommentRow");
                    object.appendChild(document.createTextNode(""));
                    element4.appendChild((Node)object);
                }
                element.appendChild(element4);
                element2.appendChild(element);
            }
            element3 = document.createElement("osdm_mr:ModelName");
            element3.appendChild(document.createTextNode(designPart.getName()));
            element2.appendChild(element3);
            element = document.createElement("osdm_mr:MCollection");
            element2.appendChild(element);
            for (Object object : design.getStorableDesignParts()) {
                List list = ((DesignPart)object).getObjectsWithMeasurements();
                if (list.size() <= 0) continue;
                for (DesignObject designObject : list) {
                    for (Measurement measurement : designObject.getMeasurements()) {
                        Element element4 = document.createElement("osdm_mr:MDetails");
                        element.appendChild(element4);
                        element3 = document.createElement("osdm_mr:MName");
                        element3.appendChild(document.createTextNode(measurement.getLongName()));
                        element4.appendChild(element3);
                        Element element5 = document.createElement("osdm_mr:MComment");
                        Element element6 = document.createElement("osdm_mr:MCommentDetails");
                        Element element7 = null;
                        for (String string2 : Arrays.asList(measurement.getComment().split("\\n"))) {
                            element7 = document.createElement("osdm_mr:MCommentRow");
                            element7.appendChild(document.createTextNode(string2));
                            element6.appendChild(element7);
                        }
                        if (element7 == null) {
                            element7 = document.createElement("osdm_mr:MCommentRow");
                            element7.appendChild(document.createTextNode(""));
                            element6.appendChild(element7);
                        }
                        element5.appendChild(element6);
                        element4.appendChild(element5);
                        Element element8 = document.createElement("osdm_mr:MNotes");
                        Element element9 = document.createElement("osdm_mr:MNotesDetails");
                        Element element10 = null;
                        for (String string3 : Arrays.asList(measurement.getNotes().split("\\n"))) {
                            element10 = document.createElement("osdm_mr:MNoteRow");
                            element10.appendChild(document.createTextNode(string3));
                            element9.appendChild(element10);
                        }
                        if (element10 == null) {
                            element10 = document.createElement("osdm_mr:MNoteRow");
                            element10.appendChild(document.createTextNode(""));
                            element9.appendChild(element10);
                        }
                        element8.appendChild(element9);
                        element4.appendChild(element8);
                        element3 = document.createElement("osdm_mr:MValue");
                        element3.appendChild(document.createTextNode(measurement.getValue()));
                        element4.appendChild(element3);
                        element3 = document.createElement("osdm_mr:MUnit");
                        element3.appendChild(document.createTextNode(measurement.getUnit()));
                        element4.appendChild(element3);
                        element3 = document.createElement("osdm_mr:MType");
                        element3.appendChild(document.createTextNode(measurement.getType()));
                        element4.appendChild(element3);
                        element3 = document.createElement("osdm_mr:MCreationDate");
                        element3.appendChild(document.createTextNode(measurement.getCreationDate()));
                        element4.appendChild(element3);
                        element3 = document.createElement("osdm_mr:MEffectiveDate");
                        element3.appendChild(document.createTextNode(measurement.getEffectiveDate()));
                        element4.appendChild(element3);
                        if (reportTemplate.getType() != 0 && !reportTemplate.isUseMRImpactedObjects()) continue;
                        Element element11 = document.createElement("osdm_mr:MUsedInObjectCollection");
                        element4.appendChild(element11);
                        Element element12 = document.createElement("osdm_mr:MUsedInObjectDetails");
                        element11.appendChild(element12);
                        element3 = document.createElement("osdm_mr:ModelName");
                        element3.appendChild(document.createTextNode(designObject.getDesignPart().getName()));
                        element12.appendChild(element3);
                        element3 = document.createElement("osdm_mr:ObjectName");
                        element3.appendChild(document.createTextNode(designObject.getObjectTypeName()));
                        element12.appendChild(element3);
                        element3 = document.createElement("osdm_mr:TypeName");
                        element3.appendChild(document.createTextNode(designObject.getName()));
                        element12.appendChild(element3);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Exception during measurements report generation " + parserConfigurationException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception during all measurements report generation " + exception.getMessage(), exception);
            return null;
        }
        return document;
    }

    private long getLastUsedFileIdx(String string) {
        long l = 0L;
        long l2 = 0L;
        try {
            File[] fileArray;
            File file = new File(this.reportsPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((fileArray = file.listFiles()) == null) {
                fileArray = new File(file.getParent()).listFiles();
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string2 = file2.getName();
                if (!file2.isFile() || !string2.startsWith(string) || string2.indexOf("_rs") != -1) continue;
                String string3 = string2.substring(string2.indexOf("_") + 1, string2.indexOf("."));
                try {
                    l2 = new Long(string3);
                    if (l2 <= l) continue;
                    l = l2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReportsGenerator.getLastUsedFileIdx() Exception : " + exception);
        }
        return l + 1L;
    }

    public void createPDFReport() {
        new Thread(new RenderPDFReport(this.appView, this.vmOptions, "report_data.xml", this.xsltFile.getAbsolutePath(), this.reportFileName, this.saxonPath, this.reportsPath)).start();
    }

    private String getSizePrecisionScale(Object object, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (object instanceof Column) {
            string2 = ((Column)object).getPrecision();
            string3 = ((Column)object).getScale();
            string4 = ((Column)object).getSize();
        } else if (object instanceof Attribute) {
            string2 = ((Attribute)object).getPrecision();
            string3 = ((Attribute)object).getScale();
            string4 = ((Attribute)object).getSize();
        } else if (object instanceof Domain) {
            string2 = ((Domain)object).getPrecision();
            string3 = ((Domain)object).getScale();
            string4 = ((Domain)object).getSize();
        } else if (object instanceof TypeElement) {
            string2 = Integer.valueOf(((TypeElement)object).getPrecision()).toString();
            string3 = Integer.valueOf(((TypeElement)object).getScale()).toString();
            string4 = ((TypeElement)object).getSize();
        }
        if (string2 != null && !string2.trim().equals("") && !string2.trim().equals("0")) {
            if ((string = string + " (" + string2).indexOf("(") > -1) {
                if (string3 != null && !string3.trim().equals("") && !string3.trim().equals("0")) {
                    string = string + "," + string3;
                }
                string = string + ")";
            }
        } else if (string4 != null && !string4.trim().equals("") && !string4.trim().equals("0")) {
            string = string + " (" + string4 + ") ";
        }
        string = string.replace("(0,0)", "");
        string = string.replace("(0)", "");
        string = string.replace("()", "");
        string = string.replace("Unknown", "");
        string = string.replace("unknown", "");
        string = string.replace("UNKNOWN", "");
        return string;
    }
}

