/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ReportTemplatesDialog
extends CustomDialog {
    private static final String TEMPLATE_NAME = "RTemplate";
    private boolean result = false;
    private JDialog dialog;
    private JPanel mainPanel;
    private JPanel jpSouth;
    private JList reportTemplatesList;
    private JButton bnClose;
    private JButton bnAdd;
    private JButton bnSave;
    private JButton bnEdit;
    private JButton bnRemove;
    private DefaultListModel reportTemplatesModel;
    private int cgCounter = 0;
    private int reportCode;
    private JTextField txtTemplateName;
    private JCheckBox cbDescriptionInfo;
    private JCheckBox cbQuantitativeInfo;
    private JCheckBox cbTCol;
    private JCheckBox cbTColComm;
    private JCheckBox cbTConstr;
    private JCheckBox cbTFKRF;
    private JCheckBox cbTFKRT;
    private JCheckBox cbTIdx;
    private JCheckBox cbEAttributes;
    private JCheckBox cbEAttributesComm;
    private JCheckBox cbEConstraints;
    private JCheckBox cbEIdentifiers;
    private JCheckBox cbERelationships;
    private JCheckBox cbEIncProcesses;
    private JCheckBox cbEOutProcesses;
    private JCheckBox cbDDetails;
    private JCheckBox cbDUsedInTables;
    private JCheckBox cbDUsedInEntities;
    private JCheckBox cbSTAttributes;
    private JCheckBox cbSTAttributesComments;
    private JCheckBox cbSTMethods;
    private JCheckBox cbSTUsedInTables;
    private JCheckBox cbSTUsedInEntities;
    private JCheckBox cbCTUsedInTables;
    private JCheckBox cbCTUsedInEntities;
    private JCheckBox cbDTUsedInTables;
    private JCheckBox cbDTUsedInEntities;
    private JCheckBox cbCRImpactedObjects;
    private JCheckBox cbMRImpactedObjects;
    private boolean isSaved = true;
    private ApplicationView appView;
    private ReportsGenerationDialog parent;
    private static final long serialVersionUID = 6116868020778036386L;

    public ReportTemplatesDialog(ApplicationView applicationView, int n, ReportsGenerationDialog reportsGenerationDialog) {
        super(applicationView);
        this.parent = reportsGenerationDialog;
        this.appView = applicationView;
        this.reportCode = n;
        this.init();
        this.initButtonsPanel();
        this.loadTemplates();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(470, 450));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        jPanel2.setPreferredSize(new Dimension(400, 160));
        this.reportTemplatesModel = new DefaultListModel();
        this.reportTemplatesList = new JList(this.reportTemplatesModel);
        this.reportTemplatesList.setCellRenderer(new TemplateReportRenderer());
        this.reportTemplatesList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.reportTemplatesList);
        jScrollPane.setPreferredSize(new Dimension(330, 120));
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), jScrollPane, 5, 5);
        this.reportTemplatesList.getSelectionModel().addListSelectionListener(new TemplateListSelectionListener());
        jPanel2.add(jScrollPane);
        this.bnAdd = new JButton(Messages.getString("ReportTemplatesDialog.Add"));
        this.bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnAdd.setEnabled(true);
        this.bnAdd.addActionListener(new AddAction());
        this.bnAdd.setMnemonic(65);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.bnAdd, 350, 5);
        jPanel2.add(this.bnAdd);
        this.bnEdit = new JButton(Messages.getString("ReportTemplatesDialog.Edit"));
        this.bnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnEdit.setEnabled(false);
        this.bnEdit.addActionListener(new EditAction());
        this.bnEdit.setMnemonic(69);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.bnEdit, 350, 35);
        jPanel2.add(this.bnEdit);
        this.bnRemove = new JButton(Messages.getString("ReportTemplatesDialog.Remove"));
        this.bnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setMnemonic(82);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.bnRemove, 350, 65);
        jPanel2.add(this.bnRemove);
        this.bnSave = new JButton(Messages.getString("ReportTemplatesDialog.Save"));
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnSave.setEnabled(false);
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setMnemonic(83);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel2.getLayout(), this.bnSave, 350, 95);
        jPanel2.add(this.bnSave);
        this.jpSouth = new JPanel(new SpringLayout());
        this.jpSouth.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportSections")));
        this.jpSouth.setPreferredSize(new Dimension(400, 300));
        this.initTemplateDetails();
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.jpSouth, "Center");
        this.mainPanel.add((Component)jPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    private void initTemplateDetails() {
        JLabel jLabel = new JLabel(Messages.getString("ReportTemplatesDialog.TemplateName"));
        jLabel.setPreferredSize(new Dimension(120, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.jpSouth.getLayout(), jLabel, 5, 5);
        this.txtTemplateName = new JTextField();
        this.txtTemplateName.setEnabled(false);
        this.txtTemplateName.setPreferredSize(new Dimension(350, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.txtTemplateName, 110, 3);
        this.jpSouth.add(jLabel);
        this.jpSouth.add(this.txtTemplateName);
        if (this.reportCode == 1 || this.reportCode == 2) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDescriptionInfo, 10, 50);
            this.cbQuantitativeInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.QuantitativeInfo"));
            this.cbQuantitativeInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbQuantitativeInfo, 10, 80);
            this.cbTCol = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumns"));
            this.cbTCol.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTCol, 10, 110);
            this.cbTColComm = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableColumnsComments"));
            this.cbTColComm.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTColComm, 10, 140);
            this.cbTConstr = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableConstraints"));
            this.cbTConstr.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTConstr, 10, 170);
            this.cbTFKRF = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRF"));
            this.cbTFKRF.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTFKRF, 10, 200);
            this.cbTFKRT = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableFKRT"));
            this.cbTFKRT.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTFKRT, 250, 50);
            this.cbTIdx = new JCheckBox(Messages.getString("ReportTemplatesDialog.TableIndexes"));
            this.cbTIdx.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbTIdx, 250, 80);
            this.jpSouth.add(this.cbDescriptionInfo);
            this.jpSouth.add(this.cbQuantitativeInfo);
            this.jpSouth.add(this.cbTCol);
            this.jpSouth.add(this.cbTColComm);
            this.jpSouth.add(this.cbTConstr);
            this.jpSouth.add(this.cbTFKRF);
            this.jpSouth.add(this.cbTFKRT);
            this.jpSouth.add(this.cbTIdx);
        } else if (this.reportCode == 3 || this.reportCode == 4) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDescriptionInfo, 10, 50);
            this.cbQuantitativeInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.QuantitativeInfo"));
            this.cbQuantitativeInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbQuantitativeInfo, 10, 80);
            this.cbEAttributes = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributes"));
            this.cbEAttributes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEAttributes, 10, 110);
            this.cbEAttributesComm = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityAttributesComments"));
            this.cbEAttributesComm.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEAttributesComm, 10, 140);
            this.cbEConstraints = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityConstraints"));
            this.cbEConstraints.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEConstraints, 10, 170);
            this.cbEIdentifiers = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityIdentifiers"));
            this.cbEIdentifiers.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEIdentifiers, 10, 200);
            this.cbERelationships = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityRelationships"));
            this.cbERelationships.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbERelationships, 250, 50);
            this.cbEIncProcesses = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityIncProcesses"));
            this.cbEIncProcesses.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEIncProcesses, 250, 80);
            this.cbEOutProcesses = new JCheckBox(Messages.getString("ReportTemplatesDialog.EntityOutProcesses"));
            this.cbEOutProcesses.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbEOutProcesses, 250, 110);
            this.jpSouth.add(this.cbDescriptionInfo);
            this.jpSouth.add(this.cbQuantitativeInfo);
            this.jpSouth.add(this.cbEAttributes);
            this.jpSouth.add(this.cbEAttributesComm);
            this.jpSouth.add(this.cbEConstraints);
            this.jpSouth.add(this.cbEIdentifiers);
            this.jpSouth.add(this.cbERelationships);
            this.jpSouth.add(this.cbEIncProcesses);
            this.jpSouth.add(this.cbEOutProcesses);
        } else if (this.reportCode == 5) {
            this.cbDDetails = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainConstraints"));
            this.cbDDetails.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDDetails, 5, 35);
            this.cbDUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainUsedInTables"));
            this.cbDUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDUsedInTables, 5, 65);
            this.cbDUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.DomainUsedInEntities"));
            this.cbDUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDUsedInEntities, 5, 95);
            this.jpSouth.add(this.cbDDetails);
            this.jpSouth.add(this.cbDUsedInTables);
            this.jpSouth.add(this.cbDUsedInEntities);
        } else if (this.reportCode == 7 || this.reportCode == 8) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDescriptionInfo, 10, 50);
            this.cbSTAttributes = new JCheckBox(Messages.getString("ReportTemplatesDialog.STAttributes"));
            this.cbSTAttributes.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbSTAttributes, 10, 80);
            this.cbSTAttributesComments = new JCheckBox(Messages.getString("ReportTemplatesDialog.STAttributesComments"));
            this.cbSTAttributesComments.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbSTAttributesComments, 10, 110);
            this.cbSTMethods = new JCheckBox(Messages.getString("ReportTemplatesDialog.STMethods"));
            this.cbSTMethods.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbSTMethods, 10, 140);
            this.cbSTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.STUsedInTables"));
            this.cbSTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbSTUsedInTables, 10, 170);
            this.cbSTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.STUsedInEntities"));
            this.cbSTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbSTUsedInEntities, 10, 200);
            this.jpSouth.add(this.cbDescriptionInfo);
            this.jpSouth.add(this.cbSTAttributes);
            this.jpSouth.add(this.cbSTAttributesComments);
            this.jpSouth.add(this.cbSTMethods);
            this.jpSouth.add(this.cbSTUsedInTables);
            this.jpSouth.add(this.cbSTUsedInEntities);
        } else if (this.reportCode == 9 || this.reportCode == 10) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDescriptionInfo, 10, 50);
            this.cbCTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.CTUsedInTables"));
            this.cbCTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbCTUsedInTables, 10, 80);
            this.cbCTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.CTUsedInEntities"));
            this.cbCTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbCTUsedInEntities, 10, 110);
            this.jpSouth.add(this.cbDescriptionInfo);
            this.jpSouth.add(this.cbCTUsedInTables);
            this.jpSouth.add(this.cbCTUsedInEntities);
        } else if (this.reportCode == 11 || this.reportCode == 12) {
            this.cbDescriptionInfo = new JCheckBox(Messages.getString("ReportTemplatesDialog.DescriptionNotes"));
            this.cbDescriptionInfo.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDescriptionInfo, 10, 50);
            this.cbDTUsedInTables = new JCheckBox(Messages.getString("ReportTemplatesDialog.DTUsedInTables"));
            this.cbDTUsedInTables.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDTUsedInTables, 10, 80);
            this.cbDTUsedInEntities = new JCheckBox(Messages.getString("ReportTemplatesDialog.DTUsedInEntities"));
            this.cbDTUsedInEntities.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbDTUsedInEntities, 10, 110);
            this.jpSouth.add(this.cbDescriptionInfo);
            this.jpSouth.add(this.cbDTUsedInTables);
            this.jpSouth.add(this.cbDTUsedInEntities);
        } else if (this.reportCode == 13) {
            this.cbCRImpactedObjects = new JCheckBox(Messages.getString("ReportTemplatesDialog.CRImpactedObjects"));
            this.cbCRImpactedObjects.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbCRImpactedObjects, 5, 35);
            this.jpSouth.add(this.cbCRImpactedObjects);
        } else if (this.reportCode == 14) {
            this.cbMRImpactedObjects = new JCheckBox(Messages.getString("ReportTemplatesDialog.MRImpactedObjects"));
            this.cbMRImpactedObjects.setEnabled(false);
            CommonUtil.setObjectConstraints((SpringLayout)this.jpSouth.getLayout(), this.cbMRImpactedObjects, 5, 35);
            this.jpSouth.add(this.cbMRImpactedObjects);
        }
        this.jpSouth.revalidate();
    }

    private void initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnClose = new JButton(Messages.getString("ReportTemplatesDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        this.bnClose.setMnemonic(67);
        jPanel.add(this.bnClose);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        this.mainPanel.add((Component)jPanel, "South");
    }

    private void loadTemplates() {
        for (ReportTemplate reportTemplate : this.appView.getReportTemplates()) {
            if (reportTemplate.getType() != this.reportCode) continue;
            this.reportTemplatesModel.addElement(reportTemplate);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ReportTemplatesDialog.ReportTemplatesManagement"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        if (this.canClose()) {
            ArrayList<ReportTemplate> arrayList = new ArrayList<ReportTemplate>();
            ArrayList arrayList2 = new ArrayList();
            ArrayList<ReportTemplate> arrayList3 = this.appView.getReportTemplates();
            for (ReportTemplate reportTemplate : arrayList3) {
                if (reportTemplate.getType() != this.reportCode) continue;
                arrayList.add(reportTemplate);
            }
            int n = this.reportTemplatesList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                Object object = this.reportTemplatesList.getModel().getElementAt(i);
                arrayList2.add(object);
            }
            arrayList3.removeAll(arrayList);
            arrayList3.addAll(arrayList2);
            this.parent.cmbTemplates.removeAllItems();
            this.parent.cmbTemplates.addItem(ReportsGenerationDialog.blankRT);
            for (ReportTemplate reportTemplate : arrayList3) {
                if (reportTemplate.getType() != this.reportCode) continue;
                this.parent.cmbTemplates.addItem(reportTemplate);
            }
            this.close(this.getDialog());
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String string = Messages.getString("ReportTemplatesDialog.Yes");
            String string2 = Messages.getString("ReportTemplatesDialog.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("ReportTemplatesDialog.NotSavedErrMsg"), Messages.getString("ReportTemplatesDialog.NotSavedConfirm"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    public void close(Window window) {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "REPORT_TEMPLATES_DIALOG";
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void showDetails(ReportTemplate reportTemplate) {
        this.txtTemplateName.setText(reportTemplate.getName());
        if (this.reportCode == 1 || this.reportCode == 2) {
            this.cbDescriptionInfo.setSelected(reportTemplate.isUseDescriptionInfo());
            this.cbQuantitativeInfo.setSelected(reportTemplate.isUseQuantitativeInfo());
            this.cbTCol.setSelected(reportTemplate.isUseTableColumns());
            this.cbTColComm.setSelected(reportTemplate.isUseTableColumnsComments());
            this.cbTConstr.setSelected(reportTemplate.isUseTableConstraints());
            this.cbTFKRF.setSelected(reportTemplate.isUseTableFKReferredFrom());
            this.cbTFKRT.setSelected(reportTemplate.isUseTableFKReferringTo());
            this.cbTIdx.setSelected(reportTemplate.isUseTableIndexes());
        } else if (this.reportCode == 3 || this.reportCode == 4) {
            this.cbDescriptionInfo.setSelected(reportTemplate.isUseDescriptionInfo());
            this.cbQuantitativeInfo.setSelected(reportTemplate.isUseQuantitativeInfo());
            this.cbEAttributes.setSelected(reportTemplate.isUseEntityAttributes());
            this.cbEAttributesComm.setSelected(reportTemplate.isUseEntityAttributesComments());
            this.cbEConstraints.setSelected(reportTemplate.isUseEntityConstraints());
            this.cbEIdentifiers.setSelected(reportTemplate.isUseEntityIdentifiers());
            this.cbERelationships.setSelected(reportTemplate.isUseEntityRelationships());
            this.cbEIncProcesses.setSelected(reportTemplate.isUseEntityIncomingProcesses());
            this.cbEOutProcesses.setSelected(reportTemplate.isUseEntityOutgoingProcesses());
        } else if (this.reportCode == 5) {
            this.cbDDetails.setSelected(reportTemplate.isUseDomainConstraints());
            this.cbDUsedInTables.setSelected(reportTemplate.isUseDomainUsedInTables());
            this.cbDUsedInEntities.setSelected(reportTemplate.isUseDomainUsedInEntities());
        } else if (this.reportCode == 7 || this.reportCode == 8) {
            this.cbDescriptionInfo.setSelected(reportTemplate.isUseDescriptionInfo());
            this.cbSTAttributes.setSelected(reportTemplate.isUseSTAttributes());
            this.cbSTAttributesComments.setSelected(reportTemplate.isUseSTAttributesComments());
            this.cbSTMethods.setSelected(reportTemplate.isUseSTMethods());
            this.cbSTUsedInEntities.setSelected(reportTemplate.isUseSTUsedInEntities());
            this.cbSTUsedInTables.setSelected(reportTemplate.isUseSTUsedInTables());
        } else if (this.reportCode == 9 || this.reportCode == 10) {
            this.cbDescriptionInfo.setSelected(reportTemplate.isUseDescriptionInfo());
            this.cbCTUsedInEntities.setSelected(reportTemplate.isUseCTUsedInEntities());
            this.cbCTUsedInTables.setSelected(reportTemplate.isUseCTUsedInTables());
        } else if (this.reportCode == 11 || this.reportCode == 12) {
            this.cbDescriptionInfo.setSelected(reportTemplate.isUseDescriptionInfo());
            this.cbDTUsedInEntities.setSelected(reportTemplate.isUseDTUsedInEntities());
            this.cbDTUsedInTables.setSelected(reportTemplate.isUseDTUsedInTables());
        } else if (this.reportCode == 13) {
            this.cbCRImpactedObjects.setSelected(reportTemplate.isUseCRImpactedObjects());
        } else if (this.reportCode == 14) {
            this.cbMRImpactedObjects.setSelected(reportTemplate.isUseMRImpactedObjects());
        }
    }

    protected String generateName() {
        String string = TEMPLATE_NAME;
        int n = 0;
        int n2 = this.reportTemplatesModel.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.nameExists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean nameExists(String string) {
        for (int i = 0; i < this.reportTemplatesModel.size(); ++i) {
            ReportTemplate reportTemplate = (ReportTemplate)this.reportTemplatesModel.get(i);
            if (!string.equalsIgnoreCase(reportTemplate.getName())) continue;
            return true;
        }
        return false;
    }

    private class TemplateListSelectionListener
    implements ListSelectionListener {
        private TemplateListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex() == -1) {
                ReportTemplatesDialog.this.bnEdit.setEnabled(false);
                ReportTemplatesDialog.this.bnRemove.setEnabled(false);
            } else {
                ReportTemplatesDialog.this.bnEdit.setEnabled(true);
                ReportTemplatesDialog.this.bnRemove.setEnabled(true);
                ReportTemplate reportTemplate = (ReportTemplate)ReportTemplatesDialog.this.reportTemplatesModel.get(ReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
                ReportTemplatesDialog.this.showDetails(reportTemplate);
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplatesDialog.this.close();
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            ReportTemplatesDialog.this.bnSave.setEnabled(false);
            ReportTemplatesDialog.this.bnAdd.setEnabled(true);
            ReportTemplatesDialog.this.bnEdit.setEnabled(true);
            ReportTemplatesDialog.this.bnRemove.setEnabled(true);
            ReportTemplate reportTemplate = (ReportTemplate)ReportTemplatesDialog.this.reportTemplatesModel.get(ReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
            reportTemplate.setName(ReportTemplatesDialog.this.txtTemplateName.getText());
            ReportTemplatesDialog.this.txtTemplateName.setEnabled(false);
            if (ReportTemplatesDialog.this.reportCode == 1 || ReportTemplatesDialog.this.reportCode == 2) {
                reportTemplate.setUseDescriptionInfo(ReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                reportTemplate.setUseQuantitativeInfo(ReportTemplatesDialog.this.cbQuantitativeInfo.isSelected());
                reportTemplate.setUseTableColumns(ReportTemplatesDialog.this.cbTCol.isSelected());
                reportTemplate.setUseTableColumnsComments(ReportTemplatesDialog.this.cbTColComm.isSelected());
                reportTemplate.setUseTableConstraints(ReportTemplatesDialog.this.cbTConstr.isSelected());
                reportTemplate.setUseTableFKReferringTo(ReportTemplatesDialog.this.cbTFKRT.isSelected());
                reportTemplate.setUseTableFKReferredFrom(ReportTemplatesDialog.this.cbTFKRF.isSelected());
                reportTemplate.setUseTableIndexes(ReportTemplatesDialog.this.cbTIdx.isSelected());
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbTCol.setEnabled(false);
                ReportTemplatesDialog.this.cbTColComm.setEnabled(false);
                ReportTemplatesDialog.this.cbTConstr.setEnabled(false);
                ReportTemplatesDialog.this.cbTFKRF.setEnabled(false);
                ReportTemplatesDialog.this.cbTFKRT.setEnabled(false);
                ReportTemplatesDialog.this.cbTIdx.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 3 || ReportTemplatesDialog.this.reportCode == 4) {
                reportTemplate.setUseDescriptionInfo(ReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                reportTemplate.setUseQuantitativeInfo(ReportTemplatesDialog.this.cbQuantitativeInfo.isSelected());
                reportTemplate.setUseEntityAttributes(ReportTemplatesDialog.this.cbEAttributes.isSelected());
                reportTemplate.setUseEntityAttributesComments(ReportTemplatesDialog.this.cbEAttributesComm.isSelected());
                reportTemplate.setUseEntityConstraints(ReportTemplatesDialog.this.cbEConstraints.isSelected());
                reportTemplate.setUseEntityIdentifiers(ReportTemplatesDialog.this.cbEIdentifiers.isSelected());
                reportTemplate.setUseEntityRelationships(ReportTemplatesDialog.this.cbERelationships.isSelected());
                reportTemplate.setUseEntityIncomingProcesses(ReportTemplatesDialog.this.cbEIncProcesses.isSelected());
                reportTemplate.setUseEntityOutgoingProcesses(ReportTemplatesDialog.this.cbEOutProcesses.isSelected());
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbEAttributes.setEnabled(false);
                ReportTemplatesDialog.this.cbEAttributesComm.setEnabled(false);
                ReportTemplatesDialog.this.cbEConstraints.setEnabled(false);
                ReportTemplatesDialog.this.cbEIdentifiers.setEnabled(false);
                ReportTemplatesDialog.this.cbERelationships.setEnabled(false);
                ReportTemplatesDialog.this.cbEIncProcesses.setEnabled(false);
                ReportTemplatesDialog.this.cbEOutProcesses.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 5) {
                reportTemplate.setUseDomainConstraints(ReportTemplatesDialog.this.cbDDetails.isSelected());
                reportTemplate.setUseDomainUsedInEntities(ReportTemplatesDialog.this.cbDUsedInEntities.isSelected());
                reportTemplate.setUseDomainUsedInTables(ReportTemplatesDialog.this.cbDUsedInTables.isSelected());
                ReportTemplatesDialog.this.cbDDetails.setEnabled(false);
                ReportTemplatesDialog.this.cbDUsedInTables.setEnabled(false);
                ReportTemplatesDialog.this.cbDUsedInEntities.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 7 || ReportTemplatesDialog.this.reportCode == 8) {
                reportTemplate.setUseDescriptionInfo(ReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                reportTemplate.setUseSTAttributes(ReportTemplatesDialog.this.cbSTAttributes.isSelected());
                reportTemplate.setUseSTAttributesComments(ReportTemplatesDialog.this.cbSTAttributesComments.isSelected());
                reportTemplate.setUseSTMethods(ReportTemplatesDialog.this.cbSTMethods.isSelected());
                reportTemplate.setUseSTUsedInEntities(ReportTemplatesDialog.this.cbSTUsedInEntities.isSelected());
                reportTemplate.setUseSTUsedInTables(ReportTemplatesDialog.this.cbSTUsedInTables.isSelected());
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbSTAttributes.setEnabled(false);
                ReportTemplatesDialog.this.cbSTAttributesComments.setEnabled(false);
                ReportTemplatesDialog.this.cbSTMethods.setEnabled(false);
                ReportTemplatesDialog.this.cbSTUsedInEntities.setEnabled(false);
                ReportTemplatesDialog.this.cbSTUsedInTables.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 9 || ReportTemplatesDialog.this.reportCode == 10) {
                reportTemplate.setUseDescriptionInfo(ReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                reportTemplate.setUseCTUsedInEntities(ReportTemplatesDialog.this.cbCTUsedInEntities.isSelected());
                reportTemplate.setUseCTUsedInTables(ReportTemplatesDialog.this.cbCTUsedInTables.isSelected());
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbCTUsedInEntities.setEnabled(false);
                ReportTemplatesDialog.this.cbCTUsedInTables.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 11 || ReportTemplatesDialog.this.reportCode == 12) {
                reportTemplate.setUseDescriptionInfo(ReportTemplatesDialog.this.cbDescriptionInfo.isSelected());
                reportTemplate.setUseDTUsedInEntities(ReportTemplatesDialog.this.cbDTUsedInEntities.isSelected());
                reportTemplate.setUseDTUsedInTables(ReportTemplatesDialog.this.cbDTUsedInTables.isSelected());
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(false);
                ReportTemplatesDialog.this.cbDTUsedInEntities.setEnabled(false);
                ReportTemplatesDialog.this.cbDTUsedInTables.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 13) {
                reportTemplate.setUseCRImpactedObjects(ReportTemplatesDialog.this.cbCRImpactedObjects.isSelected());
                ReportTemplatesDialog.this.cbCRImpactedObjects.setEnabled(false);
            } else if (ReportTemplatesDialog.this.reportCode == 14) {
                reportTemplate.setUseMRImpactedObjects(ReportTemplatesDialog.this.cbMRImpactedObjects.isSelected());
                ReportTemplatesDialog.this.cbMRImpactedObjects.setEnabled(false);
            }
            ReportTemplatesDialog.this.isSaved = true;
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplatesDialog.this.reportTemplatesModel.remove(ReportTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplatesDialog.this.txtTemplateName.setEnabled(true);
            ReportTemplatesDialog.this.reportTemplatesList.setEnabled(false);
            ReportTemplatesDialog.this.bnAdd.setEnabled(false);
            ReportTemplatesDialog.this.bnEdit.setEnabled(false);
            ReportTemplatesDialog.this.bnSave.setEnabled(true);
            ReportTemplatesDialog.this.bnRemove.setEnabled(false);
            if (ReportTemplatesDialog.this.reportCode == 1 || ReportTemplatesDialog.this.reportCode == 2) {
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbTCol.setEnabled(true);
                ReportTemplatesDialog.this.cbTColComm.setEnabled(true);
                ReportTemplatesDialog.this.cbTConstr.setEnabled(true);
                ReportTemplatesDialog.this.cbTFKRT.setEnabled(true);
                ReportTemplatesDialog.this.cbTFKRF.setEnabled(true);
                ReportTemplatesDialog.this.cbTIdx.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 3 || ReportTemplatesDialog.this.reportCode == 4) {
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbQuantitativeInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbEAttributes.setEnabled(true);
                ReportTemplatesDialog.this.cbEAttributesComm.setEnabled(true);
                ReportTemplatesDialog.this.cbEConstraints.setEnabled(true);
                ReportTemplatesDialog.this.cbEIdentifiers.setEnabled(true);
                ReportTemplatesDialog.this.cbERelationships.setEnabled(true);
                ReportTemplatesDialog.this.cbEIncProcesses.setEnabled(true);
                ReportTemplatesDialog.this.cbEOutProcesses.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 5) {
                ReportTemplatesDialog.this.cbDDetails.setEnabled(true);
                ReportTemplatesDialog.this.cbDUsedInTables.setEnabled(true);
                ReportTemplatesDialog.this.cbDUsedInEntities.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 7 || ReportTemplatesDialog.this.reportCode == 8) {
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbSTAttributes.setEnabled(true);
                ReportTemplatesDialog.this.cbSTAttributesComments.setEnabled(true);
                ReportTemplatesDialog.this.cbSTMethods.setEnabled(true);
                ReportTemplatesDialog.this.cbSTUsedInEntities.setEnabled(true);
                ReportTemplatesDialog.this.cbSTUsedInTables.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 9 || ReportTemplatesDialog.this.reportCode == 10) {
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbCTUsedInEntities.setEnabled(true);
                ReportTemplatesDialog.this.cbCTUsedInTables.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 11 || ReportTemplatesDialog.this.reportCode == 12) {
                ReportTemplatesDialog.this.cbDescriptionInfo.setEnabled(true);
                ReportTemplatesDialog.this.cbDTUsedInEntities.setEnabled(true);
                ReportTemplatesDialog.this.cbDTUsedInTables.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 13) {
                ReportTemplatesDialog.this.cbCRImpactedObjects.setEnabled(true);
            } else if (ReportTemplatesDialog.this.reportCode == 14) {
                ReportTemplatesDialog.this.cbMRImpactedObjects.setEnabled(true);
            }
            ReportTemplatesDialog.this.isSaved = false;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReportTemplate reportTemplate = new ReportTemplate(ReportTemplatesDialog.this.generateName(), ReportTemplatesDialog.this.reportCode, null);
            if (ReportTemplatesDialog.this.reportCode == 1 || ReportTemplatesDialog.this.reportCode == 2) {
                reportTemplate.setUseDescriptionInfo(true);
                reportTemplate.setUseQuantitativeInfo(true);
                reportTemplate.setUseTableColumns(true);
                reportTemplate.setUseTableColumnsComments(true);
                reportTemplate.setUseTableConstraints(true);
                reportTemplate.setUseTableFKReferredFrom(true);
                reportTemplate.setUseTableFKReferringTo(true);
                reportTemplate.setUseTableIndexes(true);
            } else if (ReportTemplatesDialog.this.reportCode == 3 || ReportTemplatesDialog.this.reportCode == 4) {
                reportTemplate.setUseDescriptionInfo(true);
                reportTemplate.setUseQuantitativeInfo(true);
                reportTemplate.setUseEntityAttributes(true);
                reportTemplate.setUseEntityAttributesComments(true);
                reportTemplate.setUseEntityConstraints(true);
                reportTemplate.setUseEntityIdentifiers(true);
                reportTemplate.setUseEntityIncomingProcesses(true);
                reportTemplate.setUseEntityOutgoingProcesses(true);
                reportTemplate.setUseEntityRelationships(true);
            } else if (ReportTemplatesDialog.this.reportCode == 5) {
                reportTemplate.setUseDomainConstraints(true);
                reportTemplate.setUseDomainUsedInEntities(true);
                reportTemplate.setUseDomainUsedInTables(true);
            } else if (ReportTemplatesDialog.this.reportCode == 7 || ReportTemplatesDialog.this.reportCode == 8) {
                reportTemplate.setUseDescriptionInfo(true);
                reportTemplate.setUseSTAttributes(true);
                reportTemplate.setUseSTAttributesComments(true);
                reportTemplate.setUseSTMethods(true);
                reportTemplate.setUseSTUsedInEntities(true);
                reportTemplate.setUseSTUsedInTables(true);
            } else if (ReportTemplatesDialog.this.reportCode == 9 || ReportTemplatesDialog.this.reportCode == 10) {
                reportTemplate.setUseDescriptionInfo(true);
                reportTemplate.setUseCTUsedInEntities(true);
                reportTemplate.setUseCTUsedInTables(true);
            } else if (ReportTemplatesDialog.this.reportCode == 11 || ReportTemplatesDialog.this.reportCode == 12) {
                reportTemplate.setUseDescriptionInfo(true);
                reportTemplate.setUseDTUsedInEntities(true);
                reportTemplate.setUseDTUsedInTables(true);
            } else if (ReportTemplatesDialog.this.reportCode == 13) {
                reportTemplate.setUseCRImpactedObjects(true);
            } else if (ReportTemplatesDialog.this.reportCode == 14) {
                reportTemplate.setUseMRImpactedObjects(true);
            }
            ReportTemplatesDialog.this.reportTemplatesModel.addElement(reportTemplate);
            ReportTemplatesDialog.this.reportTemplatesList.setSelectedValue(reportTemplate, true);
            ReportTemplatesDialog.this.bnEdit.setEnabled(true);
            ReportTemplatesDialog.this.bnRemove.setEnabled(true);
            ReportTemplatesDialog.this.bnSave.setEnabled(false);
        }
    }

    class TemplateReportRenderer
    extends JLabel
    implements ListCellRenderer {
        TemplateReportRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ReportTemplate reportTemplate = (ReportTemplate)object;
            this.setText(reportTemplate.getName());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

