/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.exports.reports.GlossaryHandler;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.reports.DeleteDesignsDialog;
import oracle.dbtools.crest.swingui.wizards.reports.DeleteGlossaryDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class ExportReportsDialog
extends CustomDialog
implements AbstractEditorConstants {
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTextArea taComments;
    private boolean result = false;
    private JTable tbConnections;
    private JButton bnOK;
    private JButton bnTest;
    private JButton bnProps;
    private JButton bnRemove;
    private JButton bnImport;
    private Connection connection = null;
    private JCheckBox chbExportDiagramsAsPDF;
    private JButton bnDrop;
    private JButton bnDeleteDesigns;
    private JButton bnExportGlossary;
    private JButton bnDeleteGlossary;
    private JButton bnEnableIndexes;
    private JButton bnDisableIndexes;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(ExportReportsDialog.class);

    public ExportReportsDialog(ApplicationView applicationView) {
        super(applicationView);
        this.add((Component)this.getGeneralPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getGeneralPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ExportReportsDialog.this.showConnectionProperties();
                } else {
                    boolean bl = ExportReportsDialog.this.tbConnections.getSelectedRow() > -1;
                    ExportReportsDialog.this.bnOK.setEnabled(bl);
                    ExportReportsDialog.this.bnTest.setEnabled(bl);
                    ExportReportsDialog.this.bnProps.setEnabled(bl);
                    ExportReportsDialog.this.bnRemove.setEnabled(bl);
                    ExportReportsDialog.this.bnDrop.setEnabled(bl);
                    ExportReportsDialog.this.bnDeleteDesigns.setEnabled(bl);
                    ExportReportsDialog.this.bnExportGlossary.setEnabled(bl);
                    ExportReportsDialog.this.bnDeleteGlossary.setEnabled(bl);
                    ExportReportsDialog.this.bnEnableIndexes.setEnabled(bl);
                    ExportReportsDialog.this.bnDisableIndexes.setEnabled(bl);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tbConnections);
        jScrollPane.setPreferredSize(new Dimension(400, 180));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(Messages.getString("ExportReportsDialog.Connections")), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setPreferredSize(new Dimension(200, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.bnProps = new JButton(gUIConfiguration.getIcon("EDIT_ICON", 16));
        this.bnProps.setToolTipText(Messages.getString("ExportReportsDialog.ConnectionProperties"));
        this.bnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportReportsDialog.this.showConnectionProperties();
            }
        });
        this.bnProps.setEnabled(false);
        JButton jButton = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton.setToolTipText(Messages.getString("ExportReportsDialog.AddConnection"));
        jButton.addActionListener(new AddAction());
        this.bnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        this.bnRemove.setToolTipText(Messages.getString("ExportReportsDialog.RemvoeConnection"));
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(gUIConfiguration.getIcon("DB_CONNECT_ICON", 16));
        this.bnImport.setToolTipText(Messages.getString("ExportReportsDialog.ImportSQLDeveloperConn"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnTest = new JButton(gUIConfiguration.getIcon("DESIGN_RULES_ICON", 16));
        this.bnTest.setToolTipText(Messages.getString("ExportReportsDialog.TestConnection"));
        this.bnTest.addActionListener(new TestAction());
        this.bnTest.setEnabled(false);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.bnProps);
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.add(this.bnRemove);
        jToolBar.addSeparator();
        jToolBar.add(this.bnImport);
        jToolBar.addSeparator();
        jToolBar.add(this.bnTest);
        jPanel3.add(jToolBar);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel(Messages.getString("ExportReportsDialog.Comments")), "North");
        this.taComments = new JTextArea();
        JScrollPane jScrollPane2 = new JScrollPane(this.taComments);
        jScrollPane2.setPreferredSize(new Dimension(400, 100));
        jPanel4.add((Component)jScrollPane2, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(400, 90));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.chbExportDiagramsAsPDF = new JCheckBox(Messages.getString("ExportReportsDialog.ExsportDiagramsAsPDF"));
        this.chbExportDiagramsAsPDF.setMnemonic(80);
        jPanel5.add(this.chbExportDiagramsAsPDF);
        jTabbedPane.add(Messages.getString("ExportReportsDialog.Options"), jPanel5);
        JPanel jPanel6 = new JPanel(new SpringLayout());
        jTabbedPane.add(Messages.getString("ExportReportsDialog.Maintenance"), jPanel6);
        this.bnDrop = new JButton(Messages.getString("ExportReportsDialog.DropRepository"));
        this.bnDrop.setMnemonic(82);
        this.bnDrop.addActionListener(new DropAction());
        this.bnDrop.setEnabled(false);
        this.bnDrop.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel6.add(this.bnDrop);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel6.getLayout(), this.bnDrop, 10, 5);
        this.bnDeleteDesigns = new JButton(Messages.getString("ExportReportsDialog.DeleteDesigns"));
        this.bnDeleteDesigns.setMnemonic(69);
        this.bnDeleteDesigns.addActionListener(new DeleteDesignsAction());
        this.bnDeleteDesigns.setEnabled(false);
        this.bnDeleteDesigns.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel6.add(this.bnDeleteDesigns);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel6.getLayout(), this.bnDeleteDesigns, 210, 5);
        this.bnEnableIndexes = new JButton(Messages.getString("ExportReportsDialog.EnableIndexes"));
        this.bnEnableIndexes.setMnemonic(73);
        this.bnEnableIndexes.addActionListener(new EnableIndexesAction());
        this.bnEnableIndexes.setEnabled(false);
        this.bnEnableIndexes.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel6.add(this.bnEnableIndexes);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel6.getLayout(), this.bnEnableIndexes, 10, 33);
        this.bnDisableIndexes = new JButton(Messages.getString("ExportReportsDialog.DisableIndexes"));
        this.bnDisableIndexes.setMnemonic(88);
        this.bnDisableIndexes.addActionListener(new DisableIndexesAction());
        this.bnDisableIndexes.setEnabled(false);
        this.bnDisableIndexes.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel6.add(this.bnDisableIndexes);
        CommonUtil.setObjectConstraints((SpringLayout)jPanel6.getLayout(), this.bnDisableIndexes, 210, 33);
        JPanel jPanel7 = new JPanel();
        jTabbedPane.add(Messages.getString("ExportReportsDialog.Glossary"), jPanel7);
        this.bnExportGlossary = new JButton(Messages.getString("ExportReportsDialog.ExportGlossary"));
        this.bnExportGlossary.setMnemonic(88);
        this.bnExportGlossary.addActionListener(new ExportGlossaryAction());
        this.bnExportGlossary.setEnabled(false);
        this.bnExportGlossary.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel7.add(this.bnExportGlossary);
        jPanel7.add(new JPanel());
        this.bnDeleteGlossary = new JButton(Messages.getString("ExportReportsDialog.DeleteGlossary"));
        this.bnDeleteGlossary.setMnemonic(76);
        this.bnDeleteGlossary.addActionListener(new DeleteGlossaryAction());
        this.bnDeleteGlossary.setEnabled(false);
        this.bnDeleteGlossary.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        jPanel7.add(this.bnDeleteGlossary);
        jPanel4.add((Component)jTabbedPane, "South");
        jPanel.add((Component)jPanel4, "South");
        this.updateConnections();
        return jPanel;
    }

    private Properties getSelectedConnectionProperties() {
        Properties properties = null;
        try {
            properties = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private void showConnectionProperties() {
        Properties properties = this.getSelectedConnectionProperties();
        if (properties != null) {
            String string = ConnectionInfo.getConnectionName(properties);
            FCPConnectionDialog.showConnectionDialog(string, true);
            this.updateConnections();
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception exception) {
                LOGGER.error("Unable to close the connection", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties properties = this.getSelectedConnectionProperties();
                if (properties == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(properties);
                }
                catch (Exception exception) {
                    MessageDialogs.showErrorMessage(exception.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnOK = new JButton(Messages.getString("ExportReportsDialog.OK"));
            this.bnOK.setMnemonic(79);
            this.bnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportReportsDialog.this.result = false;
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.result = true;
                    }
                    if (ExportReportsDialog.this.connection != null) {
                        String string = ConnectionInfo.getConnectionUserName(ExportReportsDialog.this.getSelectedConnectionProperties());
                        if ("sys".equalsIgnoreCase(string) || "system".equalsIgnoreCase(string)) {
                            MessageDialogs.showErrorMessage(Messages.getString("ExportReportsDialog.ExportingToSystemNotSuporrted"));
                        } else {
                            ExportReportsDialog.this.close();
                        }
                    }
                }
            });
            this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnOK.setEnabled(false);
            this.buttonPanel.add(this.bnOK);
            JButton jButton = new JButton(Messages.getString("ExportReportsDialog.Close"));
            jButton.setMnemonic(67);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportReportsDialog.this.result = false;
                    ExportReportsDialog.this.close();
                }
            });
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setMnemonic(72);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
        }
        return this.buttonPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ExportReportsDialog.ExportToReportingSchema"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_TO_REPORTING_SCHEMA_DIALOG";
    }

    public String getComments() {
        String string = this.taComments.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean exportDiagramsAsPDF() {
        return this.chbExportDiagramsAsPDF.isSelected();
    }

    private class DisableIndexesAction
    implements ActionListener {
        private DisableIndexesAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.disableIndexes(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class EnableIndexesAction
    implements ActionListener {
        private EnableIndexesAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.enableIndexes(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.testConnection(ExportReportsDialog.this.getSelectedConnectionProperties());
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = ExportReportsDialog.this.getSelectedConnectionProperties();
            if (properties != null) {
                try {
                    String string = ConnectionInfo.getConnectionName(properties);
                    int n = JOptionPane.showConfirmDialog(ExportReportsDialog.this, MessageFormat.format(Messages.getString("ExportReportsDialog.SureToDelete"), string), Messages.getString("ExportReportsDialog.SelectOption"), 0);
                    if (n == 0) {
                        DatabaseConnections.getInstance().removeConnection(string);
                        ExportReportsDialog.this.updateConnections();
                        ExportReportsDialog.this.tbConnections.clearSelection();
                        ExportReportsDialog.this.bnOK.setEnabled(false);
                        ExportReportsDialog.this.bnTest.setEnabled(false);
                        ExportReportsDialog.this.bnProps.setEnabled(false);
                        ExportReportsDialog.this.bnRemove.setEnabled(false);
                        ExportReportsDialog.this.bnDrop.setEnabled(false);
                        ExportReportsDialog.this.bnDeleteDesigns.setEnabled(false);
                        ExportReportsDialog.this.bnExportGlossary.setEnabled(false);
                        ExportReportsDialog.this.bnDeleteGlossary.setEnabled(false);
                        ExportReportsDialog.this.bnEnableIndexes.setEnabled(false);
                        ExportReportsDialog.this.bnDisableIndexes.setEnabled(false);
                    }
                }
                catch (ConnectionException connectionException) {
                    LOGGER.error("Unable to delete connection", connectionException);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ExportReportsDialog.this.updateConnections();
            }
            catch (Exception exception) {
                LOGGER.error(exception);
            }
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FCPConnectionDialog.importConnections();
            ExportReportsDialog.this.updateConnections();
        }
    }

    private class DeleteGlossaryAction
    implements ActionListener {
        private DeleteGlossaryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                DeleteGlossaryDialog.showDialog(ExportReportsDialog.this.getApplicationView().getFrame(), ExportReportsDialog.this.connection);
            }
        }
    }

    private class ExportGlossaryAction
    implements ActionListener {
        private ExportGlossaryAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null) {
                Glossary glossary;
                block16: {
                    glossary = null;
                    try {
                        Serializable serializable;
                        URLFilter uRLFilter = new URLFilter(){

                            public boolean accept(URL uRL) {
                                File file = new File(uRL.getPath());
                                return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("GlossaryDialog.CWDGlossaryFiles");
                            }
                        };
                        URLChooser uRLChooser = DialogUtil.newURLChooser();
                        uRLChooser.clearChooseableURLFilters();
                        uRLChooser.setSelectionScope(0);
                        uRLChooser.setSelectionMode(0);
                        uRLChooser.setShowJarsAsDirs(false);
                        uRLChooser.setURLFilter(uRLFilter);
                        if (lastFolder != null) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                        } else {
                            String string = ExportReportsDialog.this.getApplicationView().getSettings().getDefaultReportsPath();
                            if (string != null && string.length() > 0) {
                                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                            } else {
                                serializable = ExportReportsDialog.this.getApplicationView().getUserHomeDirectory();
                                if (serializable != null) {
                                    uRLChooser.setSelectedURL((URL)serializable);
                                }
                            }
                        }
                        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.InputFile"));
                        if (n != 0 || (serializable = new File(uRLChooser.getSelectedURL().getPath())) == null) break block16;
                        lastFolder = ((File)serializable).getParentFile();
                        try {
                            String string = ((File)serializable).getName().toLowerCase();
                            if (!string.endsWith(".glossary")) {
                                serializable = string.endsWith(".") ? new File(((File)serializable).getPath() + "glossary") : new File(((File)serializable).getPath() + ".glossary");
                            }
                            if (!(glossary = new Glossary((File)serializable)).isLoaded()) {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{MessageFormat.format(Messages.getString("GlossaryDialog.InputFileError"), serializable)}, Messages.getString("GlossaryDialog.Error"), 0);
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), exception.getMessage()}, Messages.getString("GlossaryDialog.Error"), 0);
                    }
                }
                if (glossary != null && glossary.isLoaded()) {
                    int n;
                    if (glossary.isDirty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("GlossaryDialog.Modified"), glossary.getName()), Messages.getString("GlossaryDialog.Warning"), 0, 3, ExportReportsDialog.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 0) {
                        glossary.save();
                        glossary.clearDirtyFlag();
                    }
                    if (ExportReportsDialog.this.initConnection()) {
                        GlossaryHandler glossaryHandler = new GlossaryHandler(ExportReportsDialog.this.getApplicationView(), ExportReportsDialog.this.connection, ExportReportsDialog.this.getComments(), glossary);
                        glossaryHandler.export();
                    }
                }
            }
        }
    }

    private class DeleteDesignsAction
    implements ActionListener {
        private DeleteDesignsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                DeleteDesignsDialog.showDialog(ExportReportsDialog.this.getApplicationView().getFrame(), ExportReportsDialog.this.connection);
            }
        }
    }

    private class DropAction
    implements ActionListener {
        private DropAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && (n = JOptionPane.showConfirmDialog(ExportReportsDialog.this, Messages.getString("ExportReportsDialog.SureToDropRepository"), Messages.getString("ExportReportsDialog.SelectAnOpiton"), 0)) == 0) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.dropRepository(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }
}

