/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class DeleteGlossaryDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable glossTable;
    private List elmList;
    private List glossList;
    private List allGlossaries;
    private Connection connection;
    private JButton bnDelete;
    private static final Logger LOGGER = new Logger(DeleteGlossaryDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteGlossaryDialog.this.dispose();
        }
    };

    public DeleteGlossaryDialog(Frame frame, Connection connection) {
        super(frame, "Select Glossary and Repository Version");
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(800, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
    }

    private JPanel init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.glossList = new ArrayList();
        this.glossTable = new JTable(new GlossaryTableModel());
        this.glossTable.setSelectionMode(0);
        this.glossTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = DeleteGlossaryDialog.this.glossTable.getSelectedRow();
                if (n != -1 && DeleteGlossaryDialog.this.glossList.size() > 0 && n < DeleteGlossaryDialog.this.glossList.size()) {
                    GlossaryDescriptor glossaryDescriptor = (GlossaryDescriptor)DeleteGlossaryDialog.this.glossList.get(n);
                    DeleteGlossaryDialog.this.loadVersions(glossaryDescriptor);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.glossTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(120);
        JScrollPane jScrollPane2 = new JScrollPane(this.jtable);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(220);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnDelete = new JButton(Messages.getString("DeleteGlossaryDialog.DeleteSelected"));
        this.bnDelete.setMnemonic(68);
        this.bnDelete.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnDelete.setEnabled(false);
        this.bnDelete.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteGlossaryDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    DeleteGlossaryDialog.this.deleteSelectedGlossaries();
                }
                finally {
                    DeleteGlossaryDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                DeleteGlossaryDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnDelete);
        jPanel.add(this.bnDelete);
        JButton jButton = new JButton(Messages.getString("Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteGlossaryDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void loadGlossaryNames() {
        for (GlossaryDescriptor glossaryDescriptor : this.allGlossaries) {
            GlossaryDescriptor glossaryDescriptor2 = this.getGlossary(this.glossList, glossaryDescriptor.getID());
            if (glossaryDescriptor2 != null) continue;
            this.glossList.add(glossaryDescriptor);
        }
        Collections.sort(this.glossList);
        this.glossTable.updateUI();
        if (this.glossList.size() > 0) {
            this.glossTable.setRowSelectionInterval(0, 0);
        }
    }

    private GlossaryDescriptor getGlossary(List list, String string) {
        for (GlossaryDescriptor glossaryDescriptor : list) {
            if (!string.equalsIgnoreCase(glossaryDescriptor.getID())) continue;
            return glossaryDescriptor;
        }
        return null;
    }

    private List getGlossaries(List list, String string) {
        ArrayList<GlossaryDescriptor> arrayList = new ArrayList<GlossaryDescriptor>();
        for (GlossaryDescriptor glossaryDescriptor : list) {
            if (!string.equalsIgnoreCase(glossaryDescriptor.getID())) continue;
            arrayList.add(glossaryDescriptor);
        }
        return arrayList;
    }

    private void enableDelete() {
        boolean bl = false;
        for (GlossaryDescriptor glossaryDescriptor : this.allGlossaries) {
            if (!glossaryDescriptor.isSelected()) continue;
            bl = true;
            break;
        }
        this.bnDelete.setEnabled(bl);
    }

    private boolean loadGlossaries() {
        boolean bl;
        block10: {
            bl = false;
            try {
                this.allGlossaries = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float f = SchemaFactory.schemaVersion(this.connection);
                    if (f != 0.0f) {
                        String string = "SELECT Glossary_ID, Glossary_OVID, Glossary_Name, to_char(Date_Published, 'DD.MM.YYYY HH24:MI'), File_Name, Version_Comments FROM DMRS_Glossaries ORDER BY Glossary_ID, Date_Published ASC";
                        try {
                            Statement statement = this.connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string);
                            while (resultSet.next()) {
                                String string2 = resultSet.getString(1);
                                String string3 = resultSet.getString(2);
                                String string4 = resultSet.getString(3);
                                String string5 = resultSet.getString(4);
                                String string6 = resultSet.getString(5);
                                String string7 = resultSet.getString(6);
                                GlossaryDescriptor glossaryDescriptor = new GlossaryDescriptor(string4, string2);
                                glossaryDescriptor.setOvid(string3);
                                glossaryDescriptor.setDate(string5);
                                glossaryDescriptor.setFile(string6);
                                if (string7 != null) {
                                    glossaryDescriptor.setComments(string7);
                                }
                                this.allGlossaries.add(glossaryDescriptor);
                            }
                            statement.close();
                            this.loadGlossaryNames();
                            bl = true;
                        }
                        catch (SQLException sQLException) {}
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteGlossaryDialog.RepositoryNotWorking"));
                }
                catch (DifferentVersionException differentVersionException) {
                    MessageDialogs.showWarningMessage(Messages.getString("DeleteGlossaryDialog.DbSchemaOutOFDate"));
                }
                catch (Exception exception) {
                    LOGGER.error("DeleteGlossaryDialog.loadGlossaries", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteGlossaryDialog.UnableToLoadGlossaries"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedGlossaries() {
        block12: {
            try {
                if (this.connection == null) break block12;
                boolean bl = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    for (GlossaryDescriptor glossaryDescriptor : this.allGlossaries) {
                        if (!glossaryDescriptor.isSelected()) continue;
                        String string = glossaryDescriptor.getOvid();
                        String string2 = "DELETE FROM DMRS_GLOSSARY_TERMS WHERE Glossary_OVID='" + string + "'";
                        PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
                        try {
                            preparedStatement.executeUpdate();
                            string2 = "DELETE FROM DMRS_GLOSSARIES WHERE Glossary_OVID='" + string + "'";
                            preparedStatement = this.connection.prepareStatement(string2);
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            JDBCUtils.close(preparedStatement);
                        }
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteGlossaryDialog.SelectedGlosariesDeleted"));
                }
                catch (Exception exception) {
                    if (this.connection != null) {
                        this.connection.rollback();
                    }
                    LOGGER.error("DeleteGlossaryDialog.deleteSelectedGlossaries", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteGlossaryDialog.UnableToDeleteSelectedGlossaries"));
                }
                finally {
                    this.connection.setAutoCommit(bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadVersions(GlossaryDescriptor glossaryDescriptor) {
        this.elmList.clear();
        try {
            this.elmList.addAll(this.getGlossaries(this.allGlossaries, glossaryDescriptor.getID()));
            Collections.sort(this.elmList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
    }

    public static void showDialog(Frame frame, Connection connection) {
        DeleteGlossaryDialog deleteGlossaryDialog = new DeleteGlossaryDialog(frame, connection);
        if (deleteGlossaryDialog.loadGlossaries()) {
            deleteGlossaryDialog.setVisible(true);
        } else {
            deleteGlossaryDialog.dispose();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DeleteGlossaryDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DeleteGlossaryDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("DeleteGlossaryDialog.Date");
            }
            if (n == 2) {
                return Messages.getString("DeleteGlossaryDialog.FileName");
            }
            if (n == 3) {
                return Messages.getString("DeleteGlossaryDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GlossaryDescriptor glossaryDescriptor = (GlossaryDescriptor)DeleteGlossaryDialog.this.elmList.get(n);
            if (n2 == 0) {
                return glossaryDescriptor.isSelected();
            }
            if (n2 == 1) {
                return glossaryDescriptor.getDate();
            }
            if (n2 == 2) {
                return glossaryDescriptor.getFile();
            }
            if (n2 == 3) {
                return glossaryDescriptor.getComments();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                GlossaryDescriptor glossaryDescriptor = (GlossaryDescriptor)DeleteGlossaryDialog.this.elmList.get(n);
                glossaryDescriptor.setSelected((Boolean)object);
                DeleteGlossaryDialog.this.enableDelete();
            }
        }
    }

    private class GlossaryTableModel
    extends AbstractTableModel {
        private GlossaryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DeleteGlossaryDialog.this.glossList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DeleteGlossaryDialog.GlossaryName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GlossaryDescriptor glossaryDescriptor = (GlossaryDescriptor)DeleteGlossaryDialog.this.glossList.get(n);
            if (n2 == 0) {
                return glossaryDescriptor.getName();
            }
            return new Integer(n * n2);
        }
    }

    public class GlossaryDescriptor
    implements Comparable {
        private String name;
        private String id;
        private String ovid;
        private String comments = "";
        private String file;
        private String date;
        private boolean selected = false;

        public GlossaryDescriptor(String string, String string2) {
            this.name = string;
            this.id = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String getOvid() {
            return this.ovid;
        }

        public void setOvid(String string) {
            this.ovid = string;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String string) {
            this.file = string;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String string) {
            this.date = string;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public int compareTo(Object object) {
            return this.getName().compareToIgnoreCase(((GlossaryDescriptor)object).getName());
        }
    }
}

