/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class DeleteDesignsDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable desTable;
    private List elmList;
    private List desList;
    private List allDesigns;
    private Connection connection;
    private JButton bnDelete;
    private static final Logger LOGGER = new Logger(DeleteDesignsDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteDesignsDialog.this.dispose();
        }
    };

    public DeleteDesignsDialog(Frame frame, Connection connection) {
        super(frame, "Select Design and Repository Version");
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        jComponent.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(800, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
    }

    private JPanel init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.desList = new ArrayList();
        this.desTable = new JTable(new DesignTableModel());
        this.desTable.setSelectionMode(0);
        this.desTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = DeleteDesignsDialog.this.desTable.getSelectedRow();
                if (n != -1 && DeleteDesignsDialog.this.desList.size() > 0 && n < DeleteDesignsDialog.this.desList.size()) {
                    DesignDescriptor designDescriptor = (DesignDescriptor)DeleteDesignsDialog.this.desList.get(n);
                    DeleteDesignsDialog.this.loadVersions(designDescriptor);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.desTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(120);
        JScrollPane jScrollPane2 = new JScrollPane(this.jtable);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(220);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnDelete = new JButton(Messages.getString("DeleteDesignsDialog.DeleteSelected"));
        this.bnDelete.setMnemonic(68);
        this.bnDelete.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnDelete.setEnabled(false);
        this.bnDelete.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDesignsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    DeleteDesignsDialog.this.deleteSelectedDesigns();
                }
                finally {
                    DeleteDesignsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                DeleteDesignsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnDelete);
        jPanel.add(this.bnDelete);
        JButton jButton = new JButton(Messages.getString("Cancel"));
        jButton.setMnemonic(67);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDesignsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void loadDesignNames() {
        for (DesignDescriptor designDescriptor : this.allDesigns) {
            DesignDescriptor designDescriptor2 = this.getDesign(this.desList, designDescriptor.getID());
            if (designDescriptor2 != null) continue;
            this.desList.add(designDescriptor);
        }
        Collections.sort(this.desList);
        this.desTable.updateUI();
        if (this.desList.size() > 0) {
            this.desTable.setRowSelectionInterval(0, 0);
        }
    }

    private DesignDescriptor getDesign(List list, String string) {
        for (DesignDescriptor designDescriptor : list) {
            if (!string.equalsIgnoreCase(designDescriptor.getID())) continue;
            return designDescriptor;
        }
        return null;
    }

    private List getDesigns(List list, String string) {
        ArrayList<DesignDescriptor> arrayList = new ArrayList<DesignDescriptor>();
        for (DesignDescriptor designDescriptor : list) {
            if (!string.equalsIgnoreCase(designDescriptor.getID())) continue;
            arrayList.add(designDescriptor);
        }
        return arrayList;
    }

    private void enableDelete() {
        boolean bl = false;
        for (DesignDescriptor designDescriptor : this.allDesigns) {
            if (!designDescriptor.isSelected()) continue;
            bl = true;
            break;
        }
        this.bnDelete.setEnabled(bl);
    }

    private boolean loadDesigns() {
        boolean bl;
        block10: {
            bl = false;
            try {
                this.allDesigns = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float f = SchemaFactory.schemaVersion(this.connection);
                    if (f != 0.0f) {
                        String string = "SELECT Design_ID, Design_OVID, Design_Name, to_char(Date_Published, 'DD.MM.YYYY HH24:MI'), Version_Comments FROM DMRS_Designs ORDER BY Design_ID, Date_Published ASC";
                        try {
                            Statement statement = this.connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string);
                            while (resultSet.next()) {
                                String string2 = resultSet.getString(1);
                                String string3 = resultSet.getString(2);
                                String string4 = resultSet.getString(3);
                                String string5 = resultSet.getString(4);
                                String string6 = resultSet.getString(5);
                                DesignDescriptor designDescriptor = new DesignDescriptor(string4, string2);
                                designDescriptor.setOvid(string3);
                                designDescriptor.setDate(string5);
                                if (string6 != null) {
                                    designDescriptor.setComments(string6);
                                }
                                this.allDesigns.add(designDescriptor);
                            }
                            statement.close();
                            this.loadDesignNames();
                            bl = true;
                        }
                        catch (SQLException sQLException) {}
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteDesignsDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException differentVersionException) {
                    MessageDialogs.showWarningMessage(Messages.getString("DeleteDesignsDialog.DBSchemaOutOfDate"));
                }
                catch (Exception exception) {
                    LOGGER.error("DeleteDesignsDialog.loadDesigns", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteDesignsDialog.UnableToLoadDesigns"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedDesigns() {
        block10: {
            try {
                if (this.connection == null) break block10;
                boolean bl = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                float f = SchemaFactory.schemaVersion(this.connection);
                try {
                    for (DesignDescriptor designDescriptor : this.allDesigns) {
                        if (!designDescriptor.isSelected()) continue;
                        String string = designDescriptor.getOvid();
                        for (String string2 : SchemaFactory.getTableNames(f)) {
                            String string3 = "DELETE FROM " + string2 + " WHERE Design_OVID='" + string + "'";
                            PreparedStatement preparedStatement = this.connection.prepareStatement(string3);
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                        }
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteDesignsDialog.SelectedDesignAreDeleted"));
                }
                catch (Exception exception) {
                    if (this.connection != null) {
                        this.connection.rollback();
                    }
                    LOGGER.error("DeleteDesignsDialog.deleteSelectedDesigns", exception);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteDesignsDialog.UnableToDeleteSelectedDesigns"));
                }
                finally {
                    this.connection.setAutoCommit(bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadVersions(DesignDescriptor designDescriptor) {
        this.elmList.clear();
        try {
            this.elmList.addAll(this.getDesigns(this.allDesigns, designDescriptor.getID()));
            Collections.sort(this.elmList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
    }

    public static void showDialog(Frame frame, Connection connection) {
        DeleteDesignsDialog deleteDesignsDialog = new DeleteDesignsDialog(frame, connection);
        if (deleteDesignsDialog.loadDesigns()) {
            deleteDesignsDialog.setVisible(true);
        } else {
            deleteDesignsDialog.dispose();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DeleteDesignsDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DeleteDesignsDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("DeleteDesignsDialog.Date");
            }
            if (n == 2) {
                return Messages.getString("DeleteDesignsDialog.Name");
            }
            if (n == 3) {
                return Messages.getString("DeleteDesignsDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignDescriptor designDescriptor = (DesignDescriptor)DeleteDesignsDialog.this.elmList.get(n);
            if (n2 == 0) {
                return designDescriptor.isSelected();
            }
            if (n2 == 1) {
                return designDescriptor.getDate();
            }
            if (n2 == 2) {
                return designDescriptor.getName();
            }
            if (n2 == 3) {
                return designDescriptor.getComments();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DesignDescriptor designDescriptor = (DesignDescriptor)DeleteDesignsDialog.this.elmList.get(n);
                designDescriptor.setSelected((Boolean)object);
                DeleteDesignsDialog.this.enableDelete();
            }
        }
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DeleteDesignsDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DeleteDesignsDialog.DesignName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignDescriptor designDescriptor = (DesignDescriptor)DeleteDesignsDialog.this.desList.get(n);
            if (n2 == 0) {
                return designDescriptor.getName();
            }
            return new Integer(n * n2);
        }
    }

    public class DesignDescriptor
    implements Comparable {
        private String name;
        private String id;
        private String ovid;
        private String comments = "";
        private String date;
        private boolean selected = false;

        public DesignDescriptor(String string, String string2) {
            this.name = string;
            this.id = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String getOvid() {
            return this.ovid;
        }

        public void setOvid(String string) {
            this.ovid = string;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String string) {
            this.date = string;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public int compareTo(Object object) {
            return this.getName().compareToIgnoreCase(((DesignDescriptor)object).getName());
        }
    }
}

