/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.udb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardUDB
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardUDB impl;
    protected JTable tbAliases;
    protected JTable tbBufferpools;
    protected JTable tbOwners;
    protected JTable tbUsergroups;
    protected JTable tbProcedures;
    protected JTable tbTablespaces;
    protected JTable tbDatatypes;
    protected JTable tbSummaryTables;
    protected JTable tbStagingTables;
    protected JTable tbTypedTables;
    protected List aliases = new ArrayList();
    protected List bufferpools = new ArrayList();
    protected List owners = new ArrayList();
    protected List usergroups = new ArrayList();
    protected List procedures = new ArrayList();
    protected List tablespaces = new ArrayList();
    protected List datatypes = new ArrayList();
    protected List summarytables = new ArrayList();
    protected List stagingtables = new ArrayList();
    protected List typedtables = new ArrayList();

    public DBMExtractionWizardUDB(DBMExtractionWizard dBMExtractionWizard) {
        super(dBMExtractionWizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard dBMExtractionWizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardUDB(dBMExtractionWizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.summarytables;
            }
            case 2: {
                return this.stagingtables;
            }
            case 3: {
                return this.typedtables;
            }
            case 4: {
                return this.lsViews;
            }
            case 5: {
                return this.aliases;
            }
            case 6: {
                return this.bufferpools;
            }
            case 7: {
                return this.owners;
            }
            case 8: {
                return this.usergroups;
            }
            case 9: {
                return this.procedures;
            }
            case 10: {
                return this.tablespaces;
            }
            case 11: {
                return this.datatypes;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardUDB.Tables"));
            this.tbSummaryTables = this.addTab(this.tbSummaryTables, this.summarytables, Messages.getString("DBMExtractionWizardUDB.SummaryTables"));
            this.tbStagingTables = this.addTab(this.tbStagingTables, this.stagingtables, Messages.getString("DBMExtractionWizardUDB.StagingTables"));
            this.tbTypedTables = this.addTab(this.tbTypedTables, this.typedtables, Messages.getString("DBMExtractionWizardUDB.TypedTables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardUDB.Views"));
            this.tbAliases = this.addTab(this.tbAliases, this.aliases, Messages.getString("DBMExtractionWizardUDB.Aliases"));
            this.tbBufferpools = this.addTab(this.tbBufferpools, this.bufferpools, Messages.getString("DBMExtractionWizardUDB.Bufferpools"));
            this.tbOwners = this.addTab(this.tbOwners, this.owners, Messages.getString("DBMExtractionWizardUDB.Owners"));
            this.tbUsergroups = this.addTab(this.tbUsergroups, this.usergroups, Messages.getString("DBMExtractionWizardUDB.Usergroups"));
            this.tbProcedures = this.addTabProcedure(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardUDB.Procedures"));
            this.tbTablespaces = this.addTab(this.tbTablespaces, this.tablespaces, Messages.getString("DBMExtractionWizardUDB.Tablespaces"));
            this.tbDatatypes = this.addTabDataType(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardUDB.Datatypes"));
        }
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbAliases.updateUI();
        this.tbBufferpools.updateUI();
        this.tbOwners.updateUI();
        this.tbUsergroups.updateUI();
        this.tbProcedures.updateUI();
        this.tbTablespaces.updateUI();
        this.tbDatatypes.updateUI();
        this.tbSummaryTables.updateUI();
        this.tbStagingTables.updateUI();
        this.tbTypedTables.updateUI();
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.aliases.clear();
        this.bufferpools.clear();
        this.owners.clear();
        this.usergroups.clear();
        this.procedures.clear();
        this.tablespaces.clear();
        this.datatypes.clear();
        this.summarytables.clear();
        this.stagingtables.clear();
        this.typedtables.clear();
    }

    @Override
    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (DBObject dBObject : list) {
            String string = dBObject.getType();
            if (string.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("ALIAS")) {
                this.aliases.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("BUFFERPOOL")) {
                this.bufferpools.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("OWNER")) {
                this.owners.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("USERGROUP")) {
                this.usergroups.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("TABLESPACE")) {
                this.tablespaces.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DATATYPE") || string.equalsIgnoreCase("TYPE")) {
                this.datatypes.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("SUMMARY TABLE")) {
                this.summarytables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("STAGING TABLE")) {
                this.stagingtables.add(dBObject);
                continue;
            }
            if (!string.equalsIgnoreCase("TYPED TABLE")) continue;
            this.typedtables.add(dBObject);
        }
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : this.lsTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsViews) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.aliases) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.bufferpools) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.owners) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.usergroups) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.procedures) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.tablespaces) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.datatypes) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.summarytables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.stagingtables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.typedtables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    protected JTable addTabProcedure(JTable jTable, List list, String string) {
        jTable = new JTable(new ProcedureModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(60);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    protected JTable addTabDataType(JTable jTable, List list, String string) {
        jTable = new JTable(new DataTypeModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(60);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    class DataTypeModel
    extends AbstractTableModel {
        List list;

        public DataTypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardUDB.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardUDB.Schema");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardUDB.ObjectName");
            }
            if (n == 3) {
                return Messages.getString("DBMExtractionWizardUDB.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getSchema();
                }
                case 2: {
                    return dBObject.getName();
                }
                case 3: {
                    return dBObject.getSpecificName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                DBMExtractionWizardUDB.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }

    class ProcedureModel
    extends AbstractTableModel {
        List list;

        public ProcedureModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardUDB.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardUDB.Schema");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardUDB.ObjectName");
            }
            if (n == 3) {
                return Messages.getString("DBMExtractionWizardUDB.SpecificName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getSchema();
                }
                case 2: {
                    return dBObject.getName();
                }
                case 3: {
                    return dBObject.getSpecificName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                DBMExtractionWizardUDB.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }
}

