/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;
import oracle.dbtools.crest.util.MessageDialogs;

public class DBMExtractionWizardSqlServer
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardSqlServer impl;
    protected JTable tbLogins;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbRules;
    protected JTable tbDefaults;
    protected JTable tbProcedures;
    protected JTable tbDatatypes;
    protected List logins = new ArrayList();
    protected List users = new ArrayList();
    protected List roles = new ArrayList();
    protected List rules = new ArrayList();
    protected List defaults = new ArrayList();
    protected List procedures = new ArrayList();
    protected List datatypes = new ArrayList();
    protected List databases = new ArrayList();

    private DBMExtractionWizardSqlServer(DBMExtractionWizard dBMExtractionWizard) {
        super(dBMExtractionWizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard dBMExtractionWizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardSqlServer(dBMExtractionWizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected void selectAll(JTable jTable, List<DBObject> list, boolean bl) {
        for (DBObject dBObject : list) {
            dBObject.setSelected(bl);
        }
    }

    @Override
    public JPanel getSecondTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new SchemaTable();
        this.tbSchemas.setModel(new SchemasModel());
        TableColumn tableColumn = this.tbSchemas.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(this.tbSchemas);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("DBMExtractionWizardSqlServer.SelectAll"));
        jButton.setMnemonic(83);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.tbSchemas, DBMExtractionWizardSqlServer.this.lsSchemas, true);
            }
        });
        JButton jButton2 = new JButton(Messages.getString("DBMExtractionWizardSqlServer.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.tbSchemas, DBMExtractionWizardSqlServer.this.lsSchemas, false);
            }
        });
        this.chAllSelected = new JCheckBox(Messages.getString("DBMExtractionWizardSqlServer.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("DBMExtractionWizardSqlServer.DefaultSelectionStatus"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionHandler.setAllSelected(DBMExtractionWizardSqlServer.this.chAllSelected.isSelected());
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(this.chAllSelected);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public JPanel getThirdTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("DBMExtractionWizardSqlServer.SelectAll"));
        jButton.setMnemonic(83);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.getCurrentTable(), DBMExtractionWizardSqlServer.this.getCurrentList(), true);
            }
        });
        JButton jButton2 = new JButton(Messages.getString("DBMExtractionWizardSqlServer.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardSqlServer.this.checkAll(DBMExtractionWizardSqlServer.this.getCurrentTable(), DBMExtractionWizardSqlServer.this.getCurrentList(), false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.logins;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.roles;
            }
            case 5: {
                return this.rules;
            }
            case 6: {
                return this.defaults;
            }
            case 7: {
                return this.procedures;
            }
        }
        return this.datatypes;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardSqlServer.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardSqlServer.Views"));
            this.tbLogins = this.addLoginTab(this.tbLogins, this.logins, Messages.getString("DBMExtractionWizardSqlServer.Logins"));
            this.tbUsers = this.addUserTab(this.tbUsers, this.users, Messages.getString("DBMExtractionWizardSqlServer.Users"));
            this.tbRoles = this.addUserTab(this.tbRoles, this.roles, Messages.getString("DBMExtractionWizardSqlServer.Roles"));
            this.tbRules = this.addTab(this.tbRules, this.rules, Messages.getString("DBMExtractionWizardSqlServer.Rules"));
            this.tbDefaults = this.addTab(this.tbDefaults, this.defaults, Messages.getString("DBMExtractionWizardSqlServer.Defaults"));
            this.tbProcedures = this.addTab(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardSqlServer.Procedures"));
            this.tbDatatypes = this.addTab(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardSqlServer.Datatypes"));
        }
    }

    @Override
    protected JTable addTab(JTable jTable, List list, String string) {
        jTable = new JTable(new ObjectModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    protected JTable addLoginTab(JTable jTable, List list, String string) {
        jTable = new JTable(new LoginModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    protected JTable addUserTab(JTable jTable, List list, String string) {
        jTable = new JTable(new UserModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(60);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(250);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbLogins.updateUI();
        this.tbUsers.updateUI();
        this.tbRoles.updateUI();
        this.tbRules.updateUI();
        this.tbDefaults.updateUI();
        this.tbProcedures.updateUI();
        this.tbDatatypes.updateUI();
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.logins.clear();
        this.users.clear();
        this.roles.clear();
        this.rules.clear();
        this.defaults.clear();
        this.procedures.clear();
        this.datatypes.clear();
    }

    @Override
    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (DBObject dBObject : list) {
            String string = dBObject.getType();
            if (string.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("LOGIN")) {
                this.logins.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("USER")) {
                this.users.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("ROLE")) {
                this.roles.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("RULE")) {
                this.rules.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DEFAULT")) {
                this.defaults.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dBObject);
                continue;
            }
            if (!string.equalsIgnoreCase("DATATYPE")) continue;
            this.datatypes.add(dBObject);
        }
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : this.lsSchemas) {
            if (dBObject.isSelected() && dBObject.getType().equalsIgnoreCase("DATABASE")) {
                DBObjectSqlServer dBObjectSqlServer = new DBObjectSqlServer(dBObject.isSelected(), dBObject.getName(), dBObject.getType());
                arrayList.add(dBObjectSqlServer);
            }
            if (!dBObject.isSelected() || !dBObject.getType().equalsIgnoreCase("SCHEMA")) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsViews) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.logins) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.users) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.roles) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.rules) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.defaults) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.procedures) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.datatypes) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    class PlainLabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PlainLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            this.setFont(this.getFont().deriveFont(0));
            return this;
        }
    }

    class BoldLabelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BoldLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            this.setFont(this.getFont().deriveFont(1));
            return this;
        }
    }

    class UserModel
    extends AbstractTableModel {
        List list;

        public UserModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Database");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObjectSqlServer.isSelected();
                }
                case 1: {
                    return dBObjectSqlServer.getDb();
                }
                case 2: {
                    return dBObjectSqlServer.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
                DBMExtractionWizardSqlServer.this.setSelected(dBObjectSqlServer, (Boolean)object);
            }
        }
    }

    class LoginModel
    extends AbstractTableModel {
        List list;

        public LoginModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.LoginName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObjectSqlServer.isSelected();
                }
                case 1: {
                    return dBObjectSqlServer.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
                DBMExtractionWizardSqlServer.this.setSelected(dBObjectSqlServer, (Boolean)object);
            }
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Database");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.User");
            }
            if (n == 3) {
                return Messages.getString("DBMExtractionWizardSqlServer.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObjectSqlServer.isSelected();
                }
                case 1: {
                    return dBObjectSqlServer.getDb();
                }
                case 2: {
                    return dBObjectSqlServer.getSchema();
                }
                case 3: {
                    return dBObjectSqlServer.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObjectSqlServer dBObjectSqlServer = (DBObjectSqlServer)this.list.get(n);
                DBMExtractionWizardSqlServer.this.setSelected(dBObjectSqlServer, (Boolean)object);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardSqlServer.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardSqlServer.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardSqlServer.Name");
            }
            if (n == 2) {
                return Messages.getString("DBMExtractionWizardSqlServer.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)DBMExtractionWizardSqlServer.this.lsSchemas.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getName();
                }
                case 2: {
                    return dBObject.getType();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)DBMExtractionWizardSqlServer.this.lsSchemas.get(n);
                DBMExtractionWizardSqlServer.this.setSelected(dBObject, (Boolean)object);
                boolean bl = (Boolean)object;
                if (dBObject.getType().equalsIgnoreCase("Database")) {
                    this.setSelectedUsers(bl, (String)this.getValueAt(n, 1));
                    DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                } else {
                    DBUserSqlServer dBUserSqlServer = (DBUserSqlServer)dBObject;
                    if (!bl) {
                        this.selectDb(dBUserSqlServer.getDb(), false);
                        DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                    } else if (this.allSelectedUsersForDB(dBUserSqlServer.getDb())) {
                        this.selectDb(dBUserSqlServer.getDb(), true);
                        DBMExtractionWizardSqlServer.this.tbSchemas.repaint();
                    }
                }
            }
        }

        private boolean allSelectedUsersForDB(String string) {
            for (DBObject dBObject : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!(dBObject instanceof DBUserSqlServer) || !((DBUserSqlServer)dBObject).getDb().equalsIgnoreCase(string) || dBObject.isSelected()) continue;
                return false;
            }
            return true;
        }

        private void selectDb(String string, boolean bl) {
            for (DBObject dBObject : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!dBObject.getType().equalsIgnoreCase("Database") || !dBObject.getName().equalsIgnoreCase(string)) continue;
                DBMExtractionWizardSqlServer.this.setSelected(dBObject, bl);
            }
        }

        private void setSelectedUsers(boolean bl, String string) {
            for (DBObject dBObject : DBMExtractionWizardSqlServer.this.lsSchemas) {
                if (!(dBObject instanceof DBUserSqlServer) || !((DBUserSqlServer)dBObject).getDb().equalsIgnoreCase(string)) continue;
                DBMExtractionWizardSqlServer.this.setSelected(dBObject, bl);
            }
        }
    }

    class SchemaTable
    extends JTable {
        SchemaTable() {
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 1) {
                if (((String)this.getValueAt(n, 2)).equalsIgnoreCase("Database")) {
                    return new BoldLabelCellRenderer();
                }
                return new PlainLabelCellRenderer();
            }
            return super.getCellRenderer(n, n2);
        }
    }
}

