/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardDB2
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardDB2 impl;
    protected JTable tbAliases;
    protected JTable tbAuxTables;
    protected JTable tbDatabases;
    protected JTable tbTablespaces;
    protected JTable tbOwners;
    protected JTable tbStorageGroups;
    protected JTable tbProcedures;
    protected JTable tbDatatypes;
    protected List aliases = new ArrayList();
    protected List auxTables = new ArrayList();
    protected List databases = new ArrayList();
    protected List tablespaces = new ArrayList();
    protected List owners = new ArrayList();
    protected List storageGroups = new ArrayList();
    protected List procedures = new ArrayList();
    protected List datatypes = new ArrayList();

    public DBMExtractionWizardDB2(DBMExtractionWizard dBMExtractionWizard) {
        super(dBMExtractionWizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard dBMExtractionWizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardDB2(dBMExtractionWizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    public JPanel getSecondTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new JTable(new SchemasModel());
        TableColumn tableColumn = this.tbSchemas.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane(this.tbSchemas);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(Messages.getString("DBMExtractionWizardDB2.SelectAll"));
        jButton.setMnemonic(83);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardDB2.this.checkAll(DBMExtractionWizardDB2.this.tbSchemas, DBMExtractionWizardDB2.this.lsSchemas, true);
            }
        });
        JButton jButton2 = new JButton(Messages.getString("DBMExtractionWizardDB2.DeselectAll"));
        jButton2.setMnemonic(68);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMExtractionWizardDB2.this.checkAll(DBMExtractionWizardDB2.this.tbSchemas, DBMExtractionWizardDB2.this.lsSchemas, false);
            }
        });
        this.chAllSelected = new JCheckBox(Messages.getString("DBMExtractionWizardDB2.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("DBMExtractionWizardDB2.DefaultSelectionStatus"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDBMExtractionHandler.setAllSelected(DBMExtractionWizardDB2.this.chAllSelected.isSelected());
            }
        });
        Dimension dimension = new Dimension(120, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(this.chAllSelected);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    protected void selectAll(JTable jTable, List<DBObject> list, boolean bl) {
        for (DBObject dBObject : list) {
            dBObject.setSelected(bl);
        }
    }

    @Override
    protected List getCurrentList() {
        int n = this.getTabbedPane().getSelectedIndex();
        switch (n) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.aliases;
            }
            case 3: {
                return this.auxTables;
            }
            case 4: {
                return this.databases;
            }
            case 5: {
                return this.tablespaces;
            }
            case 6: {
                return this.owners;
            }
            case 7: {
                return this.storageGroups;
            }
            case 8: {
                return this.procedures;
            }
            case 9: {
                return this.datatypes;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        if (this.tbTables == null) {
            this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardDB2.Tables"));
            this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardDB2.Views"));
            this.tbAliases = this.addTab(this.tbAliases, this.aliases, Messages.getString("DBMExtractionWizardDB2.Aliases"));
            this.tbAuxTables = this.addTab(this.tbAuxTables, this.auxTables, Messages.getString("DBMExtractionWizardDB2.AuxTables"));
            this.tbDatabases = this.addTab(this.tbDatabases, this.databases, Messages.getString("DBMExtractionWizardDB2.Databases"));
            this.tbTablespaces = this.addTab(this.tbTablespaces, this.tablespaces, Messages.getString("DBMExtractionWizardDB2.Tablespaces"));
            this.tbOwners = this.addOwnerTab(this.tbOwners, this.owners, Messages.getString("DBMExtractionWizardDB2.Owners"));
            this.tbStorageGroups = this.addTab(this.tbStorageGroups, this.storageGroups, Messages.getString("DBMExtractionWizardDB2.StorageGroups"));
            this.tbProcedures = this.addTab(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardDB2.Procedures"));
            this.tbDatatypes = this.addTab(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardDB2.Datatypes"));
        }
    }

    protected JTable addOwnerTab(JTable jTable, List list, String string) {
        jTable = new JTable(new OwnerModel(list));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(250);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getTabbedPane().addTab(string, jScrollPane);
        return jTable;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbAliases.updateUI();
        this.tbAuxTables.updateUI();
        this.tbDatabases.updateUI();
        this.tbTablespaces.updateUI();
        this.tbOwners.updateUI();
        this.tbStorageGroups.updateUI();
        this.tbProcedures.updateUI();
        this.tbDatatypes.updateUI();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : this.lsTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.lsViews) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.aliases) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.auxTables) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.databases) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.tablespaces) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.owners) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.storageGroups) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.procedures) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        for (DBObject dBObject : this.datatypes) {
            if (!dBObject.isSelected()) continue;
            arrayList.add(dBObject);
        }
        return arrayList;
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.aliases.clear();
        this.auxTables.clear();
        this.databases.clear();
        this.tablespaces.clear();
        this.owners.clear();
        this.storageGroups.clear();
        this.procedures.clear();
        this.datatypes.clear();
    }

    @Override
    protected void initSpecificObjects(List list) {
        this.clearAll();
        for (DBObject dBObject : list) {
            String string = dBObject.getType();
            if (string.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("ALIAS")) {
                this.aliases.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("AUX TABLE")) {
                this.auxTables.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DATABASE")) {
                this.databases.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("TABLESPACE")) {
                this.tablespaces.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("STORAGE GROUP")) {
                this.storageGroups.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dBObject);
                continue;
            }
            if (string.equalsIgnoreCase("DATATYPE")) {
                this.datatypes.add(dBObject);
                continue;
            }
            if (!string.equalsIgnoreCase("OWNER")) continue;
            this.owners.add(dBObject);
        }
    }

    class OwnerModel
    extends AbstractTableModel {
        List list;

        public OwnerModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardDB2.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardDB2.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardDB2.Owner");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)this.list.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)this.list.get(n);
                DBMExtractionWizardDB2.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        List list;

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardDB2.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DBMExtractionWizardDB2.Selected");
            }
            if (n == 1) {
                return Messages.getString("DBMExtractionWizardDB2.Owner");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBObject dBObject = (DBObject)DBMExtractionWizardDB2.this.lsSchemas.get(n);
            switch (n2) {
                case 0: {
                    return dBObject.isSelected();
                }
                case 1: {
                    return dBObject.getName();
                }
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DBObject dBObject = (DBObject)DBMExtractionWizardDB2.this.lsSchemas.get(n);
                DBMExtractionWizardDB2.this.setSelected(dBObject, (Boolean)object);
            }
        }
    }
}

