/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.cwddesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CWDOptionDialog
extends JDialog {
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    public static final int NOT_IMPORT = 0;
    public static final int USE_DESIGN_NAME = 1;
    public static final int USE_CUSTOM = 2;
    private static int action = 1;
    private int result = 0;
    private JPanel generalPanel;
    private JTextField tfCustomPrefix;
    private AbstractButton radioNotImport;
    private JRadioButton radioUseDesign;
    private JRadioButton radioPrefix;
    private String customPrefix;
    private List modelArray = new ArrayList();
    private ButtonGroup searchGroup;
    private ApplicationView view;

    public CWDOptionDialog(ApplicationView applicationView) {
        super(applicationView.getFrame());
        this.setTitle(Messages.getString("CWDOptionDialog.OptionDialog"));
        this.setDefaultCloseOperation(2);
        this.view = applicationView;
        this.getContentPane().add((Component)this.initMainPanel(), "Center");
        this.getContentPane().add((Component)this.initBottomPanel(), "South");
        this.disablePrefix();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
    }

    private void disablePrefix() {
        this.tfCustomPrefix.setEnabled(false);
    }

    private void enablePrefix() {
        this.tfCustomPrefix.setEnabled(true);
    }

    private JPanel initMainPanel() {
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new SpringLayout());
        this.generalPanel.setPreferredSize(new Dimension(300, 150));
        JLabel jLabel = new JLabel(Messages.getString("CWDOptionDialog.ChooseActionDuplicateName"));
        this.generalPanel.add(jLabel);
        this.radioNotImport = new JRadioButton(Messages.getString("CWDOptionDialog.DoNotImportObjects"));
        this.radioNotImport.setSelected(true);
        this.radioNotImport.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioNotImport.getModel());
        this.radioUseDesign = new JRadioButton(Messages.getString("CWDOptionDialog.UseDesignNameForPrefix"));
        this.radioUseDesign.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioUseDesign.getModel());
        this.radioPrefix = new JRadioButton(Messages.getString("CWDOptionDialog.UseCustomPrefix"));
        this.radioPrefix.addActionListener(new PrefixListener());
        this.modelArray.add(this.radioPrefix.getModel());
        SpringLayout.Constraints constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(jLabel);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(10));
        this.generalPanel.add(this.radioNotImport);
        constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioNotImport);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(45));
        this.generalPanel.add(this.radioUseDesign);
        constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioUseDesign);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(65));
        this.generalPanel.add(this.radioPrefix);
        constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.radioPrefix);
        constraints.setX(Spring.constant(10));
        constraints.setY(Spring.constant(85));
        this.searchGroup = new ButtonGroup();
        this.searchGroup.add(this.radioNotImport);
        this.searchGroup.add(this.radioUseDesign);
        this.searchGroup.add(this.radioPrefix);
        JLabel jLabel2 = new JLabel(Messages.getString("CWDOptionDialog.Prefix"));
        jLabel2.setPreferredSize(new Dimension(80, 20));
        this.generalPanel.add(jLabel2);
        constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(jLabel2);
        constraints.setX(Spring.constant(40));
        constraints.setY(Spring.constant(115));
        this.tfCustomPrefix = new JTextField();
        this.tfCustomPrefix.setPreferredSize(new Dimension(150, 20));
        this.generalPanel.add(this.tfCustomPrefix);
        constraints = ((SpringLayout)this.generalPanel.getLayout()).getConstraints(this.tfCustomPrefix);
        constraints.setX(Spring.constant(90));
        constraints.setY(Spring.constant(115));
        return this.generalPanel;
    }

    protected JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    protected JPanel initBottomPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("CWDOptionDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new OKAction());
        JButton jButton2 = new JButton(Messages.getString("CWDOptionDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        Dimension dimension = new Dimension(80, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public void initProperties(String string) {
        this.customPrefix = string;
        this.searchGroup.setSelected((ButtonModel)this.modelArray.get(this.view.getSettings().getRenameStrategy()), true);
        this.tfCustomPrefix.setText(string);
        this.tfCustomPrefix.setEnabled(this.radioPrefix.isSelected());
    }

    private void saveProperties() throws EmptyFieldException {
        if (this.radioPrefix.isSelected()) {
            if (!this.isEmpty(this.tfCustomPrefix.getText())) {
                this.customPrefix = this.tfCustomPrefix.getText();
                action = 2;
            }
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioPrefix.getModel()));
        } else if (this.radioUseDesign.isSelected()) {
            action = 1;
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioUseDesign.getModel()));
        } else if (this.radioNotImport.isSelected()) {
            action = 0;
            this.view.getSettings().setRenameStrategy(this.modelArray.indexOf(this.radioNotImport.getModel()));
        }
    }

    private boolean isEmpty(String string) {
        return "".equalsIgnoreCase(string);
    }

    public static int getAction() {
        return action;
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    public void setCustomPrefix(String string) {
        this.customPrefix = string;
    }

    public Design getDesign() {
        return this.view.getCurrentDesign();
    }

    public class PrefixListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CWDOptionDialog.this.radioPrefix.isSelected()) {
                CWDOptionDialog.this.enablePrefix();
            } else {
                CWDOptionDialog.this.disablePrefix();
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CWDOptionDialog.this.result = 0;
            CWDOptionDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CWDOptionDialog.this.saveProperties();
                CWDOptionDialog.this.result = 1;
                CWDOptionDialog.this.dispose();
            }
            catch (EmptyFieldException emptyFieldException) {
                JOptionPane.showMessageDialog(CWDOptionDialog.this, emptyFieldException.getMessage(), Messages.getString("CWDOptionDialog.Error"), 0);
            }
        }
    }
}

