/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TypesToDomainsDialog
extends CustomDialog {
    private JDialog dialog;
    private String title;
    private Design design;
    private List<DesignWrapper> designs = new ArrayList<DesignWrapper>();
    private JTable table;
    private JCheckBox chbCreateNewDomains;
    private DomainFactory domainFactory = new DomainFactory();

    public TypesToDomainsDialog(ApplicationView applicationView, String string) {
        super(applicationView);
        this.design = applicationView.getCurrentDesign();
        this.title = string;
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createTable());
        jScrollPane.setPreferredSize(new Dimension(500, 410));
        jPanel.add((Component)jScrollPane, "Center");
        this.chbCreateNewDomains = new JCheckBox(Messages.getString("TypesToDomainsDialog.CreateNewDomains"));
        this.chbCreateNewDomains.setSelected(true);
        jPanel.add((Component)this.chbCreateNewDomains, "South");
        this.add((Component)jPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JTable createTable() {
        this.readDesigns();
        this.table = new JTable(new TableModel());
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(60);
        tableColumn.setMinWidth(50);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(90);
        tableColumn.setMaxWidth(100);
        tableColumn.setMinWidth(50);
        return this.table;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "TYPES_TO_DOMAINS_WIZARD";
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("TypesToDomainsDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypesToDomainsDialog.this.convertTypesToDomains();
                TypesToDomainsDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("TypesToDomainsDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypesToDomainsDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void readDesigns() {
        this.designs.add(new DesignWrapper(this.design.getLogicalDesign()));
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            this.designs.add(new DesignWrapper((RelationalDesign)iterator.next()));
        }
    }

    private void convertTypesToDomains() {
        for (DesignWrapper designWrapper : this.designs) {
            if (!designWrapper.selected) continue;
            if (designWrapper.designPart instanceof LogicalDesign) {
                this.convertTypesToDomains((LogicalDesign)designWrapper.designPart);
                continue;
            }
            this.convertTypesToDomains((RelationalDesign)designWrapper.designPart);
        }
    }

    private void convertTypesToDomains(LogicalDesign logicalDesign) {
        Iterator iterator = logicalDesign.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.getUse() != 1 || attribute.isFKAttribute()) continue;
            attribute.setDomain(this.getDomain(attribute));
            attribute.setUse((short)0);
            attribute.setDirty(true);
        }
    }

    private void convertTypesToDomains(RelationalDesign relationalDesign) {
        Iterator iterator = relationalDesign.getColumnSet().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (column.getUse() != 1 || column.isFKColumn()) continue;
            column.setDomain(this.getDomain(column));
            column.setUse((short)0);
            column.setDirty(true);
        }
    }

    private Domain getDomain(ContainedObjectWithDomain containedObjectWithDomain) {
        if (this.chbCreateNewDomains.isSelected()) {
            return this.createDomain(containedObjectWithDomain, false);
        }
        Domain domain = this.getCorrespondingDomain(containedObjectWithDomain);
        return domain != null ? domain : this.createDomain(containedObjectWithDomain, true);
    }

    private Domain getCorrespondingDomain(ContainedObjectWithDomain containedObjectWithDomain) {
        DomainSet domainSet = this.design.getDomainSet();
        if (!domainSet.isEmpty()) {
            String string;
            String string2;
            LogicalDatatype logicalDatatype = containedObjectWithDomain.getLogicalDatatype();
            String string3 = containedObjectWithDomain.getSize();
            if (!StringUtilities.isNotEmpty(string3)) {
                string3 = (String)logicalDatatype.getLTDefaultValues().get("size_default_value");
            }
            if (!StringUtilities.isNotEmpty(string2 = containedObjectWithDomain.getPrecision())) {
                string2 = (String)logicalDatatype.getLTDefaultValues().get("precision_default_value");
            }
            if (!StringUtilities.isNotEmpty(string = containedObjectWithDomain.getScale())) {
                string = (String)logicalDatatype.getLTDefaultValues().get("scale_default_value");
            }
            String string4 = containedObjectWithDomain.getDefaultValue();
            Iterator iterator = domainSet.iterator();
            while (iterator.hasNext()) {
                Domain domain = (Domain)iterator.next();
                if (!domain.getLogicalDatatype().equals(logicalDatatype) || !domain.getSize().equals(string3) || !domain.getPrecision().equals(string2) || !domain.getScale().equals(string) || domain.getValueList() != null || domain.getCheck() != null || !domain.getAVTList().isEmpty() || !"".equals(domain.getDefaultValue()) && !string4.equals(domain.getDefaultValue())) continue;
                return domain;
            }
        }
        return null;
    }

    private Domain createDomain(ContainedObjectWithDomain containedObjectWithDomain, boolean bl) {
        ModelObject modelObject;
        LogicalDatatype logicalDatatype = containedObjectWithDomain.getLogicalDatatype();
        String[] stringArray = new String[]{containedObjectWithDomain.getScale(), containedObjectWithDomain.getPrecision(), containedObjectWithDomain.getSize()};
        String string = DomainFactory.createDomainName(logicalDatatype, stringArray);
        if ((bl || containedObjectWithDomain.getValueList() != null || containedObjectWithDomain.getCheck() != null || !containedObjectWithDomain.getAVTList().isEmpty()) && ((DesignObjectSet)(modelObject = this.design.getDomainSet())).containsName(string)) {
            string = ((DesignObjectSet)modelObject).createNameVariant(string);
        }
        modelObject = this.domainFactory.getInstance(containedObjectWithDomain.getDesign(), logicalDatatype, null, 1, stringArray, string);
        boolean bl2 = false;
        if (containedObjectWithDomain.getValueList() != null) {
            ((Domain)modelObject).setValueList(containedObjectWithDomain.getValueList());
            bl2 = true;
        }
        if (containedObjectWithDomain.getCheck() != null) {
            ((Domain)modelObject).setCheck(containedObjectWithDomain.getCheck());
            bl2 = true;
        }
        if (!containedObjectWithDomain.getAVTList().isEmpty()) {
            ((Domain)modelObject).applyAVTList(containedObjectWithDomain.getAVTList());
            bl2 = true;
        }
        if (!"".equals(containedObjectWithDomain.getDefaultValue())) {
            ((Domain)modelObject).setDefaultValue(containedObjectWithDomain.getDefaultValue());
        }
        if (bl2) {
            containedObjectWithDomain.setUseDomainConstraints(true);
        }
        return modelObject;
    }

    private class DesignWrapper {
        private DesignPart designPart;
        private boolean selected;

        DesignWrapper(DesignPart designPart) {
            this.designPart = designPart;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("TypesToDomainsDialog.Selected"), Messages.getString("TypesToDomainsDialog.ModelType"), Messages.getString("TypesToDomainsDialog.Model")};

        private TableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TypesToDomainsDialog.this.designs.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 <= 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignWrapper designWrapper = (DesignWrapper)TypesToDomainsDialog.this.designs.get(n);
            DesignPart designPart = designWrapper.designPart;
            if (n2 == 1) {
                return designPart instanceof LogicalDesign ? Messages.getString("TypesToDomainsDialog.Logical") : Messages.getString("TypesToDomainsDialog.Relational");
            }
            if (n2 == 2) {
                return designPart.getName();
            }
            if (n2 == 0) {
                return designWrapper.selected;
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ((DesignWrapper)TypesToDomainsDialog.this.designs.get(n)).selected = (Boolean)object;
            }
        }
    }
}

