/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.wizards.CustomTBModel;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class Table2ViewDialog
extends CustomDialog {
    private JButton btnGenerate;
    private JButton btnClose;
    private JComboBox cmbRelationals;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private JScrollPane spnTables;
    private JTable tblTables;
    private String title;
    private JDialog dialog;
    private static final Logger LOGGER = new Logger(Table2ViewDialog.class);
    private JTextField tfNamingRule;
    private JButton btnAddVariable;

    public Table2ViewDialog(ApplicationView applicationView, String string) {
        super(applicationView);
        this.title = string;
        this.setLayout(new BorderLayout());
        this.cmbRelationals = new JComboBox();
        this.bnSelectAll = new JButton(Messages.getString("Table2ViewDialog.SelectAll"));
        this.bnSelectAll.setMnemonic(65);
        this.bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_160);
        this.bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table2ViewDialog.this.selectAllRows(true);
            }
        });
        this.bnDeselectAll = new JButton(Messages.getString("Table2ViewDialog.DeselectAll"));
        this.bnDeselectAll.setMnemonic(68);
        this.bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table2ViewDialog.this.selectAllRows(false);
            }
        });
        this.spnTables = new JScrollPane();
        this.tblTables = new JTable();
        this.add((Component)this.makeTopPanel(), "North");
        this.add(this.makeCenterPanel(), "Center");
        this.add(this.makeDialogButtonsPanel(), "South");
    }

    @Override
    protected String getHelpIndex() {
        return "TABLE_TO_VIEW_WIZARD";
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.addListeners();
            this.dialog.setResizable(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.refreshComponents();
        this.getDialog().setVisible(true);
    }

    private void refreshComponents() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cmbRelationals.getModel();
        ActionListener[] actionListenerArray = this.cmbRelationals.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.cmbRelationals.removeActionListener(actionListenerArray[i]);
        }
        defaultComboBoxModel.removeAllElements();
        Object[] objectArray = this.getApplicationView().getCurrentDesign().getRelationalDesigns().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultComboBoxModel.addElement(objectArray[i]);
        }
        this.cmbRelationals.setEditable(false);
        RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
        this.tblTables.setModel(new CustomTBModel(relationalDesign.getTableSet()));
        this.setTableWidths();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.cmbRelationals.addActionListener(actionListenerArray[i]);
        }
        this.handleGenerateButton();
    }

    private void addListeners() {
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table2ViewDialog.this.close();
            }
        });
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table2ViewDialog.this.generateViews();
            }
        });
        this.cmbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Table2ViewDialog.this.loadNewTableSet();
            }
        });
    }

    protected void loadNewTableSet() {
        try {
            RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
            CustomTBModel customTBModel = new CustomTBModel(relationalDesign.getTableSet());
            this.tblTables.setModel(customTBModel);
            this.setTableWidths();
            this.handleGenerateButton();
        }
        catch (ClassCastException classCastException) {
            LOGGER.error("ERROR::Table2ViewDialog::loadNewTableSet() -> ClassCastException", classCastException);
        }
    }

    protected void selectAllRows(boolean bl) {
        CustomTBModel customTBModel = (CustomTBModel)this.tblTables.getModel();
        int n = customTBModel != null ? customTBModel.getRowCount() : 0;
        for (int i = 0; i < n; ++i) {
            customTBModel.setValueAt(new Boolean(bl), i, 0);
        }
        this.tblTables.invalidate();
        this.tblTables.repaint();
        this.handleGenerateButton();
    }

    private void handleGenerateButton() {
        CustomTBModel customTBModel = (CustomTBModel)this.tblTables.getModel();
        int n = customTBModel != null ? customTBModel.getRowCount() : 0;
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)customTBModel.getValueAt(i, 0);
            if (!bl.booleanValue()) continue;
            this.btnGenerate.setEnabled(true);
            return;
        }
        this.btnGenerate.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateViews() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationView.canLogging = false;
        try {
            CustomTBModel customTBModel = (CustomTBModel)this.tblTables.getModel();
            int n = customTBModel != null ? customTBModel.getRowCount() : 0;
            Boolean bl = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                Object object2;
                for (int i = 0; i < n; ++i) {
                    bl = (Boolean)customTBModel.getValueAt(i, 0);
                    if (!bl.booleanValue()) continue;
                    arrayList.add(customTBModel.getElementAt(i, 1));
                }
                RelationalDesign relationalDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
                ArrayList<TableView> arrayList2 = new ArrayList<TableView>();
                for (Object object2 : arrayList) {
                    arrayList2.add(this.addView((Table)object2, relationalDesign, new Rectangle(0, 0)));
                }
                object2 = relationalDesign.getMainView().getWorkSpace().getDiagramBounds();
                if (object2 != null) {
                    Rectangle rectangle = ((RectangularShape)object2).getBounds();
                    this.rearrangeViews(rectangle, arrayList2);
                }
                relationalDesign.setDirty(true);
                JOptionPane.showMessageDialog(this, Messages.getString("Table2ViewDialog.ViewsGeneratedSuccessfully"));
            }
            catch (ClassCastException classCastException) {
                LOGGER.error("ERROR::Table2ViewDialog::generateViews() -> ClassCastException", classCastException);
                JOptionPane.showMessageDialog(this, Messages.getString("Table2ViewDialog.ErrorOccuredWhileGeneratingViews"));
                ApplicationView.canLogging = true;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        finally {
            ApplicationView.canLogging = true;
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void rearrangeViews(Rectangle rectangle, List list) {
        int n = 20;
        int n2 = 50;
        int n3 = 50;
        int n4 = 200;
        int n5 = 80;
        int n6 = n;
        int n7 = (int)Math.round(rectangle.getMaxY()) + n3;
        int n8 = 0;
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            n8 = 0;
            int n9 = ((int)rectangle.getMaxX() - n) / (n4 + n2);
            if (n9 > n4) {
                ++n9;
            }
            int n10 = (int)Math.floor(n9);
            while (iterator.hasNext()) {
                TableView tableView = (TableView)iterator.next();
                TopView topView = tableView.getTopView();
                if (topView == null) continue;
                ++n8;
                Rectangle rectangle2 = topView.getBounds();
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(n6, n7, rectangle2.width, rectangle2.height));
                }
                n6 = n6 + rectangle2.width + n2;
                n5 = Math.max(n5, rectangle2.height);
                if (n8 != n10) continue;
                n8 = 0;
                n6 = n;
                n7 = n7 + n5 + n3;
                n5 = 80;
            }
        }
    }

    private TableView addView(Table table, RelationalDesign relationalDesign, Rectangle rectangle) {
        ObjectListener objectListener2;
        TableView tableView = relationalDesign.getTableViewSet().createTableView(null);
        String string = ApplyNamingStandards.createView_Name(table.getName(), this.tfNamingRule.getText(), table.getDesignPart().getName(), table.getAbbreviation());
        this.getApplicationView().getSettings().setViewNamingRule(this.tfNamingRule.getText());
        ApplicationView.log(Messages.getString("Table2ViewDialog.CreateView") + " - " + string);
        tableView.setName(string);
        tableView.addToContainers(table, "");
        for (ObjectListener objectListener2 : table.getElementsCollection()) {
            tableView.add((ContainedObject)objectListener2);
        }
        objectListener2 = relationalDesign.getMainView().getViewFor(tableView);
        Dimension dimension = relationalDesign.getTableSize(table);
        if (objectListener2 != null && ((TopView)objectListener2).getCellView() != null) {
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
            ((TopView)objectListener2).getCellView().setNewBounds(rectangle);
        }
        return tableView;
    }

    private Component makeCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.makeTable(), "Center");
        jPanel.add((Component)this.makeNamingRule(), "South");
        return jPanel;
    }

    private Component makeDialogButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.btnGenerate = new JButton(Messages.getString("Table2ViewDialog.Generate"));
        this.btnGenerate.setMnemonic(71);
        this.btnClose = new JButton(Messages.getString("Table2ViewDialog.Close"));
        this.btnClose.setMnemonic(67);
        this.btnGenerate.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.btnGenerate);
        jPanel.add(this.btnClose);
        jPanel.add(jButton);
        return jPanel;
    }

    private JComponent makeTopPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.cmbRelationals.setModel(defaultComboBoxModel);
        this.cmbRelationals.setEditable(false);
        this.cmbRelationals.setPreferredSize(new Dimension(250, 23));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.bnSelectAll);
        jPanel2.add(this.bnDeselectAll);
        jPanel.add(this.cmbRelationals);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JComponent makeTable() {
        this.tblTables.getSelectionModel().setSelectionMode(0);
        this.tblTables.setCellSelectionEnabled(false);
        this.tblTables.setRowSelectionAllowed(true);
        this.tblTables.setColumnSelectionAllowed(false);
        this.tblTables.setBorder(LineBorder.createBlackLineBorder());
        this.tblTables.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Table2ViewDialog.this.handleGenerateButton();
            }
        });
        CustomTBModel customTBModel = new CustomTBModel(new TableSet(null));
        this.tblTables.setModel(customTBModel);
        this.setTableWidths();
        this.spnTables.setViewportView(this.tblTables);
        return this.spnTables;
    }

    private void setTableWidths() {
        CustomTBModel customTBModel = (CustomTBModel)this.tblTables.getModel();
        Enumeration<TableColumn> enumeration = this.tblTables.getColumnModel().getColumns();
        int n = 0;
        FontMetrics fontMetrics = this.tblTables.getFontMetrics(this.tblTables.getFont());
        String string = "default";
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (n == 0 && enumeration.hasMoreElements()) {
                string = customTBModel.getColumnName(n);
                int n2 = fontMetrics.stringWidth(string) + 20;
                tableColumn.setMaxWidth(n2);
            }
            ++n;
        }
    }

    private JComponent makeNamingRule() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("Table2ViewDialog.NamingRule"));
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        this.tfNamingRule = new JTextField();
        this.tfNamingRule.setText(this.getApplicationView().getSettings().getViewNamingRule());
        this.tfNamingRule.setPreferredSize(new Dimension(250, 23));
        jPanel.add(this.tfNamingRule);
        this.btnAddVariable = new JButton(Messages.getString("Table2ViewDialog.AddVariable"));
        this.btnAddVariable.setMnemonic(86);
        this.btnAddVariable.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[][] stringArray = new String[][]{{"{model}", "model name"}, {"{table}", "table name"}};
                Table2ViewDialog.this.createDialog(stringArray, Table2ViewDialog.this.tfNamingRule);
            }
        });
        jPanel.add(this.btnAddVariable);
        return jPanel;
    }

    private void createDialog(String[][] stringArray, JTextField jTextField) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView());
        keyDialog.setValues(stringArray);
        keyDialog.setVisible(true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTextField.getCaretPosition();
        int n2 = jTextField.getText().length();
        if (n == 0) {
            stringBuffer.append(keyDialog.getProviderName());
        }
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                String string;
                stringBuffer.append(jTextField.getText().charAt(i));
                if (n != i + 1 || (string = keyDialog.getProviderName()) == null) continue;
                stringBuffer.append(string);
            }
            jTextField.setText(stringBuffer.toString());
        } else {
            jTextField.setText(keyDialog.getProviderName());
        }
    }

    private class KeyDialog
    extends JDialog {
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values;
        private NameProvider provider;

        public KeyDialog(ApplicationView applicationView) {
            super(applicationView.getFrame());
            this.values = new String[0][];
            this.provider = new NameProvider();
            this.setTitle(Messages.getString("Table2ViewDialog.NameElementProvider"));
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(350, 100));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton jButton = new JButton(Messages.getString("Table2ViewDialog.OK"));
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (KeyDialog.this.nameTable.getSelectedRow() != -1) {
                            KeyDialog.this.provider.setName(KeyDialog.this.nameTable.getValueAt(KeyDialog.this.nameTable.getSelectedRow(), 0).toString());
                        }
                        KeyDialog.this.dispose();
                    }
                });
                JButton jButton2 = new JButton(Messages.getString("Table2ViewDialog.Cancel"));
                jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        KeyDialog.this.dispose();
                    }
                });
                this.buttonsPanel.add(jButton);
                this.buttonsPanel.add(jButton2);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] stringArray) {
            this.values = stringArray;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return KeyDialog.this.values[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }
    }

    class NameProvider {
        private String name;

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

