/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;

public class PM2PhysicalRolesDialog
extends JPanel {
    private static final String KEY_ESCAPE = "ESCAPE";
    private DataFlowDesign dfDesign;
    private ApplicationView appView;
    private JDialog dialog;
    private JButton bnClose;
    private JButton bnOK = new JButton(Messages.getString("PM2PhysicalRolesDialog.Transform"));
    private Dimension dim = new Dimension(250, 250);
    private Map map = new TreeMap(new NameComparator());
    private TableModel tableModel;
    private JComboBox cbRelationals;
    private JComboBox cbPhysicals;
    private JComboBox cbDatabases = new JComboBox();
    private JLabel lbDB = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectSQLServerDatabase"));
    private RelationalDesign reldes;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PM2PhysicalRolesDialog.this.close();
        }
    };

    public PM2PhysicalRolesDialog(DataFlowDesign dataFlowDesign, ApplicationView applicationView) {
        this.dfDesign = dataFlowDesign;
        this.appView = applicationView;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createLeftPanel(), "West");
        jPanel.add((Component)this.createRightPanel(), "East");
        jPanel.add((Component)this.createBottomPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    private JPanel createLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PM2PhysicalRolesDialog.AvailableRoles")));
        jPanel.setPreferredSize(this.dim);
        this.tableModel = new TableModel();
        JTable jTable = new JTable(this.tableModel);
        jTable.setSelectionMode(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, "Center");
        this.collectRoles();
        return jPanel;
    }

    private JPanel createRightPanel() {
        this.cbDatabases.setVisible(false);
        this.lbDB.setVisible(this.cbDatabases.isVisible());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PM2PhysicalRolesDialog.SelectModel")));
        jPanel.setPreferredSize(this.dim);
        Dimension dimension = new Dimension(220, 20);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectRelationalModel"));
        jPanel3.add((Component)jLabel, "North");
        this.cbRelationals = new JComboBox<Object>(this.dfDesign.getDesign().getRelationalDesigns().toArray());
        this.cbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PM2PhysicalRolesDialog.this.updateStorageDesigns();
            }
        });
        this.cbRelationals.setPreferredSize(dimension);
        jPanel3.add((Component)this.cbRelationals, "Center");
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jLabel = new JLabel(Messages.getString("PM2PhysicalRolesDialog.SelectPhysicalModel"));
        jPanel6.add((Component)jLabel, "North");
        this.cbPhysicals = new JComboBox();
        this.cbPhysicals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PM2PhysicalRolesDialog.this.bnOK.setEnabled(PM2PhysicalRolesDialog.this.cbPhysicals.getSelectedItem() != null);
                PM2PhysicalRolesDialog.this.updateDBCombo();
            }
        });
        this.cbPhysicals.setPreferredSize(dimension);
        this.cbPhysicals.setToolTipText(Messages.getString("PM2PhysicalRolesDialog.OnlyOpenedUDBSQLServerCanBeSelected"));
        jPanel6.add((Component)this.cbPhysicals, "Center");
        jPanel5.add(jPanel6);
        jPanel4.add((Component)jPanel5, "North");
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)this.lbDB, "North");
        this.cbDatabases.setPreferredSize(dimension);
        jPanel8.add((Component)this.cbDatabases, "Center");
        jPanel7.add(jPanel8);
        jPanel4.add(jPanel7);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        this.updateStorageDesigns();
        return jPanel;
    }

    private void updateDBCombo() {
        boolean bl = this.cbPhysicals.getSelectedItem() != null && this.cbPhysicals.getSelectedItem() instanceof StorageDesignSqlServer;
        this.cbDatabases.setVisible(bl);
        this.lbDB.setVisible(bl);
        if (bl) {
            this.cbDatabases.removeAllItems();
            StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)this.cbPhysicals.getSelectedItem();
            Object[] objectArray = storageDesignSqlServer.getDataBaseSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.cbDatabases.addItem(objectArray[i]);
            }
        }
    }

    private void collectRoles() {
        Object[] objectArray = this.dfDesign.getProcessModel().getRoleSet().toArray();
        ArrayList arrayList = new ArrayList();
        this.dfDesign.addAllPrimitiveProcessesConnectedToStore(arrayList);
        if (objectArray.length > 0 && arrayList.size() > 0) {
            block0: for (int i = 0; i < objectArray.length; ++i) {
                Role role = (Role)objectArray[i];
                List list = role.getProcesses();
                for (Process process : list) {
                    if (!arrayList.contains(process) || process.getProcessedEntities(true).size() <= 0) continue;
                    this.map.put(objectArray[i], Boolean.TRUE.toString());
                    continue block0;
                }
            }
        }
    }

    private void updateStorageDesigns() {
        if (this.cbRelationals.getSelectedItem() != null && this.cbRelationals.getSelectedItem() instanceof RelationalDesign) {
            RelationalDesign relationalDesign = (RelationalDesign)this.cbRelationals.getSelectedItem();
            StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
            Arrays.sort(storageDesignArray, new NameComparator());
            this.cbPhysicals.removeAllItems();
            for (int i = 0; i < storageDesignArray.length; ++i) {
                StorageDesign storageDesign = storageDesignArray[i];
                if (!(storageDesign instanceof StorageDesignUDB) && !(storageDesign instanceof StorageDesignSqlServer) && !(storageDesign instanceof StorageDesignOracle)) continue;
                this.cbPhysicals.addItem(storageDesign);
            }
        }
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel();
        this.bnOK.setMnemonic(84);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PM2PhysicalRolesDialog.this.transform();
                PM2PhysicalRolesDialog.this.close();
            }
        });
        this.bnOK.setEnabled(this.cbPhysicals.getItemCount() > 0);
        this.bnClose = new JButton(Messages.getString("PM2PhysicalRolesDialog.Cancel"));
        this.bnClose.setPreferredSize(this.bnOK.getPreferredSize());
        this.bnClose.setMnemonic(67);
        this.bnClose.addActionListener(this.escape);
        jPanel.add(this.bnOK);
        jPanel.add(this.bnClose);
        return jPanel;
    }

    private void close() {
        this.getJDialog().dispose();
    }

    private void transform() {
        Object object = this.cbPhysicals.getSelectedItem();
        this.reldes = (RelationalDesign)this.cbRelationals.getSelectedItem();
        if (object != null) {
            for (Role role : this.map.keySet()) {
                Process.ProcessedObject processedObject;
                StorageObject storageObject;
                TableProxy tableProxy;
                Table table;
                PO_Tab pO_Tab;
                int n;
                StorageObject storageObject2;
                StorageDesign storageDesign;
                boolean bl = Boolean.valueOf((String)this.map.get(role));
                if (!bl) continue;
                Object[] objectArray = this.getTables(role.getProcesses()).toArray();
                if (object instanceof StorageDesignUDB) {
                    storageDesign = (StorageDesignUDB)object;
                    if (this.reldes == null) {
                        this.reldes = storageDesign.getPhysicalDesign();
                    }
                    if ((storageObject2 = (UserGroupUDB)((StorageDesignUDB)storageDesign).getUserGroupSet().getByName(role.getName())) == null) {
                        storageObject2 = ((StorageDesignUDB)storageDesign).getUserGroupSet().createUserGroup();
                        storageObject2.setName(role.getName());
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        pO_Tab = (PO_Tab)objectArray[n];
                        table = pO_Tab.table;
                        tableProxy = (TableProxyUDB)storageDesign.getProxy(table);
                        if (tableProxy == null) continue;
                        storageObject = this.getUDBPermission((StorageDesignUDB)storageDesign, storageObject2, tableProxy);
                        if (storageObject == null) {
                            storageObject = ((StorageDesignUDB)storageDesign).getPermissionsSet().createPermissions();
                            ((PermissionsUDB)storageObject).setTable((TableProxyUDB)tableProxy);
                            ((PermissionsUDB)storageObject).setGroup((UserGroupUDB)storageObject2);
                        }
                        storageObject.setDirty(true);
                        processedObject = pO_Tab.po;
                        if (processedObject.isOpCreate()) {
                            ((PermissionsUDB)storageObject).setPrivileges("INSERT");
                        }
                        if (processedObject.isOpDelete()) {
                            ((PermissionsUDB)storageObject).setPrivileges("DELETE");
                        }
                        if (processedObject.isOpUpdate()) {
                            ((PermissionsUDB)storageObject).setPrivileges("UPDATE");
                        }
                        if (!processedObject.isOpRead()) continue;
                        ((PermissionsUDB)storageObject).setPrivileges("SELECT");
                    }
                    continue;
                }
                if (object instanceof StorageDesignSqlServer) {
                    storageDesign = (StorageDesignSqlServer)object;
                    if (this.reldes == null) {
                        this.reldes = storageDesign.getPhysicalDesign();
                    }
                    if ((storageObject2 = (RoleSqlServer)((StorageDesignSqlServer)storageDesign).getRoleSet().getByName(role.getName())) == null) {
                        storageObject2 = ((StorageDesignSqlServer)storageDesign).getRoleSet().createRole();
                        storageObject2.setName(role.getName());
                        ((RoleSqlServer)storageObject2).setDatabase((DataBaseSqlServer)this.cbDatabases.getSelectedItem());
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        pO_Tab = (PO_Tab)objectArray[n];
                        table = pO_Tab.table;
                        tableProxy = (TableProxySqlServer)storageDesign.getProxy(table);
                        if (tableProxy == null) continue;
                        storageObject = this.getSQLServerPermission((StorageDesignSqlServer)storageDesign, storageObject2, tableProxy);
                        if (storageObject == null) {
                            storageObject = ((StorageDesignSqlServer)storageDesign).getPermissionsSet().createPermissions();
                            ((PermissionsSqlServer)storageObject).setTable((TableProxySqlServer)tableProxy);
                            ((PermissionsSqlServer)storageObject).setRole((RoleSqlServer)storageObject2);
                        }
                        storageObject.setDirty(true);
                        processedObject = pO_Tab.po;
                        if (processedObject.isOpCreate()) {
                            ((PermissionsSqlServer)storageObject).setPrivileges("INSERT");
                        }
                        if (processedObject.isOpDelete()) {
                            ((PermissionsSqlServer)storageObject).setPrivileges("DELETE");
                        }
                        if (processedObject.isOpUpdate()) {
                            ((PermissionsSqlServer)storageObject).setPrivileges("UPDATE");
                        }
                        if (!processedObject.isOpRead()) continue;
                        ((PermissionsSqlServer)storageObject).setPrivileges("SELECT");
                    }
                    continue;
                }
                if (!(object instanceof StorageDesignOracle)) continue;
                storageDesign = (StorageDesignOracle)object;
                if (this.reldes == null) {
                    this.reldes = storageDesign.getPhysicalDesign();
                }
                if ((storageObject2 = (RoleOracle)((StorageDesignOracle)storageDesign).getRoleSet().getByName(role.getName())) == null) {
                    storageObject2 = ((StorageDesignOracle)storageDesign).getRoleSet().createRole();
                    storageObject2.setName(role.getName());
                }
                for (n = 0; n < objectArray.length; ++n) {
                    pO_Tab = (PO_Tab)objectArray[n];
                    table = pO_Tab.table;
                    tableProxy = (TableProxy)storageDesign.getProxy(table);
                    if (tableProxy == null) continue;
                    storageObject = this.getOracleermission((StorageDesignOracle)storageDesign, storageObject2, tableProxy);
                    if (storageObject == null) {
                        storageObject = ((StorageDesignOracle)storageDesign).getPermissionsSet().createPermissions();
                        ((PermissionsOracle)storageObject).setTable((TableProxyOracle)tableProxy);
                        ((PermissionsOracle)storageObject).setRole((RoleOracle)storageObject2);
                    }
                    storageObject.setDirty(true);
                    processedObject = pO_Tab.po;
                    if (processedObject.isOpCreate()) {
                        ((PermissionsOracle)storageObject).setPrivileges("INSERT");
                    }
                    if (processedObject.isOpDelete()) {
                        ((PermissionsOracle)storageObject).setPrivileges("DELETE");
                    }
                    if (processedObject.isOpUpdate()) {
                        ((PermissionsOracle)storageObject).setPrivileges("UPDATE");
                    }
                    if (!processedObject.isOpRead()) continue;
                    ((PermissionsOracle)storageObject).setPrivileges("SELECT");
                }
            }
        }
    }

    private PermissionsUDB getUDBPermission(StorageDesignUDB storageDesignUDB, StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = storageDesignUDB.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != storageObject2) continue;
            return permissionsUDB;
        }
        return null;
    }

    private PermissionsSqlServer getSQLServerPermission(StorageDesignSqlServer storageDesignSqlServer, StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = storageDesignSqlServer.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    private PermissionsOracle getOracleermission(StorageDesignOracle storageDesignOracle, StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = storageDesignOracle.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getRole() != storageObject || permissionsOracle.getTable() != storageObject2) continue;
            return permissionsOracle;
        }
        return null;
    }

    private List getTables(List list) {
        ArrayList<PO_Tab> arrayList = new ArrayList<PO_Tab>();
        for (int i = 0; i < list.size(); ++i) {
            Process process = (Process)list.get(i);
            List list2 = process.getProcessedEntities(false);
            for (int j = 0; j < list2.size(); ++j) {
                Process.ProcessedObject processedObject = (Process.ProcessedObject)list2.get(j);
                List list3 = this.getTablesForEntity((Entity)processedObject.getObject());
                for (Table table : list3) {
                    PO_Tab pO_Tab = new PO_Tab();
                    pO_Tab.po = processedObject;
                    pO_Tab.table = table;
                    arrayList.add(pO_Tab);
                }
            }
        }
        return arrayList;
    }

    private List getTablesForEntity(Entity entity) {
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        if (entity.getGenerator() != null) {
            arrayList.add(entity.getGenerator());
        } else {
            Iterator iterator = this.dfDesign.getDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                ModelIDObject modelIDObject = relationalDesign.getTableSet().getObjectGeneratedBy(entity);
                if (modelIDObject == null) continue;
                arrayList.add(modelIDObject);
            }
        }
        return arrayList;
    }

    public void showDialog() {
        this.getJDialog().setVisible(true);
    }

    public JDialog getJDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.appView.getFrame(), Messages.getString("PM2PhysicalRolesDialog.TransformProcessModelRolesToPhysicalRoles"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    PM2PhysicalRolesDialog.this.close();
                }
            });
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            int n = 1;
            JComponent jComponent = (JComponent)this.dialog.getContentPane();
            jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
            jComponent.getActionMap().put(KEY_ESCAPE, this.escape);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jDialog.setLocation(point);
    }

    class PO_Tab {
        Process.ProcessedObject po;
        Table table;

        PO_Tab() {
        }
    }

    private class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            ModelObject modelObject = (ModelObject)object;
            ModelObject modelObject2 = (ModelObject)object2;
            return modelObject.getName().compareToIgnoreCase(modelObject2.getName());
        }
    }

    public class TableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PM2PhysicalRolesDialog.this.map.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("PM2PhysicalRolesDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("PM2PhysicalRolesDialog.RoleName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Role role = (Role)PM2PhysicalRolesDialog.this.map.keySet().toArray()[n];
            if (n2 == 0) {
                return Boolean.valueOf((String)PM2PhysicalRolesDialog.this.map.get(role));
            }
            if (n2 == 1) {
                return role.getName();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Role role = (Role)PM2PhysicalRolesDialog.this.map.keySet().toArray()[n];
                PM2PhysicalRolesDialog.this.map.put(role, ((Boolean)object).toString());
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

