/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.InvalidSeparatorException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class NamesStandardizationDialog
extends CustomDialog {
    private static final long serialVersionUID = -551787120478846367L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final String ARROW = "-->";
    private JPanel general;
    private JTextField tfCSVFile;
    private JTextField tfSeparator;
    private JCheckBox chbCase;
    private JCheckBox chbTables;
    private JCheckBox chbColumns;
    private JCheckBox chbIndices;
    private JCheckBox chbViews;
    private JCheckBox chbPKUKConstraints;
    private JCheckBox chbFKConstraints;
    private JRadioButton rbNameToAbbreviation;
    private JRadioButton rbAbbreviationToName;
    private JRadioButton rbAllObjects;
    private JRadioButton rbAbbreviations;
    private Map<String, String> names = new TreeMap<String, String>();
    private Map<String, String> logTables = new TreeMap<String, String>();
    private Map<String, Column> logColumns = new TreeMap<String, Column>();
    private Map<String, Index> logIndices = new TreeMap<String, Index>();
    private Map<String, Index> logPKUK = new TreeMap<String, Index>();
    private Map<String, FKIndexAssociation> logForeignKeys = new TreeMap<String, FKIndexAssociation>();
    private Map<String, String> logViews = new TreeMap<String, String>();
    private Map<String, String> logTableAbbreviations = new TreeMap<String, String>();
    private Map<String, Column> logColumnAbbreviations = new TreeMap<String, Column>();
    private RelationalDesign design;
    private JDialog dialog;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(NamesStandardizationDialog.class);
    int MIXED_CASE = 0;
    int LOWER_CASE = 1;
    int UPPER_CASE = 2;

    public NamesStandardizationDialog(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        this.general = new JPanel(new SpringLayout());
        this.general.setPreferredSize(new Dimension(646, 250));
        this.initGeneralView();
        this.add((Component)this.general, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton jButton = new JButton(Messages.getString("NamesStandardizationDialog.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(Messages.getString("NamesStandardizationDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.add((Component)jPanel, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("NamesStandardizationDialog.NameAbbreviations"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "NAME_STANDARDIZATION_DIALOG";
    }

    private void setObjectConstraints(JPanel jPanel, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = ((SpringLayout)jPanel.getLayout()).getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    private void initGeneralView() {
        this.initCSVFile();
        this.initScope();
        this.initDirection();
        this.initLetterCase();
        this.initSeparator();
    }

    private void initCSVFile() {
        JLabel jLabel = new JLabel(Messages.getString("NamesStandardizationDialog.SelectCSVWithPredifinedNames"));
        this.general.add(jLabel);
        this.tfCSVFile = new JTextField("");
        this.tfCSVFile.setPreferredSize(new Dimension(525, 23));
        this.general.add(this.tfCSVFile);
        JButton jButton = new JButton(Messages.getString("NamesStandardizationDialog.Browse"));
        jButton.setMnemonic(66);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.addActionListener(new BrowseAction());
        this.general.add(jButton);
        this.setObjectConstraints(this.general, jLabel, 14, 8);
        this.setObjectConstraints(this.general, this.tfCSVFile, 11, 27);
        this.setObjectConstraints(this.general, jButton, 545, 27);
    }

    private File getCSVFile() {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("NamesStandardizationDialog.NamesAbbreviationsFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                this.getApplicationView();
                String string = ApplicationView.basePath + "/templates";
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = this.getApplicationView().getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.SelectNamesAbbreviations"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastFolder = ((File)serializable).getParentFile();
                return serializable;
            }
            return null;
        }
        catch (Throwable throwable) {
            LOGGER.error("Unexpected write error: NamesStandardizationDialog.getCSVFile()");
            return null;
        }
    }

    private void initScope() {
        JPanel jPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("NamesStandardizationDialog.Scope"));
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 0, 165, 375)));
        this.general.add(jPanel);
        this.setObjectConstraints(this.general, jPanel, 8, 60);
        this.rbAllObjects = new JRadioButton(Messages.getString("NamesStandardizationDialog.AllObjects"));
        this.rbAllObjects.addActionListener(new RadioAllObjectsListener());
        this.rbAllObjects.setSelected(true);
        this.rbAllObjects.setToolTipText(Messages.getString("NamesStandardizationDialog.ApplyToAllObjects"));
        this.rbAbbreviations = new JRadioButton(Messages.getString("NamesStandardizationDialog.Abbreviations"));
        this.rbAbbreviations.addActionListener(new RadioAbbreviationsListener());
        this.rbAbbreviations.setSelected(false);
        this.rbAbbreviations.setToolTipText(Messages.getString("NamesStandardizationDialog.ApplyToAbbreviations"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAllObjects);
        buttonGroup.add(this.rbAbbreviations);
        jPanel.add(this.rbAllObjects);
        jPanel.add(this.rbAbbreviations);
        this.setObjectConstraints(jPanel, this.rbAllObjects, 4, 0);
        this.setObjectConstraints(jPanel, this.rbAbbreviations, 130, 0);
        JPanel jPanel2 = new JPanel(new SpringLayout());
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("NamesStandardizationDialog.AllOf"));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(titledBorder2, BorderFactory.createEmptyBorder(0, 0, 115, 355)));
        this.general.add(jPanel2);
        this.setObjectConstraints(this.general, jPanel2, 40, 180);
        this.chbTables = new JCheckBox(Messages.getString("NamesStandardizationDialog.Tables"));
        this.chbColumns = new JCheckBox(Messages.getString("NamesStandardizationDialog.Columns"));
        this.chbIndices = new JCheckBox(Messages.getString("NamesStandardizationDialog.Indexes"));
        this.chbViews = new JCheckBox(Messages.getString("NamesStandardizationDialog.Views"));
        this.chbPKUKConstraints = new JCheckBox(Messages.getString("NamesStandardizationDialog.PKUKConstraint"));
        this.chbFKConstraints = new JCheckBox(Messages.getString("NamesStandardizationDialog.FKConstraint"));
        this.initObjectsCheckboxes();
        jPanel2.add(this.chbTables);
        jPanel2.add(this.chbColumns);
        jPanel2.add(this.chbIndices);
        jPanel2.add(this.chbViews);
        jPanel2.add(this.chbPKUKConstraints);
        jPanel2.add(this.chbFKConstraints);
        this.setObjectConstraints(jPanel2, this.chbTables, 4, 0);
        this.setObjectConstraints(jPanel2, this.chbColumns, 160, 0);
        this.setObjectConstraints(jPanel2, this.chbViews, 4, 30);
        this.setObjectConstraints(jPanel2, this.chbIndices, 160, 30);
        this.setObjectConstraints(jPanel2, this.chbFKConstraints, 4, 60);
        this.setObjectConstraints(jPanel2, this.chbPKUKConstraints, 4, 90);
        this.setObjectConstraints(jPanel, jPanel2, 5, 25);
        jPanel.add(jPanel2);
    }

    private void initDirection() {
        JPanel jPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("NamesStandardizationDialog.Direction"));
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 0, 55, 237)));
        this.general.add(jPanel);
        this.setObjectConstraints(this.general, jPanel, 400, 60);
        this.rbNameToAbbreviation = new JRadioButton(Messages.getString("NamesStandardizationDialog.NameToAbbreviation"));
        this.rbNameToAbbreviation.setSelected(true);
        this.rbNameToAbbreviation.setToolTipText(Messages.getString("NamesStandardizationDialog.FullNamesWillBeReplacedWithAbbreviations"));
        this.rbAbbreviationToName = new JRadioButton(Messages.getString("NamesStandardizationDialog.AbbreviationToName"));
        this.rbAbbreviationToName.setSelected(false);
        this.rbAbbreviationToName.setToolTipText(Messages.getString("NamesStandardizationDialog.AbbreviatedNamesWillBeReplacedWithFullNames"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNameToAbbreviation);
        buttonGroup.add(this.rbAbbreviationToName);
        jPanel.add(this.rbNameToAbbreviation);
        jPanel.add(this.rbAbbreviationToName);
        this.setObjectConstraints(jPanel, this.rbNameToAbbreviation, 4, 0);
        this.setObjectConstraints(jPanel, this.rbAbbreviationToName, 4, 30);
    }

    private void initLetterCase() {
        this.chbCase = new JCheckBox(Messages.getString("NamesStandardizationDialog.KeepLetterCase"));
        this.chbCase.setSelected(true);
        this.general.add(this.chbCase);
        this.setObjectConstraints(this.general, this.chbCase, 403, 145);
    }

    private void initSeparator() {
        JLabel jLabel = new JLabel(Messages.getString("NamesStandardizationDialog.Separator"));
        this.setObjectConstraints(this.general, jLabel, 403, 180);
        this.general.add(jLabel);
        this.tfSeparator = new JTextField(",", 1);
        this.tfSeparator.setToolTipText(Messages.getString("NamesStandardizationDialog.EnterSeparatorSymbol"));
        this.setObjectConstraints(this.general, this.tfSeparator, 480, 175);
        this.general.add(this.tfSeparator);
    }

    private void initObjectsCheckboxes() {
        this.chbTables.setSelected(true);
        this.chbTables.setEnabled(true);
        this.chbColumns.setSelected(true);
        this.chbColumns.setEnabled(true);
        this.chbIndices.setSelected(true);
        this.chbIndices.setEnabled(true);
        this.chbViews.setSelected(true);
        this.chbViews.setEnabled(true);
        this.chbPKUKConstraints.setSelected(true);
        this.chbPKUKConstraints.setEnabled(true);
        this.chbFKConstraints.setSelected(true);
        this.chbFKConstraints.setEnabled(true);
    }

    private boolean standardize() {
        this.design = this.getApplicationView().selectRelationalDesign();
        if (this.design != null) {
            this.getNames();
            if (this.names.size() > 0) {
                if (this.rbAllObjects.isSelected()) {
                    if (this.chbTables.isSelected()) {
                        this.renameTables();
                    }
                    if (this.chbColumns.isSelected()) {
                        this.renameColumns();
                    }
                    if (this.chbIndices.isSelected()) {
                        this.renameIndices();
                    }
                    if (this.chbPKUKConstraints.isSelected()) {
                        this.renamePKUK();
                    }
                    if (this.chbFKConstraints.isSelected()) {
                        this.renameFK();
                    }
                    if (this.chbViews.isSelected()) {
                        this.renameViews();
                    }
                } else if (this.rbAbbreviations.isSelected()) {
                    if (this.chbTables.isSelected()) {
                        this.renameTableAbbreviations(this.rbNameToAbbreviation.isSelected());
                    }
                    if (this.chbColumns.isSelected()) {
                        this.renameColumnAbbreviations(this.rbNameToAbbreviation.isSelected());
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNames() {
        File file = new File(this.tfCSVFile.getText().trim());
        if (file.exists()) {
            if (this.tfSeparator.getText().length() > 0) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    int n = 0;
                    try {
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            ++n;
                            this.addName(string);
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Error: " + this.getName() + ": getNames()", iOException);
                    }
                    catch (InvalidSeparatorException invalidSeparatorException) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("NamesStandardizationDialog.SpecifiedSeparatorNotFoundInFileAtLine"), n), Messages.getString("NamesStandardizationDialog.NamesAbbreviations"), 2);
                        StringBuffer stringBuffer = new StringBuffer("Invalid separator found at line: {0}" + n);
                        LOGGER.error(stringBuffer.toString(), invalidSeparatorException);
                    }
                    finally {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            StringBuffer stringBuffer = new StringBuffer("Cannot close file in NamesStandardizationDialog.standardize: ");
                            stringBuffer.append(file.getAbsolutePath());
                            LOGGER.error(stringBuffer.toString());
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    StringBuffer stringBuffer = new StringBuffer("Can not open file: ");
                    stringBuffer.append(file.getAbsolutePath());
                    LOGGER.error(stringBuffer.toString(), fileNotFoundException);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.PleaseSpecifySeparator"), Messages.getString("NamesStandardizationDialog.NamesAbbreviations"), 2);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("NamesStandardizationDialog.PleaseSelectExistingCSVFile"), Messages.getString("NamesStandardizationDialog.NamesAbbreviationsFiles"), 2);
        }
    }

    private void addName(String string) throws InvalidSeparatorException {
        int n = string.indexOf(this.tfSeparator.getText());
        if (n > -1) {
            String string2 = "";
            String string3 = "";
            String string4 = string.substring(0, n).trim();
            String string5 = string.substring(n + 1, string.length()).trim();
            if (string4.length() > string5.length()) {
                string2 = string4;
                string3 = string5;
            } else {
                string2 = string5;
                string3 = string4;
            }
            if (this.rbNameToAbbreviation.isSelected()) {
                this.names.put(string2, string3);
            }
            if (this.rbAbbreviationToName.isSelected()) {
                this.names.put(string3, string2);
            }
        } else if (n == -1) {
            throw new InvalidSeparatorException(Messages.getString("NamesStandardizationDialog.SpecifiedSeparatorNotFoundInFile"));
        }
    }

    private void renameTables() {
        Table[] tableArray = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            String string = table.getName();
            String string2 = this.convertName(string);
            if (string2 == null || string2.equals(string)) continue;
            table.setName(string2);
            table.setDirty(true);
            this.logTables.put(string, string2);
        }
    }

    private void renameTableAbbreviations(boolean bl) {
        Table[] tableArray = (Table[])this.design.getTableSet().toArray();
        String string = null;
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            string = bl ? table.getName() : table.getAbbreviation();
            String string2 = this.convertName(string);
            if (string2 == null || string2.equals(string)) continue;
            table.setAbbreviation(string2);
            table.setDirty(true);
            this.logTableAbbreviations.put(string, string2);
        }
    }

    private void renameColumnAbbreviations(boolean bl) {
        Column[] columnArray = (Column[])this.design.getColumnSet().toArray();
        String string = null;
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            string = bl ? column.getName() : column.getAbbreviation();
            String string2 = this.convertName(string);
            if (string2 == null || string2.equals(string)) continue;
            column.setAbbreviation(string2);
            column.setDirty(true);
            this.logColumnAbbreviations.put(string2, column);
        }
    }

    private void renameColumns() {
        Column[] columnArray = (Column[])this.design.getColumnSet().toArray();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            String string = column.getName();
            String string2 = this.convertName(string);
            if (string2 == null || string2.equals(string)) continue;
            column.setName(string2);
            column.setDirty(true);
            this.logColumns.put(string, column);
        }
    }

    private void renameIndices() {
        Table[] tableArray = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            Iterator iterator = table.getIndexes().iterator();
            while (iterator.hasNext()) {
                Index index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                String string = index.getName();
                String string2 = this.convertName(string);
                if (string2 == null || string2.equals(string)) continue;
                index.setName(string2);
                index.setDirty(true);
                this.logIndices.put(string, index);
            }
        }
    }

    private void renamePKUK() {
        Table[] tableArray = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            Iterator iterator = table.getPKeys().iterator();
            while (iterator.hasNext()) {
                Index index = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                String string = index.getName();
                String string2 = this.convertName(string);
                if (string2 == null || string2.equals(string)) continue;
                index.setName(string2);
                index.setDirty(true);
                this.logPKUK.put(string, index);
            }
        }
    }

    private void renameFK() {
        Table[] tableArray = (Table[])this.design.getTableSet().toArray();
        for (int i = 0; i < tableArray.length; ++i) {
            Table table = tableArray[i];
            for (FKIndexAssociation fKIndexAssociation : table.getFKAssociationsList()) {
                String string = fKIndexAssociation.getName();
                String string2 = this.convertName(string);
                if (string2 == null || string2.equals(string)) continue;
                fKIndexAssociation.setName(string2);
                fKIndexAssociation.setDirty(true);
                this.logForeignKeys.put(string, fKIndexAssociation);
            }
        }
    }

    private void renameViews() {
        TableView[] tableViewArray = (TableView[])this.design.getTableViewSet().toArray();
        for (int i = 0; i < tableViewArray.length; ++i) {
            TableView tableView = tableViewArray[i];
            String string = tableView.getName();
            String string2 = this.convertName(string);
            if (string2 == null || string2.equals(string)) continue;
            tableView.setName(string2);
            tableView.setDirty(true);
            this.logViews.put(string, string2);
        }
    }

    private void showLog() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("NamesStandardizationDialog.NamesAbbreviationsLog")).append(NEWLINE);
        stringBuffer.append(Messages.getString("NamesStandardizationDialog.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        stringBuffer.append(Messages.getString("NamesStandardizationDialog.DesignName")).append(this.getApplicationView().getDesignName()).append(NEWLINE).append(NEWLINE);
        stringBuffer.append(TAB).append(Messages.getString("NamesStandardizationDialog.StandardizedObjects")).append(NEWLINE);
        if (this.rbAbbreviations.isSelected()) {
            String string;
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.TableAabbreviations")).append('\t').append(this.logTableAbbreviations.size()).append(NEWLINE);
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ColumnAbbreviations")).append('\t').append(this.logColumnAbbreviations.size()).append(NEWLINE);
            if (this.logTableAbbreviations.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< TABLE ABBREVIATIONS >>>>>").append(NEWLINE);
                for (String object : this.logTableAbbreviations.keySet()) {
                    string = this.logTableAbbreviations.get(object);
                    stringBuffer.append(TAB).append(this.formatText(object)).append(this.formatText(ARROW)).append(string).append(NEWLINE);
                }
            }
            if (this.logColumnAbbreviations.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< COLUMN ABBREVIATIONS >>>>>").append(NEWLINE);
                for (Map.Entry<String, Column> entry : this.logColumnAbbreviations.entrySet()) {
                    string = entry.getKey();
                    Column column = entry.getValue();
                    stringBuffer.append(TAB).append(this.formatText(column.getName() + " (" + column.getContainer().getName() + ")")).append(this.formatText(ARROW)).append(string).append(NEWLINE);
                }
            }
        } else if (this.rbAllObjects.isSelected()) {
            DesignObject designObject;
            String string;
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.TablesL")).append('\t').append(this.logTables.size()).append(NEWLINE);
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ColumnsL")).append('\t').append(this.logColumns.size()).append(NEWLINE);
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.IndexesL")).append('\t').append(this.logIndices.size()).append(NEWLINE);
            stringBuffer.append(TAB).append(TAB).append(Messages.getString("NamesStandardizationDialog.ViewsL")).append('\t').append(this.logViews.size()).append(NEWLINE);
            if (this.logTables.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< TABLES >>>>>").append(NEWLINE);
                for (String string2 : this.logTables.keySet()) {
                    string = this.logTables.get(string2);
                    stringBuffer.append(TAB).append(this.formatText(string2)).append(this.formatText(ARROW)).append(string).append(NEWLINE);
                }
            }
            if (this.logColumns.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< COLUMNS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logColumns.entrySet()) {
                    string = (String)entry.getKey();
                    designObject = (Column)entry.getValue();
                    stringBuffer.append(TAB).append(this.formatText(string + " (" + ((ContainedObject)designObject).getContainer().getName() + ")")).append(this.formatText(ARROW)).append(((ContainedObject)designObject).getName()).append(NEWLINE);
                }
            }
            if (this.logIndices.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< INDEXES >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logIndices.entrySet()) {
                    string = (String)entry.getKey();
                    designObject = (Index)entry.getValue();
                    stringBuffer.append(TAB).append(this.formatText(string + " (" + ((SubsetCO)designObject).getTopLevelContainer().getName() + ")")).append(this.formatText(ARROW)).append(designObject.getName()).append(NEWLINE);
                }
            }
            if (this.logPKUK.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< PRIMARY KEYS & UNIQUE KEYS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logPKUK.entrySet()) {
                    string = (String)entry.getKey();
                    designObject = (Index)entry.getValue();
                    stringBuffer.append(TAB).append(this.formatText(string + " (" + ((SubsetCO)designObject).getTopLevelContainer().getName() + ")")).append(this.formatText(ARROW)).append(designObject.getName()).append(NEWLINE);
                }
            }
            if (this.logForeignKeys.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< FOREIGN KEYS >>>>>").append(NEWLINE);
                for (Map.Entry entry : this.logForeignKeys.entrySet()) {
                    string = (String)entry.getKey();
                    designObject = (FKIndexAssociation)entry.getValue();
                    stringBuffer.append(TAB).append(this.formatText(string + " (" + ((FKIndexAssociation)designObject).getContainerWithKeyObject().getName() + ")")).append(this.formatText(ARROW)).append(designObject.getName()).append(NEWLINE);
                }
            }
            if (this.logViews.size() > 0) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("<<<<< VIEWS >>>>>").append(NEWLINE);
                for (String string3 : this.logViews.keySet()) {
                    string = this.logViews.get(string3);
                    stringBuffer.append(TAB).append(this.formatText(string3)).append(this.formatText(ARROW)).append(string).append(NEWLINE);
                }
            }
        }
        Iterator<Object> iterator = new LogReport(this.getApplicationView());
        ((LogReport)((Object)iterator)).setLog(stringBuffer.toString());
        ((LogReport)((Object)iterator)).showDialog();
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        while (stringBuffer.length() < 40) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private boolean containsKey(String string) {
        return this.names.containsKey(string) || this.names.containsKey(string.toUpperCase()) || this.names.containsKey(string.toLowerCase());
    }

    private Object getKey(String string) {
        String string2;
        boolean bl = this.chbCase.isSelected();
        int n = this.MIXED_CASE;
        if (bl) {
            string2 = string.toUpperCase();
            if (string2.equals(string)) {
                n = this.UPPER_CASE;
            } else {
                string2 = string.toLowerCase();
                if (string2.equals(string)) {
                    n = this.LOWER_CASE;
                }
            }
        }
        if ((string2 = this.names.get(string)) == null) {
            string2 = this.names.get(string.toUpperCase());
        }
        if (string2 == null) {
            string2 = this.names.get(string.toLowerCase());
        }
        if (string2 != null && bl) {
            if (n == this.LOWER_CASE) {
                return string2.toLowerCase();
            }
            if (n == this.UPPER_CASE) {
                return string2.toUpperCase();
            }
        }
        return string2;
    }

    private String convertName(String string) {
        int n = 0;
        String string2 = null;
        string2 = (String)this.getKey(string);
        if (string2 == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string2 = this.containsKey(string3) ? (n == 0 ? (String)this.getKey(string3) : string2 + "_" + (String)this.getKey(string3)) : (n == 0 ? string3 : string2 + "_" + string3);
                ++n;
            }
        }
        return string2;
    }

    private class RadioAllObjectsListener
    implements ActionListener {
        private RadioAllObjectsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NamesStandardizationDialog.this.initObjectsCheckboxes();
        }
    }

    private class RadioAbbreviationsListener
    implements ActionListener {
        private RadioAbbreviationsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NamesStandardizationDialog.this.chbTables.setSelected(true);
            NamesStandardizationDialog.this.chbTables.setEnabled(true);
            NamesStandardizationDialog.this.chbColumns.setSelected(true);
            NamesStandardizationDialog.this.chbColumns.setEnabled(true);
            NamesStandardizationDialog.this.chbIndices.setSelected(false);
            NamesStandardizationDialog.this.chbIndices.setEnabled(false);
            NamesStandardizationDialog.this.chbViews.setSelected(false);
            NamesStandardizationDialog.this.chbViews.setEnabled(false);
            NamesStandardizationDialog.this.chbPKUKConstraints.setSelected(false);
            NamesStandardizationDialog.this.chbPKUKConstraints.setEnabled(false);
            NamesStandardizationDialog.this.chbFKConstraints.setSelected(false);
            NamesStandardizationDialog.this.chbFKConstraints.setEnabled(false);
        }
    }

    private class BrowseAction
    implements ActionListener {
        private BrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = NamesStandardizationDialog.this.getCSVFile();
            if (file != null) {
                NamesStandardizationDialog.this.tfCSVFile.setText(file.getAbsolutePath());
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NamesStandardizationDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NamesStandardizationDialog.this.standardize()) {
                NamesStandardizationDialog.this.showLog();
                NamesStandardizationDialog.this.close();
            }
        }
    }
}

