/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.swingui.transformations.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CustomTransformationsScriptsDialog
extends CustomDialog {
    private static final long serialVersionUID = 8085236653946186628L;
    private static final Logger LOGGER = new Logger(CustomTransformationsScriptsDialog.class);
    private JDialog dialog;
    private JPanel mainPanel;
    public JButton bnClose;
    public JButton bnApply;
    private DefaultListModel availableTransformationScriptsModel;
    private JList availableTransformationScriptsList;
    private JScrollPane availableTransformationScriptsSP;
    private DefaultListModel selectedTransformationScriptsModel;
    private JList selectedTransformationScriptsList;
    private JScrollPane selectedTransformationScriptsSP;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private ApplicationView appView;
    private String type;
    private DesignPart dp;

    public CustomTransformationsScriptsDialog(ApplicationView applicationView, DesignPart designPart, String string) {
        super(applicationView);
        this.appView = applicationView;
        this.type = string;
        this.dp = designPart;
        this.init();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(14, 1));
        this.availableTransformationScriptsModel = new DefaultListModel();
        this.availableTransformationScriptsList = new JList(this.availableTransformationScriptsModel);
        for (DRCustomScript object2 : this.appView.getCustomDesignRules()) {
            if (!object2.getPurpose().equals("transformation") || !object2.getObject().equals(this.type)) continue;
            this.availableTransformationScriptsModel.addElement(object2.getName());
        }
        this.availableTransformationScriptsSP = new JScrollPane(this.availableTransformationScriptsList);
        this.availableTransformationScriptsSP.setPreferredSize(new Dimension(270, 500));
        this.availableTransformationScriptsSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsScriptsDialog.AvailableScripts")));
        this.availableTransformationScriptsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CustomTransformationsScriptsDialog.this.availableTransformationScriptsList.getSelectedIndex() == -1) {
                    CustomTransformationsScriptsDialog.this.btnAdd.setEnabled(false);
                } else {
                    CustomTransformationsScriptsDialog.this.btnAdd.setEnabled(true);
                }
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsScriptsDialog.SelectedScripts")));
        jPanel4.add((Component)this.createCustomTransformationsToolbarPanel(), "North");
        this.selectedTransformationScriptsModel = new DefaultListModel();
        this.selectedTransformationScriptsList = new JList(this.selectedTransformationScriptsModel);
        this.selectedTransformationScriptsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndex() == -1) {
                    CustomTransformationsScriptsDialog.this.btnRemove.setEnabled(false);
                    CustomTransformationsScriptsDialog.this.btnMoveDown.setEnabled(false);
                    CustomTransformationsScriptsDialog.this.btnMoveUp.setEnabled(false);
                } else {
                    CustomTransformationsScriptsDialog.this.btnRemove.setEnabled(true);
                    if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.size() > 1) {
                        CustomTransformationsScriptsDialog.this.btnMoveDown.setEnabled(true);
                        CustomTransformationsScriptsDialog.this.btnMoveUp.setEnabled(true);
                    }
                }
            }
        });
        this.selectedTransformationScriptsSP = new JScrollPane(this.selectedTransformationScriptsList);
        this.selectedTransformationScriptsSP.setPreferredSize(new Dimension(270, 500));
        jPanel4.add((Component)this.selectedTransformationScriptsSP, "South");
        this.btnAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnAdd.addActionListener(new AddActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.Add"));
        this.btnAdd.setPreferredSize(new Dimension(32, 32));
        this.btnRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnRemove.addActionListener(new RemoveActionListener());
        this.btnRemove.setEnabled(false);
        this.btnRemove.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.Remove"));
        this.btnRemove.setPreferredSize(new Dimension(32, 32));
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(this.btnAdd);
        jPanel3.add(this.btnRemove);
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel3.add(new JPanel());
        jPanel2.add((Component)this.availableTransformationScriptsSP, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel4, "East");
        this.mainPanel.add((Component)jPanel, "North");
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomTransformationsScriptsDialog.Apply"));
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setEnabled(false);
        jPanel5.add(this.bnApply);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        jPanel5.add(this.bnClose);
        this.mainPanel.add((Component)jPanel5, "South");
    }

    protected JPanel createCustomTransformationsToolbarPanel() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnMoveUp = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
        this.btnMoveUp.setEnabled(false);
        this.btnMoveUp.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.MoveUp"));
        this.btnMoveUp.addActionListener(new MoveUpAction());
        this.btnMoveDown = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.btnMoveDown.setEnabled(false);
        this.btnMoveDown.setToolTipText(Messages.getString("CustomTransformationsScriptsDialog.MoveDown"));
        this.btnMoveDown.addActionListener(new MoveDownAction());
        jToolBar.add(this.btnMoveUp);
        jToolBar.add(this.btnMoveDown);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(270, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    public Action closeAction() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomTransformationsScriptsDialog.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomTransformationsScriptsDialog.this.canClose()) {
                    CustomTransformationsScriptsDialog.this.close();
                }
            }
        };
        return abstractAction;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(600, 630);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_RULES_DIALOG";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    private boolean engineExist(DRCustomScript dRCustomScript) {
        for (String string : this.appView.getScriptEngines()) {
            if (!string.equals(dRCustomScript.getEngineName())) continue;
            return true;
        }
        return false;
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            ArrayList<DRCustomScript> arrayList = new ArrayList<DRCustomScript>();
            int n2 = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getModel().getSize();
            block2: for (n = 0; n < n2; ++n) {
                String string = (String)CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getModel().getElementAt(n);
                for (DRCustomScript dRCustomScript : CustomTransformationsScriptsDialog.this.appView.getCustomDesignRules()) {
                    if (!dRCustomScript.getName().equals(string)) continue;
                    arrayList.add(dRCustomScript);
                    continue block2;
                }
            }
            n = 1;
            for (DRCustomScript dRCustomScript : arrayList) {
                if (CustomTransformationsScriptsDialog.this.engineExist(dRCustomScript)) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomTransformationsScriptsDialog.CannotApply"), dRCustomScript.getName()), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), 0);
                n = 0;
                break;
            }
            if (n != 0) {
                try {
                    ApplyCustomTransformation applyCustomTransformation = new ApplyCustomTransformation(CustomTransformationsScriptsDialog.this.type, CustomTransformationsScriptsDialog.this.dp, arrayList);
                    boolean bl = applyCustomTransformation.runTransformation();
                    if (!bl) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsScriptsDialog.Finished"), Messages.getString("CustomTransformationsScriptsDialog.CustomTransformationScripts"), 1);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error during execution of custom transformation script : ", exception);
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndices();
            if (nArray.length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    if (n >= CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getSize() - 1) continue;
                    Object e = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getElementAt(n);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.remove(n);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.add(n + 1, e);
                    nArray[i] = n + 1;
                }
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.updateUI();
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.setSelectedIndices(nArray);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedIndices();
            if (nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n <= 0) continue;
                    Object e = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.getElementAt(n);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.remove(n);
                    CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.add(n - 1, e);
                    nArray[i] = n - 1;
                }
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.updateUI();
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.setSelectedIndices(nArray);
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = CustomTransformationsScriptsDialog.this.selectedTransformationScriptsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                if (CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.contains(string)) continue;
                CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.addElement(string);
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.removeElement(objectArray[i]);
            }
            CustomTransformationsScriptsDialog.this.sort(CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel);
            CustomTransformationsScriptsDialog.this.bnApply.setEnabled(CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.size() > 0);
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = CustomTransformationsScriptsDialog.this.availableTransformationScriptsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                if (CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.contains(string)) continue;
                CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel.addElement(string);
                CustomTransformationsScriptsDialog.this.availableTransformationScriptsModel.removeElement(objectArray[i]);
            }
            CustomTransformationsScriptsDialog.this.sort(CustomTransformationsScriptsDialog.this.selectedTransformationScriptsModel);
            CustomTransformationsScriptsDialog.this.bnApply.setEnabled(true);
        }
    }
}

