/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.distincttype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypesDialogUDB
extends JDialog {
    protected JPanel general;
    protected StorageDesignUDB storageDesign;
    private DefaultListModel allDomainsModel;
    private DefaultListModel selectedDomainsModel;
    private JList allDomainsList;
    private JList selectedDomainsList;
    private JButton bnAdd;
    private JButton bnRemove;

    public DistinctTypesDialogUDB(ApplicationView applicationView, StorageDesignUDB storageDesignUDB) {
        super(applicationView.getFrame());
        this.storageDesign = storageDesignUDB;
        this.storageDesign.setDtDialogVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DistinctTypesDialogUDB.this.storageDesign.setDtDialogVisible(false);
            }
        });
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.general = new JPanel(new SpringLayout());
        this.getContentPane().add(this.general);
        this.initGeneralView();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.general, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Messages.getString("DistinctTypesDialogUDB.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("DistinctTypesDialogUDB.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(Messages.getString("DistinctTypesDialogUDB.Cancel"));
        jButton3.setMnemonic(67);
        jButton3.addActionListener(new CancelAction());
        jButton3.setCursor(Cursor.getPredefinedCursor(12));
        jPanel2.add(jButton3);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.setSize(new Dimension(434, 270));
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public String getCaption() {
        return Messages.getString("DistinctTypesDialogUDB.DistinctTypes");
    }

    protected void initGeneralView() {
        this.initAllDomainsList();
        this.initDistinctTypesList();
        this.initButtons();
    }

    private void initAllDomainsList() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypesDialogUDB.Domains"));
        this.general.add(jLabel);
        this.allDomainsModel = new DefaultListModel();
        this.allDomainsList = new JList(this.allDomainsModel);
        ListSelectionModel listSelectionModel = this.allDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allDomainsList);
        jScrollPane.setPreferredSize(new Dimension(144, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getGeneralLayout(), jScrollPane, 10, 22);
    }

    private void initDistinctTypesList() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypesDialogUDB.DistinctTypes1"));
        this.general.add(jLabel);
        this.selectedDomainsModel = new DefaultListModel();
        this.selectedDomainsList = new JList(this.selectedDomainsModel);
        ListSelectionModel listSelectionModel = this.selectedDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedDomainsList);
        jScrollPane.setPreferredSize(new Dimension(145, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralLayout(), jLabel, 274, 4);
        this.setObjectConstraints(this.getGeneralLayout(), jScrollPane, 272, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("DistinctTypesDialogUDB.Add"));
        this.bnAdd.addActionListener(new AddDomainsActionListener());
        this.bnAdd.setEnabled(false);
        this.bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getGeneralLayout(), this.bnAdd, 162, 85);
        this.bnRemove = new JButton(Messages.getString("DistinctTypesDialogUDB.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveDomainsActionListener());
        this.bnRemove.setPreferredSize(this.bnAdd.getPreferredSize());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getGeneralLayout(), this.bnRemove, 162, 115);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected void setLabelConstraints(SpringLayout springLayout, JLabel jLabel, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(jLabel);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    public void initProperties() {
        Iterator iterator = this.storageDesign.getDesign().getDomainSet().iterator();
        DistinctTypeSetUDB distinctTypeSetUDB = this.storageDesign.getDistinctTypeSet();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (distinctTypeSetUDB.getDistinctType(domain) != null) {
                this.selectedDomainsModel.addElement(domain);
                continue;
            }
            this.allDomainsModel.addElement(domain);
        }
    }

    protected void setProperties() {
        Object[] objectArray = this.selectedDomainsModel.toArray();
        this.storageDesign.getDistinctTypeSet().removeAll();
        DistinctTypeUDB distinctTypeUDB = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Domain domain = (Domain)objectArray[i];
            distinctTypeUDB = this.storageDesign.getDistinctTypeSet().createDistinctType();
            distinctTypeUDB.setName(domain.getName());
            distinctTypeUDB.setDomain(domain.getName());
            distinctTypeUDB.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogUDB.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogUDB.this.setProperties();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogUDB.this.setProperties();
            DistinctTypesDialogUDB.this.dispose();
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DistinctTypesDialogUDB.this.selectedDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogUDB.this.bnRemove.setEnabled(false);
                } else {
                    DistinctTypesDialogUDB.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DistinctTypesDialogUDB.this.allDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogUDB.this.bnAdd.setEnabled(false);
                } else {
                    DistinctTypesDialogUDB.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveDomainsActionListener
    implements ActionListener {
        private RemoveDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DistinctTypesDialogUDB.this.selectedDomainsModel.isEmpty()) {
                Object[] objectArray = DistinctTypesDialogUDB.this.selectedDomainsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DistinctTypesDialogUDB.this.allDomainsModel.contains(object)) continue;
                    DistinctTypesDialogUDB.this.allDomainsModel.addElement(object);
                    DistinctTypesDialogUDB.this.selectedDomainsModel.removeElement(object);
                }
            }
        }
    }

    private class AddDomainsActionListener
    implements ActionListener {
        private AddDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DistinctTypesDialogUDB.this.allDomainsModel.isEmpty()) {
                Object[] objectArray = DistinctTypesDialogUDB.this.allDomainsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DistinctTypesDialogUDB.this.selectedDomainsModel.contains(object)) continue;
                    DistinctTypesDialogUDB.this.selectedDomainsModel.addElement(object);
                    DistinctTypesDialogUDB.this.allDomainsModel.removeElement(object);
                }
            }
        }
    }
}

