/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.distincttype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypesDialogDB2
extends JDialog {
    protected JPanel general;
    protected AbstractStorageDesignDB2 storageDesign;
    private DefaultListModel allDomainsModel;
    private DefaultListModel selectedDomainsModel;
    private JList allDomainsList;
    private JList selectedDomainsList;
    private JButton bnAdd;
    private JButton bnRemove;

    public DistinctTypesDialogDB2(ApplicationView applicationView, AbstractStorageDesignDB2 abstractStorageDesignDB2) {
        super(applicationView.getFrame());
        this.storageDesign = abstractStorageDesignDB2;
        this.storageDesign.setDtDialogVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DistinctTypesDialogDB2.this.storageDesign.setDtDialogVisible(false);
            }
        });
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.general = new JPanel(new SpringLayout());
        this.getContentPane().add(this.general);
        this.initGeneralView();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.general, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Messages.getString("DistinctTypesDialogDB2.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("DistinctTypesDialogDB2.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(Messages.getString("DistinctTypesDialogDB2.Cancel"));
        jButton3.setMnemonic(67);
        jButton3.addActionListener(new CancelAction());
        jButton3.setCursor(Cursor.getPredefinedCursor(12));
        jPanel2.add(jButton3);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.setSize(new Dimension(434, 270));
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public String getCaption() {
        return Messages.getString("DistinctTypesDialogDB2.DistinctTypes");
    }

    protected void initGeneralView() {
        this.initAllDomainsList();
        this.initDistinctTypesList();
        this.initButtons();
    }

    private void initAllDomainsList() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypesDialogDB2.Domains"));
        this.general.add(jLabel);
        this.allDomainsModel = new DefaultListModel();
        this.allDomainsList = new JList(this.allDomainsModel);
        ListSelectionModel listSelectionModel = this.allDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allDomainsList);
        jScrollPane.setPreferredSize(new Dimension(144, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getGeneralLayout(), jLabel, 12, 4);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), jScrollPane, 10, 22);
    }

    private void initDistinctTypesList() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypesDialogDB2.DistinctTypes1"));
        this.general.add(jLabel);
        this.selectedDomainsModel = new DefaultListModel();
        this.selectedDomainsList = new JList(this.selectedDomainsModel);
        ListSelectionModel listSelectionModel = this.selectedDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedDomainsList);
        jScrollPane.setPreferredSize(new Dimension(145, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getGeneralLayout(), jLabel, 274, 4);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), jScrollPane, 272, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("DistinctTypesDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddDomainsActionListener());
        this.bnAdd.setEnabled(false);
        this.bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.general.add(this.bnAdd);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), this.bnAdd, 162, 85);
        this.bnRemove = new JButton(Messages.getString("DistinctTypesDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveDomainsActionListener());
        this.bnRemove.setPreferredSize(this.bnAdd.getPreferredSize());
        this.general.add(this.bnRemove);
        CommonUtil.setObjectConstraints(this.getGeneralLayout(), this.bnRemove, 162, 115);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    public void initProperties() {
        Iterator iterator = this.storageDesign.getDesign().getDomainSet().iterator();
        DistinctTypeSetDB2 distinctTypeSetDB2 = this.storageDesign.getDistinctTypeSet();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (distinctTypeSetDB2.getDistinctType(domain) != null) {
                this.selectedDomainsModel.addElement(domain);
                continue;
            }
            this.allDomainsModel.addElement(domain);
        }
    }

    protected void setProperties() {
        Object[] objectArray = this.selectedDomainsModel.toArray();
        this.storageDesign.getDistinctTypeSet().removeAll();
        DistinctTypeDB2 distinctTypeDB2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Domain domain = (Domain)objectArray[i];
            distinctTypeDB2 = this.storageDesign.getDistinctTypeSet().createDistinctType();
            distinctTypeDB2.setName(domain.getName());
            distinctTypeDB2.setDomain(domain.getName());
            distinctTypeDB2.setImplementedDomain(domain);
            distinctTypeDB2.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogDB2.this.setProperties();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DistinctTypesDialogDB2.this.setProperties();
            DistinctTypesDialogDB2.this.dispose();
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.allDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveDomainsActionListener
    implements ActionListener {
        private RemoveDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DistinctTypesDialogDB2.this.selectedDomainsModel.isEmpty()) {
                Object[] objectArray = DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DistinctTypesDialogDB2.this.allDomainsModel.contains(object)) continue;
                    DistinctTypesDialogDB2.this.allDomainsModel.addElement(object);
                    DistinctTypesDialogDB2.this.selectedDomainsModel.removeElement(object);
                }
            }
        }
    }

    private class AddDomainsActionListener
    implements ActionListener {
        private AddDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DistinctTypesDialogDB2.this.allDomainsModel.isEmpty()) {
                Object[] objectArray = DistinctTypesDialogDB2.this.allDomainsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (DistinctTypesDialogDB2.this.selectedDomainsModel.contains(object)) continue;
                    DistinctTypesDialogDB2.this.selectedDomainsModel.addElement(object);
                    DistinctTypesDialogDB2.this.allDomainsModel.removeElement(object);
                }
            }
        }
    }
}

