/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.ItemsHolder;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SearchResultsList
extends JDialog
implements ListSelectionListener,
PropertyChangeListener {
    private ApplicationView appView;
    JDialog dlg;
    private JOptionPane optionPane;
    private JList list;
    private DefaultListModel listModel;
    ToStringComparator toStringComparator = new ToStringComparator();

    public SearchResultsList(ApplicationView applicationView) {
        super((Frame)applicationView.getFrame(), true);
        this.setTitle(Messages.getString("SearchResultsList.ResultList"));
        this.appView = applicationView;
        this.setModal(false);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(this);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer(new SearchCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        Object[] objectArray = new Object[]{jScrollPane};
        Object[] objectArray2 = new Object[]{this.getButtonsPanel()};
        this.optionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(2);
        this.optionPane.addPropertyChangeListener(this);
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("SearchResultsList.NewSearch"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultsList.this.dispose();
                SearchResultsList.this.appView.search(-1);
            }
        });
        JButton jButton2 = new JButton(Messages.getString("SearchResultsList.Close"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultsList.this.dispose();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.optionPane && ("value".equals(string) || "inputValue".equals(string))) {
            Object object = this.optionPane.getValue();
            if (object == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
    }

    private void selectInTree(DesignObject designObject) {
        this.appView.getBrowserPanel().getJTree().setSelectionPath(new TreePath(designObject.getPath()));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && this.list.getSelectedIndex() != -1) {
            Object e = this.list.getSelectedValue();
            if (e instanceof TVEntity) {
                TVEntity tVEntity = (TVEntity)e;
                DesignPartView designPartView = tVEntity.getDesignPartView();
                if (tVEntity != null) {
                    designPartView.setCurrentSelection(tVEntity.getSelectableObject(), tVEntity);
                    this.selectInTree(tVEntity.getModel());
                }
            } else if (e instanceof TVTable) {
                TVTable tVTable = (TVTable)e;
                DesignPartView designPartView = tVTable.getDesignPartView();
                if (tVTable != null) {
                    designPartView.setCurrentSelection(tVTable.getSelectableObject(), tVTable);
                    this.selectInTree(tVTable.getModel());
                }
            } else if (e instanceof ItemsHolder) {
                ItemsHolder itemsHolder = (ItemsHolder)e;
                if (itemsHolder.dobject instanceof Attribute) {
                    DesignPartView designPartView = itemsHolder.tv.getDesignPartView();
                    ContainerView containerView = (ContainerView)itemsHolder.tv;
                    if (containerView != null) {
                        designPartView.setCurrentSelection(containerView.getSelectableObject(), containerView);
                        this.selectInTree(itemsHolder.dobject);
                    }
                } else if (itemsHolder.dobject instanceof Column) {
                    DesignPartView designPartView = itemsHolder.tv.getDesignPartView();
                    ContainerView containerView = (ContainerView)itemsHolder.tv;
                    if (containerView != null) {
                        designPartView.setCurrentSelection(containerView.getSelectableObject(), containerView);
                        this.selectInTree(itemsHolder.dobject);
                    }
                } else if (itemsHolder.dobject instanceof CandidateKey) {
                    DesignPartView designPartView = itemsHolder.tv.getDesignPartView();
                    TopView topView = itemsHolder.tv;
                    if (topView != null) {
                        designPartView.setCurrentSelection(topView.getSelectableObject(), topView);
                        this.selectInTree(itemsHolder.dobject);
                    }
                } else if (itemsHolder.dobject instanceof Index) {
                    DesignPartView designPartView = itemsHolder.tv.getDesignPartView();
                    TopView topView = itemsHolder.tv;
                    if (topView != null) {
                        designPartView.setCurrentSelection(topView.getSelectableObject(), topView);
                        this.selectInTree(itemsHolder.dobject);
                    }
                }
            } else if (e instanceof TVView) {
                TVView tVView = (TVView)e;
                DesignPartView designPartView = tVView.getDesignPartView();
                TVView tVView2 = tVView;
                if (tVView2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVView2).getSelectableObject(), tVView);
                    this.selectInTree(tVView.getModel());
                }
            } else if (e instanceof TVEntityView) {
                TVEntityView tVEntityView = (TVEntityView)e;
                DesignPartView designPartView = tVEntityView.getDesignPartView();
                TVEntityView tVEntityView2 = tVEntityView;
                if (tVEntityView2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVEntityView2).getSelectableObject(), tVEntityView);
                    this.selectInTree(tVEntityView.getModel());
                }
            } else if (e instanceof TVFKRelation) {
                TVFKRelation tVFKRelation = (TVFKRelation)e;
                DesignPartView designPartView = tVFKRelation.getDesignPartView();
                TVFKRelation tVFKRelation2 = tVFKRelation;
                if (tVFKRelation2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVFKRelation2).getSelectableObject(), tVFKRelation);
                    this.selectInTree(tVFKRelation.getModel());
                }
            } else if (e instanceof TVRelation) {
                TVRelation tVRelation = (TVRelation)e;
                DesignPartView designPartView = tVRelation.getDesignPartView();
                TVRelation tVRelation2 = tVRelation;
                if (tVRelation2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVRelation2).getSelectableObject(), tVRelation);
                    this.selectInTree(tVRelation.getModel());
                }
            } else if (e instanceof TVProcess) {
                TVProcess tVProcess = (TVProcess)e;
                DesignPartView designPartView = tVProcess.getDesignPartView();
                TVProcess tVProcess2 = tVProcess;
                if (tVProcess2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVProcess2).getSelectableObject(), tVProcess);
                    this.selectInTree(tVProcess.getModel());
                }
            } else if (e instanceof TVAgent) {
                TVAgent tVAgent = (TVAgent)e;
                DesignPartView designPartView = tVAgent.getDesignPartView();
                TVAgent tVAgent2 = tVAgent;
                if (tVAgent2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVAgent2).getSelectableObject(), tVAgent);
                    this.selectInTree(tVAgent.getModel());
                }
            } else if (e instanceof TVInfoStore) {
                TVInfoStore tVInfoStore = (TVInfoStore)e;
                DesignPartView designPartView = tVInfoStore.getDesignPartView();
                TVInfoStore tVInfoStore2 = tVInfoStore;
                if (tVInfoStore2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVInfoStore2).getSelectableObject(), tVInfoStore);
                    this.selectInTree(tVInfoStore.getModel());
                }
            } else if (e instanceof TVCube) {
                TVCube tVCube = (TVCube)e;
                DesignPartView designPartView = tVCube.getDesignPartView();
                TVCube tVCube2 = tVCube;
                if (tVCube2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVCube2).getSelectableObject(), tVCube);
                    this.selectInTree(tVCube.getModel());
                }
            } else if (e instanceof TVLevel) {
                TVLevel tVLevel = (TVLevel)e;
                DesignPartView designPartView = tVLevel.getDesignPartView();
                TVLevel tVLevel2 = tVLevel;
                if (tVLevel2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVLevel2).getSelectableObject(), tVLevel);
                    this.selectInTree(tVLevel.getModel());
                }
            } else if (e instanceof TVDimension) {
                TVDimension tVDimension = (TVDimension)e;
                DesignPartView designPartView = tVDimension.getDesignPartView();
                TVDimension tVDimension2 = tVDimension;
                if (tVDimension2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVDimension2).getSelectableObject(), tVDimension);
                    this.selectInTree(tVDimension.getModel());
                }
            } else if (e instanceof TVStructuredType) {
                TVStructuredType tVStructuredType = (TVStructuredType)e;
                DesignPartView designPartView = tVStructuredType.getDesignPartView();
                TVStructuredType tVStructuredType2 = tVStructuredType;
                if (tVStructuredType2 != null) {
                    designPartView.setCurrentSelection(((TopView)tVStructuredType2).getSelectableObject(), tVStructuredType);
                    this.selectInTree(tVStructuredType.getModel());
                }
            }
        }
    }

    public void clear() {
        this.listModel.clear();
    }

    public void addDesignObject(Object object) {
        this.listModel.addElement(object);
    }

    public void sort() {
        ArrayList arrayList = new ArrayList();
        Object object = this.listModel.elements();
        while (object.hasMoreElements()) {
            arrayList.add(object.nextElement());
        }
        Collections.sort(arrayList, this.toStringComparator);
        this.listModel.clear();
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.listModel.addElement(object.next());
        }
    }

    public boolean isEmpty() {
        return this.listModel.getSize() == 0;
    }

    class SearchCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public SearchCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ItemsHolder) {
                ItemsHolder itemsHolder = (ItemsHolder)object;
                if (itemsHolder.dobject instanceof Column || itemsHolder.dobject instanceof Attribute || itemsHolder.dobject instanceof KeyObject) {
                    this.setText(((ItemsHolder)object).dobject.toString() + " (" + ((ItemsHolder)object).tv.toString() + ")");
                }
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

