/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.relational.TVTable;

public class TVFKRelation
extends TVConnector {
    private RelationSelection selectionWrapper = new RelationSelection();
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;

    public TVFKRelation(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    public void addConnection() {
        if (this.edge == null) {
            TVTable tVTable = this.getFKIndexAssociation().getSourceTV(this.getDesignPartView());
            TVTable tVTable2 = this.getFKIndexAssociation().getTargetTV(this.getDesignPartView());
            if (tVTable != null && tVTable2 != null && tVTable.getCellView() != null && tVTable2.getCellView() != null) {
                ContainerDiagramCell containerDiagramCell = (ContainerDiagramCell)tVTable.getCellView().getCell();
                ContainerDiagramCell containerDiagramCell2 = (ContainerDiagramCell)tVTable2.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(containerDiagramCell, containerDiagramCell2, Color.BLACK);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.resetEdgeParams(this.edge, false);
                this.displayLabels();
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                if (!"".equalsIgnoreCase(((FKEdge)this.edge).getName())) {
                    this.displayLabel(((FKEdge)this.edge).getName(), this.getLabelBounds(), 1);
                } else {
                    this.removeLabel(1);
                }
            }
        } else {
            this.removeLabel(1);
        }
    }

    public void addConnection(boolean bl) {
        if (bl) {
            this.edge = null;
        }
        this.addConnection();
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            Label label = this.getLabel(1);
            if (label != null) {
                label.setText(this.getModel().getName());
            }
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean bl) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, bl);
        }
    }

    private void resetEdgeParams(DefaultEdge defaultEdge, boolean bl) {
        Map map = defaultEdge.getAttributes();
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getModel();
        boolean bl2 = fKIndexAssociation.isOneToOne();
        if (this.getDesign().getAppView().getSettings().isFk2pkArrow()) {
            DiagramConstants.setLineBegin(map, 2);
            if (bl2) {
                if ("CASCADE".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                    DiagramConstants.setLineEnd(map, 22);
                } else if ("RESTRICT".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                    DiagramConstants.setLineEnd(map, 8);
                } else if ("SET NULL".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                    DiagramConstants.setLineEnd(map, 23);
                } else {
                    DiagramConstants.setLineEnd(map, 8);
                }
            } else if ("CASCADE".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                DiagramConstants.setLineEnd(map, 21);
            } else if ("RESTRICT".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                DiagramConstants.setLineEnd(map, 17);
            } else if ("SET NULL".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                DiagramConstants.setLineEnd(map, 20);
            } else {
                DiagramConstants.setLineEnd(map, 17);
            }
            DiagramConstants.setBeginSize(map, 8);
            DiagramConstants.setEndSize(map, 6);
            DiagramConstants.setEndFill(map, false);
        } else {
            DiagramConstants.setLineBegin(map, 5);
            DiagramConstants.setLineEnd(map, 2);
            DiagramConstants.setBeginSize(map, 4);
            DiagramConstants.setEndSize(map, 8);
            DiagramConstants.setEndFill(map, true);
        }
        if (!this.getFKIndexAssociation().isMandatory()) {
            DiagramConstants.setDashPattern(map, FKIndexAssociation.dashpattern);
        } else {
            map.remove("dashPattern");
        }
        if (fKIndexAssociation.isTransferable()) {
            DiagramConstants.setTransferable(map, true);
        } else {
            DiagramConstants.setTransferable(map, false);
        }
        defaultEdge.setAttributes(map);
        EdgeView edgeView = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false);
        if (edgeView != null) {
            edgeView.update();
        }
        if (bl && edgeView != null) {
            edgeView.getDiagram().repaint();
        }
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public FKIndexAssociation getFKIndexAssociation() {
        return (FKIndexAssociation)this.getModel();
    }

    public FKIndexAssociation.FKConnection getFKConnection() {
        return ((FKIndexAssociation)this.getModel()).getFKConnection();
    }

    public void repairSelfReference(TopView topView) {
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent mouseEvent) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDLSettings().getDefaultLWCObject("Relational Foreign Key").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDLSettings().getDefaultLWCObject("Relational Foreign Key").getWidth();
    }

    class RelationSelection
    implements SelectableObject {
        RelationSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVFKRelation.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

