/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVFKArc;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DPVRelational
extends DesignPartView {
    public static final String MI_COLUMNS = Messages.getString("DPVRelational.Columns");
    public static final String MI_KEY_ELEMENTS = Messages.getString("DPVRelational.KeyElements");
    public static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private AbstractController controller;
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JMenuItem miDiagramColor;
    private JMenu miLayout;
    private JMenuItem miUseSynonyms;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miKeyElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miIndexes;
    private JCheckBoxMenuItem miKeyAndIndexColumns;
    private JCheckBoxMenuItem miShowLegend;
    private JCheckBoxMenuItem miShowLabels;
    private JCheckBoxMenuItem miSchemaName;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int autoLayout = 0;
    private List createdTV = new ArrayList();
    private static String LAYOUT_1 = Messages.getString("DPVRelational.Layout1");
    private static String LAYOUT_2 = Messages.getString("DPVRelational.Layout2");
    private static String LAYOUT_3 = Messages.getString("DPVRelational.Layout3");
    private static String LAYOUT_4 = Messages.getString("DPVRelational.Layout4");
    private static String USE_SYNONYMS = Messages.getString("DPVRelational.UseSynonyms");
    private static final Logger LOGGER = new Logger(DPVRelational.class);
    int lvers = 1;
    private Map thMap = new TreeMap();
    private int maxWidth = 12000;
    private int refCount = 13;
    private boolean useSynonyms = false;
    private int gcount = 0;
    private List roots;
    private List fkList = new ArrayList();
    private int startx = 2000;
    private int starty = 20;
    private int dx = 80;
    private int dy = 80;
    private int maxLevel = 999999;
    private boolean mixLeftRight = true;
    private int levelled = 0;
    private int arranged = 0;
    THReferredByComparatorAsc1 referredByComparatorAsc1 = new THReferredByComparatorAsc1();
    THReferredByComparatorAsc2 referredByComparatorAsc2 = new THReferredByComparatorAsc2();
    THReferredByComparatorDesc referredByComparatorDesc = new THReferredByComparatorDesc();
    THReferComparatorDesc referComparatorDesc = new THReferComparatorDesc();
    THHeightComparatorAsc heightComparatorAsc = new THHeightComparatorAsc();
    THHeightComparatorDesc heightComparatorDesc = new THHeightComparatorDesc();
    boolean layOutchanging = false;

    public DPVRelational(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerRelational(applicationView);
        this.controller.setName("Relational");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    public Collection getTVTypeSubstitutions() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getTypeSubstitutionSet().iterator();
        while (iterator.hasNext()) {
            TypeSubstitution typeSubstitution = (TypeSubstitution)iterator.next();
            TopView topView = typeSubstitution.getViewFor(this);
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public Collection getTVFKRelations() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            TopView topView = fKIndexAssociation.getViewFor(this);
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public Collection getTVViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            TopViewCollection topViewCollection = tableView.getViewsForDPV(this);
            for (TopView topView : topViewCollection) {
                if (topView == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVRelational(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Table) {
            topView = new TVTable(this.getApplicationView(), this);
        } else if (designObject instanceof TableView) {
            topView = new TVView(this.getApplicationView(), this);
        } else if (designObject instanceof FKIndexAssociation) {
            topView = new TVFKRelation(this.getApplicationView(), this);
        } else if (designObject instanceof TypeSubstitution) {
            topView = new TVTypeSubstitution(this.getApplicationView(), this);
        } else if (designObject instanceof Note) {
            topView = new TVNote(this.getApplicationView(), this);
        } else if (designObject instanceof Legend) {
            topView = new TVLegend(this.getApplicationView(), this);
        } else if (designObject instanceof DiagramView) {
            topView = new TVDiagramView(this.getApplicationView(), this);
        } else if (designObject instanceof Label) {
            topView = new TVLabel(this.getApplicationView(), this);
        } else if (designObject instanceof FKArc) {
            TVFKArc tVFKArc = new TVFKArc(this.getApplicationView(), this);
            tVFKArc.setModel(designObject);
            topView = tVFKArc;
        } else {
            return null;
        }
        ((TopView)topView).setModel(designObject);
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
                modelPropertiesDialogEx.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVRelational.this.getController().paste(DPVRelational.this.pt);
                }
            });
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVRelational.this.setAutoRoute(!DPVRelational.this.isAutoRoute());
                    DPVRelational.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.miLayout = this.getAutoLayout();
            this.menu.add(this.miLayout);
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.menu.add(this.getShowMenu());
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVRelational.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVRelational.this.getName());
                    try {
                        DPVRelational.this.resizeTables();
                        DPVRelational.this.resizeViews();
                        if (!DPVRelational.this.isAutoRoute()) {
                            DPVRelational.this.straightenLines(false);
                        }
                    }
                    finally {
                        DPVRelational.this.stopAutoLayoutEdit();
                    }
                }
            });
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVRelational.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_VALIDATE_ALL_VIEWS){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.validateAllViews();
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PARSE_OLDER_STYLE_VIEWS){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.parseOlderStyleViews();
            }
        });
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.showPropertiesDialog();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.canPaste());
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miLayout.setEnabled(true);
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miSchemaName.setSelected(this.showSchemaName());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miKeyElements.setSelected(this.showKeyElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miKeys.setSelected(this.showKeys());
            this.miIndexes.setSelected(this.showIndexes());
            this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
            this.miKeyAndIndexColumns.setVisible(this.showKeys() || this.showIndexes());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    private JMenu getAutoLayout() {
        this.miLayout = new JMenu(MI_AUTO_LAYOUT);
        this.miLayout.add(new AbstractAction(LAYOUT_1){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.rearrangeDiagram2(1, true, LAYOUT_1);
            }
        });
        this.miLayout.add(new AbstractAction(LAYOUT_2){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.rearrangeDiagram2(1, false, LAYOUT_2);
            }
        });
        this.miLayout.add(new AbstractAction(LAYOUT_3){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.rearrangeDiagram2(3, true, LAYOUT_3);
            }
        });
        this.miLayout.add(new AbstractAction(LAYOUT_4){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.rearrangeDiagram2(3, false, LAYOUT_4);
            }
        });
        if (this.miUseSynonyms == null) {
            this.miUseSynonyms = new JCheckBoxMenuItem(USE_SYNONYMS);
            this.miUseSynonyms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVRelational.this.useSynonyms = !DPVRelational.this.useSynonyms;
                }
            });
        }
        this.miLayout.addSeparator();
        this.miLayout.add(this.miUseSynonyms);
        this.miUseSynonyms.setSelected(this.useSynonyms);
        return this.miLayout;
    }

    @Override
    public JMenu getDetailsMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miSchemaName = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_SCHEMA_NAME));
        this.miSchemaName.setMnemonic(MenuUtils.getMnemonicKey(MI_SCHEMA_NAME));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_COLUMNS));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_COLUMNS));
        this.miKeyElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_ELEMENTS));
        this.miKeyElements.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_ELEMENTS));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEYS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_KEYS));
        this.miIndexes = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_INDEXES));
        this.miIndexes.setMnemonic(MenuUtils.getMnemonicKey(MI_INDEXES));
        this.miKeyAndIndexColumns = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_AND_INDEX_COLUMNS));
        this.miKeyAndIndexColumns.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_AND_INDEX_COLUMNS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowAllDetails(true);
                DPVRelational.this.setShowNamesOnly(false);
                DPVRelational.this.setShowElements(false);
                DPVRelational.this.setShowKeyElements(false);
                DPVRelational.this.setShowDatatype(false);
                DPVRelational.this.setShowKeys(false);
                DPVRelational.this.setShowIndexes(false);
                DPVRelational.this.setShowKeyAndIndexColumns(false);
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miAllDetails);
        jMenu.addSeparator();
        this.miSchemaName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowSchemaName(!DPVRelational.this.showSchemaName());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miSchemaName);
        jMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowAllDetails(false);
                DPVRelational.this.setShowNamesOnly(true);
                DPVRelational.this.setShowElements(false);
                DPVRelational.this.setShowKeyElements(false);
                DPVRelational.this.setShowDatatype(false);
                DPVRelational.this.setShowKeys(false);
                DPVRelational.this.setShowIndexes(false);
                DPVRelational.this.setShowKeyAndIndexColumns(false);
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowElements(!DPVRelational.this.showElements());
                if (!DPVRelational.this.showElements() && !DPVRelational.this.showKeyElements()) {
                    DPVRelational.this.setShowDatatype(false);
                    if (!DPVRelational.this.showKeys() && !DPVRelational.this.showIndexes()) {
                        DPVRelational.this.setShowAllDetails(true);
                    }
                } else {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                    DPVRelational.this.setShowKeyAndIndexColumns(false);
                    if (DPVRelational.this.showElements()) {
                        DPVRelational.this.setShowKeyElements(false);
                    }
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miElements);
        this.miKeyElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowKeyElements(!DPVRelational.this.showKeyElements());
                if (!DPVRelational.this.showElements() && !DPVRelational.this.showKeyElements()) {
                    DPVRelational.this.setShowDatatype(false);
                    if (!DPVRelational.this.showKeys()) {
                        DPVRelational.this.setShowAllDetails(true);
                    }
                } else {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                    DPVRelational.this.setShowKeyAndIndexColumns(false);
                    if (DPVRelational.this.showKeyElements()) {
                        DPVRelational.this.setShowElements(false);
                    }
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miKeyElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowDatatype(!DPVRelational.this.showDatatype());
                if (DPVRelational.this.showDatatype()) {
                    if (!DPVRelational.this.showKeyElements()) {
                        DPVRelational.this.setShowElements(true);
                    }
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowKeys(!DPVRelational.this.showKeys());
                if (DPVRelational.this.showKeys()) {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                } else if (!(DPVRelational.this.showElements() || DPVRelational.this.showIndexes() || DPVRelational.this.showKeyElements())) {
                    DPVRelational.this.setShowAllDetails(true);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miIndexes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowIndexes(!DPVRelational.this.showIndexes());
                if (DPVRelational.this.showIndexes()) {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                } else if (!(DPVRelational.this.showElements() || DPVRelational.this.showKeys() || DPVRelational.this.showKeyElements())) {
                    DPVRelational.this.setShowAllDetails(true);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miKeyAndIndexColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowKeyAndIndexColumns(!DPVRelational.this.showKeyAndIndexColumns());
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        jMenu.add(this.miKeys);
        jMenu.add(this.miIndexes);
        jMenu.add(this.miKeyAndIndexColumns);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miSchemaName.setSelected(this.showSchemaName());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miKeyElements.setSelected(this.showKeyElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miKeys.setSelected(this.showKeys());
        this.miIndexes.setSelected(this.showIndexes());
        this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
        this.miKeyAndIndexColumns.setVisible(this.showKeys() || this.showIndexes());
        return jMenu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowGrid(!DPVRelational.this.showGrid());
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowLabels(!DPVRelational.this.showLabels());
            }
        });
        jMenu.add(this.miShowLabels);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVRelational.this.setShowLegend(!DPVRelational.this.showLegend());
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    public void rearrangeDiagram() {
        if (this.autoLayout == 0) {
            this.layOutchanging = true;
            this.layOutchanging = false;
            return;
        }
        if (this.autoLayout == 1) {
            // empty if block
        }
        this.layOutchanging = true;
        this.startAutoLayoutEdit("AutoLayout " + this.lvers + "_" + this.bulToInt(this.mixLeftRight));
        this.rearrangeT(this.lvers, false);
        this.rearrangeViews();
        this.stopAutoLayoutEdit();
        if (this.lvers == 3 && !this.mixLeftRight) {
            this.layOutchanging = false;
            this.lvers = 1;
            this.mixLeftRight = true;
        } else if (!this.mixLeftRight) {
            ++this.lvers;
            this.mixLeftRight = true;
        } else {
            this.mixLeftRight = false;
        }
    }

    public void rearrangeDiagram2(int n, boolean bl, String string) {
        this.lvers = n;
        this.mixLeftRight = bl;
        this.startAutoLayoutEdit(string);
        this.rearrangeT(this.lvers, false);
        this.rearrangeViews();
        this.stopAutoLayoutEdit();
    }

    public void rearrangeNewDiagram() {
        this.left = 20;
        this.top = 20;
        this.lvers = 3;
        this.mixLeftRight = false;
        this.rearrangeT(this.lvers, true);
        this.rearrangeViews();
        this.lvers = 1;
        this.mixLeftRight = true;
    }

    private int bulToInt(boolean bl) {
        if (bl) {
            return 0;
        }
        return 1;
    }

    public Collection getTVTables() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVTable)) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public void rearrangeT(int n, boolean bl) {
        this.left = 20;
        this.top = 20;
        this.dy = 60;
        this.dx = 80;
        this.gcount = 0;
        this.refCount = 10;
        List list = (List)this.getTVTables();
        this.maxWidth = 1000;
        this.createdTV.clear();
        this.fkList.clear();
        ArrayList<TH> arrayList = new ArrayList<TH>();
        ArrayList<TH> arrayList2 = new ArrayList<TH>();
        this.roots = new ArrayList();
        ArrayList<TH> arrayList3 = new ArrayList<TH>();
        List list2 = this.buildTH_Map(list, bl);
        ArrayList arrayList4 = new ArrayList();
        for (TH tH : list2) {
            if (tH.refer_count == 0 && tH.referredBy_count == 0) {
                arrayList.add(tH);
                continue;
            }
            arrayList2.add(tH);
            if (tH.refer.size() > 0) {
                if (n == 1) {
                    Collections.sort(tH.refer, this.referredByComparatorAsc1);
                } else if (n == 2) {
                    Collections.sort(tH.refer, this.referredByComparatorAsc2);
                } else {
                    Collections.sort(tH.refer, this.referredByComparatorDesc);
                }
            }
            if (tH.referredBy_count == 0 && !tH.usedInStar) {
                this.roots.add(tH);
            }
            if (tH.referredBy.size() <= 0) continue;
            Collections.sort(tH.referredBy, this.referComparatorDesc);
        }
        if (this.useSynonyms) {
            arrayList4.addAll(this.makeSynonyms(arrayList2));
        }
        if (arrayList2.size() > 0) {
            if (this.roots.size() == 0) {
                this.findRoots(arrayList2, this.roots);
            }
            this.roots.addAll(arrayList4);
            Collections.sort(this.roots, this.referComparatorDesc);
            int n2 = this.startx;
            int n3 = this.starty;
            for (int i = 0; i < this.roots.size(); ++i) {
                Rectangle rectangle;
                TH tH = (TH)this.roots.get(i);
                if (tH.arranged || tH.usedInStar) continue;
                arrayList3.add(tH);
                this.levelled = 0;
                this.arranged = 0;
                if (tH.star) {
                    rectangle = this.arrangeStar(tH, n2, n3);
                } else {
                    this.setLevel2(tH, 0);
                    rectangle = this.arrange(tH, n2, n3, null, null, null);
                }
                n3 = n3 + rectangle.height + 2 * this.dy;
            }
            Collections.sort(arrayList3, this.heightComparatorDesc);
            this.translateArrangeRoots(arrayList3);
            arrayList2.addAll(this.createdTV);
            this.applyArrange(arrayList2);
        }
        this.rearrangeNoneRefTables(arrayList);
        this.applyArrange(arrayList);
        if (!this.isAutoRoute()) {
            this.straightenLines(this.fkList);
        }
        if (this.showLabels()) {
            this.refreshLabels(this.fkList);
        }
        this.createdTV.clear();
        this.roots.clear();
        this.thMap.clear();
        this.fkList.clear();
    }

    private void straightenLines(List list) {
        for (FKIndexAssociation fKIndexAssociation : list) {
            TopView topView = fKIndexAssociation.getViewFor(this);
            if (topView.getCellView() == null) continue;
            DefaultEdge defaultEdge = (DefaultEdge)topView.getCellView().getCell();
            defaultEdge.straightLine(false);
        }
    }

    private void refreshLabels(List list) {
        for (FKIndexAssociation fKIndexAssociation : list) {
            TopView topView = fKIndexAssociation.getViewFor(this);
            if (topView.getCellView() == null || !(topView.getCellView() instanceof EdgeView)) continue;
            DefaultEdge defaultEdge = (DefaultEdge)topView.getCellView().getCell();
            ((EdgeView)defaultEdge.getTopView().getCellView()).refreshLabels();
        }
    }

    private Rectangle arrangeStar(TH tH, int n, int n2) {
        TH tH2;
        int n3;
        Rectangle rectangle = new Rectangle(n, n2, 1, 1);
        tH.nodes.add(tH);
        ArrayList<TH> arrayList = new ArrayList<TH>();
        for (TH tH3 : tH.referredBy) {
            if (arrayList.contains(tH3)) continue;
            arrayList.add(tH3);
        }
        for (TH tH3 : tH.refer) {
            if (arrayList.contains(tH3)) continue;
            arrayList.add(tH3);
        }
        Collections.sort(arrayList, this.heightComparatorAsc);
        int n4 = 0;
        for (TH tH4 : arrayList) {
            n4 = n4 + tH4.init_dim.width + this.dx;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n + n4 / 2;
        int n8 = 0;
        int n9 = 0;
        int n10 = n;
        for (n3 = arrayList.size() - 1; n3 >= 0 && n5 < n7; --n3) {
            n8 = n3;
            tH2 = (TH)arrayList.get(n3);
            n9 = Math.max(n9, tH2.init_dim.height);
            n10 = n5 + tH2.init_dim.width;
            tH.nodes.add(tH2);
            tH2.nodes.add(tH2);
            tH2.location = new Point(n5, n6);
            tH2.rect = new Rectangle(tH2.location, tH2.init_dim);
            n5 = n5 + this.dx + tH2.init_dim.width;
            rectangle = rectangle.union(tH2.rect);
            tH2.arranged = true;
        }
        n6 = n6 + n9 + 2 * this.dy;
        n5 = n + (n10 - n) / 2;
        tH.location = new Point(n5, n6);
        tH.rect = new Rectangle(tH.location, tH.init_dim);
        rectangle = rectangle.union(tH.rect);
        tH.arranged = true;
        n6 = n6 + tH.init_dim.height + 2 * this.dy;
        n5 = n;
        for (n3 = n8 - 1; n3 >= 0; --n3) {
            tH2 = (TH)arrayList.get(n3);
            tH.nodes.add(tH2);
            tH2.nodes.add(tH2);
            tH2.location = new Point(n5, n6);
            tH2.rect = new Rectangle(tH2.location, tH2.init_dim);
            n5 = n5 + this.dx + tH2.init_dim.width;
            rectangle = rectangle.union(tH2.rect);
            tH2.arranged = true;
        }
        tH.rect = rectangle;
        return rectangle;
    }

    private void translateArrangeRoots(List list) {
        this.left = 20;
        this.top = 20;
        int n = 0;
        int n2 = this.getRootsMaxWidth(list) + this.left + 5;
        for (TH tH : list) {
            Rectangle rectangle = tH.rect;
            if (this.left + rectangle.width > n2) {
                this.left = 20;
                this.top = this.top + n + 2 * this.dy;
                n = 0;
            }
            n = Math.max(rectangle.height, n);
            int n3 = this.left - rectangle.x;
            int n4 = this.top - rectangle.y;
            for (TH tH2 : tH.nodes) {
                tH2.location.x = n3 + tH2.location.x;
                tH2.location.y = n4 + tH2.location.y;
            }
            this.left = this.left + rectangle.width + 2 * this.dx;
        }
        this.top = this.top + n + 3 * this.dy;
        this.left = 20;
    }

    private int getRootsMaxWidth(List list) {
        int n = this.maxWidth;
        for (TH tH : list) {
            if (n >= tH.rect.width) continue;
            n = tH.rect.width;
        }
        return n;
    }

    private Rectangle orderLeft(TH tH, List list, int n, int n2, List list2, List list3, Rectangle rectangle) {
        int n3 = n - this.dx;
        int n4 = n2;
        Rectangle rectangle2 = new Rectangle(n, n2, 1, 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            TH tH2 = (TH)list.get(i);
            if (tH2.arranged || tH2.isConnectdToBetterLevel(tH, tH.level) || tH2.booked && !list2.contains(tH2)) continue;
            int n5 = n3 - tH2.init_dim.width;
            Rectangle rectangle3 = this.arrange(tH2, n5, n4, null, rectangle, list3);
            n3 = Math.min(n3, rectangle3.x) - this.dx;
            rectangle2 = rectangle2.union(rectangle3);
        }
        return rectangle2;
    }

    private Rectangle orderLeftCenter(TH tH, List list, int n, int n2, List list2, List list3, Rectangle rectangle) {
        int n3;
        int n4 = n - this.dx;
        int n5 = n2;
        ArrayList<TH> arrayList = new ArrayList<TH>();
        Rectangle rectangle2 = new Rectangle(n, n2, 1, 1);
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            TH tH2 = (TH)list.get(n3);
            if (tH2.arranged || tH2.isConnectdToBetterLevel(tH, tH.level) || tH2.booked && !list2.contains(tH2)) continue;
            arrayList.add(0, tH2);
        }
        if (arrayList.size() > 1) {
            n3 = 0;
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                TH tH3 = (TH)arrayList.get(i);
                n3 = n3 + this.dx + tH3.init_dim.width;
            }
            n4 = n + n3 / 2 - this.dx;
        }
        for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
            TH tH4 = (TH)arrayList.get(n3);
            if (tH4.arranged || tH4.isConnectdToBetterLevel(tH, tH.level) || tH4.booked && !list2.contains(tH4)) continue;
            int n6 = n4 - tH4.init_dim.width;
            Rectangle rectangle3 = this.arrange(tH4, n6, n5, null, rectangle, list3);
            n4 = Math.min(n4, rectangle3.x) - this.dx;
            rectangle2 = rectangle2.union(rectangle3);
        }
        return rectangle2;
    }

    private Rectangle orderDown(TH tH, List list, int n, int n2, List list2, List list3, Rectangle rectangle) {
        int n3;
        int n4;
        int n5;
        int n6;
        List list4;
        ArrayList<TH> arrayList = new ArrayList<TH>();
        for (TH tH2 : list) {
            if (tH2.arranged || tH2.booked || list2.contains(tH2) || tH2.isConnectdToBetterLevel(tH, tH.level)) continue;
            tH2.booked = true;
            arrayList.add(tH2);
        }
        int n7 = n;
        int n8 = n2;
        Rectangle rectangle2 = new Rectangle(n, n2, 1, 1);
        Rectangle rectangle3 = rectangle == null ? null : new Rectangle(rectangle);
        ArrayList<TH> arrayList2 = new ArrayList<TH>();
        int n9 = arrayList.size();
        if (n9 > 1 && (list4 = this.getReferOnly(arrayList, tH)).size() > 0) {
            int n10;
            if (list4.size() > 1) {
                Collections.sort(list4, this.heightComparatorAsc);
            }
            n6 = tH.location.y;
            n5 = this.dy / 3;
            n4 = n6 + tH.init_dim.height + n5;
            for (n10 = 0; n10 < list4.size(); ++n10) {
                TH tH3 = (TH)list4.get(n10);
                int n11 = n6 + tH3.init_dim.height;
                if (n11 > n4) break;
                arrayList2.add(tH3);
                arrayList.remove(tH3);
                n6 = n11 + n5;
            }
            if ((n10 = n9 / 2) > 1) {
                n10 = 1;
            }
            while (arrayList.size() < n10) {
                arrayList.add((TH)arrayList2.get(arrayList2.size() - 1));
                arrayList2.remove(arrayList2.size() - 1);
            }
        }
        n9 = arrayList.size();
        for (n3 = 0; n3 < n9; ++n3) {
            TH tH4 = (TH)arrayList.get(n3);
            if (n9 > 1 && n3 == n9 - 1 && arrayList2.size() == 0) {
                if (arrayList2.size() == 0 && tH4.referOnlyAndArranged(tH)) {
                    n5 = tH.location.x + this.dx + tH.init_dim.width;
                    Rectangle rectangle4 = this.arrange(tH4, n5, tH.location.y, null, rectangle3, list3);
                    rectangle2 = rectangle2.union(rectangle4);
                } else {
                    n5 = Math.max(tH.location.x + this.dx + tH.init_dim.width, rectangle2.x + rectangle2.width + this.dx);
                    Rectangle rectangle5 = this.arrange(tH4, n5, tH.location.y, null, rectangle3, list3);
                    rectangle2 = rectangle2.union(rectangle5);
                }
            }
            n5 = n7;
            Rectangle rectangle6 = this.arrange(tH4, n5, n8, null, rectangle3, list3);
            rectangle3 = rectangle3 == null ? new Rectangle(rectangle6) : rectangle3.union(rectangle6);
            n7 = Math.max(n7, rectangle6.x + rectangle6.width) + this.dx;
            rectangle2 = rectangle2.union(rectangle6);
        }
        n3 = tH.location.y;
        n6 = this.dy / 3;
        n5 = tH.location.x + this.dx + tH.init_dim.width;
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            TH tH5 = (TH)arrayList2.get(n4);
            tH5.nodes.add(tH5);
            if (list3 != null) {
                list3.add(tH5);
            }
            tH5.location = new Point(n5, n3);
            tH5.arranged = true;
            tH5.booked = false;
            tH5.rect = new Rectangle(tH5.location, tH5.init_dim);
            rectangle2 = rectangle2.union(tH5.rect);
            n3 = n3 + tH5.init_dim.height + n6;
        }
        return rectangle2;
    }

    private List getReferOnly(List list, TH tH) {
        Iterator iterator = list.iterator();
        ArrayList<TH> arrayList = new ArrayList<TH>();
        while (iterator.hasNext()) {
            TH tH2 = (TH)iterator.next();
            if (!tH2.referOnly(tH)) continue;
            arrayList.add(tH2);
        }
        return arrayList;
    }

    private List getNotArranged(List list) {
        ArrayList<TH> arrayList = new ArrayList<TH>();
        for (TH tH : list) {
            if (tH.arranged) continue;
            arrayList.add(tH);
        }
        return arrayList;
    }

    private Rectangle arrange(TH tH, int n, int n2, Rectangle rectangle, Rectangle rectangle2, List list) {
        if (!tH.arranged) {
            Rectangle rectangle3;
            boolean bl;
            Rectangle rectangle4 = rectangle;
            tH.location = new Point(n, n2);
            tH.nodes.add(tH);
            rectangle4 = rectangle4 == null ? new Rectangle(tH.location, tH.init_dim) : rectangle4.union(new Rectangle(tH.location, tH.init_dim));
            tH.arranged = true;
            ++this.arranged;
            ++this.gcount;
            List list2 = this.getNotArranged(tH.refer);
            List list3 = this.getNotArranged(tH.referredBy);
            ArrayList arrayList = new ArrayList();
            if (!this.mixLeftRight && this.canGoLeft(rectangle2, n, n2 + tH.init_dim.height + this.dy, list3)) {
                for (Object object : list3) {
                    if (((TH)object).arranged || ((TH)object).booked || ((TH)object).isConnectdToBetterLevel(tH, tH.level)) continue;
                    ((TH)object).booked = true;
                    arrayList.add(object);
                }
            }
            if (!(bl = this.canGoLeft(rectangle2, n, n2 + tH.init_dim.height + this.dy, list3))) {
                for (TH tH2 : arrayList) {
                    tH2.booked = false;
                }
                arrayList.clear();
            }
            if (list2.size() > 0) {
                if (this.mixLeftRight || !bl) {
                    list3.addAll(list2);
                    rectangle3 = this.orderDown(tH, list3, n, n2 + tH.init_dim.height + this.dy, Collections.EMPTY_LIST, tH.nodes, rectangle2);
                    rectangle4 = rectangle4.union(rectangle3);
                } else if (list3.size() > 0) {
                    rectangle3 = this.orderLeft(tH, list3, n, n2 + tH.init_dim.height + this.dy, arrayList, tH.nodes, rectangle2);
                    rectangle2 = rectangle2 == null ? new Rectangle(rectangle3) : rectangle2.union(rectangle3);
                    rectangle4 = rectangle4.union(rectangle3);
                    rectangle3 = this.orderDown(tH, list2, Math.max(n, rectangle3.x + rectangle3.width), n2 + tH.init_dim.height + this.dy, arrayList, tH.nodes, rectangle2);
                    rectangle4 = rectangle4.union(rectangle3);
                } else {
                    rectangle3 = this.orderDown(tH, list2, n, n2 + tH.init_dim.height + this.dy, arrayList, tH.nodes, rectangle2);
                    rectangle4 = rectangle4.union(rectangle3);
                }
            } else if (list3.size() > 0) {
                if (this.mixLeftRight || !this.canGoLeft(rectangle2, n, n2 + tH.init_dim.height + this.dy, list3)) {
                    list3.addAll(list2);
                    rectangle3 = this.orderDown(tH, list3, n, n2 + tH.init_dim.height + this.dy, Collections.EMPTY_LIST, tH.nodes, rectangle2);
                    rectangle4 = rectangle4.union(rectangle3);
                } else {
                    Object object;
                    object = (TH)list3.get(list3.size() - 1);
                    rectangle3 = this.orderLeftCenter(tH, list3, n + ((TH)object).init_dim.width + this.dx, n2 + tH.init_dim.height + this.dy, arrayList, tH.nodes, rectangle2);
                    rectangle4 = rectangle4.union(rectangle3);
                }
            }
            tH.rect = new Rectangle(rectangle4);
            if (list != null) {
                for (TH tH2 : tH.nodes) {
                    if (list.contains(tH2)) continue;
                    list.add(tH2);
                }
            }
            return rectangle4;
        }
        return tH.rect;
    }

    private boolean canGoLeft(Rectangle rectangle, int n, int n2, List list) {
        if (rectangle == null || list.size() == 0) {
            return true;
        }
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            TH tH = (TH)iterator.next();
            n3 = n3 + this.dx + tH.init_dim.width;
        }
        return n2 > rectangle.y + rectangle.height || n - n3 > rectangle.x + n3;
    }

    private void findRoots(List list, List list2) {
        Collections.sort(list, this.referredByComparatorAsc1);
        int n = -1;
        if (list.size() > 0) {
            do {
                ++n;
                for (TH tH : list) {
                    if (tH.referredBy_count != n) continue;
                    list2.add(tH);
                }
            } while (list2.size() == 0);
        }
    }

    private void applyArrange(List list) {
        for (TH tH : list) {
            if (!tH.arranged) continue;
            if (tH.tv.getCellView() != null) {
                tH.tv.getCellView().setNewBounds(new Rectangle(new Point(tH.location.x, tH.location.y), tH.init_dim));
                continue;
            }
            tH.tv.setBounds(new Rectangle(new Point(tH.location), tH.init_dim));
        }
    }

    private void setLevel2(TH tH, int n) {
        block8: {
            if (n > tH.level || tH.scanned) break block8;
            ArrayList<TH> arrayList = new ArrayList<TH>();
            ArrayList<TH> arrayList2 = new ArrayList<TH>();
            tH.level = n;
            tH.scanned = true;
            ++this.levelled;
            for (TH tH2 : tH.refer) {
                if (tH2.level <= n + 1 || tH2.scanned || tH2.isScanConnectedToBetterLevel(tH, tH.level)) continue;
                tH2.level = n + 1;
                arrayList.add(tH2);
            }
            for (TH tH2 : tH.referredBy) {
                if (tH2.level <= n + 1 || tH2.scanned || tH2.isScanConnectedToBetterLevel(tH, tH.level)) continue;
                tH2.level = n + 1;
                arrayList2.add(tH2);
            }
            if (this.mixLeftRight) {
                for (TH tH2 : arrayList) {
                    this.setLevel2(tH2, n + 1);
                }
                for (TH tH2 : arrayList2) {
                    this.setLevel2(tH2, n + 1);
                }
            } else {
                TH tH3;
                int n2;
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    tH3 = (TH)arrayList.get(n2);
                    this.setLevel2(tH3, n + 1);
                }
                for (n2 = arrayList2.size() - 1; n2 >= 0; --n2) {
                    tH3 = (TH)arrayList2.get(n2);
                    this.setLevel2(tH3, n + 1);
                }
            }
        }
    }

    private List buildTH_Map(List list, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        DesignObject designObject;
        this.thMap.clear();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object4 : list) {
            designObject = ((TopView)object4).getModel();
            object3 = (TH)this.thMap.get(((TopView)object4).getViewID());
            if (object3 != null) continue;
            object3 = new TH();
            this.thMap.put(((TopView)object4).getViewID(), object3);
            ((TH)object3).tv = object4;
            ((TH)object3).table = (Table)designObject;
            if (bl) {
                ((TH)object3).init_dim = this.getTableSize(((TH)object3).table, this.getFontMetrics((TopView)object4));
            } else {
                object2 = ((TopView)object4).getCellView();
                if (object2 != null) {
                    object = ((AbstractCellView)object2).getBounds().getBounds();
                    ((TH)object3).init_dim = new Dimension(((Rectangle)object).width, ((Rectangle)object).height);
                } else {
                    object = ((TopView)object4).getBounds();
                    ((TH)object3).init_dim = new Dimension(((Rectangle)object).width, ((Rectangle)object).height);
                }
            }
            arrayList.add(object3);
        }
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            Object object4;
            object4 = (FKIndexAssociation)iterator.next();
            designObject = ((FKIndexAssociation)object4).getTable();
            object3 = ((FKIndexAssociation)object4).getRemoteTable();
            object2 = ((FKIndexAssociation)object4).getTargetTopView(this);
            object = ((FKIndexAssociation)object4).getSourceTopView(this);
            if (object2 == null || object == null) continue;
            this.fkList.add(object4);
            TH tH = (TH)this.thMap.get(((TopView)object).getViewID());
            TH tH2 = (TH)this.thMap.get(((TopView)object2).getViewID());
            if (designObject == object3 || tH == null || tH2 == null) continue;
            if (!tH.referredByFK.contains(object4)) {
                tH.referredBy.add(tH2);
                tH.referredByFK.add(object4);
                tH.referredByMap.put(((ModelIDObject)object4).getObjectID(), tH2);
                ++tH.referredBy_count;
            }
            if (tH2.referFK.contains(object4)) continue;
            tH2.refer.add(tH);
            tH2.referFK.add(object4);
            tH2.referMap.put(((ModelIDObject)object4).getObjectID(), tH);
            ++tH2.refer_count;
        }
        return arrayList;
    }

    private List makeSynonyms(List list) {
        ArrayList<TH> arrayList = new ArrayList<TH>();
        ArrayList<TH> arrayList2 = new ArrayList<TH>();
        for (TH tH : list) {
            if (tH.referredBy_count < this.refCount) continue;
            arrayList.add(tH);
        }
        Collections.sort(arrayList, this.referredByComparatorDesc);
        for (TH tH : arrayList) {
            if (tH.referredBy_count < this.refCount) continue;
            arrayList2.add(tH);
            tH.star = true;
            if (tH.refer.size() == 0 || tH.referNodesWithNorefs()) {
                this.makeSynonyms(tH);
                continue;
            }
            TH tH2 = this.createSynonmTH(tH, false, false);
            this.roots.add(tH2);
            Object[] objectArray = tH.referFK.toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                TH tH3;
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)objectArray[i];
                TH tH4 = (TH)tH.referMap.get(fKIndexAssociation.getObjectID());
                if (!tH4.referredByFK.remove(fKIndexAssociation) || (tH3 = (TH)tH4.referredByMap.get(fKIndexAssociation.getObjectID())) != tH) continue;
                tH4.referredBy.remove(tH);
                tH4.referredByMap.remove(fKIndexAssociation.getObjectID());
                tH4.referredBy.add(tH2);
                tH4.referredByFK.add(fKIndexAssociation);
                tH4.referredByMap.put(fKIndexAssociation.getObjectID(), tH2);
                FK_TV_Edit fK_TV_Edit = new FK_TV_Edit(fKIndexAssociation, tH2.tv, false);
                this.getDesignPart().postUndoableEdit(fK_TV_Edit);
                fK_TV_Edit.applyUpdates();
                tH2.refer.add(tH4);
                tH2.referFK.add(fKIndexAssociation);
                tH2.referMap.put(fKIndexAssociation.getObjectID(), tH4);
                ++tH2.refer_count;
                tH.refer.remove(tH4);
                tH.referFK.remove(fKIndexAssociation);
                tH.referMap.remove(fKIndexAssociation.getObjectID());
                --tH.refer_count;
            }
            this.makeSynonyms(tH);
        }
        return arrayList2;
    }

    private void makeSynonyms(TH tH) {
        Object[] objectArray = tH.referredByFK.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)objectArray[i];
            TH tH2 = (TH)tH.referredByMap.get(fKIndexAssociation.getObjectID());
            if (tH2.refer.size() + tH2.referredBy.size() > 1 && !tH2.referOnly(tH)) {
                TH tH3 = (TH)tH.synonymsMap.get(tH2.tv.getViewID());
                if (tH3 == null) {
                    tH3 = this.createSynonmTH(tH2, false, false);
                    tH.synonymsMap.put(tH2.tv.getViewID(), tH3);
                }
                tH3.usedInStar = true;
                TH tH4 = (TH)tH2.referMap.get(fKIndexAssociation.getObjectID());
                if (tH4 != tH) continue;
                tH2.referFK.remove(fKIndexAssociation);
                tH2.refer.remove(tH);
                tH2.referMap.remove(fKIndexAssociation.getObjectID());
                --tH2.refer_count;
                tH3.refer.add(tH);
                tH3.referFK.add(fKIndexAssociation);
                tH3.referMap.put(fKIndexAssociation.getObjectID(), tH);
                ++tH3.refer_count;
                tH.referredBy.remove(tH2);
                tH.referredByMap.remove(fKIndexAssociation.getObjectID());
                tH.referredBy.add(tH3);
                tH.referredByMap.put(fKIndexAssociation.getObjectID(), tH3);
                FK_TV_Edit fK_TV_Edit = new FK_TV_Edit(fKIndexAssociation, tH3.tv, false);
                this.getDesignPart().postUndoableEdit(fK_TV_Edit);
                fK_TV_Edit.applyUpdates();
                continue;
            }
            tH2.usedInStar = true;
        }
    }

    private TH createSynonmTH(TH tH, boolean bl, boolean bl2) {
        TH tH2 = new TH();
        this.createdTV.add(tH2);
        tH2.init_dim = new Dimension(tH.init_dim);
        if (bl) {
            tH2.refer.addAll(tH.refer);
            tH2.refer_count = tH.refer_count;
            tH2.referFK.addAll(tH.referFK);
        }
        if (bl2) {
            tH2.referredBy.addAll(tH.refer);
            tH2.referredBy_count = tH.refer_count;
            tH2.referredByFK.addAll(tH.referFK);
        }
        tH2.table = tH.table;
        tH2.tv = tH.tv.createViewSynonim(this);
        return tH2;
    }

    public void rearrangeNoneRefTables(List list) {
        this.width = 35;
        this.height = 50;
        this.count = 0;
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        for (TH tH : list) {
            ++this.count;
            Dimension dimension = tH.init_dim;
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            tH.location = new Point(this.left, this.top);
            tH.arranged = true;
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void resizeTable(TopView topView) {
        Dimension dimension = this.getTableSize((Table)topView.getModel(), this.getFontMetrics(topView));
        if (topView.getCellView() != null) {
            Point point = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(point.x, point.y), dimension));
        } else {
            Point point = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(point.x, point.y), dimension));
        }
    }

    public void resizeTables() {
        List list = (List)this.getTVTables();
        for (TopView topView : list) {
            if (topView == null) continue;
            this.resizeTable(topView);
        }
    }

    public void resizeView(TopView topView) {
        Dimension dimension = this.getTableViewSize((TableView)topView.getModel(), this.getFontMetrics(topView));
        if (topView.getCellView() != null) {
            Point point = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(point.x, point.y), dimension));
        } else {
            Point point = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(point.x, point.y), dimension));
        }
    }

    public void resizeViews() {
        List list = (List)this.getTVViews();
        for (TopView topView : list) {
            if (topView == null) continue;
            this.resizeView(topView);
        }
    }

    @Override
    public void resizeSelectedObjects() {
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] objectArray = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                TopView topView;
                Object object = objectArray[i];
                if (!(object instanceof DefaultDiagramCell) || (topView = ((DefaultDiagramCell)object).getTopView()) == null) continue;
                if (topView instanceof TVTable) {
                    this.resizeTable(topView);
                    continue;
                }
                if (!(topView instanceof TVView)) continue;
                this.resizeView(topView);
            }
        }
    }

    public int getMaxTopPoint() {
        Object object;
        Object object22;
        int n = 20;
        List list = (List)this.getTVTables();
        for (Object object22 : list) {
            if (object22 == null) continue;
            object = ((TopView)object22).getBounds();
            int n2 = ((Rectangle)object).y + ((Rectangle)object).height;
            n = Math.max(n, n2);
        }
        object22 = (List)this.getTVViews();
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (TopView)iterator.next();
            if (object == null) continue;
            Rectangle rectangle = ((TopView)object).getBounds();
            int n3 = rectangle.y + rectangle.height;
            n = Math.max(n, n3);
        }
        return n += 50;
    }

    public void rearrangeNewTables(List list, int n) {
        this.top = n;
        this.left = 20;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        Collections.sort(list, new TableComparator());
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        for (TopView topView : list) {
            if (topView == null) continue;
            ++this.count;
            Dimension dimension = this.getTableSize((Table)topView.getModel(), this.getFontMetrics(topView));
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void rearrangeTables() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        List list = (List)this.getTVTables();
        Collections.sort(list, new TableComparator());
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        for (TopView topView : list) {
            if (topView == null) continue;
            ++this.count;
            Dimension dimension = this.getTableSize((Table)topView.getModel(), this.getFontMetrics(topView));
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private Dimension getTableSize(Table table, FontMetrics fontMetrics) {
        int n;
        DesignObject designObject;
        int n2;
        int n3;
        int n4 = 35;
        int n5 = 25;
        int n6 = 0;
        int n7 = 1;
        String string = table.getName();
        StructuredType structuredType = null;
        if (table.isBST() && table.getBasedOnStructuredType() != null) {
            string = string + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        if (table.getSchemaObject() != null) {
            string = table.getSchemaObject().getName() + "." + string;
        }
        int n8 = fontMetrics.stringWidth(string);
        if (this.isShowNamesOnly()) {
            return new Dimension(n4 * 2 + n8, n5);
        }
        if (this.showAllDetails() || this.showElements() || this.showKeyElements()) {
            if (table.isBST() && table.getTypeSubstitution() != null) {
                structuredType = table.getBasedOnStructuredType();
                if (structuredType != null) {
                    n6 = structuredType.getElements().length;
                }
            } else if (this.showKeyElements()) {
                ContainedObject[] containedObjectArray = table.getElements();
                n3 = 0;
                for (n2 = 0; n2 < containedObjectArray.length; ++n2) {
                    designObject = (ContainedObjectWithDomain)containedObjectArray[n2];
                    if (!((ContainedObjectWithDomain)designObject).isPKElement() && !((ContainedObject)designObject).isFKElement() && !((ContainedObjectWithDomain)designObject).isUnique()) continue;
                    ++n3;
                }
                n6 = n3;
            } else {
                n6 = table.getElements().length;
            }
            n5 += n6 * 15;
        }
        int n9 = 0;
        if (this.showAllDetails() || this.showKeys() || this.showIndexes()) {
            n3 = 0;
            if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
                n5 += 6;
                for (n2 = 0; n2 < table.getKeys().length; ++n2) {
                    designObject = table.getKeys()[n2];
                    if (((KeyObject)designObject).isFK() || !this.showAllDetails() && ((((KeyObject)designObject).isPK() || ((KeyObject)designObject).isUnique()) && !this.showKeys() || !((KeyObject)designObject).isPK() && !((KeyObject)designObject).isUnique() && !this.showIndexes())) continue;
                    ++n3;
                    n = fontMetrics.stringWidth(table.getKeys()[n2].getName());
                    if (this.showAllDetails() || this.showKeyAndIndexColumns()) {
                        ContainedObject[] containedObjectArray;
                        String string2 = " (";
                        String string3 = null;
                        if (designObject instanceof Index && "".equals(string3 = (containedObjectArray = (ContainedObject[])designObject).getIndexExpression())) {
                            string3 = null;
                        }
                        if (string3 == null) {
                            containedObjectArray = table.getKeys()[n2].getElements();
                            for (int i = 0; i < containedObjectArray.length; ++i) {
                                ContainedObject containedObject = containedObjectArray[i];
                                String string4 = containedObject.getName();
                                if (i > 0) {
                                    string2 = string2 + ", ";
                                }
                                string2 = string2 + string4;
                            }
                        } else {
                            string2 = string2 + string3;
                        }
                        string2 = string2 + ")";
                        n += fontMetrics.stringWidth(string2);
                    }
                    n9 = Math.max(n, n9);
                }
            }
            if (n3 > 0) {
                n5 += n3 * 14;
            }
        }
        n3 = 1;
        for (n2 = 0; n2 < n6; ++n2) {
            int n10;
            if (structuredType != null) {
                designObject = structuredType.getElements()[n2];
                n = fontMetrics.stringWidth(designObject.getName());
                n3 = Math.max(n, n3);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                n10 = fontMetrics.stringWidth(((TypeElement)designObject).getDataType()) + 40;
                n7 = Math.max(n10, n7);
                continue;
            }
            designObject = (ContainedObjectWithDomain)table.getElement(n2);
            n = fontMetrics.stringWidth(((ContainedObject)designObject).getName());
            n3 = Math.max(n, n3);
            if (!this.showAllDetails() && !this.showDatatype()) continue;
            n10 = fontMetrics.stringWidth(((ContainedObjectWithDomain)designObject).getDataType().toString()) + 40;
            n7 = Math.max(n10, n7);
        }
        if (n3 == 1) {
            n3 = fontMetrics.stringWidth(table.getName());
        }
        n3 = Math.max(n9, n3 + n7);
        n3 = Math.max(n8, n3);
        return new Dimension(n4 + n3, n5);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void rearrangeNewViews(List list) {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.count = 0;
        this.width = 35;
        this.height = 25;
        Collections.sort(list, new TableViewComparator());
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        for (TopView topView : list) {
            if (topView == null) continue;
            ++this.count;
            Dimension dimension = this.getTableViewSize((TableView)topView.getModel(), this.getFontMetrics(topView));
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.count = 0;
        this.width = 35;
        this.height = 25;
        List list = (List)this.getTVViews();
        Collections.sort(list, new TableViewComparator());
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        for (TopView topView : list) {
            if (topView == null) continue;
            ++this.count;
            Dimension dimension = this.getTableViewSize((TableView)topView.getModel(), this.getFontMetrics(topView));
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private Dimension getTableViewSize(TableView tableView, FontMetrics fontMetrics) {
        int n;
        int n2 = 25;
        int n3 = 25;
        int n4 = 0;
        int n5 = 1;
        String string = tableView.getName();
        StructuredType structuredType = null;
        if (tableView.isBST() && tableView.getBasedOnStructuredType() != null) {
            string = string + " (" + tableView.getBasedOnStructuredType().getName() + ")";
        }
        if (tableView.getSchemaObject() != null) {
            string = tableView.getSchemaObject().getName() + "." + string;
        }
        int n6 = fontMetrics.stringWidth(string);
        if (this.isShowNamesOnly()) {
            return new Dimension(n2 * 2 + n6, n3);
        }
        if (this.showAllDetails() || this.showElements()) {
            if (tableView.isBST() && tableView.getTypeSubstitution() != null) {
                structuredType = tableView.getBasedOnStructuredType();
                if (structuredType != null) {
                    n4 = structuredType.getElements().length;
                }
            } else {
                n4 = tableView.getElements().length;
            }
            n3 += n4 * 15;
            if (this.showAllDetails() && (n = tableView.getUsedTablesAndViews().size()) > 0) {
                n3 += n * 15;
            }
        }
        n = 0;
        for (int i = 0; i < n4; ++i) {
            int n7;
            if (structuredType != null) {
                TypeElement typeElement = structuredType.getElements()[i];
                int n8 = fontMetrics.stringWidth(typeElement.getName());
                n = Math.max(n8, n);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                n7 = fontMetrics.stringWidth(typeElement.getDataType());
                n5 = Math.max(n7, n5);
                continue;
            }
            if (tableView.getColumns()[i] instanceof ColumnView) {
                ColumnView columnView = (ColumnView)tableView.getColumns()[i];
                String string2 = columnView.getAlias();
                if ("".equalsIgnoreCase(string2)) {
                    string2 = columnView.getReferencedName();
                }
                n7 = fontMetrics.stringWidth(string2);
                n = Math.max(n7, n);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                String string3 = columnView.getDataType();
                if (string3 == null && (string3 = columnView.getExpression()) == null) {
                    string3 = "";
                }
                int n9 = fontMetrics.stringWidth(string3);
                n5 = Math.max(n9, n5);
                continue;
            }
            int n10 = fontMetrics.stringWidth(tableView.getColumns()[i].getName());
            n = Math.max(n10, n);
        }
        if (n > 250) {
            n = 250;
        }
        n = Math.max(n6, n);
        return new Dimension(n2 + n + n5 + 10, n3);
    }

    @Override
    public void setZeroLayout() {
        if (!this.layOutchanging) {
            this.autoLayout = 0;
        }
    }

    @Override
    public void fireSelectionChanged() {
        if (((ControllerRelational)this.getController()).getNewArcAction() != null) {
            ((ControllerRelational)this.getController()).getNewArcAction().setEnabled(true);
        }
        if (((ControllerRelational)this.getController()).getAddToArcAction() != null) {
            ((ControllerRelational)this.getController()).getAddToArcAction().setEnabled(true);
        }
        if (((ControllerRelational)this.getController()).getRemoveFromArcAction() != null) {
            ((ControllerRelational)this.getController()).getRemoveFromArcAction().setEnabled(true);
        }
    }

    @Override
    public void createSubViewFromSelected() {
        Object[] objectArray = this.getSelectedObjects();
        this.createSubViewFromSelected(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubViewFromSelected(Object[] objectArray) {
        if (objectArray.length > 0) {
            this.getUndoManager().setLocked(true);
            try {
                DesignPartView designPartView = this.getApplicationView().createSubview(this);
                if (designPartView != null) {
                    FKIndexAssociation[] fKIndexAssociationArray;
                    ObjectListener objectListener;
                    Object object;
                    int n;
                    designPartView.setAutoRoute(false);
                    for (n = 0; n < objectArray.length; ++n) {
                        object = objectArray[n];
                        if (!(object instanceof Table) && !(object instanceof TableView)) continue;
                        objectListener = this.getViewFor((DesignObject)object);
                        fKIndexAssociationArray = ((ContainerView)objectListener).createViewSynonim(designPartView);
                        if (fKIndexAssociationArray.getCellView() != null) {
                            fKIndexAssociationArray.getCellView().setNewBounds(((TopView)objectListener).getBounds());
                        } else {
                            fKIndexAssociationArray.setBounds(((TopView)objectListener).getBounds());
                        }
                        if (fKIndexAssociationArray instanceof TVTable) {
                            ((TVTable)fKIndexAssociationArray).addTVFKRelations();
                            ((TVTable)fKIndexAssociationArray).addArcs();
                        }
                        fKIndexAssociationArray.addTVTypeSubstitutions();
                        designPartView.synchronizeSynonymWithDisplays((TopView)fKIndexAssociationArray);
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        object = objectArray[n];
                        if (!(object instanceof Table)) continue;
                        objectListener = (Table)object;
                        fKIndexAssociationArray = ((Table)objectListener).getFKAssociations();
                        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
                            Object object2;
                            int n2;
                            List list;
                            List list2;
                            TVConnector tVConnector = (TVConnector)fKIndexAssociationArray[i].getViewFor(this);
                            TVConnector tVConnector2 = (TVConnector)fKIndexAssociationArray[i].getViewFor(designPartView);
                            if (tVConnector2 == null || tVConnector == null) continue;
                            EdgeView edgeView = null;
                            if (tVConnector.getEdge() != null) {
                                edgeView = (EdgeView)tVConnector.getEdge().getCellView();
                            }
                            if (edgeView != null) {
                                list2 = edgeView.getPoints();
                                list = tVConnector2.getEdgePoints();
                                list.clear();
                                for (n2 = 0; n2 < list2.size(); ++n2) {
                                    object2 = list2.get(n2);
                                    Point2D point2D = null;
                                    if (object2 instanceof Point2D) {
                                        point2D = (Point2D)object2;
                                    } else if (object2 instanceof PortView) {
                                        point2D = ((PortView)object2).getPoint();
                                    }
                                    if (point2D == null) continue;
                                    list.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                                }
                                if (tVConnector2.getEdge() == null || tVConnector2.getEdge().getCellView() == null) continue;
                                Hashtable hashtable = new Hashtable();
                                DiagramConstants.setPoints(hashtable, list);
                                tVConnector2.getEdge().changeAttributes(hashtable);
                                tVConnector2.getEdge().getCellView().update();
                                if (list.size() != 2) continue;
                                tVConnector2.getEdge().straightLine(false);
                                continue;
                            }
                            list2 = tVConnector.getEdgePoints();
                            list = tVConnector2.getEdgePoints();
                            list.clear();
                            for (n2 = 0; n2 < list2.size(); ++n2) {
                                object2 = (Point2D)list2.get(n2);
                                list.add(DiagramConstants.createPoint(((Point2D)object2).getX(), ((Point2D)object2).getY()));
                            }
                        }
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        object = objectArray[n];
                        if (!(object instanceof Table) || (objectListener = (TVTable)designPartView.getViewFor((DesignObject)object)) == null) continue;
                        ((TVTable)objectListener).addArcs();
                    }
                    designPartView.setAutoRoute(this.isAutoRoute());
                    designPartView.getWorkSpace().updateSettings();
                }
            }
            finally {
                this.getUndoManager().setLocked(false);
            }
        }
    }

    @Override
    public void selectNeighbors(ContainerObject containerObject) {
        SelectNeighborsDialog selectNeighborsDialog = new SelectNeighborsDialog(this.getApplicationView(), true);
        selectNeighborsDialog.showDialog();
        int n = selectNeighborsDialog.getZones();
        int n2 = selectNeighborsDialog.getType();
        if (n > -1) {
            ArrayList<ContainerObject> arrayList = new ArrayList<ContainerObject>();
            Table table = (Table)containerObject;
            arrayList.add(containerObject);
            RelationalDesign.collectNeighbors(table, arrayList, n, n == 0, n2);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(arrayList).toArray());
        }
    }

    @Override
    public DP_UndoManager getUndoManager() {
        return this.getDesignPart().getUndoManager();
    }

    public void validateAllViews() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = System.currentTimeMillis();
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ProgressDialog progressDialog = new ProgressDialog(ApplicationView.getInstance(), "", 0, DPVRelational.this.getTVViews().size());
                    try {
                        Iterator iterator = DPVRelational.this.getTVViews().iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            TVView tVView = (TVView)iterator.next();
                            progressDialog.setNote("Validating View - " + tVView.getTableViewModel().getName());
                            progressDialog.setProgress(++n);
                            if (tVView.getTableViewModel().isValidSQL()) continue;
                            tVView.getTableViewModel().validateSQL();
                        }
                    }
                    finally {
                        progressDialog.close();
                        DPVRelational.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Validating All Views: ", exception);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
                System.out.println("validateAllViews Time: " + (System.currentTimeMillis() - l));
                System.gc();
            }
        });
        thread.start();
    }

    public void parseOlderStyleViews() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = System.currentTimeMillis();
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    QueryBuilder queryBuilder = new QueryBuilder(true);
                    PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
                    plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
                    plainTextSQLBuilder.setQueryBuilder(queryBuilder);
                    QBUtils.initMetadata(DPVRelational.this.getDesignPart(), queryBuilder, plainTextSQLBuilder);
                    ProgressDialog progressDialog = new ProgressDialog(ApplicationView.getInstance(), "", 0, DPVRelational.this.getTVViews().size());
                    try {
                        int n = 0x100000;
                        Runtime runtime = Runtime.getRuntime();
                        System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  free  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                        Iterator iterator = DPVRelational.this.getTVViews().iterator();
                        int n2 = 0;
                        while (iterator.hasNext()) {
                            TVView tVView = (TVView)iterator.next();
                            progressDialog.setNote("Parsing View - " + tVView.getTableViewModel().getName());
                            progressDialog.setProgress(++n2);
                            System.out.println("view " + n2 + " " + tVView.getTableViewModel().getName() + " memory  total  " + runtime.totalMemory() / (long)n + "  /memory  free  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                            if (tVView.getTableViewModel().isParsed()) continue;
                            tVView.getTableViewModel().parseOlderStyleView(queryBuilder, plainTextSQLBuilder);
                        }
                    }
                    finally {
                        progressDialog.close();
                        DPVRelational.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Parsing Older Style Views: ", exception);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
                System.out.println("parseOlderStyleViews Time: " + (System.currentTimeMillis() - l));
                System.gc();
            }
        });
        thread.start();
    }

    static /* synthetic */ int access$800(DPVRelational dPVRelational) {
        return dPVRelational.maxLevel;
    }

    public class FK_TV_Edit
    extends UpdateDO_Edit {
        FKIndexAssociation fk;
        TopView oldtv;
        TopView newtv;
        boolean source;
        DesignPartView dpv;
        private DesignObjectEdit.ConnectorStore cs;

        public FK_TV_Edit(FKIndexAssociation fKIndexAssociation, TopView topView, boolean bl) {
            super(fKIndexAssociation);
            this.source = false;
            this.fk = fKIndexAssociation;
            this.dpv = topView.getDesignPartView();
            this.source = bl;
            this.newtv = topView;
            this.oldtv = bl ? fKIndexAssociation.getSourceTV(this.dpv) : fKIndexAssociation.getTargetTV(this.dpv);
            TVConnector tVConnector = (TVConnector)fKIndexAssociation.getFirstViewForDPV(this.dpv);
            if (tVConnector != null) {
                this.cs = this.backupTVConnector(tVConnector);
            }
        }

        @Override
        public void applyUpdates() {
            MultiShapedDesignObject multiShapedDesignObject = (MultiShapedDesignObject)this.newtv.getModel();
            int n = multiShapedDesignObject.getViewNumber(this.newtv);
            if (n < 0) {
                multiShapedDesignObject.addTopView(this.newtv);
            }
            if (this.source) {
                this.fk.setSourceTopView(this.newtv);
            } else {
                this.fk.setTargetTopView(this.newtv);
            }
        }

        @Override
        protected void restoreObject() {
            MultiShapedDesignObject multiShapedDesignObject = (MultiShapedDesignObject)this.newtv.getModel();
            int n = multiShapedDesignObject.getViewNumber(this.newtv);
            if (n >= 0) {
                multiShapedDesignObject.removeViewSynonim(this.newtv);
            }
            if (this.source) {
                this.fk.setSourceTopView(this.oldtv);
            } else {
                this.fk.setTargetTopView(this.oldtv);
            }
            if (this.cs != null) {
                this.restoreConnectorTopView(this.fk, this.cs);
            }
        }
    }

    class THReferredByComparatorAsc2
    implements Comparator {
        THReferredByComparatorAsc2() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.referredBy_count > tH2.referredBy_count) {
                return 1;
            }
            if (tH.referredBy_count < tH2.referredBy_count) {
                return -1;
            }
            if (tH.refer_count > tH2.refer_count) {
                return 1;
            }
            if (tH.refer_count < tH2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorAsc1
    implements Comparator {
        THReferredByComparatorAsc1() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.referredBy_count > tH2.referredBy_count) {
                return 1;
            }
            if (tH.referredBy_count < tH2.referredBy_count) {
                return -1;
            }
            if (tH.refer_count < tH2.refer_count) {
                return 1;
            }
            if (tH.refer_count > tH2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorDesc
    implements Comparator {
        THReferredByComparatorDesc() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.referredBy_count < tH2.referredBy_count) {
                return 1;
            }
            if (tH.referredBy_count > tH2.referredBy_count) {
                return -1;
            }
            if (tH.refer_count < tH2.refer_count) {
                return 1;
            }
            if (tH.refer_count > tH2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferComparatorDesc
    implements Comparator {
        THReferComparatorDesc() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.refer_count < tH2.refer_count) {
                return 1;
            }
            if (tH.refer_count > tH2.refer_count) {
                return -1;
            }
            if (tH.referredBy_count < tH2.referredBy_count) {
                return 1;
            }
            if (tH.referredBy_count > tH2.referredBy_count) {
                return -1;
            }
            return 0;
        }
    }

    class THHeightComparatorAsc
    implements Comparator {
        THHeightComparatorAsc() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.init_dim.height > tH2.init_dim.height) {
                return 1;
            }
            if (tH.init_dim.height < tH2.init_dim.height) {
                return -1;
            }
            return 0;
        }
    }

    class THHeightComparatorDesc
    implements Comparator {
        THHeightComparatorDesc() {
        }

        public int compare(Object object, Object object2) {
            TH tH = (TH)object;
            TH tH2 = (TH)object2;
            if (tH.rect.height < tH2.rect.height) {
                return 1;
            }
            if (tH.rect.height > tH2.rect.height) {
                return -1;
            }
            return 0;
        }
    }

    class TableViewComparator
    implements Comparator {
        TableViewComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            TableView tableView = (TableView)((TopView)object).getModel();
            TableView tableView2 = (TableView)((TopView)object2).getModel();
            int n2 = tableView.getElementsCollection().size();
            if (n2 < (n = tableView2.getElementsCollection().size())) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }
    }

    class TableComparator
    implements Comparator {
        TableComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3;
            int n4;
            Table table = (Table)((TopView)object).getModel();
            Table table2 = (Table)((TopView)object2).getModel();
            int n5 = table.getFKAssociationsCount();
            if (n5 < (n4 = table2.getFKAssociationsCount())) {
                return 1;
            }
            if (n5 > n4) {
                return -1;
            }
            int n6 = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table).size();
            if (n6 < (n3 = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table2).size())) {
                return 1;
            }
            if (n6 > n3) {
                return -1;
            }
            int n7 = table.getElementsCollection().size();
            if (n7 < (n2 = table2.getElementsCollection().size())) {
                return 1;
            }
            if (n7 > n2) {
                return -1;
            }
            int n8 = table.getKeySet().size();
            if (n8 < (n = table2.getKeySet().size())) {
                return 1;
            }
            if (n8 > n) {
                return -1;
            }
            return 0;
        }
    }

    class TH {
        TopView tv;
        Table table;
        List refer = new ArrayList();
        List referFK = new ArrayList();
        int refer_count = 0;
        List referredBy = new ArrayList();
        List referredByFK = new ArrayList();
        int referredBy_count = 0;
        Dimension init_dim;
        Dimension dim;
        Point location;
        int level = DPVRelational.access$800(DPVRelational.this);
        boolean arranged = false;
        boolean booked = false;
        boolean scanned = false;
        boolean star = false;
        boolean usedInStar = false;
        Rectangle rect;
        List nodes = new ArrayList();
        Map referMap = new TreeMap();
        Map referredByMap = new TreeMap();
        Map synonymsMap = new TreeMap();

        TH() {
        }

        public String toString() {
            if (this.table != null) {
                return this.table.getName();
            }
            return "nunnn";
        }

        public boolean isScanConnectedToBetterLevel(TH tH, int n) {
            for (TH tH2 : this.refer) {
                if (tH2 == tH || tH2.level >= n || tH2.scanned) continue;
                return true;
            }
            for (TH tH2 : this.referredBy) {
                if (tH2 == tH || tH2.level >= n || tH2.scanned) continue;
                return true;
            }
            return false;
        }

        public boolean isConnectdToBetterLevel(TH tH, int n) {
            for (TH tH2 : this.refer) {
                if (tH2 == tH || tH2.level >= n || tH2.arranged) continue;
                return true;
            }
            for (TH tH2 : this.referredBy) {
                if (tH2 == tH || tH2.level >= n || tH2.arranged) continue;
                return true;
            }
            return false;
        }

        private boolean referNodesWithNorefs() {
            for (TH tH : this.refer) {
                if (tH.refer.size() <= 0 || tH.referredBy.size() <= 1) continue;
                return false;
            }
            return true;
        }

        private boolean referOnly(TH tH) {
            for (TH tH2 : this.refer) {
                if (tH2 == tH) continue;
                return false;
            }
            for (TH tH2 : this.referredBy) {
                if (tH2 == tH) continue;
                return false;
            }
            return true;
        }

        private boolean referOnlyAndArranged(TH tH) {
            for (TH tH2 : this.refer) {
                if (tH2 == tH || tH2.arranged) continue;
                return false;
            }
            for (TH tH2 : this.referredBy) {
                if (tH2 == tH || tH2.arranged) continue;
                return false;
            }
            return true;
        }
    }
}

