/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class ControllerTransformation
extends AbstractController {
    private DesignPartView designPV = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private ProcessObjectCollector poCollector = null;
    private NewTransformation newTransformation;
    private NewInfoStore newInfoStore;
    private NewFlow newFlow;
    private NewNote newNote;
    private Delete delete;
    private final String[] OBJECT_PROCESS_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.TRANSFORMATION_CAPTION};

    public ControllerTransformation(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectTransformationMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PROCESS_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newTransformation = new NewTransformation();
            this.newInfoStore = new NewInfoStore();
            this.newFlow = new NewFlow();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newTransformation);
            this.add(this.newInfoStore);
            this.add(this.newFlow);
            this.add(this.newNote);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerTransformation.DataFlow");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.designPV = designPartView;
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newTransformation, bl);
        this.setEnabled(this.newInfoStore, bl);
        this.setEnabled(this.newFlow, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    public class ProcessObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        public ProcessObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerTransformation.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerTransformation.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            AbstractDataFlowTV abstractDataFlowTV = this.getTVEntityFor(pointArray[0]);
            AbstractDataFlowTV abstractDataFlowTV2 = this.getTVEntityFor(pointArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (abstractDataFlowTV == null) {
                arrayList.add(Messages.getString("ControllerTransformation.NoSourceObjectSelected"));
            }
            if (abstractDataFlowTV2 == null) {
                arrayList.add(Messages.getString("ControllerTransformation.NoDestinationObjectSelected"));
            }
            if (abstractDataFlowTV != null && abstractDataFlowTV == abstractDataFlowTV2) {
                arrayList.add(Messages.getString("ControllerTransformation.SourceTargetEquals"));
            } else if (abstractDataFlowTV != null && abstractDataFlowTV2 != null) {
                if (abstractDataFlowTV.getModel() instanceof InOutParams && abstractDataFlowTV2.getModel() instanceof InOutParams) {
                    arrayList.add(Messages.getString("ControllerTransformation.DirectFlowNotPermitted"));
                }
                if (abstractDataFlowTV.getModel() instanceof InOutParams && ((InOutParams)abstractDataFlowTV.getModel()).getInOutType().equalsIgnoreCase("Output")) {
                    arrayList.add(Messages.getString("ControllerTransformation.OutgoingFlowNotPermitted"));
                }
                if (abstractDataFlowTV2.getModel() instanceof InOutParams && ((InOutParams)abstractDataFlowTV2.getModel()).getInOutType().equalsIgnoreCase("Input")) {
                    arrayList.add(Messages.getString("ControllerTransformation.FlowNotPermitted"));
                }
            }
            if (arrayList.size() == 0) {
                AbstractProcessObject abstractProcessObject = (AbstractProcessObject)abstractDataFlowTV.getModel();
                AbstractProcessObject abstractProcessObject2 = (AbstractProcessObject)abstractDataFlowTV2.getModel();
                if (!(abstractProcessObject instanceof Transformation) && !(abstractProcessObject2 instanceof Transformation)) {
                    arrayList.add(Messages.getString("ControllerTransformation.OneShouldBeTransformation"));
                }
                if (arrayList.size() == 0) {
                    this.createFlow(abstractDataFlowTV, abstractDataFlowTV2);
                } else {
                    JOptionPane.showMessageDialog(ControllerTransformation.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerTransformation.NewFlow"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(ControllerTransformation.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerTransformation.NewFlow"), 0);
            }
            this.startCollecting();
        }

        private AbstractDataFlowTV getTVEntityFor(Point point) {
            Object object = ControllerTransformation.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof DFDiagramCell) {
                return (AbstractDataFlowTV)((DFDiagramCell)object).getTopView();
            }
            return null;
        }

        private void createFlow(AbstractDataFlowTV abstractDataFlowTV, AbstractDataFlowTV abstractDataFlowTV2) {
            ApplicationView.log(Messages.getString("ControllerTransformation.CreateFlow"));
            DesignPartView designPartView = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            if (designPartView instanceof DPVTransformation) {
                TransformationTask transformationTask = (TransformationTask)designPartView.getDesignPart();
                TransformationFlow transformationFlow = transformationTask.createFlow();
                transformationFlow.setSourceTV(abstractDataFlowTV);
                transformationFlow.setTargetTV(abstractDataFlowTV2);
                ((TVFlow)transformationFlow.getTopView()).addConnection();
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerTransformation.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("SEARCH_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerTransformation.this.getApplicationView().search(3);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerTransformation.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerTransformation.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("DELETE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("NOTE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewInfoStore
    extends MDBAction {
        private NewInfoStore() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STORE_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("INFO_STORE_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STORE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(9);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class NewFlow
    extends MDBAction {
        private NewFlow() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FLOW_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("FLOW_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FLOW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(10);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerTransformation.this.updateToolbar(this);
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.poCollector = new ProcessObjectCollector();
        }
    }

    class NewTransformation
    extends MDBAction {
        private NewTransformation() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TRANSFORMATION_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("PROCESS_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TRANSFORMATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(15);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerTransformation.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerTransformation.this.getConfiguration().getIcon("SELECT_ICON", ControllerTransformation.this.getPreferredIconSize()));
            this.setMenuPath(ControllerTransformation.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerTransformation.this.poCollector != null) {
                ControllerTransformation.this.poCollector.stopWaiting();
            }
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerTransformation.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerTransformation.this.updateToolbar(this);
        }
    }
}

