/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class ControllerProcess
extends AbstractController {
    private DesignPartView designPV = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private ProcessObjectCollector poCollector = null;
    private NewProcess newProcess;
    private NewAgent newAgent;
    private NewInfoStore newInfoStore;
    private NewFlow newFlow;
    private NewNote newNote;
    private Delete delete;
    private final String[] OBJECT_PROCESS_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.DATAFLOW_CAPTION};

    public ControllerProcess(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectProcessMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PROCESS_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newProcess = new NewProcess();
            this.newAgent = new NewAgent();
            this.newInfoStore = new NewInfoStore();
            this.newFlow = new NewFlow();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newProcess);
            this.add(this.newAgent);
            this.add(this.newInfoStore);
            this.add(this.newFlow);
            this.add(this.newNote);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerProcess.DataFlow");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.designPV = designPartView;
    }

    @Override
    public boolean canPaste() {
        for (Object e : this.getApplicationView().getCopiedObjects()) {
            if (e == null || !(e instanceof Process) && !(e instanceof ExternalAgent) && !(e instanceof InfoStore)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point point) {
        if (this.canPaste()) {
            try {
                Object object;
                Object object22;
                Object object3;
                AbstractProcessObject abstractProcessObject;
                ApplicationView.canLogging = false;
                int n = 0;
                int n2 = 0;
                HashMap<String, AbstractProcessObject> hashMap = null;
                for (Object object4 : this.getApplicationView().getCopiedObjects()) {
                    Object object5;
                    AbstractProcessObject abstractProcessObject2;
                    if (!(object4 instanceof DesignObject)) continue;
                    if (object4 instanceof Process) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateProcess"));
                        abstractProcessObject2 = (Process)object4;
                        abstractProcessObject = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createProcess();
                        abstractProcessObject2.copy(abstractProcessObject);
                        if (hashMap == null) {
                            hashMap = new HashMap<String, AbstractProcessObject>();
                        }
                        hashMap.put(abstractProcessObject2.getObjectID(), abstractProcessObject);
                        object3 = this.getDesignPartView().getViewFor(abstractProcessObject);
                        if (object3 == null || ((TopView)object3).getCellView() == null || (object5 = abstractProcessObject2.getTopView()) == null || ((TopView)object5).getCellView() == null) continue;
                        object22 = null;
                        if (point != null) {
                            object22 = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
                        }
                        object = new Rectangle(((TopView)object5).getCellView().getBounds().getBounds());
                        if (object22 != null) {
                            ((Rectangle)object).x = (int)((Point2D)object22).getX() + n;
                            ((Rectangle)object).y = (int)((Point2D)object22).getY() + n2;
                        } else {
                            ((Rectangle)object).x += 30 + n;
                            ((Rectangle)object).y += 30 + n2;
                        }
                        ((TopView)object3).getCellView().setNewBounds((Rectangle)object);
                        n += 20;
                        n2 += 20;
                        continue;
                    }
                    if (object4 instanceof ExternalAgent) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateExternalAgent"));
                        abstractProcessObject2 = (ExternalAgent)object4;
                        abstractProcessObject = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createExternalAgent();
                        ((ExternalAgent)abstractProcessObject2).copy(abstractProcessObject);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        hashMap.put(abstractProcessObject2.getObjectID(), abstractProcessObject);
                        object3 = this.getDesignPartView().getViewFor(abstractProcessObject);
                        if (object3 == null || ((TopView)object3).getCellView() == null || (object5 = abstractProcessObject2.getTopView()) == null || ((TopView)object5).getCellView() == null) continue;
                        object22 = new Rectangle(((TopView)object5).getCellView().getBounds().getBounds());
                        object = null;
                        if (point != null) {
                            object = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
                        }
                        if (object != null) {
                            ((Rectangle)object22).x = (int)((Point2D)object).getX() + n;
                            ((Rectangle)object22).y = (int)((Point2D)object).getY() + n2;
                        } else {
                            ((Rectangle)object22).x += 30 + n;
                            ((Rectangle)object22).y += 30 + n2;
                        }
                        ((TopView)object3).getCellView().setNewBounds((Rectangle)object22);
                        n += 20;
                        n2 += 20;
                        continue;
                    }
                    if (!(object4 instanceof InfoStore)) continue;
                    ApplicationView.log(Messages.getString("ControllerProcess.CreateInformationStore"));
                    abstractProcessObject2 = (InfoStore)object4;
                    abstractProcessObject = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createInfoStore();
                    ((InfoStore)abstractProcessObject2).copy(abstractProcessObject);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(abstractProcessObject2.getObjectID(), abstractProcessObject);
                    object3 = this.getDesignPartView().getViewFor(abstractProcessObject);
                    if (object3 == null || ((TopView)object3).getCellView() == null || (object5 = abstractProcessObject2.getTopView()) == null || ((TopView)object5).getCellView() == null) continue;
                    object22 = new Rectangle(((TopView)object5).getCellView().getBounds().getBounds());
                    object = null;
                    if (point != null) {
                        object = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
                    }
                    if (object != null) {
                        ((Rectangle)object22).x = (int)((Point2D)object).getX() + n;
                        ((Rectangle)object22).y = (int)((Point2D)object).getY() + n2;
                    } else {
                        ((Rectangle)object22).x += 30 + n;
                        ((Rectangle)object22).y += 30 + n2;
                    }
                    ((TopView)object3).getCellView().setNewBounds((Rectangle)object22);
                    n += 20;
                    n2 += 20;
                }
                if (hashMap != null) {
                    Object object4;
                    object4 = new HashMap();
                    for (AbstractProcessObject abstractProcessObject2 : this.getApplicationView().getCopiedObjects()) {
                        Object object6;
                        TopView topView;
                        Object object7;
                        DesignObject designObject;
                        if (!(abstractProcessObject2 instanceof AbstractProcessObject)) continue;
                        abstractProcessObject = abstractProcessObject2;
                        object3 = (AbstractProcessObject)hashMap.get(abstractProcessObject.getObjectID());
                        for (Object object22 : abstractProcessObject.getIncomingFlows()) {
                            object = ((Flow)object22).getSourceObject();
                            designObject = (DesignObject)hashMap.get(((ModelIDObject)object).getObjectID());
                            object7 = null;
                            object7 = designObject != null ? this.getDesignPartView().getFirstViewFor(designObject) : this.getDesignPartView().getFirstViewFor((DesignObject)object);
                            topView = this.getDesignPartView().getFirstViewFor((DesignObject)object3);
                            if (object7 == null || topView == null || object4.get(((TopView)object7).getViewID() + topView.getViewID()) != null) continue;
                            object6 = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createFlow();
                            ((Flow)object6).setSourceTV((AbstractDataFlowTV)object7);
                            ((Flow)object6).setTargetTV((AbstractDataFlowTV)topView);
                            ((TVFlow)((Flow)object6).getViewFor(this.getDesignPartView())).addConnection();
                            ((Flow)object6).addToAllDPVs(this.getDesignPartView());
                            object4.put(((TopView)object7).getViewID() + topView.getViewID(), topView.getViewID());
                        }
                        object22 = abstractProcessObject.getOutgoingFlows().iterator();
                        while (object22.hasNext()) {
                            object = (Flow)object22.next();
                            designObject = ((Flow)object).getTargetObject();
                            object7 = (DesignObject)hashMap.get(designObject.getObjectID());
                            topView = this.getDesignPartView().getFirstViewFor((DesignObject)object3);
                            object6 = null;
                            object6 = object7 != null ? this.getDesignPartView().getFirstViewFor((DesignObject)object7) : this.getDesignPartView().getFirstViewFor(designObject);
                            if (topView == null || object6 == null || object4.get(topView.getViewID() + ((TopView)object6).getViewID()) != null) continue;
                            Flow flow = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createFlow();
                            flow.setSourceTV((AbstractDataFlowTV)topView);
                            flow.setTargetTV((AbstractDataFlowTV)object6);
                            ((TVFlow)flow.getViewFor(this.getDesignPartView())).addConnection();
                            flow.addToAllDPVs(this.getDesignPartView());
                            object4.put(topView.getViewID() + ((TopView)object6).getViewID(), ((TopView)object6).getViewID());
                        }
                    }
                }
                this.getDesign().setDirty(true);
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newProcess, bl);
        this.setEnabled(this.newAgent, bl);
        this.setEnabled(this.newInfoStore, bl);
        this.setEnabled(this.newFlow, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    public class ProcessObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        public ProcessObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerProcess.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerProcess.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            AbstractDataFlowTV abstractDataFlowTV = this.getTVEntityFor(pointArray[0]);
            AbstractDataFlowTV abstractDataFlowTV2 = this.getTVEntityFor(pointArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (abstractDataFlowTV == null) {
                arrayList.add(Messages.getString("ControllerProcess.NoSourceObjectSelected"));
            }
            if (abstractDataFlowTV2 == null) {
                arrayList.add(Messages.getString("ControllerProcess.NoDestinationObjectSelected"));
            }
            if (abstractDataFlowTV != null && abstractDataFlowTV == abstractDataFlowTV2) {
                arrayList.add(Messages.getString("ControllerProcess.SourceTargetEquals"));
            }
            if (arrayList.size() == 0) {
                AbstractProcessObject abstractProcessObject = (AbstractProcessObject)abstractDataFlowTV.getModel();
                AbstractProcessObject abstractProcessObject2 = (AbstractProcessObject)abstractDataFlowTV2.getModel();
                if (!(abstractProcessObject instanceof Process) && !(abstractProcessObject2 instanceof Process)) {
                    arrayList.add(Messages.getString("ControllerProcess.OneObjectShouldBeProcess"));
                }
                DesignPart designPart = ControllerProcess.this.getApplicationView().getCurrentDPV().getDesignPart();
                if (abstractProcessObject instanceof Process && abstractProcessObject2 instanceof Process && abstractProcessObject.getDesignPart() != designPart && abstractProcessObject2.getDesignPart() != designPart) {
                    arrayList.add(Messages.getString("ControllerProcess.SourceDestinationObjectNotInCurrentLevel"));
                }
                if (arrayList.size() == 0) {
                    this.createFlow(abstractDataFlowTV, abstractDataFlowTV2);
                } else {
                    JOptionPane.showMessageDialog(ControllerProcess.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerProcess.NewFlow"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(ControllerProcess.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerProcess.NewFlow"), 0);
            }
            this.startCollecting();
        }

        private AbstractDataFlowTV getTVEntityFor(Point point) {
            Object object = ControllerProcess.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof DFDiagramCell) {
                return (AbstractDataFlowTV)((DFDiagramCell)object).getTopView();
            }
            return null;
        }

        private void createFlow(AbstractDataFlowTV abstractDataFlowTV, AbstractDataFlowTV abstractDataFlowTV2) {
            ApplicationView.log(Messages.getString("ControllerProcess.CreateFlow"));
            Flow flow = ControllerProcess.this.getDesign().getProcessModel().getDataFlowDesign().createFlow();
            flow.setSourceTV(abstractDataFlowTV);
            flow.setTargetTV(abstractDataFlowTV2);
            ((TVFlow)flow.getViewFor(abstractDataFlowTV.getDesignPartView())).addConnection();
            flow.addToAllDPVs(ControllerProcess.this.getApplicationView().getCurrentDPV());
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerProcess.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerProcess.this.getConfiguration().getIcon("SEARCH_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerProcess.this.getApplicationView().search(3);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerProcess.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerProcess.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerProcess.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerProcess.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerProcess.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerProcess.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("DELETE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("NOTE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewInfoStore
    extends MDBAction {
        private NewInfoStore() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STORE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("INFO_STORE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STORE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(9);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewAgent
    extends MDBAction {
        private NewAgent() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_AGENT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("AGENT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_AGENT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(8);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewFlow
    extends MDBAction {
        private NewFlow() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FLOW_CAPTION), ControllerProcess.this.getConfiguration().getIcon("FLOW_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FLOW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(10);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerProcess.this.updateToolbar(this);
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.poCollector = new ProcessObjectCollector();
        }
    }

    class NewProcess
    extends MDBAction {
        private NewProcess() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_PROCESS_CAPTION), ControllerProcess.this.getConfiguration().getIcon("PROCESS_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_PROCESS_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(7);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("SELECT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerProcess.this.updateToolbar(this);
        }
    }
}

