/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.swingui.printing.SVGErrorHandler;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ErrorHandler;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGPrinter {
    private PrintPreviewModel model;
    private PrinterJob prnJob;
    private List fileList;
    private static final Logger LOGGER = new Logger(SVGPrinter.class);

    public SVGPrinter(PrinterJob printerJob, PrintPreviewModel printPreviewModel) {
        this.prnJob = printerJob;
        this.model = printPreviewModel;
        this.fileList = new ArrayList();
    }

    private boolean writeSVG(Diagram diagram) {
        try {
            this.fileList.clear();
            DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
            Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
            sVGGraphics2D.getGeneratorContext().setErrorHandler((ErrorHandler)new SVGErrorHandler());
            int n = this.model.getNumberOfPages();
            File file = new File(System.getProperty("java.io.tmpdir"), "svg");
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                for (int i = fileArray.length - 1; i >= 0; --i) {
                    fileArray[i].delete();
                }
            } else {
                file.mkdir();
            }
            for (int i = 0; i < n; ++i) {
                this.model.print((Graphics)sVGGraphics2D, null, i);
                String string = String.format("temp_%d.svg", i);
                File file2 = new File(file, string);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                sVGGraphics2D.stream((Writer)outputStreamWriter, false);
                ((Writer)outputStreamWriter).close();
                this.fileList.add(file2.getAbsolutePath());
            }
            sVGGraphics2D.dispose();
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("SVGPrinter.writeSVG", exception);
            return false;
        }
    }

    public void print() {
        try {
            Diagram diagram = (Diagram)this.model.getObjectToPrint();
            if (this.writeSVG(diagram)) {
                Object object;
                Object object22;
                PageablePrintTranscoder pageablePrintTranscoder = new PageablePrintTranscoder();
                for (Object object22 : this.fileList) {
                    object = new File((String)object22);
                    TranscoderInput transcoderInput = new TranscoderInput(((File)object).toURL().toString());
                    pageablePrintTranscoder.transcode(transcoderInput, null);
                }
                object22 = (PageFormat)this.model.getPageFormat().clone();
                object = ((PageFormat)object22).getPaper();
                float f = (float)((Paper)object).getWidth();
                float f2 = (float)((Paper)object).getHeight();
                ((Paper)object).setImageableArea(0.0, 0.0, f, f2);
                ((PageFormat)object22).setPaper((Paper)object);
                pageablePrintTranscoder.setNumberOfPages(this.model.getNumberOfPages());
                pageablePrintTranscoder.setPageFormat((PageFormat)object22);
                this.prnJob.setPageable(pageablePrintTranscoder);
                this.prnJob.setJobName(diagram.getDesignPartView().getDesign().getName());
                this.prnJob.print();
            }
        }
        catch (Exception exception) {
            LOGGER.error("SVGPrinter.export", exception);
            MessageDialogs.showErrorMessage("Error occures while printing diagram.");
        }
    }

    private class PageablePrintTranscoder
    extends PrintTranscoder
    implements Pageable {
        private PageFormat pageFormat;
        private int nbrPages = 0;

        private PageablePrintTranscoder() {
        }

        @Override
        public int getNumberOfPages() {
            return this.nbrPages;
        }

        @Override
        public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
            return this.pageFormat;
        }

        @Override
        public Printable getPrintable(int n) throws IndexOutOfBoundsException {
            if (n >= this.nbrPages) {
                throw new IndexOutOfBoundsException("Number of pages : " + this.nbrPages + " Requested pageindex : " + n);
            }
            return this;
        }

        public void setPageFormat(PageFormat pageFormat) {
            this.pageFormat = pageFormat;
        }

        public void setNumberOfPages(int n) {
            this.nbrPages = n;
        }
    }
}

