/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;

public class PagePreview
extends JPanel {
    private int previewWidth;
    private int previewHeight;
    private int pageindex;
    private PrintPreviewModel model;

    public PagePreview(PrintPreviewModel printPreviewModel, int n) {
        this.previewWidth = printPreviewModel.getPreviewWidth();
        this.previewHeight = printPreviewModel.getPreviewHeight();
        this.pageindex = n;
        this.model = printPreviewModel;
        this.setBackground(Color.white);
        this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
    }

    @Override
    public final void setBackground(Color color) {
        super.setBackground(color);
    }

    @Override
    public final void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.previewWidth + insets.left + insets.right, this.previewHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintBorder(graphics);
        this.model.printPreview(graphics, this.pageindex);
    }
}

