/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.AbstractExporter;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PDFDocument;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFilter;
import org.apache.batik.transcoder.TranscoderOutput;

public class PDFExporter
extends AbstractExporter {
    private static final Logger LOGGER = new Logger(PDFExporter.class);

    public PDFExporter(ApplicationView applicationView) {
        super(applicationView);
        this.getFilterList().add(new PDFFileFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Diagram diagram) {
        block5: {
            try {
                File file = this.getFile();
                if (file == null) break block5;
                String string = this.getFileName(file);
                TimeLog.log("Export Started");
                RepaintManager repaintManager = RepaintManager.currentManager(diagram);
                repaintManager.setDoubleBufferingEnabled(false);
                ProgressDialog progressDialog = new ProgressDialog(this.getAppView(), "", 0, 100, true);
                try {
                    progressDialog.setNote(Messages.getString("PDFExporter.SavingFileWait"));
                    progressDialog.setProgress(1);
                    PDFDocument pDFDocument = new PDFDocument();
                    Dimension dimension = diagram.getPreferredScrollableViewportSize();
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
                    pDFDocument.transcode(diagram, transcoderOutput, (float)dimension.getWidth() + 10.0f, (float)dimension.getHeight() + 10.0f);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    TimeLog.log("Export End");
                }
                finally {
                    repaintManager.setDoubleBufferingEnabled(true);
                    progressDialog.close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("PDFExporter.export", exception);
                MessageDialogs.showErrorMessage("Error occures while saving PDF file.");
            }
        }
    }

    protected String getDefaultExtension() {
        return ".pdf";
    }

    @Override
    protected String getTitle() {
        return Messages.getString("PDFExporter.SaveAsPDF");
    }

    @Override
    protected boolean isSupportedExtension(String string) {
        return string.equals("pdf");
    }

    private class PDFFileFilter
    implements URLFilter {
        private PDFFileFilter() {
        }

        public boolean accept(URL uRL) {
            File file = new File(uRL.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String string = AbstractExporter.getExtension(file);
            if (string != null) {
                return PDFExporter.this.isSupportedExtension(string);
            }
            return false;
        }

        public String toString() {
            return Messages.getString("PDFExporter.PDFFiles");
        }
    }
}

