/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.util.Extension;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class PDFDocument
extends PDFDocumentGraphics2D {
    private Map map = new TreeMap();

    public PDFDocument() {
        super(false);
    }

    public PDFDocument(boolean bl) {
        super(bl);
    }

    public PDFDocument(PDFDocumentGraphics2D pDFDocumentGraphics2D) {
        super(pDFDocumentGraphics2D);
    }

    public Graphics create() {
        return new PDFDocument(this);
    }

    private boolean isUnicodeStr(String string) {
        try {
            int n = string.length();
            int n2 = string.getBytes("UTF-8").length;
            return n < n2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private org.apache.fop.fonts.Font getOrCreateFont() {
        Font font = super.getFont();
        String string = font.getFamily();
        int n = font.getSize();
        int n2 = font.getStyle();
        int n3 = 1;
        if (n2 == 2) {
            n3 = 2;
        } else if (n2 == 1) {
            n3 = 3;
        } else if (n2 == 3) {
            n3 = 4;
        }
        if (string.toLowerCase().indexOf("roman") > -1) {
            n3 += 4;
        } else if (string.toLowerCase().indexOf("courier") > -1) {
            n3 += 8;
        }
        String string2 = "F" + String.valueOf(n3);
        FontMetrics fontMetrics = this.getFontInfo().getMetricsFor(string2);
        FontTriplet fontTriplet = this.getFontInfo().getTripletFor(string2);
        String string3 = String.format("%s_%d", string2, n);
        org.apache.fop.fonts.Font font2 = (org.apache.fop.fonts.Font)this.map.get(string3);
        if (font2 == null) {
            font2 = new org.apache.fop.fonts.Font(string, fontTriplet, fontMetrics, n * 1000);
            this.map.put(string3, font2);
        }
        return font2;
    }

    public void drawString(String string, float f, float f2) {
        if (this.isUnicodeStr(string)) {
            Font font = super.getFont();
            FontRenderContext fontRenderContext = super.getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Shape shape = glyphVector.getOutline(f, f2);
            super.fill(shape);
        } else {
            this.setOverrideFontState(this.getOrCreateFont());
            super.drawString(string, f, f2);
        }
    }

    public void transcode(JComponent jComponent, TranscoderOutput transcoderOutput, float f, float f2) throws TranscoderException {
        this.getPDFDocument().getInfo().setProducer(Extension.getExtensionVersion());
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream);
            }
            this.setupDocument(outputStream, (int)f, (int)f2);
            this.setSVGDimension(f, f2);
            this.setGraphicContext(new GraphicContext());
            this.preparePainting();
            this.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Vector");
            jComponent.print((Graphics)((Object)this));
            this.finish();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }
}

