/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public abstract class AbstractExporter {
    protected static final String PNG = "png";
    protected static final String JPG = "jpg";
    protected static final String GIF = "gif";
    protected static final String SVG = "svg";
    protected static final String PDF = "pdf";
    private static File lastFolder = null;
    protected URLChooser fileChooser = DialogUtil.newURLChooser();
    private static final Logger LOGGER = new Logger(AbstractExporter.class);
    private ApplicationView appView;
    private List filterList;

    public AbstractExporter(ApplicationView applicationView) {
        this.appView = applicationView;
        this.filterList = new ArrayList();
    }

    public abstract void export(Diagram var1);

    protected abstract boolean isSupportedExtension(String var1);

    public ApplicationView getAppView() {
        return this.appView;
    }

    public List getFilterList() {
        return this.filterList;
    }

    protected static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    protected abstract String getTitle();

    private String getDefaultExtension() {
        URLFilter uRLFilter = this.fileChooser.getSelectedFilter();
        String string = uRLFilter.toString();
        String string2 = string.substring(string.indexOf("(") + 2, string.indexOf(")"));
        return string2;
    }

    protected String changeExtension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n) + string2;
        }
        return string + string2;
    }

    protected File getFile() {
        try {
            File file;
            String string;
            this.fileChooser.clearChooseableURLFilters();
            this.fileChooser.setSelectionScope(0);
            this.fileChooser.setSelectionMode(0);
            this.fileChooser.setShowJarsAsDirs(false);
            Iterator iterator = this.filterList.iterator();
            while (iterator.hasNext()) {
                this.fileChooser.setURLFilter((URLFilter)iterator.next());
            }
            if (this.filterList.size() > 0) {
                this.fileChooser.setURLFilter((URLFilter)this.filterList.get(0));
            }
            if (lastFolder != null) {
                this.fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                string = this.appView.getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    this.fileChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    URL uRL = this.appView.getUserHomeDirectory();
                    if (uRL != null) {
                        this.fileChooser.setSelectedURL(uRL);
                    }
                }
            }
            string = this.appView.getDesignName() + this.getDefaultExtension();
            this.fileChooser.setFileNameURL(string);
            int n = this.fileChooser.showSaveDialog((Component)Ide.getMainWindow(), this.getTitle());
            if (n == 0 && (file = new File(this.fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AbstractExporter.FileExists"), file.getAbsolutePath()), Messages.getString("AbstractExporter.Warning"), 0, 3, GUIConfiguration.getInstance().getIcon("SAVE_ICON", 32));
                    if (n == 1) {
                        return null;
                    }
                    return file;
                }
                return file;
            }
        }
        catch (Exception exception) {
            LOGGER.error("AbstractExporter.getFile", exception);
        }
        return null;
    }

    protected String getFileName(File file) {
        return this.changeExtension(file.getAbsolutePath(), this.getDefaultExtension());
    }
}

