/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.ControllerMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class DPVCompactMultidimentional
extends DPVMultidimensional {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    private AbstractController controller;

    public DPVCompactMultidimentional(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerMultidimensional(applicationView);
        this.controller.setName("Multidimensional");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Cube) {
            TVCube tVCube = new TVCube(this.getApplicationView(), this);
            tVCube.setModel(designObject);
            topView = tVCube;
            topView.setSize(new Dimension(TOPVIEW_SIZE));
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof Level) {
                TVLevel tVLevel = new TVLevel(this.getApplicationView(), this);
                tVLevel.setModel(designObject);
                topView = tVLevel;
                Dimension dimension = new Dimension(170, 65);
                topView.setSize(dimension);
            } else if (designObject instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                TVDimension tVDimension = new TVDimension(this.getApplicationView(), this);
                tVDimension.setModel(designObject);
                topView = tVDimension;
                Dimension dimension = new Dimension(80, 30);
                topView.setSize(dimension);
            } else if (designObject instanceof Link) {
                TVLink tVLink = new TVLink(this.getApplicationView(), this);
                tVLink.setModel(designObject);
                topView = tVLink;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (designObject instanceof RaggedHLink) {
                TVRaggedHLink tVRaggedHLink = new TVRaggedHLink(this.getApplicationView(), this);
                tVRaggedHLink.setModel(designObject);
                topView = tVRaggedHLink;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else {
                return null;
            }
        }
        return topView;
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (ApplicationView.loading || this.getApplicationView().getCurrentDPV() != this) {
            return;
        }
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            this.addViewFor(designObject);
        }
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    public void generateDiagram() {
        AbstractMDTV abstractMDTV;
        TopView topView;
        AbstractMDObject abstractMDObject2;
        ArrayList arrayList = new ArrayList();
        ((MultidimensionalDesign)this.getDesignPart()).getCubeSet().addAllElementsTo(arrayList);
        ((MultidimensionalDesign)this.getDesignPart()).getDimensionSet().addAllElementsTo(arrayList);
        ((MultidimensionalDesign)this.getDesignPart()).getLevelSet().addAllElementsTo(arrayList);
        for (AbstractMDObject abstractMDObject2 : arrayList) {
            if (abstractMDObject2.getFirstViewForDPV(this) != null || (topView = abstractMDObject2.getFirstViewForDPV(this.getDesignPart().getMainView())) == null) continue;
            topView.createViewSynonim(this);
        }
        Iterator iterator = ((MultidimensionalDesign)this.getDesignPart()).getLinkSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject2 = (Link)iterator.next();
            if (((Link)abstractMDObject2).getFirstViewForDPV(this) != null) continue;
            topView = (AbstractMDTV)((Link)abstractMDObject2).getSourceMDObject().getFirstViewForDPV(this);
            abstractMDTV = (AbstractMDTV)((Link)abstractMDObject2).getTargetMDObject().getFirstViewForDPV(this);
            if (topView == null || abstractMDTV == null) continue;
            ((Link)abstractMDObject2).setSourceTV((AbstractMDTV)topView);
            ((Link)abstractMDObject2).setTargetTV(abstractMDTV);
        }
        iterator = ((MultidimensionalDesign)this.getDesignPart()).getRaggedHLinkSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject2 = (RaggedHLink)iterator.next();
            if (((RaggedHLink)abstractMDObject2).getFirstViewForDPV(this) != null) continue;
            topView = (AbstractMDTV)((RaggedHLink)abstractMDObject2).getSourceMDObject().getFirstViewForDPV(this);
            abstractMDTV = (AbstractMDTV)((RaggedHLink)abstractMDObject2).getTargetMDObject().getFirstViewForDPV(this);
            if (topView == null || abstractMDTV == null) continue;
            ((RaggedHLink)abstractMDObject2).setSourceTV((AbstractMDTV)topView);
            ((RaggedHLink)abstractMDObject2).setTargetTV(abstractMDTV);
        }
        this.rearrangeDiagram(true);
    }

    @Override
    public DesignPartView getCompactDiagram() {
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        if (bl) {
            this.getMultidimensionalDesign().getMainView().setDirty(true);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isDirty();
        boolean bl3 = this.getMultidimensionalDesign().getMainView().isDirty();
        super.setVisible(bl);
        if (bl && !this.getDesign().isLoading()) {
            if (!bl2) {
                this.setDirty(bl2);
            }
            if (!bl3) {
                this.getMultidimensionalDesign().getMainView().setDirty(bl3);
            }
        }
    }

    @Override
    public void setVisible(boolean bl, ProgressDialog progressDialog) {
        boolean bl2 = this.isDirty();
        boolean bl3 = this.getMultidimensionalDesign().getMainView().isDirty();
        super.setVisible(bl, progressDialog);
        if (bl) {
            if (!bl2) {
                this.setDirty(bl2);
            }
            if (!bl3) {
                this.getMultidimensionalDesign().getMainView().setDirty(bl3);
            }
        }
    }
}

