/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntity;

public class TVRelation
extends TVConnector {
    private RelationSelection selectionWrapper = new RelationSelection();
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;
    private static final float[] dashpattern = new float[]{8.0f, 8.0f};

    public TVRelation(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    public DPVLogical getLogicalView() {
        return this.getApplicationView().getDPVLogical();
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getApplicationView().getDPVLogical();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public Relation getRelation() {
        return (Relation)this.getModel();
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (ObjectChangeEvent.OBJECT_REMOVED.equals(objectChangeEvent)) {
            this.removeLabel(0);
            this.removeLabel(2);
        }
    }

    public void addConnection() {
        if (this.edge == null) {
            TVEntity tVEntity = this.getRelation().getSourceTV(this.getDesignPartView());
            TVEntity tVEntity2 = this.getRelation().getTargetTV(this.getDesignPartView());
            if (tVEntity != null && tVEntity.getCellView() != null && tVEntity2 != null && tVEntity2.getCellView() != null) {
                ContainerDiagramCell containerDiagramCell = (ContainerDiagramCell)tVEntity.getCellView().getCell();
                ContainerDiagramCell containerDiagramCell2 = (ContainerDiagramCell)tVEntity2.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(containerDiagramCell, containerDiagramCell2, Color.BLACK);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.getDesignPartView().getWorkSpace().addPoints(this.edge, this.getEdgePoints(), true);
                this.edge.getCellView().update();
                this.resetEdgeParams(this.edge, false);
                ((EntityView)tVEntity.getCellView()).updateParent();
                ((EntityView)tVEntity2.getCellView()).updateParent();
                this.displayLabels();
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                boolean bl = false;
                if (!"".equalsIgnoreCase(((RelationEdge)this.edge).getSourceLabel())) {
                    this.displayLabel(((RelationEdge)this.edge).getSourceLabel(), this.getSourceLabelBounds(), 0);
                    bl = true;
                } else {
                    this.removeLabel(0);
                }
                if (!"".equalsIgnoreCase(((RelationEdge)this.edge).getTargetLabel())) {
                    this.displayLabel(((RelationEdge)this.edge).getTargetLabel(), this.getTargetLabelBounds(), 2);
                    bl = true;
                } else {
                    this.removeLabel(2);
                }
                if (bl) {
                    this.getEdgeView().refreshLabels();
                }
            }
        } else {
            this.removeLabel(0);
            this.removeLabel(2);
        }
    }

    public void updateParents() {
        TVEntity tVEntity = this.getRelation().getSourceTV(this.getDesignPartView());
        TVEntity tVEntity2 = this.getRelation().getTargetTV(this.getDesignPartView());
        if (tVEntity != null && tVEntity.getCellView() != null && tVEntity2 != null && tVEntity2.getCellView() != null && this.getDesignPartView().isBoxInBox()) {
            ((EntityView)tVEntity.getCellView()).updateParent();
            ((EntityView)tVEntity2.getCellView()).updateParent();
        }
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean bl) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, bl);
        }
    }

    private void resetEdgeParams(DefaultEdge defaultEdge, boolean bl) {
        Object object;
        Map map = defaultEdge.getAttributes();
        Relation relation = (Relation)this.getModel();
        if (relation.getClass() == Relation.class) {
            map.remove("dashPattern");
            object = (Relation.Cardinality)relation.getSourceCardinality();
            Relation.Cardinality cardinality = (Relation.Cardinality)relation.getTargetCardinality();
            int n = this.getApplicationView().getSettings().getNotation();
            n = this.getDesignPartView().getNotation();
            if (n == 0) {
                DiagramConstants.setBeginDashed(map, false);
                DiagramConstants.setEndDashed(map, false);
                if (relation.isIdentifying()) {
                    if (((Relation.Cardinality)object).getValue() == 1 && cardinality.getValue() == 1) {
                        Entity entity = relation.getDominantRole();
                        if (relation.getSourceEntity() == entity) {
                            DiagramConstants.setLineBegin(map, 5);
                            DiagramConstants.setLineEnd(map, 15);
                        } else {
                            DiagramConstants.setLineBegin(map, 15);
                            DiagramConstants.setLineEnd(map, 5);
                        }
                    } else if (cardinality.getValue() == 0) {
                        DiagramConstants.setLineBegin(map, 5);
                        DiagramConstants.setLineEnd(map, 14);
                    } else {
                        DiagramConstants.setLineBegin(map, 14);
                        DiagramConstants.setLineEnd(map, 5);
                    }
                } else {
                    if (cardinality.getValue() == 0) {
                        DiagramConstants.setLineEnd(map, 2);
                    } else {
                        DiagramConstants.setLineEnd(map, 5);
                    }
                    if (((Relation.Cardinality)object).getValue() == 0) {
                        DiagramConstants.setLineBegin(map, 2);
                    } else {
                        DiagramConstants.setLineBegin(map, 5);
                    }
                }
                if (relation.getOptional(0).booleanValue()) {
                    DiagramConstants.setBeginFill(map, false);
                } else {
                    DiagramConstants.setBeginFill(map, true);
                }
                if (relation.getOptional(1).booleanValue()) {
                    DiagramConstants.setEndFill(map, false);
                } else {
                    DiagramConstants.setEndFill(map, true);
                }
            } else if (n == 1) {
                DiagramConstants.setBeginFill(map, false);
                DiagramConstants.setEndFill(map, false);
                DiagramConstants.setBeginSize(map, 6);
                DiagramConstants.setEndSize(map, 6);
                if (relation.isIdentifying()) {
                    if (((Relation.Cardinality)object).getValue() == 1 && cardinality.getValue() == 1) {
                        Entity entity = relation.getDominantRole();
                        if (relation.getSourceEntity() == entity) {
                            DiagramConstants.setLineBegin(map, 0);
                            DiagramConstants.setLineEnd(map, 7);
                        } else if (relation.getTargetEntity() == entity) {
                            DiagramConstants.setLineBegin(map, 7);
                            DiagramConstants.setLineEnd(map, 0);
                        } else if (relation.isOptionalSource() && !relation.isOptionalTarget()) {
                            DiagramConstants.setLineBegin(map, 0);
                            DiagramConstants.setLineEnd(map, 7);
                        } else if (!relation.isOptionalSource() && relation.isOptionalTarget()) {
                            DiagramConstants.setLineBegin(map, 7);
                            DiagramConstants.setLineEnd(map, 0);
                        }
                    } else if (cardinality.getValue() == 0) {
                        DiagramConstants.setLineBegin(map, 0);
                        DiagramConstants.setLineEnd(map, 17);
                    } else {
                        DiagramConstants.setLineBegin(map, 17);
                        DiagramConstants.setLineEnd(map, 0);
                    }
                } else {
                    if (cardinality.getValue() == 0) {
                        DiagramConstants.setLineEnd(map, 16);
                    } else {
                        DiagramConstants.setLineEnd(map, 0);
                    }
                    if (((Relation.Cardinality)object).getValue() == 0) {
                        DiagramConstants.setLineBegin(map, 16);
                    } else {
                        DiagramConstants.setLineBegin(map, 0);
                    }
                }
                if (relation.getOptional(0).booleanValue()) {
                    DiagramConstants.setBeginDashed(map, true);
                } else {
                    DiagramConstants.setBeginDashed(map, false);
                }
                if (relation.getOptional(1).booleanValue()) {
                    DiagramConstants.setEndDashed(map, true);
                } else {
                    DiagramConstants.setEndDashed(map, false);
                }
            } else if (n == 2) {
                DiagramConstants.setBeginFill(map, false);
                DiagramConstants.setEndFill(map, false);
                DiagramConstants.setBeginSize(map, 6);
                DiagramConstants.setEndSize(map, 6);
                if (!relation.isIdentifying()) {
                    DiagramConstants.setDashPattern(map, dashpattern);
                } else {
                    map.remove("dashPattern");
                }
                if (cardinality.getValue() == 0) {
                    if (relation.getOptional(0).booleanValue()) {
                        DiagramConstants.setLineEnd(map, 19);
                    } else {
                        DiagramConstants.setLineEnd(map, 17);
                    }
                } else if (relation.getOptional(0).booleanValue()) {
                    DiagramConstants.setLineEnd(map, 18);
                } else {
                    DiagramConstants.setLineEnd(map, 8);
                }
                if (((Relation.Cardinality)object).getValue() == 0) {
                    if (relation.getOptional(1).booleanValue()) {
                        DiagramConstants.setLineBegin(map, 19);
                    } else {
                        DiagramConstants.setLineBegin(map, 17);
                    }
                } else if (relation.getOptional(1).booleanValue()) {
                    DiagramConstants.setLineBegin(map, 18);
                } else {
                    DiagramConstants.setLineBegin(map, 8);
                }
            }
            defaultEdge.setAttributes(map);
        }
        if ((object = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false)) != null) {
            ((EdgeView)object).update();
            if (bl) {
                ((AbstractCellView)object).getDiagram().repaint();
            }
        }
        this.updateParents();
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent mouseEvent) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDLSettings().getDefaultLWCObject("Logical Relation").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDLSettings().getDefaultLWCObject("Logical Relation").getWidth();
    }

    class RelationSelection
    implements SelectableObject {
        RelationSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVRelation.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

