/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.util.logging.Logger;

public class TVEntity
extends ContainerView {
    private Set listeners = new HashSet();
    private Collection conns = new ArrayList();
    private static final Logger LOGGER = new Logger(TVEntity.class);

    public TVEntity(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getApplicationView().getDPVLogical();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    protected Entity getEntityModel() {
        return (Entity)this.getModel();
    }

    protected Relation.Connection[] getConnections() {
        return this.getEntityModel().getRelationConnections();
    }

    @Override
    public void setModel(DesignObject designObject) {
        super.setModel(designObject);
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (!objectChangeEvent.isType(ObjectChangeEvent.CONNECTION_ADDED) && !objectChangeEvent.isType(ObjectChangeEvent.CONNECTION_REMOVED)) {
            super.changed(designObject, objectChangeEvent);
        }
    }

    public Collection getAllConnections() {
        return this.conns;
    }

    @Override
    protected void doPrivateActions() {
        this.reassignRelations();
    }

    public void reassignRelations() {
        TVEntity tVEntity = (TVEntity)((ContainerWithKeyObject)this.getModel()).getAnotherView(this);
        if (tVEntity != null) {
            Entity entity = (Entity)this.getModel();
            List list = ((LogicalDesign)this.getModel().getDesignPart()).getRelationSet().getRelationsTo(entity);
            for (Relation relation : list) {
                if (relation.getSourceTV(this.getDesignPartView()) == this) {
                    relation.setSourceTV(tVEntity);
                }
                if (relation.getTargetTV(this.getDesignPartView()) != this) continue;
                relation.setTargetTV(tVEntity);
            }
            this.addArc(entity);
        } else {
            Entity entity = (Entity)this.getModel();
            List list = ((LogicalDesign)this.getModel().getDesignPart()).getRelationSet().getRelationsTo(entity);
            for (Relation relation : list) {
                if (relation.getSourceTV(this.getDesignPartView()) == this) {
                    relation.removeViewFor(this.dpv);
                    this.removeArcs(relation.getTargetEntity());
                }
                if (relation.getTargetTV(this.getDesignPartView()) != this) continue;
                relation.removeViewFor(this.dpv);
                this.removeArcs(relation.getSourceEntity());
            }
            this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
        }
    }

    private void removeArcs(Entity entity) {
        for (Arc arc : entity.getArcs()) {
            TVArc tVArc = (TVArc)arc.getFirstViewForDPV(this.getDesignPartView());
            if (tVArc == null) continue;
            int n = 0;
            for (Relation relation : arc.getRelations()) {
                if (relation.getFirstViewForDPV(this.getDesignPartView()) == null) continue;
                ++n;
            }
            if (n >= 2) continue;
            tVArc.remove(false);
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        TopViewListener[] topViewListenerArray = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < topViewListenerArray.length; ++i) {
            try {
                topViewListenerArray[i].changed(this, objectChangeEvent);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView applicationView, DesignPartView designPartView) {
        return new TVEntity(applicationView, designPartView);
    }

    @Override
    public void addTopViewListener(TopViewListener topViewListener) {
        this.listeners.add(topViewListener);
    }

    @Override
    public void removeTopViewListener(TopViewListener topViewListener) {
        this.listeners.remove(topViewListener);
    }

    public void addTVRelations() {
        ObjectListener objectListener;
        Object object;
        Object object22;
        Entity entity = (Entity)this.getModel();
        DesignPartView designPartView = this.getDesignPartView();
        Collection collection = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToSource(entity);
        for (Object object22 : collection) {
            ((Relation)object22).getSourceTV(designPartView);
            ((Relation)object22).getTargetTV(designPartView);
        }
        collection = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToTarget(entity);
        for (Object object22 : collection) {
            ((Relation)object22).getSourceTV(designPartView);
            ((Relation)object22).getTargetTV(designPartView);
        }
        if (entity.getHierarchicalParent() != null && (object22 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getInheritanceRelation(entity.getHierarchicalParent(), entity)) != null) {
            if (((Relation)object22).getTargetTV(designPartView) == null) {
                ((Relation)object22).setTargetTV(this);
            }
            if ((collection = entity.getHierarchicalParent().getViewsForDPV(designPartView)).size() > 0) {
                object = collection.iterator();
                objectListener = (TopView)object.next();
                if (((Relation)object22).getSourceTV(designPartView) == null) {
                    ((Relation)object22).setSourceTV((TVEntity)objectListener);
                }
            }
        }
        object22 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getSubtypesOf(entity);
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (InheritanceRelation)iterator.next();
            if (((Relation)object).getSourceTV(designPartView) == null) {
                ((Relation)object).setSourceTV(this);
            }
            if ((collection = (objectListener = ((Relation)object).getTargetEntity()).getViewsForDPV(designPartView)).size() <= 0) continue;
            Iterator iterator2 = collection.iterator();
            TopView topView = (TopView)iterator2.next();
            if (((Relation)object).getTargetTV(designPartView) != null) continue;
            ((Relation)object).setTargetTV((TVEntity)topView);
        }
    }

    public void addTVRelations(DesignPartView designPartView) {
        ObjectListener objectListener;
        Object object;
        Object object22;
        Entity entity = (Entity)this.getModel();
        Collection collection = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToSource(entity);
        for (Object object22 : collection) {
            if (((Relation)object22).getSourceTV(designPartView) != null) continue;
            ((Relation)object22).setSourceTV(this);
        }
        collection = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToTarget(entity);
        for (Object object22 : collection) {
            if (((Relation)object22).getTargetTV(designPartView) != null) continue;
            ((Relation)object22).setTargetTV(this);
        }
        if (entity.getHierarchicalParent() != null && (object22 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getInheritanceRelation(entity.getHierarchicalParent(), entity)) != null) {
            if (((Relation)object22).getTargetTV(designPartView) == null) {
                ((Relation)object22).setTargetTV(this);
            }
            if ((collection = entity.getHierarchicalParent().getViewsForDPV(designPartView)).size() > 0) {
                object = collection.iterator();
                objectListener = (TopView)object.next();
                if (((Relation)object22).getSourceTV(designPartView) == null) {
                    ((Relation)object22).setSourceTV((TVEntity)objectListener);
                }
            }
        }
        object22 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getSubtypesOf(entity);
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (InheritanceRelation)iterator.next();
            if (((Relation)object).getSourceTV(designPartView) == null) {
                ((Relation)object).setSourceTV(this);
            }
            if ((collection = (objectListener = ((Relation)object).getTargetEntity()).getViewsForDPV(designPartView)).size() <= 0) continue;
            Iterator iterator2 = collection.iterator();
            TopView topView = (TopView)iterator2.next();
            if (((Relation)object).getTargetTV(designPartView) != null) continue;
            ((Relation)object).setTargetTV((TVEntity)topView);
        }
    }

    public void addArcs() {
        Object object;
        Entity entity = (Entity)this.getModel();
        for (DesignObject designObject : entity.getArcs()) {
            if (((MultiShapedDesignObject)designObject).getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            object = ((Arc)designObject).getRelations().iterator();
            int n = 0;
            while (object.hasNext()) {
                Relation relation = (Relation)object.next();
                TopView topView = relation.getFirstViewForDPV(this.getDesignPartView());
                if (topView == null) continue;
                ++n;
            }
            if (n <= true) continue;
            this.getDesignPartView().addViewFor(designObject, true);
        }
        for (DesignObject designObject : this.getDesign().getLogicalDesign().getRelationSet().getRelationsTo(entity)) {
            object = ((Relation)designObject).getOtherEntity(entity);
            if (((MultiShapedDesignObject)object).getFirstViewForDPV(this.getDesignPartView()) == null) continue;
            this.addArc((Entity)object);
        }
    }

    private void addArc(Entity entity) {
        for (Arc arc : entity.getArcs()) {
            if (arc.getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            Iterator iterator = arc.getRelations().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                TopView topView = relation.getFirstViewForDPV(this.getDesignPartView());
                if (topView == null) continue;
                ++n;
            }
            if (n <= true) continue;
            this.getDesignPartView().addViewFor(arc);
        }
    }

    @Override
    public String toString() {
        int n = this.getViewNumber();
        String string = n == 0 ? "" : ":" + n;
        String string2 = this.getModel().getName();
        String string3 = ((Entity)this.getModel()).getSynonymToDisplay();
        if (string3 != null && !"".equals(string3)) {
            string2 = string3;
        }
        return string2 + string;
    }

    @Override
    protected void hideRelations() {
    }

    private void removeArc() {
        Entity entity = (Entity)this.getModel();
        for (Arc arc : entity.getArcs()) {
            TVArc tVArc = (TVArc)arc.getFirstViewForDPV(this.getDesignPartView());
            if (tVArc == null) continue;
            tVArc.remove(false);
        }
    }

    @Override
    public void remove() {
        this.removeArc();
        super.remove();
    }

    @Override
    public void remove(boolean bl) {
        if (bl) {
            this.removeArc();
            ((Entity)this.getModel()).remove(true);
            this.getDesignPartView().getWorkSpace().repaint();
        } else {
            if (this.getCellView() != null) {
                Object[] objectArray = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(objectArray);
            }
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }
}

