/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.glossary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.glossary.ImportGlossaryDialog;
import oracle.dbtools.crest.swingui.glossary.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class GlossaryDialog
extends CustomDialog {
    private Glossary glossary;
    private ApplicationView appView;
    private List allWords;
    private List selectedWords = new ArrayList();
    private JDialog dialog;
    private JButton bnClose;
    private JButton bnSave;
    private JButton bnSaveAs;
    private JButton bnImport;
    private JButton bnExportToCSV;
    private WordJTable wordsTable;
    private boolean badWordName = false;
    private static final Comparator COMPARATOR = new StringComparator();
    private JComboBox cbFilter;
    private JTextField tfName;
    private JTextField tfDescription;
    public static String CWD_GLOSS_DESC = Messages.getString("GlossaryDialog.CWDGlossaryFiles");
    public static String ERWIN_TXT_GLOSS_DESC = Messages.getString("GlossaryDialog.ERwinExportedNamesTXT");
    public static String ERWIN_CSV_GLOSS_DESC = Messages.getString("GlossaryDialog.ERwinExportedNamesCSV");
    public static String RDA7_GLOSS_DESC = Messages.getString("GlossaryDialog.RDA7GlossaryFiles");
    private static String CHARACTER_L = Messages.getString("GlossaryDialog.Character");
    private static String SPACE_L = Messages.getString("GlossaryDialog.Space");
    private static String ALL_L = Messages.getString("GlossaryDialog.ALL");
    private static String PRIME_WORD_L = Messages.getString("GlossaryDialog.PrimeWord");
    private static String CLASS_WORD_L = Messages.getString("GlossaryDialog.ClassWord");
    private static String MODIFIER_L = Messages.getString("GlossaryDialog.Modifier");
    private static String QUALIFIER_L = Messages.getString("GlossaryDialog.Qualifier");
    private static String UNCLASSIFIED_L = Messages.getString("GlossaryDialog.Unclassified");
    private JCheckBox chbIncomplete = new JCheckBox(Messages.getString("GlossaryDialog.IncompleteModifiers"));
    private JCheckBox chbCaseSensitive = new JCheckBox(Messages.getString("GlossaryDialog.CaseSensitive"));
    private JComboBox cbSeparator;
    private JLabel lbSeparator = new JLabel(Messages.getString("GlossaryDialog.Separator"));
    private JCharField tfSeparator = new JCharField();
    private JLabel lbCharSep = new JLabel(Messages.getString("GlossaryDialog.SepChar"));
    private JCheckBox chbUniqueAbbreviations = new JCheckBox(Messages.getString("GlossaryDialog.UniqueAbbreviations"));
    private JButton bnSeparator = new JButton(Messages.getString("GlossaryDialog.ApplyNewSeparator"));
    private JButton removeButton;
    private static File lastExpFolder = null;
    private static File lastImpFolder = null;
    private LinkedHashMap mapSeparator = new LinkedHashMap();
    private LinkedHashMap mapFilter = new LinkedHashMap();

    public GlossaryDialog(ApplicationView applicationView, Glossary glossary) {
        super(applicationView);
        this.appView = applicationView;
        this.glossary = glossary;
        this.mapSeparator.put(Glossary.CHARACTER, CHARACTER_L);
        this.mapSeparator.put(Glossary.SPACE, SPACE_L);
        this.cbSeparator = new JComboBox<Object>(this.mapSeparator.values().toArray());
        this.mapFilter.put(ALL_L, ALL_L);
        this.mapFilter.put("Prime Word", PRIME_WORD_L);
        this.mapFilter.put("Class Word", CLASS_WORD_L);
        this.mapFilter.put("Modifier", MODIFIER_L);
        this.mapFilter.put("Qualifier", QUALIFIER_L);
        this.mapFilter.put(UNCLASSIFIED_L, UNCLASSIFIED_L);
        this.allWords = glossary.getWords();
        this.selectedWords.addAll(this.allWords);
        Collections.sort(this.selectedWords, COMPARATOR);
        this.add((Component)this.initWordsPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
        this.validateMultiwords(glossary.getMW_SeparatorChar());
    }

    private boolean save() {
        if (this.stopEditing()) {
            this.glossary.setName(this.tfName.getText());
            this.glossary.setDescription(this.tfDescription.getText());
            this.glossary.setIncompleteModifiers(this.chbIncomplete.isSelected());
            this.glossary.setUniqueAbbreviations(this.chbUniqueAbbreviations.isSelected());
            this.glossary.setCaseSensitive(this.chbCaseSensitive.isSelected());
            this.glossary.save();
            this.glossary.clearDirtyFlag();
            ((JDialog)this.getDialog()).setTitle(Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName());
            return true;
        }
        return false;
    }

    private boolean saveAs() {
        if (this.stopEditing()) {
            this.glossary.setName(this.tfName.getText());
            this.glossary.setDescription(this.tfDescription.getText());
            this.glossary.setIncompleteModifiers(this.chbIncomplete.isSelected());
            this.glossary.setUniqueAbbreviations(this.chbUniqueAbbreviations.isSelected());
            this.glossary.setCaseSensitive(this.chbCaseSensitive.isSelected());
            this.glossary.saveAs(this.appView);
            this.glossary.clearDirtyFlag();
            ((JDialog)this.getDialog()).setTitle(Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName());
            return true;
        }
        return false;
    }

    private boolean exportToCSVFile() {
        if (this.stopEditing()) {
            try {
                File file;
                int n;
                String string;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("GlossaryDialog.CSVFile");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastExpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                } else {
                    string = this.appView.getSettings().getDefaultSavePath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = this.appView.getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                }
                string = this.tfName.getText().trim();
                if (!"".equalsIgnoreCase(string)) {
                    ApplicationView.waitLoadFilesThreadToComplete();
                    uRLChooser.setFileNameURL(string + ".csv");
                }
                if ((n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.ExportCWDGlossaryToCSVFile"))) == 0 && (file = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                    lastExpFolder = file.getParentFile();
                    this.glossary.exportAsCSVFile(file, this.appView);
                    MessageDialogs.showMessage(Messages.getString("GlossaryDialog.GlossaryExportedOK"));
                }
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), throwable.getMessage()}, Messages.getString("GlossaryDialog.WriteError"), 0);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean stopEditing() {
        int n = this.wordsTable.getEditingRow();
        int n2 = this.wordsTable.getEditingColumn();
        return n2 <= -1 || n <= -1 || this.wordsTable.getCellEditor(n, n2).stopCellEditing();
    }

    @Override
    protected void close() {
        int n;
        if (this.glossary.isDirty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("GlossaryDialog.Glossary"), this.glossary.getName()), Messages.getString("GlossaryDialog.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 0 && !this.save()) {
            return;
        }
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName(), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnSave);
            this.setDefaultActions(this.dialog);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = GlossaryDialog.this.dialog.getWidth();
                    int n2 = GlossaryDialog.this.dialog.getHeight();
                    n = Math.max(GlossaryDialog.this.getMinimumWidth(), n);
                    n2 = Math.max(GlossaryDialog.this.getMinimumHeight(), n2);
                    GlossaryDialog.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.pack();
            this.dialog.setModal(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    protected int getMinimumWidth() {
        return 1050;
    }

    protected int getMinimumHeight() {
        return 600;
    }

    private JPanel initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.bnImport = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Import")));
        this.bnImport.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Import")));
        this.bnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.importGlossary(GlossaryDialog.this.appView);
            }
        });
        this.bnExportToCSV = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Export")));
        this.bnExportToCSV.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Export")));
        this.bnExportToCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.exportToCSVFile();
            }
        });
        this.bnSave = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Save")));
        this.bnSave.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Save")));
        this.bnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.save();
            }
        });
        this.bnSaveAs = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.SaveAs")));
        this.bnSaveAs.setMnemonic(MenuUtils.getMnemonicChar(Messages.getString("GlossaryDialog.SaveAs")));
        this.bnSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.saveAs();
            }
        });
        this.bnClose = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Close")));
        this.bnClose.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Close")));
        this.bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.close();
            }
        });
        jPanel.add(this.bnImport);
        jPanel.add(this.bnExportToCSV);
        jPanel.add(this.bnSave);
        jPanel.add(this.bnSaveAs);
        jPanel.add(this.bnClose);
        JButton jButton = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Help")));
        jButton.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Help")));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.showHelp();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jPanel.add(jButton);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnExportToCSV.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnSaveAs.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        return jPanel;
    }

    private JPanel initWordsPanel() {
        Object object2;
        Dimension dimension = new Dimension(100, 22);
        Dimension dimension2 = new Dimension(10, 22);
        JPanel jPanel = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.GlossaryProperties"));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.Words"));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.Options"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(900, 600));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        this.tfName = new JTextField(this.glossary.getName());
        JLabel jLabel2 = new JLabel();
        this.tfDescription = new JTextField(this.glossary.getDescription());
        JPanel jPanel4 = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.cbFilter = new JComboBox();
        for (Object object2 : this.mapFilter.values()) {
            this.cbFilter.addItem(object2);
        }
        this.cbFilter.setSelectedItem(this.mapFilter.get(ALL_L));
        this.cbFilter.setMaximumSize(dimension);
        this.cbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.filterWords();
            }
        });
        object2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        ((AbstractButton)object2).addActionListener(new AddWordAction());
        this.removeButton = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.removeButton.addActionListener(new RemoveWordAction());
        this.removeButton.setEnabled(false);
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jPanel6 = new JPanel(flowLayout);
        jPanel6.setBorder(titledBorder3);
        jPanel6.add(this.chbIncomplete);
        String string = Messages.getString("GlossaryDialog.HTMLTip1.0") + "\n" + Messages.getString(Messages.getString("GlossaryDialog.5"));
        this.chbIncomplete.setToolTipText(string);
        jPanel6.add(this.chbCaseSensitive);
        jPanel6.add(this.chbUniqueAbbreviations);
        this.chbUniqueAbbreviations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.checkAndShowWordsWithNoneUniqueAbbreviations();
            }
        });
        this.chbUniqueAbbreviations.setToolTipText(Messages.getString("GlossaryDialog.ShowReportAboutWords"));
        jPanel6.add(this.lbSeparator);
        jPanel6.add(this.cbSeparator);
        jPanel6.add(this.lbCharSep);
        this.cbSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.bnSeparator.setEnabled(GlossaryDialog.this.isDifferentSeparator() && !"".equalsIgnoreCase(GlossaryDialog.this.tfSeparator.getText()));
                String string = "";
                for (Map.Entry entry : GlossaryDialog.this.mapSeparator.entrySet()) {
                    if (!entry.getValue().equals(GlossaryDialog.this.cbSeparator.getSelectedItem().toString())) continue;
                    string = (String)entry.getKey();
                    break;
                }
                if (Glossary.SPACE.equalsIgnoreCase(string)) {
                    GlossaryDialog.this.tfSeparator.setEnabled(false);
                } else {
                    GlossaryDialog.this.tfSeparator.setEnabled(true);
                }
            }
        });
        string = Messages.getString("GlossaryDialog.HTMLTip12.0") + "\n" + Messages.getString("GlossaryDialog.HTMLTip12.1");
        this.cbSeparator.setToolTipText(string);
        this.cbSeparator.setPreferredSize(new Dimension(100, (int)this.cbSeparator.getPreferredSize().getHeight()));
        this.bnSeparator.setEnabled(this.isDifferentSeparator());
        this.tfSeparator.setPreferredSize(dimension2);
        jPanel6.add(this.tfSeparator);
        jPanel6.add(this.bnSeparator);
        this.tfSeparator.setText(new String() + this.glossary.getMultiWordSeparator());
        this.tfSeparator.setToolTipText(string);
        jPanel3.setBorder(titledBorder);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 82));
        jPanel3.setLayout(gridBagLayout);
        jLabel.setText(Messages.getString("GlossaryDialog.Name"));
        jLabel2.setText(Messages.getString("GlossaryDialog.Description"));
        jPanel4.setLayout(borderLayout);
        jPanel4.setBorder(titledBorder2);
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        jLabel3.setText(Messages.getString("GlossaryDialog.Filter"));
        jLabel4.setText(Messages.getString("GlossaryDialog.DefaultType"));
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 11, 0, 11), 0, -1));
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 11, 0, 10), 29, 7));
        jPanel3.add((Component)this.tfName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 11, 0, 274), 176, 3));
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 11, 10, 0), 13, 4));
        jPanel3.add((Component)this.tfDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 11, 10, 11), 428, 1));
        jPanel3.add((Component)jPanel6, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(8, 11, 10, 11), 428, 1));
        jPanel2.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 11, 16, 11), 309, 197));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel4.add((Component)jPanel7, "North");
        jPanel7.add((Component)object2);
        jPanel7.add(this.removeButton);
        jPanel7.add(new JPanel());
        jPanel7.add(jLabel3);
        jPanel7.add(this.cbFilter);
        this.bnSeparator.setEnabled(this.isDifferentSeparator());
        jPanel4.add((Component)jPanel5, "Center");
        this.bnSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlossaryDialog.this.replaceSeparators();
                GlossaryDialog.this.bnSeparator.setEnabled(false);
            }
        });
        this.bnSeparator.setToolTipText(Messages.getString("GlossaryDialog.ApplyNewSeparatorForMultiwordTerms"));
        this.wordsTable = new WordJTable(new WordsModel());
        this.tuneWordsTable(this.wordsTable);
        this.wordsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = GlossaryDialog.this.wordsTable.getSelectedRow();
                if (n > -1) {
                    GlossaryDialog.this.removeButton.setEnabled(true);
                }
            }
        });
        jPanel5.add(new JScrollPane(this.wordsTable));
        this.initProperties();
        String string2 = "";
        for (Map.Entry entry : this.mapSeparator.entrySet()) {
            if (!entry.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
            string2 = (String)entry.getKey();
            break;
        }
        if (Glossary.SPACE.equalsIgnoreCase(string2)) {
            this.tfSeparator.setEnabled(false);
        } else {
            this.tfSeparator.setEnabled(true);
        }
        return jPanel;
    }

    private boolean isDifferentSeparator() {
        Map.Entry entry2;
        String string = this.glossary.getSeparatorType();
        char c = this.glossary.getMultiWordSeparator();
        String string2 = "";
        for (Map.Entry entry2 : this.mapSeparator.entrySet()) {
            if (!entry2.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
            string2 = (String)entry2.getKey();
            break;
        }
        entry2 = this.tfSeparator.getText();
        char c2 = '\u0000';
        if (!"".equals(entry2)) {
            c2 = ((String)((Object)entry2)).charAt(0);
        }
        return !string.equals(string2) || string.equals(Glossary.CHARACTER) && c != c2;
    }

    private void replaceSeparators() {
        if (this.isDifferentSeparator()) {
            Map.Entry entry2;
            char c = this.glossary.getMW_SeparatorChar();
            String string = "";
            for (Map.Entry entry2 : this.mapSeparator.entrySet()) {
                if (!entry2.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
                string = (String)entry2.getKey();
                break;
            }
            this.glossary.setSeparatorType(string);
            entry2 = this.tfSeparator.getText();
            char c2 = '\u0000';
            if (!"".equals(entry2)) {
                c2 = ((String)((Object)entry2)).charAt(0);
            }
            this.glossary.setMultiWordSeparator(c2);
            c2 = this.glossary.getMW_SeparatorChar();
            this.glossary.replaceSeparator(c, c2);
            this.validateMultiwords(c2);
            this.wordsTable.updateUI();
        }
    }

    private void initProperties() {
        this.chbCaseSensitive.setSelected(this.glossary.isCaseSensitive());
        this.chbUniqueAbbreviations.setSelected(this.glossary.isUniqueAbbreviations());
        this.chbIncomplete.setSelected(this.glossary.isIncompleteModifiers());
        this.cbSeparator.setSelectedItem(this.mapSeparator.get(this.glossary.getSeparatorType()));
        this.tfSeparator.setText(new String() + this.glossary.getMultiWordSeparator());
        this.tfSeparator.addCaretListener(new SeparatorUpdate());
        this.tfName.addCaretListener(new SeparatorUpdate());
    }

    private void tuneWordsTable(JTable jTable) {
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setCellSelectionEnabled(true);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new NameCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(140);
        tableColumn.setMinWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new TextCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(110);
        tableColumn.setMinWidth(40);
        tableColumn.setMaxWidth(120);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new TextCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(80);
        tableColumn.setMinWidth(40);
        tableColumn.setMaxWidth(90);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new TextCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(140);
        tableColumn.setMinWidth(140);
        tableColumn.setMaxWidth(180);
        tableColumn = jTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(60);
        tableColumn.setMinWidth(60);
        tableColumn.setMaxWidth(90);
        tableColumn = jTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(6);
        tableColumn.setPreferredWidth(70);
        tableColumn.setMinWidth(70);
        tableColumn.setMaxWidth(120);
        tableColumn = jTable.getColumnModel().getColumn(7);
        tableColumn.setPreferredWidth(70);
        tableColumn.setMinWidth(70);
        tableColumn.setMaxWidth(120);
        tableColumn = jTable.getColumnModel().getColumn(8);
        tableColumn.setCellEditor(new DescriptionCellEditor());
        tableColumn.setPreferredWidth(200);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected String getHelpIndex() {
        return "GLOSSARY_EDITOR";
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    private void filterWords() {
        if (this.stopEditing()) {
            String string = "";
            for (Map.Entry entry : this.mapFilter.entrySet()) {
                if (!entry.getValue().equals(this.cbFilter.getSelectedItem().toString())) continue;
                string = (String)entry.getKey();
                break;
            }
            this.selectedWords.clear();
            if (ALL_L.equals(string)) {
                this.selectedWords.addAll(this.allWords);
            } else {
                this.addToList(string, this.selectedWords);
            }
            Collections.sort(this.selectedWords, COMPARATOR);
            this.wordsTable.updateUI();
        }
    }

    private void addToList(String string, List list) {
        for (GlossaryWord glossaryWord : this.allWords) {
            if (string.equals("Prime Word") && glossaryWord.isPrimaryWord()) {
                list.add(glossaryWord);
                continue;
            }
            if (string.equals("Class Word") && glossaryWord.isClassWord()) {
                list.add(glossaryWord);
                continue;
            }
            if (string.equals("Modifier") && glossaryWord.isModifier()) {
                list.add(glossaryWord);
                continue;
            }
            if (string.equals("Qualifier") && glossaryWord.isQualifier()) {
                list.add(glossaryWord);
                continue;
            }
            if (!string.equals(UNCLASSIFIED_L) || glossaryWord.isPrimaryWord() || glossaryWord.isClassWord() || glossaryWord.isQualifier() || glossaryWord.isModifier()) continue;
            list.add(glossaryWord);
        }
    }

    public void importGlossary(ApplicationView applicationView) {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return uRL.getFile().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return CWD_GLOSS_DESC;
                }
            };
            URLFilter uRLFilter2 = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                public String toString() {
                    return ERWIN_CSV_GLOSS_DESC;
                }
            };
            URLFilter uRLFilter3 = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
                }

                public String toString() {
                    return ERWIN_TXT_GLOSS_DESC;
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter2);
            uRLChooser.setURLFilter(uRLFilter3);
            uRLChooser.setURLFilter(uRLFilter);
            ApplicationView.waitLoadFilesThreadToComplete();
            if (lastImpFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
            } else {
                String string = this.getApplicationView().getSettings().getDefaultImportPath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = this.getApplicationView().getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.SelectTypeAndGlossaryFile"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                CustomDialog customDialog;
                String string;
                lastImpFolder = ((File)serializable).getParentFile();
                URLFilter uRLFilter4 = uRLChooser.getSelectedFilter();
                Glossary glossary = null;
                String string2 = uRLFilter4.toString();
                if (string2.equals(ERWIN_TXT_GLOSS_DESC) || string2.equals(ERWIN_CSV_GLOSS_DESC)) {
                    glossary = new Glossary(new File(" "));
                    string = glossary.importERwinGlossaryFile((File)serializable);
                    this.selectedWords.clear();
                    this.selectedWords.addAll(this.allWords);
                    Collections.sort(this.selectedWords, COMPARATOR);
                    this.wordsTable.updateUI();
                    if (!"".equalsIgnoreCase(string)) {
                        customDialog = new LogReport(applicationView);
                        ((LogReport)customDialog).setName(Messages.getString("GlossaryDialog.Errors"));
                        ((LogReport)customDialog).setLog(string);
                        ((LogReport)customDialog).showModalDialog(new Dimension(750, 550));
                    }
                } else if (string2.equals(CWD_GLOSS_DESC)) {
                    glossary = new Glossary(new File(" "));
                    string = glossary.importGlossary((File)serializable, applicationView);
                    this.selectedWords.clear();
                    this.selectedWords.addAll(this.allWords);
                    Collections.sort(this.selectedWords, COMPARATOR);
                    this.wordsTable.updateUI();
                    if (!"".equalsIgnoreCase(string)) {
                        customDialog = new LogReport(applicationView);
                        ((LogReport)customDialog).setName(Messages.getString("GlossaryDialog.Errors"));
                        ((LogReport)customDialog).setLog(string);
                        ((LogReport)customDialog).showModalDialog(new Dimension(750, 550));
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.ImportIsNotImplemented")}, Messages.getString("GlossaryDialog.ImportError"), 2);
                }
                if (glossary != null) {
                    int n2 = this.allWords.size();
                    customDialog = new ImportGlossaryDialog(this.getApplicationView(), glossary, this.glossary);
                    ((ImportGlossaryDialog)customDialog).setModal(true);
                    ((ImportGlossaryDialog)customDialog).show();
                    if (n2 != this.allWords.size()) {
                        this.cbFilter.setSelectedItem(this.mapFilter.get(ALL_L));
                        this.filterWords();
                        this.wordsTable.updateUI();
                    }
                    MessageDialogs.showMessage(Messages.getString("GlossaryDialog.GlossaryImportedOK"));
                }
            }
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), throwable.getMessage()}, Messages.getString("GlossaryDialog.ImportError"), 0);
        }
    }

    private void validateMultiwords(char c) {
        String string;
        if (' ' != c && !"".equals(string = this.glossary.validateMultiWordsForSpaces(c))) {
            LogReport logReport = new LogReport(this.appView);
            logReport.setName(Messages.getString("GlossaryDialog.WordsContainingSPACECharacter"));
            logReport.setLog(string);
            logReport.showModalDialog(new Dimension(750, 550));
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), new Object[]{MessageFormat.format(Messages.getString("GlossaryDialog.WouldYouLikeSPACEToBeReplacedWith"), Character.valueOf(c))}, Messages.getString("GlossaryDialog.MultiwordsValidationError"), 0);
            if (n == 0) {
                this.glossary.replaceSeparator(' ', c);
            }
        }
    }

    private void checkAndShowWordsWithNoneUniqueAbbreviations() {
        if (this.chbUniqueAbbreviations.isSelected()) {
            Object object;
            List list = this.glossary.getWordsWithNoneUniqueAbbreviations();
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = (GlossaryWord)iterator.next();
                if ("".equals(((GlossaryWord)object).getAbbreviation().trim())) {
                    if (bl) {
                        bl = false;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("\n\n\n");
                        }
                        stringBuffer.append(Messages.getString("GlossaryDialog.WordsWithoutAbbreviation"));
                    }
                    stringBuffer.append(((GlossaryWord)object).getName()).append("\n");
                    continue;
                }
                stringBuffer.append(this.getStringWithLingth(((GlossaryWord)object).getName(), 40)).append("   ").append(this.getStringWithLingth(((GlossaryWord)object).getAbbreviation(), 15)).append("   ").append(this.getStringWithLingth(((GlossaryWord)object).getAltAbbrevation(), 15)).append("\n");
            }
            if (stringBuffer.length() > 0) {
                object = new LogReport(this.appView);
                ((LogReport)object).setName(Messages.getString("GlossaryDialog.WordsWithNoneUniqueAbbreviation"));
                ((LogReport)object).setLog(stringBuffer.toString());
                ((LogReport)object).showModalDialog(new Dimension(750, 550));
            }
        }
    }

    private String getStringWithLingth(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        String string2 = "";
        for (int i = n2; i < n; ++i) {
            string2 = string2 + ' ';
        }
        return string + string2;
    }

    class SeparatorUpdate
    implements CaretListener {
        SeparatorUpdate() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            GlossaryDialog.this.bnSeparator.setEnabled(GlossaryDialog.this.isDifferentSeparator() && !"".equalsIgnoreCase(GlossaryDialog.this.tfSeparator.getText()));
        }
    }

    class DescriptionCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;
        JButton temp = new JButton();
        StringEditor datatypeDialog;

        DescriptionCellEditor() {
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.datatypeDialog = new StringEditor(GlossaryDialog.this.appView, this.button.getText(), Messages.getString("GlossaryDialog.ShortDescription"));
            this.datatypeDialog.setModal(true);
            this.datatypeDialog.show();
            if (!this.datatypeDialog.cancel) {
                this.button.setText(this.datatypeDialog.getText());
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)object;
            this.button.setText(string);
            return this.button;
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    class WordJTable
    extends JTable {
        boolean badName;

        public WordJTable(TableModel tableModel) {
            super(tableModel);
            this.badName = false;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!this.badName) {
                super.valueChanged(listSelectionEvent);
            } else {
                int n;
                int n2 = GlossaryDialog.this.wordsTable.getEditingRow();
                if (n2 != (n = GlossaryDialog.this.wordsTable.getSelectedRow())) {
                    GlossaryDialog.this.wordsTable.clearSelection();
                    GlossaryDialog.this.wordsTable.setRowSelectionInterval(n2, n2);
                }
            }
        }
    }

    private class RemoveWordAction
    implements ActionListener {
        private RemoveWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GlossaryDialog.this.stopEditing()) {
                int[] nArray = GlossaryDialog.this.wordsTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    GlossaryWord glossaryWord = (GlossaryWord)GlossaryDialog.this.selectedWords.get(nArray[i]);
                    GlossaryDialog.this.glossary.removeWord(glossaryWord);
                    GlossaryDialog.this.selectedWords.remove(glossaryWord);
                }
                GlossaryDialog.this.wordsTable.updateUI();
                GlossaryDialog.this.removeButton.setEnabled(false);
                if (GlossaryDialog.this.selectedWords.size() > 0) {
                    GlossaryDialog.this.wordsTable.removeRowSelectionInterval(0, GlossaryDialog.this.selectedWords.size() - 1);
                }
            }
        }
    }

    private class AddWordAction
    implements ActionListener {
        private AddWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GlossaryDialog.this.stopEditing()) {
                GlossaryWord glossaryWord = GlossaryDialog.this.glossary.createGlossaryWordWithID();
                GlossaryDialog.this.selectedWords.add(glossaryWord);
                GlossaryDialog.this.wordsTable.updateUI();
                Rectangle rectangle = GlossaryDialog.this.wordsTable.getCellRect(GlossaryDialog.this.selectedWords.size() - 1, 0, true);
                GlossaryDialog.this.wordsTable.scrollRectToVisible(rectangle);
                if (GlossaryDialog.this.wordsTable.getSelectedRow() > -1) {
                    GlossaryDialog.this.removeButton.setEnabled(true);
                }
                int n = GlossaryDialog.this.selectedWords.size() - 1;
                boolean bl = GlossaryDialog.this.wordsTable.editCellAt(n, 0);
                if (bl) {
                    GlossaryDialog.this.wordsTable.changeSelection(n, 0, false, false);
                    GlossaryDialog.this.wordsTable.getEditorComponent().requestFocusInWindow();
                }
            }
        }
    }

    class NameCellEditor
    extends DefaultCellEditor {
        JTextField textField;
        int row;

        public NameCellEditor(JTextField jTextField) {
            super(jTextField);
            this.row = -1;
            this.textField = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.textField.setText((String)object);
            this.row = n;
            this.textField.setBorder(null);
            return this.textField;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.row > -1 && this.row < GlossaryDialog.this.selectedWords.size()) {
                String string = this.textField.getText();
                GlossaryWord glossaryWord = (GlossaryWord)GlossaryDialog.this.selectedWords.get(this.row);
                GlossaryWord glossaryWord2 = GlossaryDialog.this.glossary.getDifferentWordByName(string, glossaryWord);
                if (glossaryWord2 != null && glossaryWord2 != glossaryWord) {
                    GlossaryDialog.this.badWordName = true;
                    ((GlossaryDialog)GlossaryDialog.this).wordsTable.badName = true;
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.textField), Messages.getString("GlossaryDialog.ThereIsWordWithTheSameName"), Messages.getString("GlossaryDialog.DuplicatedName"), 0);
                    return false;
                }
            }
            GlossaryDialog.this.badWordName = false;
            ((GlossaryDialog)GlossaryDialog.this).wordsTable.badName = false;
            return super.stopCellEditing();
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField textField;

        public TextCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.textField.setText((String)object);
            this.textField.setBorder(null);
            return this.textField;
        }
    }

    public class WordsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return GlossaryDialog.this.selectedWords.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("GlossaryDialog.Name");
            }
            if (n == 1) {
                return Messages.getString("GlossaryDialog.Plural");
            }
            if (n == 2) {
                return Messages.getString("GlossaryDialog.Abbreviation");
            }
            if (n == 3) {
                return Messages.getString("GlossaryDialog.AltAbbreviation");
            }
            if (n == 4) {
                return Messages.getString("GlossaryDialog.Primary");
            }
            if (n == 5) {
                return Messages.getString("GlossaryDialog.Class");
            }
            if (n == 6) {
                return Messages.getString("GlossaryDialog.Modifier");
            }
            if (n == 7) {
                return Messages.getString("GlossaryDialog.Qualifier");
            }
            if (n == 8) {
                return Messages.getString("GlossaryDialog.ShortDescription");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !GlossaryDialog.this.badWordName;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GlossaryWord glossaryWord = (GlossaryWord)GlossaryDialog.this.selectedWords.get(n);
            if (n2 == 0) {
                return glossaryWord.getName();
            }
            if (n2 == 1) {
                return glossaryWord.getPlural();
            }
            if (n2 == 2) {
                return glossaryWord.getAbbreviation();
            }
            if (n2 == 3) {
                return glossaryWord.getAltAbbrevation();
            }
            if (n2 == 4) {
                return glossaryWord.isPrimaryWord();
            }
            if (n2 == 5) {
                return glossaryWord.isClassWord();
            }
            if (n2 == 6) {
                return glossaryWord.isModifier();
            }
            if (n2 == 7) {
                return glossaryWord.isQualifier();
            }
            if (n2 == 8) {
                return glossaryWord.getShortDescription();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            GlossaryWord glossaryWord = (GlossaryWord)GlossaryDialog.this.selectedWords.get(n);
            String string = String.valueOf(object);
            if (n2 == 0) {
                glossaryWord.setName(string);
            } else if (n2 == 1) {
                glossaryWord.setPlural(string);
            } else if (n2 == 2) {
                glossaryWord.setAbbreviation(string);
            } else if (n2 == 3) {
                glossaryWord.setAltAbbrevation(string);
            } else if (n2 == 4) {
                if (object instanceof Boolean) {
                    glossaryWord.setPrimaryWord((Boolean)object);
                }
            } else if (n2 == 5) {
                if (object instanceof Boolean) {
                    glossaryWord.setClassWord((Boolean)object);
                }
            } else if (n2 == 6) {
                if (object instanceof Boolean) {
                    glossaryWord.setModifier((Boolean)object);
                }
            } else if (n2 == 7) {
                if (object instanceof Boolean) {
                    glossaryWord.setQualifier((Boolean)object);
                }
            } else if (n2 == 8) {
                glossaryWord.setShortDescription(string);
            }
        }
    }
}

